/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.productie.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import ro.atreides.productie.ProductieEntry;
import ro.atreides.productie.ProductieLogic;
import ro.atreides.productie.gui.DetaliiProduseDialog;
import ro.atreides.productie.gui.ProductieCellRenderer;
import ro.atreides.productie.gui.ProductieMain;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class ProductiePanel
extends AbstractListPanel {
    private ProductieLogic logic;
    private JLabel productName;
    private Vector idSectii;
    private JButton mese;
    private JButton accept;
    private JButton refuz;
    private JButton start;
    private JButton terminata;
    private JButton servita;
    private JButton detalii;
    private JButton invertSelection;
    private ProductieMain parent;
    private String masa;
    private String ospatar;
    private static final int FONT_SIZE = 24;
    private long lastAction = System.currentTimeMillis();
    private boolean isFocused = false;
    private ProductieEntry currentItem;
    private boolean selected = false;

    public ProductiePanel() {
        this.logic = ProductieLogic.getInstance();
        Thread logoutThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    if (ProductiePanel.this.isFocused && ProductiePanel.this.lastAction + (long)(ProductieLogic.getInstance().getProductieTimeout() * 1000) < System.currentTimeMillis()) {
                        ProductiePanel.this.gotoComenzi();
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        logoutThread.setName("ProductieTimeoutThread");
        if (ProductieLogic.getInstance().getProductieTimeout() > 0) {
            logoutThread.start();
        }
    }

    @Override
    public String[] buildColumns() {
        return new String[]{LangRoAll.comanda};
    }

    @Override
    public Vector buildData() {
        return this.logic.getAllForMasa(this.idSectii, this.masa);
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(1);
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        result.add((Component)this.getActiuniPanel(), c);
        return result;
    }

    protected void invertSelection() {
        for (Object o : this.tm.getData()) {
            if (!(o instanceof ProductieEntry)) continue;
            ProductieEntry p = (ProductieEntry)o;
            p.setSelected(this.selected);
        }
        this.tm.fireTableDataChanged();
    }

    protected void deselectAll() {
        this.selected = false;
        this.invertSelection();
    }

    private JPanel getActiuniPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 5;
        this.productName = new JLabel();
        this.productName.setFont(new Font(null, 0, 24));
        this.productName.setForeground(Color.RED);
        result.add((Component)this.productName, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        this.invertSelection = new JButton("De/Select");
        this.invertSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductiePanel.this.selected = !ProductiePanel.this.selected;
                ProductiePanel.this.invertSelection();
            }
        });
        result.add((Component)this.invertSelection, c);
        ++c.gridx;
        this.mese = new JButton(LangRoAll.mese);
        this.mese.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductiePanel.this.parent.switchToComenzi();
                ProductiePanel.this.isFocused = false;
            }
        });
        result.add((Component)this.mese, c);
        ++c.gridx;
        this.detalii = new JButton(LangRoAll.detalii);
        this.detalii.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ProductiePanel.this.currentItem != null) {
                    String details = ProductiePanel.this.logic.getDetails(ProductiePanel.this.currentItem.getIdProductie());
                    DetaliiProduseDialog dia = new DetaliiProduseDialog((Frame)GuiUtils.currentFrame, true, details);
                    ProductiePanel.this.lastAction = System.currentTimeMillis();
                }
            }
        });
        result.add((Component)this.detalii, c);
        ++c.gridx;
        this.accept = new JButton("Accept");
        this.accept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector selectedItems = ProductiePanel.this.getSelectedItems();
                for (ProductieEntry p : selectedItems) {
                    if ((p.getStatus() == 4 || p.getStatus() == 5 || p.getStatus() == 6) && selectedItems.size() != 1) continue;
                    ProductiePanel.this.logic.acceptata(p.getIdProductie(), p.getStatus());
                }
                ProductiePanel.this.reset();
                ProductiePanel.this.lastAction = System.currentTimeMillis();
                ProductiePanel.this.deselectAll();
            }
        });
        result.add((Component)this.accept, c);
        ++c.gridy;
        c.gridx = 0;
        this.refuz = new JButton("Refuz");
        this.refuz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector selectedItems = ProductiePanel.this.getSelectedItems();
                for (ProductieEntry p : selectedItems) {
                    if ((p.getStatus() == 4 || p.getStatus() == 5 || p.getStatus() == 6) && selectedItems.size() != 1) continue;
                    ProductiePanel.this.logic.refuzata(p.getIdProductie(), ProductiePanel.this.idSectii, p.getStatus());
                }
                ProductiePanel.this.reset();
                ProductiePanel.this.lastAction = System.currentTimeMillis();
                ProductiePanel.this.deselectAll();
            }
        });
        result.add((Component)this.refuz, c);
        ++c.gridx;
        this.start = new JButton("Incep");
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector selectedItems = ProductiePanel.this.getSelectedItems();
                for (ProductieEntry p : selectedItems) {
                    if ((p.getStatus() == 4 || p.getStatus() == 5) && selectedItems.size() != 1) continue;
                    ProductiePanel.this.logic.inLucru(p.getIdProductie(), p.getStatus());
                }
                ProductiePanel.this.reset();
                ProductiePanel.this.lastAction = System.currentTimeMillis();
                ProductiePanel.this.deselectAll();
            }
        });
        result.add((Component)this.start, c);
        ++c.gridx;
        this.terminata = new JButton("Terminata");
        this.terminata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector<ProductieEntry> selectedItems = new Vector<ProductieEntry>();
                for (ProductieEntry p : ProductiePanel.this.getSelectedItems()) {
                    if (p.getStatus() == 4 && selectedItems.size() != 1) continue;
                    selectedItems.add(p);
                }
                if (selectedItems.size() > 0) {
                    ProductiePanel.this.logic.terminata(selectedItems);
                }
                ProductiePanel.this.reset();
                ProductiePanel.this.lastAction = System.currentTimeMillis();
                ProductiePanel.this.deselectAll();
            }
        });
        result.add((Component)this.terminata, c);
        ++c.gridx;
        this.servita = new JButton("Servita");
        this.servita.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector selectedItems = ProductiePanel.this.getSelectedItems();
                if (selectedItems.size() > 0) {
                    ProductiePanel.this.logic.servita(selectedItems, ProductiePanel.this.masa, ProductiePanel.this.ospatar);
                }
                ProductiePanel.this.reset();
                ProductiePanel.this.lastAction = System.currentTimeMillis();
                ProductiePanel.this.deselectAll();
            }
        });
        result.add((Component)this.servita, c);
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        return result;
    }

    private Vector<ProductieEntry> getSelectedItems() {
        Vector<ProductieEntry> selectedItems = new Vector<ProductieEntry>();
        for (Object o : this.tm.getData()) {
            ProductieEntry p;
            if (!(o instanceof ProductieEntry) || !(p = (ProductieEntry)o).isSelected()) continue;
            selectedItems.add(p);
        }
        return selectedItems;
    }

    private void gotoComenzi() {
        this.parent.switchToComenzi();
        this.isFocused = false;
    }

    private void reset() {
        this.productName.setText("");
        this.refreshTable();
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Object o = data.elementAt(rowIndex);
                if (o instanceof String) {
                    return (String)o;
                }
                ProductieEntry pe = (ProductieEntry)o;
                return pe;
            }
        });
        return this.tm;
    }

    @Override
    public void doStuff() {
        this.display();
        this.table.setFont(new Font(null, 0, 24));
        this.table.setTableHeader(null);
        this.table.setRowHeight(24);
        ProductieCellRenderer cellRenderer = new ProductieCellRenderer(this.tm);
        GuiUtils.updateJTableColumns(this.table, cellRenderer);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ProductieEntry pe;
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                Object o = ProductiePanel.this.tm.getObjectAt(selRow);
                if (o instanceof String) {
                    return;
                }
                pe.setSelected(!(pe = (ProductieEntry)o).isSelected());
                ProductiePanel.this.currentItem = pe;
                ProductiePanel.this.tm.fireTableDataChanged();
                ProductiePanel.this.productName.setText(pe.toString());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public void setMasa(Vector idSectii, String masa, ProductieMain parent, String ospatar) {
        this.parent = parent;
        this.idSectii = idSectii;
        this.masa = masa;
        this.ospatar = ospatar;
        this.tm.refresh(this.buildData());
        this.logic.comandaVazuta(idSectii, masa);
        this.lastAction = System.currentTimeMillis();
        this.isFocused = true;
        this.deselectAll();
    }

    public Vector getIdSectie() {
        return this.idSectii;
    }

    public void setIdSectii(Vector idSectie) {
        this.idSectii = idSectie;
    }

    @Override
    public ProductieMain getParent() {
        return this.parent;
    }

    public void setParent(ProductieMain parent) {
        this.parent = parent;
    }

    public void setLogic(ProductieLogic logic) {
        this.logic = logic;
    }
}

