/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.productie.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import ro.atreides.productie.ProductieEntry;
import ro.atreides.productie.ProductieLogic;
import ro.atreides.productie.gui.DetaliiProduseDialog;
import ro.atreides.productie.gui.GolesteDialog;
import ro.atreides.productie.gui.GolireBean;
import ro.atreides.productie.gui.ProductieCellRenderer;
import ro.atreides.productie.gui.ProductieWaiterInterface;
import ro.atreides.productie.gui.SimpleProductieMain;
import ro.atreides.productie.gui.SimpleProductiePanel;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class SimpleProductieMultiSelectionPanel
extends SimpleProductiePanel {
    private JButton accept;
    private JButton refuz;
    private JButton start;
    private JButton terminata;
    private JButton servita;
    private JButton detalii;
    private JButton invertSelection;
    private AbstractTM tableModel;
    private ProductieEntry currentItem;
    private boolean selected = false;

    public SimpleProductieMultiSelectionPanel(int idUser, String userName, SimpleProductieMain parent, int fontSize, ProductieLogic logic, Vector readOnlySectii, Vector readWriteSectii, ProductieWaiterInterface waiterInterface) {
        super(idUser, userName, parent, fontSize, logic, readOnlySectii, readWriteSectii, waiterInterface);
    }

    @Override
    protected void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        this.alp = new AbstractListPanel(){

            @Override
            public AbstractTM buildTableModel() {
                SimpleProductieMultiSelectionPanel.this.tableModel = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        ProductieEntry pe = (ProductieEntry)data.elementAt(rowIndex);
                        return pe.toString();
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }
                });
                return SimpleProductieMultiSelectionPanel.this.tableModel;
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public Vector buildData() {
                Vector<ProductieEntry> data = SimpleProductieMultiSelectionPanel.this.logic.getByWaiter(SimpleProductieMultiSelectionPanel.this.idUser, SimpleProductieMultiSelectionPanel.this.readOnlySectii);
                return data;
            }

            @Override
            public String[] buildColumns() {
                return new String[]{SimpleProductieMultiSelectionPanel.this.userName};
            }

            @Override
            public Class[] buildTypes() {
                return new Class[]{String.class};
            }

            @Override
            public void doStuff() {
                this.display();
                this.table.setRowHeight(SimpleProductieMultiSelectionPanel.this.fontSize);
                this.table.setFont(new Font(null, 0, SimpleProductieMultiSelectionPanel.this.fontSize));
                this.table.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        Point p;
                        JTable t = (JTable)e.getSource();
                        int selRow = t.rowAtPoint(p = e.getPoint());
                        if (selRow == -1) {
                            return;
                        }
                        Object o = tm.getObjectAt(selRow);
                        if (o instanceof String) {
                            return;
                        }
                        ProductieEntry pe = (ProductieEntry)o;
                        SimpleProductieMultiSelectionPanel.this.currentItem = pe;
                        pe.setSelected(!pe.isSelected());
                        tm.fireTableDataChanged();
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }
                });
            }
        };
        c.gridwidth = 2;
        this.alp.doStuff();
        this.add((Component)this.alp, c);
        c.weighty = 0.0;
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        JButton goleste = new JButton("Goleste");
        goleste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector<GolireBean> optiuni = new Vector<GolireBean>();
                if (SimpleProductieMultiSelectionPanel.this.readWriteSectii.size() > 0) {
                    GolireBean gb1 = new GolireBean(5, "Terminate");
                    optiuni.add(gb1);
                    GolireBean gb2 = new GolireBean(6, "In lucru");
                    optiuni.add(gb2);
                    GolireBean gb3 = new GolireBean(1, "Noi");
                    optiuni.add(gb3);
                    GolireBean gb4 = new GolireBean(-1, LangRoAll.toate);
                    optiuni.add(gb4);
                    GolesteDialog dialog = new GolesteDialog(4, optiuni);
                    int sel = dialog.getSelected();
                    SimpleProductieMultiSelectionPanel.this.logic.finishByUserAndStatus(SimpleProductieMultiSelectionPanel.this.idUser, sel);
                }
            }
        });
        this.add((Component)goleste, c);
        if (this.parent != null) {
            ++c.gridx;
            this.zoom = new JButton("Mare");
            this.zoom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (SimpleProductieMultiSelectionPanel.this.zoom.getText().equalsIgnoreCase("Mare")) {
                        SimpleProductieMultiSelectionPanel.this.zoomIn();
                    } else {
                        SimpleProductieMultiSelectionPanel.this.zoomOut();
                    }
                }
            });
            this.add((Component)this.zoom, c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        this.add((Component)this.getActiuniPanel(), c);
        ProductieCellRenderer cellRenderer = new ProductieCellRenderer(this.alp.getTm());
        GuiUtils.updateJTableColumns(this.alp.getJTable(), cellRenderer);
    }

    protected void invertSelection() {
        for (Object o : this.tableModel.getData()) {
            if (!(o instanceof ProductieEntry)) continue;
            ProductieEntry p = (ProductieEntry)o;
            p.setSelected(this.selected);
        }
        this.tableModel.fireTableDataChanged();
    }

    protected void deselectAll() {
        this.selected = false;
        this.invertSelection();
    }

    private JPanel getActiuniPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        this.invertSelection = new JButton("De/Select");
        this.invertSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleProductieMultiSelectionPanel.this.selected = !SimpleProductieMultiSelectionPanel.this.selected;
                SimpleProductieMultiSelectionPanel.this.invertSelection();
            }
        });
        result.add((Component)this.invertSelection, c);
        SimpleProductieMultiSelectionPanel panel = this;
        ++c.gridx;
        this.detalii = new JButton(LangRoAll.detalii);
        this.detalii.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (SimpleProductieMultiSelectionPanel.this.currentItem != null) {
                    String details = SimpleProductieMultiSelectionPanel.this.logic.getDetails(SimpleProductieMultiSelectionPanel.this.currentItem.getIdProductie());
                    DetaliiProduseDialog detaliiProduseDialog = new DetaliiProduseDialog((Frame)GuiUtils.currentFrame, true, details);
                }
            }
        });
        result.add((Component)this.detalii, c);
        ++c.gridx;
        this.accept = new JButton("Accept");
        this.accept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector selectedItems = SimpleProductieMultiSelectionPanel.this.getSelectedItems();
                for (ProductieEntry p : selectedItems) {
                    if ((p.getStatus() == 4 || p.getStatus() == 5 || p.getStatus() == 6) && selectedItems.size() != 1) continue;
                    SimpleProductieMultiSelectionPanel.this.logic.acceptata(p);
                }
                SimpleProductieMultiSelectionPanel.this.alp.refreshTable();
                SimpleProductieMultiSelectionPanel.this.deselectAll();
            }
        });
        result.add((Component)this.accept, c);
        ++c.gridy;
        c.gridx = 0;
        this.refuz = new JButton("Refuz");
        this.refuz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector selectedItems = SimpleProductieMultiSelectionPanel.this.getSelectedItems();
                for (ProductieEntry p : selectedItems) {
                    if ((p.getStatus() == 4 || p.getStatus() == 5 || p.getStatus() == 6) && selectedItems.size() != 1) continue;
                    SimpleProductieMultiSelectionPanel.this.logic.refuzata(p, SimpleProductieMultiSelectionPanel.this.readWriteSectii);
                }
                SimpleProductieMultiSelectionPanel.this.alp.refreshTable();
                SimpleProductieMultiSelectionPanel.this.deselectAll();
            }
        });
        result.add((Component)this.refuz, c);
        ++c.gridx;
        this.start = new JButton("Incep");
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector selectedItems = SimpleProductieMultiSelectionPanel.this.getSelectedItems();
                for (ProductieEntry p : selectedItems) {
                    if ((p.getStatus() == 4 || p.getStatus() == 5) && selectedItems.size() != 1) continue;
                    SimpleProductieMultiSelectionPanel.this.logic.inLucru(p);
                }
                SimpleProductieMultiSelectionPanel.this.alp.refreshTable();
                SimpleProductieMultiSelectionPanel.this.deselectAll();
            }
        });
        result.add((Component)this.start, c);
        ++c.gridx;
        this.terminata = new JButton("Terminata");
        this.terminata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector<ProductieEntry> selectedItems = new Vector<ProductieEntry>();
                for (ProductieEntry p : SimpleProductieMultiSelectionPanel.this.getSelectedItems()) {
                    if (p.getStatus() == 4 && selectedItems.size() != 1) continue;
                    selectedItems.add(p);
                }
                for (ProductieEntry p : selectedItems) {
                    SimpleProductieMultiSelectionPanel.this.logic.terminata(p, SimpleProductieMultiSelectionPanel.this.readWriteSectii);
                }
                SimpleProductieMultiSelectionPanel.this.alp.refreshTable();
                SimpleProductieMultiSelectionPanel.this.deselectAll();
            }
        });
        result.add((Component)this.terminata, c);
        ++c.gridx;
        this.servita = new JButton("Servita");
        this.servita.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector selectedItems = SimpleProductieMultiSelectionPanel.this.getSelectedItems();
                if (selectedItems.size() > 0) {
                    SimpleProductieMultiSelectionPanel.this.logic.servita(selectedItems);
                }
                SimpleProductieMultiSelectionPanel.this.alp.refreshTable();
                SimpleProductieMultiSelectionPanel.this.deselectAll();
            }
        });
        result.add((Component)this.servita, c);
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        return result;
    }

    private Vector<ProductieEntry> getSelectedItems() {
        Vector<ProductieEntry> selectedItems = new Vector<ProductieEntry>();
        for (Object o : this.tableModel.getData()) {
            ProductieEntry p;
            if (!(o instanceof ProductieEntry) || !(p = (ProductieEntry)o).isSelected()) continue;
            selectedItems.add(p);
        }
        return selectedItems;
    }

    @Override
    protected void zoomIn() {
        this.zoom.setText("Mic");
        this.parent.zoomInPanel(this);
    }

    @Override
    protected void zoomOut() {
        this.zoom.setText("Mare");
        this.parent.zoomOut();
    }

    public void refreshData1() {
        boolean mustRefresh = true;
        for (Object o : this.tableModel.getData()) {
            ProductieEntry pe;
            if (!(o instanceof ProductieEntry) || !(pe = (ProductieEntry)o).isSelected()) continue;
            mustRefresh = false;
        }
        if (mustRefresh) {
            this.refreshData();
        } else {
            mustRefresh = false;
        }
    }
}

