/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.productie.gui.quick;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import ro.atreides.productie.MasaProductie;
import ro.atreides.productie.ProductieLogic;
import ro.atreides.productie.gui.quick.QuickProductiePanel;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;

public class QuickProductieMain
extends ReflectedJPanel {
    private ProductieLogic logic;
    private int waitersPerLine;
    private int fontSize;
    Vector<JPanel> panels = new Vector();
    private Hashtable<QuickProductiePanel, String> hash = new Hashtable();
    private Hashtable<Integer, Integer> howMany = new Hashtable();
    private Hashtable<Integer, JLabel> labels = new Hashtable();
    private GridBagConstraints addProductConstraints;

    public QuickProductieMain() {
        this.logic = ProductieLogic.getInstance();
        this.waitersPerLine = Config.getInstance().getInt("productieQuickWaitersPerLine", 2);
        this.fontSize = Config.getInstance().getInt("productieQuickFontSize", 20);
        this.addProductConstraints = new GridBagConstraints();
        this.addProductConstraints.weightx = 1.0;
        this.addProductConstraints.weighty = 0.0;
        this.addProductConstraints.anchor = 11;
        this.addProductConstraints.fill = 2;
        this.addProductConstraints.insets = new Insets(5, 2, 5, 2);
        for (int i = 0; i < this.waitersPerLine; ++i) {
            JPanel pan = new JPanel(new GridBagLayout());
            pan.setBorder(new TitledBorder("" + i));
            this.panels.add(pan);
        }
        this.buildPanels();
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    Vector<MasaProductie> mustAdd = new Vector<MasaProductie>();
                    Vector<MasaProductie> comenzi = QuickProductieMain.this.logic.getComenzi(QuickProductieMain.this.logic.getReadIds());
                    for (MasaProductie masaProductie : comenzi) {
                        boolean found = false;
                        for (QuickProductiePanel quickProductiePanel : QuickProductieMain.this.hash.keySet()) {
                            if (!masaProductie.getMasa().equalsIgnoreCase(quickProductiePanel.getMasa())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        mustAdd.add(masaProductie);
                    }
                    for (MasaProductie masaProductie : mustAdd) {
                        int minIndex = 0;
                        int min = QuickProductieMain.this.hash.size();
                        for (int i = 0; i < QuickProductieMain.this.panels.size(); ++i) {
                            int j = QuickProductieMain.this.panels.get(i).getComponentCount();
                            if (j >= min) continue;
                            min = j;
                            minIndex = i;
                        }
                        JLabel space = (JLabel)QuickProductieMain.this.labels.get(minIndex);
                        QuickProductieMain.this.panels.get(minIndex).remove(space);
                        QuickProductieMain.this.addPanel(masaProductie, minIndex);
                        QuickProductieMain.this.addLabel(minIndex);
                    }
                    Vector<QuickProductiePanel> toDelete = new Vector<QuickProductiePanel>();
                    for (QuickProductiePanel productiePanel : QuickProductieMain.this.hash.keySet()) {
                        productiePanel.refreshData();
                        if (productiePanel.isEmpty()) {
                            toDelete.add(productiePanel);
                        } else {
                            Dimension d = productiePanel.getSize();
                            d.setSize(d.getWidth(), (double)productiePanel.getMinimmumHeight());
                            productiePanel.setPreferredSize(d);
                            productiePanel.setSize(d);
                            productiePanel.setMaximumSize(d);
                        }
                        productiePanel.revalidate();
                        productiePanel.repaint();
                    }
                    for (QuickProductiePanel panel : toDelete) {
                        QuickProductieMain.this.stergeComanda(panel);
                    }
                    QuickProductieMain.this.revalidate();
                    QuickProductieMain.this.repaint();
                }
            }
        }.start();
    }

    public void stergeComanda(QuickProductiePanel child) {
        String location = this.hash.get(child);
        System.out.println("location: " + location);
        Vector coordinates = Utils.splitString(location, '_');
        int x = Integer.parseInt((String)coordinates.get(0));
        JPanel addTo = this.panels.get(x);
        addTo.setVisible(false);
        addTo.remove(child);
        addTo.setVisible(true);
        this.hash.remove(child);
    }

    private void addPanel(MasaProductie masaProductie, int panelToUse) {
        QuickProductiePanel productiePanel = new QuickProductiePanel(masaProductie.getMasa(), this, this.fontSize, this.logic, this.logic.getReadIds(), this.logic.getWriteIds(), ProductieLogic.waiterInterface);
        Dimension d = productiePanel.getSize();
        d.setSize(d.getWidth(), (double)productiePanel.getMinimmumHeight());
        productiePanel.setPreferredSize(d);
        productiePanel.setSize(d);
        productiePanel.setMaximumSize(d);
        JPanel addTo = this.panels.get(panelToUse);
        Integer lastIndex = this.howMany.get(panelToUse);
        int last = -1;
        if (lastIndex != null) {
            last = lastIndex;
        }
        int y = last + 1;
        this.addProductConstraints.weighty = 0.0;
        this.addProductConstraints.gridy = y;
        addTo.add((Component)productiePanel, this.addProductConstraints);
        this.hash.put(productiePanel, panelToUse + "_" + y);
        this.howMany.put(panelToUse, y);
        addTo.setVisible(false);
        addTo.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    private void addLabel(int panelToUse) {
        JPanel addTo = this.panels.get(panelToUse);
        Integer lastIndex = this.howMany.get(panelToUse);
        int last = -1;
        if (lastIndex != null) {
            last = lastIndex;
        }
        JLabel space = new JLabel();
        this.addProductConstraints.gridy = last + 1;
        this.addProductConstraints.weighty = 1.0;
        this.addProductConstraints.fill = 1;
        addTo.add((Component)space, this.addProductConstraints);
        this.labels.put(panelToUse, space);
    }

    private void buildPanels() {
        Vector<MasaProductie> comenzi = this.logic.getComenzi(this.logic.getReadIds());
        int i = 0;
        for (MasaProductie masaProductie : comenzi) {
            int panelToUse = i % this.waitersPerLine;
            this.addPanel(masaProductie, panelToUse);
            ++i;
        }
        for (i = 0; i < this.panels.size(); ++i) {
            int panelToUse = i % this.waitersPerLine;
            this.addLabel(panelToUse);
        }
    }

    private JPanel redraw() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(5, 2, 5, 2);
        c.gridx = 0;
        c.gridy = 0;
        for (JPanel panel : this.panels) {
            result.add((Component)panel, c);
            ++c.gridx;
        }
        return result;
    }

    @Override
    public void doStuff() {
        JPanel panel = this.redraw();
        JScrollPane scrollPane = new JScrollPane(panel);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.setVisible(false);
        this.removeAll();
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)scrollPane, c);
    }
}

