/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.productie.gui.quick;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import ro.atreides.productie.ProductieEntry;
import ro.atreides.productie.ProductieLogic;
import ro.atreides.productie.gui.ProductieCellRenderer;
import ro.atreides.productie.gui.ProductieWaiterInterface;
import ro.atreides.productie.gui.quick.QuickProductieMain;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;

public class QuickProductiePanel
extends JPanel {
    protected int fontSize;
    protected QuickProductieMain parent;
    protected ProductieLogic logic;
    protected AbstractListPanel alp;
    protected Vector readOnlySectii;
    protected Vector readWriteSectii;
    protected ProductieWaiterInterface waiterInterface;
    private String masa;
    public static String showButtons;

    public QuickProductiePanel(String masa, QuickProductieMain parent, int fontSize, ProductieLogic logic, Vector readOnlySectii, Vector readWriteSectii, ProductieWaiterInterface waiterInterface) {
        this.masa = masa;
        this.parent = parent;
        this.fontSize = fontSize;
        this.logic = logic;
        this.readOnlySectii = readOnlySectii;
        this.readWriteSectii = readWriteSectii;
        this.waiterInterface = waiterInterface;
        this.display();
    }

    protected void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        final QuickProductiePanel child = this;
        this.alp = new AbstractListPanel(){

            @Override
            public AbstractTM buildTableModel() {
                this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        Object o = data.elementAt(rowIndex);
                        return o.toString();
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }
                });
                return this.tm;
            }

            @Override
            public JPanel getBottomPanel() {
                JPanel result = new JPanel(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.anchor = 10;
                c.fill = 1;
                c.insets = new Insets(2, 2, 2, 2);
                c.gridy = 0;
                c.gridwidth = 1;
                ++c.gridy;
                c.gridx = -1;
                Vector buttons = Utils.splitString(showButtons, ',');
                for (String button : buttons) {
                    if (button.equalsIgnoreCase("Incep")) {
                        ++c.gridx;
                        JButton incep = new JButton("Incep");
                        incep.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                for (Object o : tm.getData()) {
                                    if (!(o instanceof ProductieEntry)) continue;
                                    ProductieEntry p = (ProductieEntry)o;
                                    QuickProductiePanel.this.logic.inLucru(p.getIdProductie(), p.getStatus());
                                }
                            }
                        });
                        result.add((Component)incep, c);
                        continue;
                    }
                    if (button.equalsIgnoreCase("Terminat")) {
                        ++c.gridx;
                        JButton terminat = new JButton("Terminat");
                        terminat.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                for (Object o : tm.getData()) {
                                    if (!(o instanceof ProductieEntry)) continue;
                                    ProductieEntry p = (ProductieEntry)o;
                                    QuickProductiePanel.this.logic.terminata(p.getIdProductie(), QuickProductiePanel.this.readWriteSectii, p.getStatus());
                                }
                                QuickProductiePanel.this.parent.stergeComanda(child);
                            }
                        });
                        result.add((Component)terminat, c);
                        continue;
                    }
                    if (!button.equalsIgnoreCase("Servit")) continue;
                    ++c.gridx;
                    JButton servit = new JButton("Servit");
                    servit.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Vector<ProductieEntry> servite = new Vector<ProductieEntry>();
                            for (Object o : tm.getData()) {
                                if (!(o instanceof ProductieEntry)) continue;
                                ProductieEntry p = (ProductieEntry)o;
                                servite.add(p);
                            }
                            if (QuickProductiePanel.this.logic.servitaQuick(servite)) {
                                QuickProductiePanel.this.parent.stergeComanda(child);
                            }
                        }
                    });
                    result.add((Component)servit, c);
                }
                return result;
            }

            @Override
            public Vector buildData() {
                Vector data = QuickProductiePanel.this.logic.getAllForMasa(QuickProductiePanel.this.readOnlySectii, QuickProductiePanel.this.masa);
                return data;
            }

            @Override
            public String[] buildColumns() {
                return new String[]{QuickProductiePanel.this.masa};
            }

            @Override
            public Class[] buildTypes() {
                return new Class[]{String.class};
            }

            @Override
            public void doStuff() {
                this.display();
                this.table.setRowHeight(QuickProductiePanel.this.fontSize);
                this.table.setFont(new Font(null, 0, QuickProductiePanel.this.fontSize));
            }
        };
        this.alp.doStuff();
        this.add((Component)this.alp, c);
        ProductieCellRenderer cellRenderer = new ProductieCellRenderer(this.alp.getTm());
        GuiUtils.updateJTableColumns(this.alp.getJTable(), cellRenderer);
    }

    public void refreshData() {
        this.alp.refreshTable();
    }

    public boolean isEmpty() {
        return this.alp.getTm().getData().size() <= 1;
    }

    public String getMasa() {
        return this.masa;
    }

    public int getMinimmumHeight() {
        return this.alp.getTm().getData().size() * this.fontSize * 1 + 65;
    }
}

