/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.promo;

import java.util.Date;
import java.util.Vector;
import ro.atreides.promo.PriceWrapper;
import ro.atreides.promo.PromotionElement;
import ro.atreides.promo.PromotionPeriod;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.multilanguage.LanguageLogic;
import ro.atreides.utils.plati.SimplePromotion;

public class Promotion
extends SimplePromotion {
    public static final int PRET_FIX = 1;
    public static final int REDUCERE_PROCENT = 2;
    public static final int REDUCERE_FIXA = 3;
    public static final int X_PLUS_UNU = 4;
    private int type;
    private boolean publicPromotion;
    private PromotionPeriod period;
    private Vector<PromotionElement> promoElements;

    public Promotion(int id, String label, int type, Date start, Date stop, int periodType, String weekDays) {
        super(id, label);
        this.type = type;
        this.period = new PromotionPeriod(start, stop, periodType, weekDays);
    }

    public Vector<PromotionElement> getPromoElements() {
        return this.promoElements;
    }

    public void setPromoElements(Vector<PromotionElement> promoElements) {
        this.promoElements = promoElements;
    }

    public boolean isPublicPromotion() {
        return this.publicPromotion;
    }

    public void setPublicPromotion(boolean publicPromotion) {
        this.publicPromotion = publicPromotion;
    }

    public PromotionPeriod getPeriod() {
        return this.period;
    }

    public void setPromotionPeriod(PromotionPeriod pp) {
        this.period = pp;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String toString() {
        return this.label;
    }

    public boolean isPromotionActive(long date) {
        return this.period.isPromotionActive(date);
    }

    private double getPriceForProduct(double originalPrice, PromotionElement element) {
        double price = originalPrice;
        switch (this.type) {
            case 1: {
                price = element.getValue();
                break;
            }
            case 2: {
                double reducere = element.getValue() * price / 100.0;
                price += reducere;
                break;
            }
            case 3: {
                price += element.getValue();
                break;
            }
            case 4: {
                price = originalPrice;
                break;
            }
        }
        return price;
    }

    private PromotionElement isActiveForProduct(int idProdus1, int idSubcat1, int idCat1, double orderTotal) {
        PromotionElement result = null;
        int level = 0;
        for (int i = 0; i < this.promoElements.size(); ++i) {
            PromotionElement o = this.promoElements.elementAt(i);
            boolean elementOK = false;
            level = 0;
            if (o.getOrderMinimValue() > 0.0 && orderTotal < o.getOrderMinimValue()) {
                elementOK = false;
            } else if (o.getCategory() == -1) {
                elementOK = true;
            } else {
                level = 1;
                if (o.getCategory() != idCat1) {
                    elementOK = false;
                } else if (o.getSubcat() == -1) {
                    elementOK = true;
                } else {
                    level = 2;
                    int s1 = o.getSubcat();
                    if (s1 != idSubcat1) {
                        elementOK = false;
                    } else if (o.getProduct() == -1) {
                        elementOK = true;
                    } else {
                        level = 3;
                        elementOK = idProdus1 == o.getProduct();
                    }
                }
            }
            if (!elementOK) continue;
            result = o;
            result.setLevel(level);
            break;
        }
        return result;
    }

    public boolean usesProduct(int idProd) {
        boolean result = false;
        for (int i = 0; i < this.promoElements.size(); ++i) {
            PromotionElement o = this.promoElements.elementAt(i);
            if (o.getProduct() == -1 || o.getProduct() != idProd) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean usesSubcategory(int idSubcat1) {
        boolean result = false;
        for (int i = 0; i < this.promoElements.size(); ++i) {
            PromotionElement o = this.promoElements.elementAt(i);
            if (o.getSubcat() == -1 || o.getSubcat() != idSubcat1) continue;
            result = true;
            break;
        }
        return result;
    }

    public PriceWrapper getPw(int idProduct, int idSubcat, int idCat, double normalPrice, long saleDate, double orderValue) {
        PromotionElement found;
        PriceWrapper result = null;
        boolean b1 = this.isPromotionActive(saleDate);
        if (b1 && (found = this.isActiveForProduct(idProduct, idSubcat, idCat, orderValue)) != null) {
            result = new PriceWrapper(normalPrice, -1, 0.0);
            double newPrice = this.getPriceForProduct(normalPrice, found);
            newPrice = FloatUtils.roundDoubleUp(newPrice, 2);
            result.setPrice(newPrice);
            result.setDiffPret(normalPrice - newPrice);
            result.setIdPromotion(this.getId());
            if (this.getType() == 4) {
                result.setIdPromotieXPlusUnu(this.getId());
                result.setValueXForXPlusUnuPromotie((int)found.getValue());
            }
            Logger.logDebugVerbose(this, "Am gasit promotia : " + this.getLabel() + " pt produsul : " + idProduct);
        }
        return result;
    }

    public boolean isStrongerThan(Promotion two, int targetSectie, int targetCategorie, int targetProdus, double orderValue) {
        if (two == null) {
            return true;
        }
        PromotionElement found = this.isActiveForProduct(targetProdus, targetCategorie, targetSectie, orderValue);
        if (found != null) {
            PromotionElement foundTwo = two.isActiveForProduct(targetProdus, targetCategorie, targetSectie, orderValue);
            if (foundTwo != null) {
                return found.getLevel() > foundTwo.getLevel();
            }
            return true;
        }
        return false;
    }

    public String getTypeName() {
        switch (this.type) {
            case 1: {
                return LanguageLogic.promo_pret_fix;
            }
            case 3: {
                return LanguageLogic.promo_reducere_fixa;
            }
            case 2: {
                return LanguageLogic.promo_reducere_procent;
            }
            case 4: {
                return LanguageLogic.promo_x_plus_unu;
            }
        }
        return LanguageLogic.common_nedefinit;
    }
}

