/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.promo;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import jxl.read.biff.BiffException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.promo.ClientPromotieView;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionElement;
import ro.atreides.promo.db.PromotionsImpl;
import ro.atreides.promo.gui.PromotiiDialog;
import ro.atreides.promo.importPromotiiClientiInterface;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.utils.Client;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.excel.ExcelImportInterface;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.PromotionsInterface;

public class PromotionLogic
extends EventGenerator
implements PromotionsInterface {
    private static PromotionLogic instance;
    private ConnectionPool pool = ConnectionPool.getInstance();

    public static synchronized PromotionLogic getInstance() {
        if (instance == null) {
            instance = new PromotionLogic();
        }
        return instance;
    }

    private PromotionLogic() {
    }

    private synchronized PromotionsImpl getPromotionsImpl() {
        ConnectionWrapper connection = this.pool.requestConnection();
        PromotionsImpl dao = null;
        while (dao == null) {
            dao = (PromotionsImpl)this.pool.getDao(PromotionsImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(PromotionsImpl.class.getName(), connection);
        }
        return dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Promotion> getFidelitatePromotions() {
        try {
            Vector<Promotion> result;
            Vector<Promotion> vector = result = this.getPromotionsImpl().getFidelitatePromotions();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Promotion> vector = new Vector<Promotion>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector<Promotion> getPromotions() {
        try {
            Vector<Promotion> result;
            Vector<Promotion> vector = result = this.getPromotionsImpl().getPromotions();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Promotion> vector = new Vector<Promotion>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newPromotion(Promotion toAdd, Vector elements) {
        boolean modified = false;
        try {
            this.getPromotionsImpl().addPromotion(toAdd);
            int idPromo = this.pool.requestConnection().getIndentityLocal();
            for (int i = 0; i < elements.size(); ++i) {
                PromotionElement o = (PromotionElement)elements.elementAt(i);
                this.getPromotionsImpl().addPromotionElement(idPromo, o);
            }
            this.pool.commit();
            modified = true;
        }
        catch (SQLException ex) {
            Logger.logException(this, (Exception)ex);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        if (modified) {
            this.notifyListeners(8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePromotion(int promotionId) {
        boolean modified = false;
        try {
            this.getPromotionsImpl().deletePromotion(promotionId);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        if (modified) {
            this.notifyListeners(8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePromotion(Promotion toUpdate, Vector elements) {
        boolean modified = false;
        try {
            this.getPromotionsImpl().updatePromotion(toUpdate);
            this.getPromotionsImpl().deletePromotionsElementsForPromotion(toUpdate.getId());
            for (int i = 0; i < elements.size(); ++i) {
                PromotionElement o = (PromotionElement)elements.elementAt(i);
                this.getPromotionsImpl().addPromotionElement(toUpdate.getId(), o);
            }
            this.pool.commit();
            modified = true;
        }
        catch (SQLException ex) {
            Logger.logException(this, (Exception)ex);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        if (modified) {
            this.notifyListeners(8);
        }
    }

    public String getPromotionsThatUseSubcategory(Integer sc) {
        String result = "";
        for (Promotion element : this.getPromotions()) {
            if (!element.usesSubcategory(sc)) continue;
            Logger.logDebugVerbose(this, "subcat for promotion : " + element.getLabel() + " is : " + sc);
            result = result + element.getLabel() + " ";
        }
        return result;
    }

    public String getPromotionsThatUseProduct(Integer prod) {
        String result = "";
        for (Promotion element : this.getPromotions()) {
            if (!element.usesProduct(prod)) continue;
            Logger.logDebugVerbose(this, "product for promotion : " + element.getLabel() + " is : " + prod);
            result = result + element.getLabel() + " ";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePromotionClient(int id) {
        try {
            this.getPromotionsImpl().deletePromotiiClient(id);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPromotionClientCuCodSync(int idClient, int idPromotie, String cardStart, String cardStop, String codSync, Timestamp dateadded) {
        try {
            this.getPromotionsImpl().addPromotiiClientCuCodSync(idClient, idPromotie, cardStart, cardStop, codSync, dateadded);
            this.pool.commit();
        }
        catch (SQLException e) {
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPromotionClient(int idClient, int idPromotie, String cardStart, String cardStop) {
        try {
            this.addPromotionClientNoCommit(idClient, idPromotie, cardStart, cardStop);
            this.pool.commit();
        }
        catch (SQLException e) {
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void addPromotionClientNoCommit(int idClient, int idPromotie, String cardStart, String cardStop) throws SQLException {
        int idPromotieClientCard = this.getPromotionsImpl().addPromotiiClient(idClient, idPromotie, cardStart, cardStop);
        this.setPromotiiClientiCodSync(idPromotieClientCard, VpConfig.getInstance().codUnicDatabase + "_" + idPromotieClientCard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ClientPromotieView> getPromotiiClient() {
        try {
            Vector<ClientPromotieView> result;
            Vector<ClientPromotieView> vector = result = this.getPromotionsImpl().getAllPromotiiClient();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<ClientPromotieView> vector = new Vector<ClientPromotieView>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<ClientPromotieView> getPromotiiClientSorted() {
        Vector<ClientPromotieView> promotiiClient = this.getPromotiiClient();
        Collections.sort(promotiiClient, new Comparator<ClientPromotieView>(){

            @Override
            public int compare(ClientPromotieView o1, ClientPromotieView o2) {
                return o1.getClient().compareToIgnoreCase(o2.getClient());
            }
        });
        return promotiiClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ClientPromotieView> getPromotiiClientForCard(String card) {
        try {
            Vector<ClientPromotieView> clientiPromotii;
            Vector<ClientPromotieView> vector = clientiPromotii = this.getPromotionsImpl().getPromotieClientForCard(card);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<ClientPromotieView> vector = new Vector<ClientPromotieView>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientPromotieView getClientPromotieForCard(String card) {
        try {
            ClientPromotieView clientPromotieView = this.getClientPromotieForCardNoCommit(card);
            return clientPromotieView;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            ClientPromotieView clientPromotieView = null;
            return clientPromotieView;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public ClientPromotieView getClientPromotieForCardNoCommit(String card) throws SQLException {
        Vector<ClientPromotieView> clientiPromotii = this.getPromotionsImpl().getPromotieClientForCard(card);
        if (clientiPromotii.size() > 0) {
            ClientPromotieView result = clientiPromotii.get(0);
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promotion getPromotionById(int id) {
        try {
            Promotion result;
            Promotion promotion = result = this.getPromotionByIdNoCommit(id);
            return promotion;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Promotion promotion = null;
            return promotion;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Promotion getPromotionByIdNoCommit(int id) throws SQLException {
        return this.getPromotionsImpl().getPromotionById(id);
    }

    public void deleteAllPromotions() throws SQLException {
        this.getPromotionsImpl().deleteAllPromotions();
    }

    public void deleteAllPromotiiClienti() throws SQLException {
        this.getPromotionsImpl().deleteAllPromotiiClienti();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getPremiiInstant() {
        try {
            Vector vector = this.getPromotionsImpl().getPremiiInstant();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePremiu(int id) {
        try {
            this.getPromotionsImpl().deletePremiuInstant(id);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPremiu(String premiu, double valoare, int nrZile) {
        try {
            this.getPromotionsImpl().addPremiuInstant(premiu, valoare, nrZile);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPromotiiClientiBulk(String clientPrefix, String cardPrefix, int start, int stop, int suffixSize, int idPromotion) {
        try {
            for (int i = start; i <= stop; ++i) {
                String suffix = Utils.getStringMaxSize(suffixSize, i + "", Character.valueOf('0'), true);
                String fullCard = cardPrefix + suffix;
                String clientName = clientPrefix + "_" + suffix;
                int idClient = ClientLogic.getInstance().addPersFizicaNoCommit(clientName, "", "", 1, "", -1, -1, -1, "", "", "", "", "", "", "", "", new Date(), null, new Date(), "");
                Client c = ClientLogic.getInstance().getClientByIdNoCommit(idClient);
                ClientLogic.getInstance().syncClientNoCommit(c);
                this.addPromotionClientNoCommit(idClient, idPromotion, fullCard, fullCard);
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Logger.logException(this, (Exception)e);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void setPromotiiClientiCodSync(int idPromotieClient, String codSync) throws SQLException {
        this.getPromotionsImpl().updateCodSyncForCard(codSync, idPromotieClient);
    }

    public void generateCarduriFidelitate(Component panel) {
        Vector<Promotion> promotii = PromotionLogic.getInstance().getFidelitatePromotions();
        if (promotii.size() <= 0) {
            DialogUtils.errorDialog(panel, "Trebuie sa definiti cel putin o promotie", LangRoAll.nuPotContinua);
            return;
        }
        String prefix = DialogUtils.inputDialog(panel, "000000", "Introduceti prefixul");
        String startIndex = DialogUtils.inputDialog(panel, "0001", "Introduceti codul de start");
        if (!Validators.correctInteger(startIndex)) {
            DialogUtils.errorDialog(panel, startIndex + " nu este un numar intreg.", LangRoAll.nuPotContinua);
            return;
        }
        String stopIndex = DialogUtils.inputDialog(panel, "2999", "Introduceti codul de stop");
        if (!Validators.correctInteger(stopIndex)) {
            DialogUtils.errorDialog(panel, stopIndex + " nu este un numar intreg.", LangRoAll.nuPotContinua);
            return;
        }
        String clientPrefix = DialogUtils.inputDialog(panel, "cupon", "Introduceti prefixul clientului");
        PromotiiDialog dialog = new PromotiiDialog(4, promotii);
        int idPromotie = dialog.getSelected();
        int start = Integer.valueOf(startIndex);
        int stop = Integer.valueOf(stopIndex);
        String cardStart = prefix + startIndex;
        String cardStop = prefix + stopIndex;
        if (DialogUtils.confirmDialog(panel, "Adaugam carduri fidelitate de la \"" + cardStart + "\" la \"" + cardStop + "\" ", LangRoAll.confirmare)) {
            PromotionLogic.getInstance().addPromotiiClientiBulk(clientPrefix, prefix, start, stop, stopIndex.length(), idPromotie);
            DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existaCardPentruClient(int idClient, int idPromotie, String cardStart, String cardStop) {
        boolean result = false;
        try {
            result = this.getPromotionsImpl().getPromotiiClientByIdClientCard(idClient, idPromotie, cardStart, cardStop);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ClientPromotieView> getPromotiiClientByIdClient(int idClient) {
        Vector<ClientPromotieView> result = new Vector();
        try {
            result = this.getPromotionsImpl().getPromotiiClientByIdClient(idClient);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Promotion> getPromotiiForClientByIdClientV2(int idClient) {
        try {
            Vector<Promotion> result = new Vector<Promotion>();
            Vector<ClientPromotieView> cpvClient = this.getPromotionsImpl().getPromotiiClientByIdClient(idClient);
            Vector<Promotion> promotions = this.getPromotionsImpl().getPromotions();
            Hashtable<Integer, Promotion> promotiiHash = new Hashtable<Integer, Promotion>();
            for (Promotion promotion : promotions) {
                promotiiHash.put(promotion.getId(), promotion);
            }
            for (ClientPromotieView cpv : cpvClient) {
                result.add((Promotion)promotiiHash.get(cpv.getIdPromotie()));
            }
            Vector<Promotion> vector = result;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Promotion> vector = new Vector<Promotion>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePromotionClientByCodSync(String codSync) {
        try {
            this.getPromotionsImpl().deletePromotiiClientByCodSync(codSync);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Promotion getPromotionByLabel(String label) {
        Promotion result = null;
        try {
            result = this.getPromotionsImpl().getPromotionByLabel(label);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Promotion getPromotionByLabelNoCommit(String label) throws SQLException {
        return this.getPromotionsImpl().getPromotionByLabel(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePromotieClient(ClientPromotieView promotieClient) {
        try {
            this.getPromotionsImpl().updatePromotieClient(promotieClient.getId(), promotieClient.getCodStart(), promotieClient.getCodStop());
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void importPromotiiClientiGeneric(File file, importPromotiiClientiInterface importInterface) {
        importInterface.importPromotiiClienti(file);
    }

    public void importPromotiiClientFromExcel(File fileExcel) {
        final Vector toAdd = new Vector();
        this.importPromotiiClientiGeneric(fileExcel, new importPromotiiClientiInterface(){

            @Override
            public void importPromotiiClienti(File fileToImport) {
                try {
                    int batchSize = 500;
                    ExcelUtils.readExcel(fileToImport, new ExcelImportInterface(){
                        String numeClient;
                        String promotie;
                        String codStart;
                        String codStop;
                        int positionInBatch = 1;
                        int line = 1;

                        @Override
                        public void valueRead(int row, int column, String value) {
                            switch (column) {
                                case 0: {
                                    this.numeClient = value;
                                    break;
                                }
                                case 1: {
                                    this.promotie = value;
                                    break;
                                }
                                case 2: {
                                    this.codStart = value;
                                    break;
                                }
                                case 3: {
                                    this.codStop = value;
                                    break;
                                }
                            }
                        }

                        @Override
                        public void lineEnd() {
                            if (this.codStop == null || this.codStop.isEmpty()) {
                                this.codStop = this.codStart;
                            }
                            ClientPromotieView cpv = new ClientPromotieView();
                            cpv.setClient(this.numeClient);
                            cpv.setPromotie(this.promotie);
                            cpv.setCodStart(this.codStart);
                            cpv.setCodStop(this.codStop);
                            toAdd.add(cpv);
                        }

                        @Override
                        public void lineStart() {
                            this.codStop = "";
                            this.codStart = "";
                            this.promotie = "";
                            this.numeClient = "";
                        }

                        @Override
                        public void sheetStart(String sheetName) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void sheetEnd(String sheetName) {
                            try {
                                for (int i = 0; i < toAdd.size(); ++i) {
                                    ClientPromotieView cpv = (ClientPromotieView)toAdd.elementAt(i);
                                    Client client = ClientLogic.getInstance().getClientByNameNoCommit(cpv.getClient());
                                    Promotion promotion = PromotionLogic.this.getPromotionByLabelNoCommit(cpv.getPromotie());
                                    if (client != null) {
                                        if (promotion != null) {
                                            PromotionLogic.this.addPromotionClient(client.getId(), promotion.getId(), cpv.getCodStart(), cpv.getCodStop());
                                        } else {
                                            Logger.logError((Object)this, "Nu se gaseste promotia de la linia " + this.line);
                                        }
                                    } else {
                                        Logger.logError((Object)this, "Nu se gaseste clientul de la linia " + this.line);
                                    }
                                    ++this.positionInBatch;
                                    ++this.line;
                                    if (500 > this.positionInBatch) continue;
                                    this.positionInBatch = 1;
                                    PromotionLogic.this.pool.commit();
                                }
                                PromotionLogic.this.pool.commit();
                            }
                            catch (SQLException e) {
                                Logger.logException(this, (Exception)e);
                                try {
                                    PromotionLogic.this.pool.rollBack();
                                }
                                catch (SQLException e1) {
                                    Logger.logException(this, (Exception)e1);
                                }
                            }
                            finally {
                                PromotionLogic.this.pool.releaseConnection();
                            }
                        }
                    });
                }
                catch (IOException e) {
                    Logger.logException(this, (Exception)e);
                }
                catch (BiffException e) {
                    Logger.logException(this, (Exception)((Object)e));
                }
            }
        });
        DialogUtils.okDialog(GuiUtils.currentFrame, "Import realizat cu succes", LangRoAll.succes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cardClientExists(String card) {
        try {
            boolean bl = this.getPromotionsImpl().cardClientExists(card);
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return false;
    }
}

