/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.promo.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionElement;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.promo.PromotionPeriod;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.SwitchToList;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class EditPromotionPanel
extends ReflectedJPanel {
    private JTextField _nameField;
    private JTextField _valueField;
    private JTextField _totalOrderField;
    private JTextField _startField;
    private JTextField _stopField;
    private JTextField daysInWeek;
    private JRadioButton _fixedPriceRadioButton;
    private JRadioButton _procentRadioButton;
    private JRadioButton _fixedValueRadioButton;
    private JRadioButton _xPlusOneRadioButton;
    private JRadioButton _hourPeriodRadioButton;
    private JRadioButton _datePeriodRadioButton;
    private JRadioButton _permanentRadioButton;
    private JComboBox _categoryComboBox;
    private JComboBox _subCategoryComboBox;
    private JComboBox _productComboBox = null;
    private JCheckBox _clientiFideliOnly = null;
    private JButton _addButton;
    private JButton _deleteButton;
    private JButton _saveButton;
    private JButton _resetButton;
    private Promotion _promotion = null;
    private PromotionLogic promotionsLogic = null;
    private NomeclaturaLogic nomenclaturaLogic;
    private SwitchToList action;
    private Vector elements = new Vector();
    private AbstractListPanel elementsPanel;

    @Override
    public void doStuff() {
    }

    public EditPromotionPanel(Promotion p, NomeclaturaLogic logic) {
        this.nomenclaturaLogic = logic;
        this._promotion = p;
        this.promotionsLogic = PromotionLogic.getInstance();
        this.display();
        this.initFields();
    }

    public void cleanup() {
    }

    public void setAction(SwitchToList action) {
        this.action = action;
    }

    private boolean updatePromotionAttr() {
        String s1;
        String label = this._nameField.getText();
        int type = 1;
        if (this._fixedPriceRadioButton.isSelected()) {
            type = 1;
        } else if (this._procentRadioButton.isSelected()) {
            type = 2;
        } else if (this._fixedValueRadioButton.isSelected()) {
            type = 3;
        } else if (this._xPlusOneRadioButton.isSelected()) {
            type = 4;
        }
        Date start = new Date();
        Date stop = new Date();
        int periodType = 3;
        if (!this._permanentRadioButton.isSelected()) {
            periodType = 2;
            SimpleDateFormat sdf = Formatters.TIME_FORMAT;
            if (this._datePeriodRadioButton.isSelected()) {
                periodType = 1;
                sdf = Formatters.DATE_FORMAT;
            }
            try {
                start = sdf.parse(this._startField.getText());
            }
            catch (ParseException ex) {
                DialogUtils.errorDialog(this, "Campul start este gresit !!", LangRoAll.nuPotContinua);
                return false;
            }
            try {
                stop = sdf.parse(this._stopField.getText());
            }
            catch (ParseException ex) {
                DialogUtils.errorDialog(this, "Campul stop este gresit !!", LangRoAll.nuPotContinua);
                return false;
            }
        }
        if (!Validators.correctString(s1 = this.daysInWeek.getText())) {
            DialogUtils.errorDialog(this, "Completati zilele saptamanii (*,1,2..)", LangRoAll.nuPotContinua);
            return false;
        }
        PromotionPeriod promotionPeriod = new PromotionPeriod(start, stop, periodType, s1);
        if (this._promotion == null) {
            this._promotion = new Promotion(new Integer(-1), label, type, start, stop, periodType, s1);
        } else {
            this._promotion.setLabel(label);
            this._promotion.setType(type);
            this._promotion.setPromotionPeriod(promotionPeriod);
        }
        if (this._clientiFideliOnly.isSelected()) {
            this._promotion.setPublicPromotion(false);
        } else {
            this._promotion.setPublicPromotion(true);
        }
        return true;
    }

    private PromotionElement readPromotionElement() {
        PromotionElement el = new PromotionElement();
        Sectie categ = null;
        if (ComboUtils.anythingButAllSelected(this._categoryComboBox)) {
            categ = (Sectie)this._categoryComboBox.getSelectedItem();
            el.setCategory(categ.getId());
        } else {
            el.setCategory(-1);
        }
        Categorie subCateg = null;
        if (ComboUtils.anythingButAllSelected(this._subCategoryComboBox)) {
            subCateg = (Categorie)this._subCategoryComboBox.getSelectedItem();
            el.setSubcat(subCateg.getId());
        } else {
            el.setSubcat(-1);
        }
        Product prod = null;
        if (ComboUtils.anythingButAllSelected(this._productComboBox)) {
            prod = (Product)this._productComboBox.getSelectedItem();
            el.setProduct(prod.getId());
        } else {
            el.setProduct(-1);
        }
        String v = this._valueField.getText();
        if (Validators.correctDouble(v)) {
            double value = Utils.parseDouble(v);
            el.setValue(value);
        } else {
            el = null;
        }
        String totalOrder = this._totalOrderField.getText();
        if (Validators.correctDouble(totalOrder)) {
            double value = Utils.parseDouble(totalOrder);
            el.setOrderMinimValue(value);
        } else {
            el.setOrderMinimValue(0.0);
        }
        return el;
    }

    private void addPromotion() {
        if (this.updatePromotionAttr()) {
            this.promotionsLogic.newPromotion(this._promotion, this.elements);
            this._promotion = null;
            this.initFields();
        }
    }

    private void savePromotion() {
        if (this.updatePromotionAttr()) {
            this.promotionsLogic.updatePromotion(this._promotion, this.elements);
            this._promotion = null;
            this.initFields();
            this.action.doAction();
        }
    }

    private void deletePromotion() {
        if (DialogUtils.confirmDialog(this, "Delete promotion", "Delete Promotion")) {
            this.promotionsLogic.deletePromotion(this._promotion.getId());
        }
    }

    public void setPromotionToEdit(Promotion p) {
        this._promotion = p;
        this.initFields();
    }

    private void initFields() {
        if (this._promotion == null) {
            this._nameField.setText("");
            this._valueField.setText("");
            this._totalOrderField.setText("0");
            this._categoryComboBox.setSelectedIndex(0);
            this._subCategoryComboBox.setSelectedIndex(0);
            this._productComboBox.setSelectedIndex(0);
            this._permanentRadioButton.setSelected(true);
            this._procentRadioButton.setSelected(true);
            this._startField.setText("");
            this._stopField.setText("");
            this.daysInWeek.setText("*");
            this._addButton.setEnabled(true);
            this._deleteButton.setEnabled(false);
            this._saveButton.setEnabled(false);
            this._resetButton.setEnabled(true);
            this._clientiFideliOnly.setSelected(true);
            this.elements = new Vector();
            this.elementsPanel.refreshTable();
        } else {
            this._nameField.setText(this._promotion.getLabel());
            int type = this._promotion.getType();
            switch (type) {
                case 1: {
                    this._fixedPriceRadioButton.setSelected(true);
                    break;
                }
                case 2: {
                    this._procentRadioButton.setSelected(true);
                    break;
                }
                case 3: {
                    this._fixedValueRadioButton.setSelected(true);
                    break;
                }
                case 4: {
                    this._xPlusOneRadioButton.setSelected(true);
                    break;
                }
            }
            this.elements = this._promotion.getPromoElements();
            this.elementsPanel.refreshTable();
            PromotionPeriod pp = this._promotion.getPeriod();
            switch (pp.getTip()) {
                case 2: {
                    this._hourPeriodRadioButton.setSelected(true);
                    break;
                }
                case 1: {
                    this._datePeriodRadioButton.setSelected(true);
                    break;
                }
                case 3: {
                    this._permanentRadioButton.setSelected(true);
                }
            }
            this._startField.setText(pp.getStartAsString());
            this._stopField.setText(pp.getStopAsString());
            this._clientiFideliOnly.setSelected(!this._promotion.isPublicPromotion());
            this.daysInWeek.setText(pp.getWeekDays());
            this._addButton.setEnabled(false);
            this._deleteButton.setEnabled(true);
            this._saveButton.setEnabled(true);
            this._resetButton.setEnabled(true);
        }
    }

    private JPanel getTargetPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        this._categoryComboBox = ComboUtils.buildComboWithAll(NomeclaturaLogic.getInstance().getAllSectii());
        this._categoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(EditPromotionPanel.this._categoryComboBox)) {
                    Sectie cat = (Sectie)EditPromotionPanel.this._categoryComboBox.getSelectedItem();
                    Vector subcats = EditPromotionPanel.this.nomenclaturaLogic.getCategoriiNaturalOrder(cat.getId());
                    EditPromotionPanel.this._subCategoryComboBox = ComboUtils.replaceItemsForCombo(EditPromotionPanel.this._subCategoryComboBox, subcats);
                } else {
                    EditPromotionPanel.this._subCategoryComboBox = ComboUtils.replaceItemsForCombo(EditPromotionPanel.this._subCategoryComboBox, new Vector());
                }
            }
        });
        this._subCategoryComboBox = ComboUtils.buildComboWithAll(new Vector());
        this._subCategoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(EditPromotionPanel.this._subCategoryComboBox)) {
                    Categorie subcat = (Categorie)EditPromotionPanel.this._subCategoryComboBox.getSelectedItem();
                    Vector products = EditPromotionPanel.this.nomenclaturaLogic.getProductsForCategorie(subcat);
                    EditPromotionPanel.this._productComboBox = ComboUtils.replaceItemsForCombo(EditPromotionPanel.this._productComboBox, products);
                } else {
                    EditPromotionPanel.this._productComboBox = ComboUtils.replaceItemsForCombo(EditPromotionPanel.this._productComboBox, new Vector());
                }
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)new JLabel(LangRoAll.sectie), c);
        ++c.gridx;
        p.add((Component)this._categoryComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        p.add((Component)new JLabel(LangRoAll.categorie), c);
        ++c.gridx;
        p.add((Component)this._subCategoryComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)new JLabel(LangRoAll.produs), c);
        this._productComboBox = ComboUtils.buildComboWithAll(new Vector());
        this._productComboBox.setPrototypeDisplayValue("111111111111111111111111111111111");
        ++c.gridx;
        p.add((Component)this._productComboBox, c);
        ++c.gridy;
        c.gridx = 0;
        p.add((Component)new JLabel(LangRoAll.valoare), c);
        ++c.gridx;
        this._valueField = new JTextField(10);
        p.add((Component)this._valueField, c);
        ++c.gridy;
        c.gridx = 0;
        p.add((Component)new JLabel("Valoare minima nota"), c);
        ++c.gridx;
        this._totalOrderField = new JTextField(10);
        p.add((Component)this._totalOrderField, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        final EditPromotionPanel panel = this;
        JButton addElement = new JButton("Add target");
        addElement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PromotionElement el = EditPromotionPanel.this.readPromotionElement();
                if (el != null) {
                    EditPromotionPanel.this.elements.add(el);
                    EditPromotionPanel.this.elementsPanel.refreshTable();
                    EditPromotionPanel.this._valueField.setText("");
                    EditPromotionPanel.this._categoryComboBox.setSelectedIndex(0);
                    EditPromotionPanel.this._subCategoryComboBox.setSelectedIndex(0);
                    EditPromotionPanel.this._productComboBox.setSelectedIndex(0);
                    EditPromotionPanel.this._totalOrderField.setText("");
                } else {
                    DialogUtils.errorDialog(panel, "Completati valoarea", LangRoAll.nuPotContinua);
                    EditPromotionPanel.this._valueField.requestFocus();
                }
            }
        });
        p.add((Component)addElement, c);
        p.setBorder(new TitledBorder("Target"));
        return p;
    }

    private AbstractListPanel getElementsPane() {
        AbstractListPanel result = new AbstractListPanel(){

            @Override
            public AbstractTM buildTableModel() {
                this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        PromotionElement p = (PromotionElement)data.elementAt(rowIndex);
                        switch (columnIndex) {
                            case 0: {
                                int idCategory = p.getCategory();
                                if (idCategory != -1) {
                                    return EditPromotionPanel.this.nomenclaturaLogic.getSectieById(idCategory).getName();
                                }
                                return "All";
                            }
                            case 1: {
                                int idSubcategory = p.getSubcat();
                                if (idSubcategory != -1) {
                                    return EditPromotionPanel.this.nomenclaturaLogic.getCategoryById(idSubcategory).getName();
                                }
                                return "All";
                            }
                            case 2: {
                                int idProduct = p.getProduct();
                                if (idProduct != -1) {
                                    return EditPromotionPanel.this.nomenclaturaLogic.getProductNameById(idProduct);
                                }
                                return "All";
                            }
                            case 3: {
                                return Utils.getString2Decimals(p.getValue());
                            }
                            case 4: {
                                return Utils.getString2Decimals(p.getOrderMinimValue());
                            }
                        }
                        return null;
                    }
                });
                return this.tm;
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public Vector buildData() {
                return EditPromotionPanel.this.elements;
            }

            @Override
            public String[] buildColumns() {
                return new String[]{LangRoAll.sectie, LangRoAll.categorie, LangRoAll.produs, LangRoAll.valoare, "Valoare minima nota"};
            }

            @Override
            public Class[] buildTypes() {
                return Utils.getStringClass(5);
            }

            @Override
            public void doStuff() {
                this.display();
                this.table.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        int selRow = table.rowAtPoint(e.getPoint());
                        if (selRow != -1 && e.getClickCount() == 2 && DialogUtils.confirmDialog(table, "Stergem acest target", LangRoAll.confirmare)) {
                            EditPromotionPanel.this.elements.removeElementAt(selRow);
                            EditPromotionPanel.this.elementsPanel.refreshTable();
                        }
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }
                });
            }
        };
        return result;
    }

    private JPanel getPerioadaPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Permanent"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this._permanentRadioButton = new JRadioButton();
        result.add((Component)this._permanentRadioButton, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Intre 2 ore (HH:mm)"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this._hourPeriodRadioButton = new JRadioButton();
        result.add((Component)this._hourPeriodRadioButton, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Intre 2 date (YYYY-MM-DD)"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this._datePeriodRadioButton = new JRadioButton();
        result.add((Component)this._datePeriodRadioButton, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("start"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this._startField = new JTextField(15);
        result.add((Component)this._startField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel("stop"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this._stopField = new JTextField(15);
        result.add((Component)this._stopField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Zile saptamana (*,1,2..)"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.daysInWeek = new JTextField(15);
        result.add((Component)this.daysInWeek, c);
        ButtonGroup periodBG = new ButtonGroup();
        periodBG.add(this._hourPeriodRadioButton);
        periodBG.add(this._datePeriodRadioButton);
        periodBG.add(this._permanentRadioButton);
        result.setBorder(new TitledBorder("Perioada"));
        return result;
    }

    private JPanel buttonsPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        this._addButton = new JButton(LangRoAll.adauga);
        this._addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPromotionPanel.this.addPromotion();
            }
        });
        this._deleteButton = new JButton(LangRoAll.sterge);
        this._deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPromotionPanel.this.deletePromotion();
                EditPromotionPanel.this._promotion = null;
                EditPromotionPanel.this.initFields();
                EditPromotionPanel.this.action.doAction();
            }
        });
        this._saveButton = new JButton(LangRoAll.salveaza);
        this._saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPromotionPanel.this.savePromotion();
            }
        });
        this._resetButton = new JButton("Valori Initiale");
        this._resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPromotionPanel.this.initFields();
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)this._addButton, c);
        ++c.gridx;
        p.add((Component)this._deleteButton, c);
        ++c.gridx;
        p.add((Component)this._saveButton, c);
        ++c.gridx;
        p.add((Component)this._resetButton, c);
        p.setBorder(new TitledBorder(LangRoAll.actiuni));
        return p;
    }

    private JPanel getDenumirePanel() {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)new JLabel(LangRoAll.denumire), c);
        ++c.gridx;
        this._nameField = new JTextField(10);
        p.add((Component)this._nameField, c);
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)new JLabel("Tip promotie"), c);
        ++c.gridx;
        this._fixedPriceRadioButton = new JRadioButton("Pret fix");
        p.add((Component)this._fixedPriceRadioButton, c);
        ++c.gridy;
        this._procentRadioButton = new JRadioButton("Procent (0-100)");
        p.add((Component)this._procentRadioButton, c);
        ++c.gridy;
        this._fixedValueRadioButton = new JRadioButton("Valoare fixa");
        p.add((Component)this._fixedValueRadioButton, c);
        ++c.gridy;
        this._xPlusOneRadioButton = new JRadioButton("X plus 1");
        p.add((Component)this._xPlusOneRadioButton, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        this._clientiFideliOnly = new JCheckBox("Doar clienti fideli");
        this._clientiFideliOnly.setSelected(true);
        p.add((Component)this._clientiFideliOnly, c);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._fixedPriceRadioButton);
        bg.add(this._procentRadioButton);
        bg.add(this._fixedValueRadioButton);
        bg.add(this._xPlusOneRadioButton);
        p.setBorder(new TitledBorder(LangRoAll.denumire));
        return p;
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 1;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.2;
        this.add((Component)this.getDenumirePanel(), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.getPerioadaPanel(), c);
        ++c.gridx;
        this.add((Component)this.getTargetPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.fill = 1;
        this.elementsPanel = this.getElementsPane();
        this.elementsPanel.doStuff();
        this.add((Component)this.elementsPanel, c);
        c.weighty = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)this.buttonsPanel(), c);
    }
}

