/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant;

public class AdaosReportEntry {
    private String produs;
    private double pretVanzare;
    private double valIngrediente;
    private double adaosCoef;
    private double adaosProcent;
    private double diffValoare;
    private double cotaTva;
    private int idReteta = 0;
    private int idStock = 0;
    private boolean completed;
    private boolean selected;

    public double getCotaTva() {
        return this.cotaTva;
    }

    public void setCotaTva(double cotaTva) {
        this.cotaTva = cotaTva;
    }

    public void computeByPretVanzare(double pv) {
        this.setPretVanzare(pv);
        double adaos = pv / ((1.0 + this.cotaTva) * this.valIngrediente);
        double adaosProcent = (adaos - 1.0) * 100.0;
        this.setAdaosCoef(adaos);
        this.setAdaosProcent(adaosProcent);
        double diffValue = pv / (1.0 + this.cotaTva) - this.valIngrediente;
        this.setDiffValoare(diffValue);
    }

    public void computeByAdaosCoeficient(double adaosCoef) {
        double pretVz = adaosCoef * this.valIngrediente * (1.0 + this.cotaTva);
        this.computeByPretVanzare(pretVz);
    }

    public void computeByAdaosProcent(double adaosProcent) {
        double pretVz = (100.0 + adaosProcent) / 100.0 * this.valIngrediente * (1.0 + this.cotaTva);
        this.computeByPretVanzare(pretVz);
    }

    public void computeByAdaosDiferenta(double adaosDiff) {
        double pretVz = (adaosDiff + this.valIngrediente) * (1.0 + this.cotaTva);
        this.computeByPretVanzare(pretVz);
    }

    public double getDiffValoare() {
        return this.diffValoare;
    }

    public void setDiffValoare(double diffValoare) {
        this.diffValoare = diffValoare;
    }

    public String getProdus() {
        return this.produs;
    }

    public void setProdus(String produs) {
        this.produs = produs;
    }

    public double getPretVanzare() {
        return this.pretVanzare;
    }

    public void setPretVanzare(double pretVanzare) {
        this.pretVanzare = pretVanzare;
    }

    public double getValIngrediente() {
        return this.valIngrediente;
    }

    public void setValIngrediente(double valIngrediente) {
        this.valIngrediente = valIngrediente;
    }

    public double getAdaosCoef() {
        return this.adaosCoef;
    }

    public void setAdaosCoef(double adaosCoef) {
        this.adaosCoef = adaosCoef;
    }

    public double getAdaosProcent() {
        return this.adaosProcent;
    }

    public void setAdaosProcent(double adaosProcent) {
        this.adaosProcent = adaosProcent;
    }

    public int getIdReteta() {
        return this.idReteta;
    }

    public void setIdReteta(int idReteta) {
        this.idReteta = idReteta;
    }

    public int getIdStock() {
        return this.idStock;
    }

    public void setIdStock(int idStock) {
        this.idStock = idStock;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

