/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant;

import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Order;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.deversoft.anaf.AnafUtils;
import ro.deversoft.anaf.RmiObserver;
import ro.deversoft.anaf.beans.OrderBean;
import ro.deversoft.anaf.beans.ResponseBean;

public class AnafCuiObserver
implements RmiObserver {
    private Order order;

    public AnafCuiObserver(Order order) {
        this.order = order;
    }

    @Override
    public void onUpdate(String reqCui) {
        boolean canContinue;
        String requestObject = reqCui;
        ResponseBean rBean = AnafUtils.pullBean();
        if (!(rBean != null && Validators.correctString(requestObject) || (canContinue = DialogUtils.confirmDialog(GuiUtils.currentFrame, "Eroare verificare cui! Codul fiscal poate fi incorect. Doriti sa continuati", LangRoAll.confirmare)))) {
            DialogUtils.okDialog(GuiUtils.currentFrame, "Codul fiscal nu a fost salvat!", LangRoAll.atentie);
            return;
        }
        Boolean platitorTVA = null;
        OrderBean orderBean = AnafUtils.verifyResponseFromServer(requestObject, rBean);
        if (!orderBean.isCuiFound().booleanValue()) {
            String message;
            String string = message = Validators.correctString(orderBean.getMesaj()) ? orderBean.getMesaj() : "NA";
            if (!DialogUtils.confirmDialog(GuiUtils.currentFrame, "Eroare cod fiscal : " + message + ". Doriti sa continuati oricum", LangRoAll.eroare)) {
                DialogUtils.okDialog(GuiUtils.currentFrame, "Codul fiscal nu a fost salvat!", LangRoAll.atentie);
                return;
            }
        } else {
            platitorTVA = orderBean.isPlatitorTVA();
        }
        if (platitorTVA == null) {
            platitorTVA = DialogUtils.confirmDialog(GuiUtils.currentFrame, "Clientul este platitor de tva?", LangRoAll.confirmare);
        } else {
            String text1 = "Raspuns server: Clientul este " + orderBean.getMesaj() + ". Este clientul platitor de TVA?";
            platitorTVA = DialogUtils.confirmDialog(GuiUtils.currentFrame, text1, LangRoAll.confirmare);
        }
        if (platitorTVA.booleanValue()) {
            requestObject = "RO" + requestObject;
        }
        this.order.setCodFiscal(requestObject);
        RestLogic.getInstance().setCodFiscalToOrder(this.order.getId(), requestObject);
    }
}

