/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.UIManager;
import org.mortbay.jetty.Server;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.FacturiDataProvider;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.print.PrintLogic;
import ro.atreides.print.PrinterConfig;
import ro.atreides.print.PrinterEntry;
import ro.atreides.print.PrinterInterface;
import ro.atreides.print.printers.FacturiConfig;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.promo.PromotionPriceProviderImpl;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.logic.FestiveLogic;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockConfig;
import ro.atreides.stocks.StockLogic;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.AbstractAppInit;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.LanguageProvider;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.DatabaseManager;
import ro.atreides.utils.events.EventsLogic;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.messaging.Messenger;
import ro.atreides.utils.plati.TipPlataProvider;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.units.UnitsLogic;

public class AppInit
extends AbstractAppInit {
    public AppInit(String[] args) throws SQLException {
        super(args);
    }

    private void enableNimbus(String[] args) {
        String propFile = Utils.getCmdlineValue("-nimbusfile", args, "");
        if (Validators.correctString(propFile)) {
            try {
                Properties props = new Properties();
                try {
                    FileInputStream file = new FileInputStream(propFile);
                    props.load(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (Object key : props.keySet()) {
                    UIManager.put(key, Color.decode((String)props.get(key)));
                }
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"Nimbus".equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
            catch (Exception e) {
                Logger.logError((Object)this, "no nimbus");
            }
        }
    }

    @Override
    protected void doSpecificStuff(String[] args, Config conf, DatabaseManager db) throws SQLException {
        int ecrSkipBons;
        VpConfig.getInstance(conf);
        StockConfig.getInstance(conf);
        UsersLogic.getInstance();
        final NomeclaturaLogic nomeclaturaLogic = NomeclaturaLogic.getInstance();
        EventsLogic.getInstance();
        final Messenger mess = Messenger.getInstance();
        LanguageProvider langProv = new LanguageProvider(){

            @Override
            public int getCurrentUserLanguage() {
                return 1;
            }
        };
        conf.setLanguageProvider(langProv);
        final StockLogic sl = StockLogic.getInstance();
        sl.setLanguageProvider(langProv);
        final RestLogic logic = RestLogic.getInstance();
        if (!GuiUtils.daemon) {
            this.enableNimbus(args);
            XComboBox.xcomboSearchMinCharsGlobal = Config.getInstance().getInt("xcomboSearchMinChars");
            if (VpConfig.getInstance().xComboWaitForEnter) {
                XComboBox.waitForEnter = true;
            }
            TipPlataProvider.getInstance();
            PrinterConfig.getInstance(conf);
            PrintLogic pl = PrintLogic.getInstance();
            pl.setSectiiProvider(nomeclaturaLogic);
            pl.setPrinterInterface(new PrinterInterface(){

                @Override
                public boolean printsBon(Object categoryObj, Object locatieObj, PrinterEntry printer) {
                    Sectie cat = (Sectie)categoryObj;
                    Location locatie = (Location)locatieObj;
                    return printer.printsBonForCategory(cat.getId(), locatie.getId());
                }

                @Override
                public Vector getLocations() {
                    return logic.getLocations();
                }

                @Override
                public boolean printsNota(Object locatieObj, PrinterEntry printer) {
                    Location locatie = (Location)locatieObj;
                    return printer.printsNotaForCategory(locatie.getId());
                }
            });
            pl.setLanguageProvider(langProv);
            logic.setPrinter(pl);
        }
        PromotionPriceProviderImpl pp = new PromotionPriceProviderImpl();
        logic.setPriceProvider(pp);
        PromotionLogic.getInstance();
        ClientLogic.getInstance();
        final UnitsLogic unitsLogic = UnitsLogic.getInstance();
        unitsLogic.setLanguageProvider(langProv);
        ContaLogic contalogic = ContaLogic.getInstance();
        contalogic.setUnitsProvider(unitsLogic);
        contalogic.setLanguageProvider(langProv);
        contalogic.init();
        sl.setDeleteImpediments(logic);
        logic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "Messenger_DAY_CLOSED";
            }

            @Override
            public void dataChanged() {
                mess.deleteAll();
            }
        }, 6);
        sl.setStockInterface(logic);
        contalogic.setWinmentorExportInterface(logic);
        Server server = null;
        try {
            String portS = Utils.getCmdlineValue("-webserverport", args, "8080");
            int port = Integer.parseInt(portS);
            server = (Server)RestLogic.getInstance().prepareWebServer(port);
            server.addWebApplication("/system", "./webapps/system/");
        }
        catch (IllegalArgumentException e) {
            Logger.logException(this, (Exception)e);
            Utils.systemExit();
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            Utils.systemExit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            Utils.systemExit();
        }
        EcrLogic ecrLogic = EcrLogic.getInstance(args, false, logic);
        String ecrSkipBonsS = Utils.getCmdlineValue("-ecrSkipBons", args, "0");
        EcrLogic.skipBons = ecrSkipBons = Integer.parseInt(ecrSkipBonsS);
        AbstractCashRegister ecr = ecrLogic.getEcr();
        if (ecr != null) {
            logic.setCashRegister(ecr);
        }
        FacturiConfig.getInstance(conf);
        FacturiLogic fl = FacturiLogic.getInstance();
        FacturiDataProvider fdp = new FacturiDataProvider(){

            @Override
            public Vector getAllProducts() {
                Vector products = nomeclaturaLogic.getPowerSearchProducts(0);
                return products;
            }

            @Override
            public Categorie getCategorieForProduct(int idProduct) {
                Product rp = nomeclaturaLogic.getProductById(idProduct);
                return nomeclaturaLogic.getCategoryById(rp.getIdCategorie());
            }

            @Override
            public double getPriceForProductNoCommit(int idProduct) throws SQLException {
                return RestLogic.getInstance().getPriceForProductNoCommit(idProduct);
            }

            @Override
            public double getPriceForProduct(int idProduct) {
                return RestLogic.getInstance().getPriceForProductCommit(idProduct);
            }

            @Override
            public double getCotaTvaForProduct(int idProduct) {
                Product p = nomeclaturaLogic.getProductById(idProduct);
                Categorie cat = NomeclaturaLogic.getInstance().getCategoryById(p.getIdCategorie());
                Tva t = TvaLogic.getInstance().getTvaById(cat.getIdTva());
                double tvaNoi = t.getCota();
                return tvaNoi;
            }

            @Override
            public String getUmForProduct(int p) throws SQLException {
                Product s = nomeclaturaLogic.getProductByIdNoCommit(p);
                if (logic.isRetetaNoCommit(s.getId())) {
                    return "Buc";
                }
                int idStock = logic.getIdStockNoCommit(s.getId());
                Stock s1 = sl.getStockByIdNoCommit(idStock);
                if (s1 != null) {
                    int idUnit = s1.getIdUnit();
                    Unit u = unitsLogic.getUnitByIdNoCommit(idUnit);
                    return u.getLabel();
                }
                return "?";
            }

            @Override
            public int getStockForProductNoCommit(int idProduct) throws SQLException {
                Product rp = nomeclaturaLogic.getProductByIdNoCommit(idProduct);
                return logic.getIdStockNoCommit(rp.getId());
            }

            @Override
            public int getStockForProduct(int idProduct) {
                Product rp = nomeclaturaLogic.getProductById(idProduct);
                return logic.getIdStock(rp.getId());
            }

            @Override
            public void addListener(EventListener listener, int eventType) {
                logic.addListener(listener, eventType);
            }

            @Override
            public void descarcaFactura(int idProdusReteta, double cantitate, Timestamp saleTime, String document, int idMagazie, boolean fiscal, boolean protocol, StockLogic.COMANDA_TYPE comandaType, int idLot) throws SQLException {
                logic.descarcaRetetaForFacturaEmisa(idProdusReteta, cantitate, saleTime, document, idMagazie, new Vector(), -1, fiscal, protocol, comandaType, idLot);
            }

            @Override
            public int getIdReteta(int idProduct) throws SQLException {
                return logic.getIdRetetaNoCommit(idProduct);
            }

            @Override
            public double getPretAchizitieForProduct(int idProduct) throws SQLException {
                int idStock = this.getStockForProductNoCommit(idProduct);
                if (idStock > 0) {
                    return StockLogic.getInstance().getBackupBuyPriceNoCommit(idStock);
                }
                return 0.0;
            }

            public void addIncasareFacturaCashInRegCasa(Vector plati, int idLocatie, String nrDocument, Timestamp data, String anexa, String explicatii, Vector facturiEmisePlatite) {
                RestLogic.getInstance().incasareCommit(plati, "Chitanta", idLocatie, nrDocument, data, anexa, explicatii, facturiEmisePlatite);
            }
        };
        fl.setDataProvider(fdp);
        sl.setFacturiEmiseInterface(fl);
        contalogic.setDocumentInterface(logic);
        contalogic.setPriceInterface(logic);
        sl.setDocumentInterface(logic);
        contalogic.setInter(fdp);
        fl.setDocumentInterface(logic);
        UsersLogic.getInstance().setUserInterface(logic);
        FestiveLogic.getInstance();
        Hashtable<String, Server> runTimeObjects = new Hashtable<String, Server>();
        runTimeObjects.put("Runtime_Jetty_Key", server);
        this.instantiateModules(args, "ro.atreides.restaurant.modules.", "", runTimeObjects);
        if (logic.getServer() != null) {
            try {
                logic.startJettyServer();
            }
            catch (Exception e) {
                Logger.logException(this, e);
            }
        }
        if (this.splash != null) {
            this.splash.stop();
        }
        FileUtils.buildTempDir();
        new Thread(){

            @Override
            public void run() {
                StockLogic.getInstance().getPowerSearchStocks();
                ClientLogic.getInstance().getAllPersFiziceSorted();
                ClientLogic.getInstance().getAllPersJuridiceSorted();
            }
        }.start();
    }
}

