/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant;

import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.restaurant.base.reports.SalesEntry;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.multilang.LangRoAll;

public class SalesExcel394Processor
implements ExcelProcessor {
    @Override
    public int buildHeader(WritableSheet sheet, int startRow) {
        return 0;
    }

    @Override
    public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
    }

    @Override
    public String[] getColumns() {
        return new String[]{LangRoAll.codFiscal.toPattern(), "Valoare fara TVA", LangRoAll.cotaTva, "Valoare TVA"};
    }

    @Override
    public String getSheetName() {
        return "Raport 394";
    }

    @Override
    public void processLine(Object o, WritableSheet sheet, int row) {
        try {
            SalesEntry se = (SalesEntry)o;
            double totalValue = se.getTotalValue();
            double tva = se.getCotaTva();
            Label cui = new Label(0, row, se.getCui());
            sheet.addCell((WritableCell)cui);
            double valoareFaraTva = totalValue / (1.0 + tva);
            double valFaraTva2Dec = FloatUtils.roundDouble(valoareFaraTva, 2);
            String sFaraTva = Utils.getString2Decimals(valFaraTva2Dec);
            Label faraTva = new Label(1, row, sFaraTva);
            sheet.addCell((WritableCell)faraTva);
            Label cotaTva = new Label(2, row, Utils.getString2Decimals(tva));
            sheet.addCell((WritableCell)cotaTva);
            double valTva = totalValue - valoareFaraTva;
            valTva = FloatUtils.roundDouble(valTva, 2);
            String sValTva = Utils.getString2Decimals(valTva);
            Label valoareTva = new Label(3, row, sValTva);
            sheet.addCell((WritableCell)valoareTva);
        }
        catch (RowsExceededException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
    }
}

