/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant;

import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.restaurant.base.reports.SalesEntry;
import ro.atreides.utils.Logger;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.multilang.LangRoAll;

public class SalesExcelProcessor
implements ExcelProcessor {
    @Override
    public int buildHeader(WritableSheet sheet, int startRow) {
        return 0;
    }

    @Override
    public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
    }

    @Override
    public String[] getColumns() {
        return new String[]{LangRoAll.grouping, LangRoAll.sectie, LangRoAll.categorie, LangRoAll.produs, "Pret unitar", LangRoAll.cantitate, LangRoAll.total, LangRoAll.promotie};
    }

    @Override
    public String getSheetName() {
        return "Raport vanzari";
    }

    @Override
    public void processLine(Object o, WritableSheet sheet, int row) {
        try {
            SalesEntry se = (SalesEntry)o;
            Label data = new Label(0, row, se.getDataOra());
            sheet.addCell((WritableCell)data);
            Label categ = new Label(1, row, se.getCategory());
            sheet.addCell((WritableCell)categ);
            Label subcateg = new Label(2, row, se.getSubcategory());
            sheet.addCell((WritableCell)subcateg);
            Label prod = new Label(3, row, se.getProduct());
            sheet.addCell((WritableCell)prod);
            Number valUnit = new Number(4, row, se.getPrice());
            sheet.addCell((WritableCell)valUnit);
            Number quantity = new Number(5, row, se.getQuantity());
            sheet.addCell((WritableCell)quantity);
            Number totalVal = new Number(6, row, se.getTotalValue());
            sheet.addCell((WritableCell)totalVal);
            Label promo = new Label(7, row, se.getPromotion());
            sheet.addCell((WritableCell)promo);
        }
        catch (RowsExceededException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
    }
}

