/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.base;

import java.util.Vector;
import ro.atreides.utils.Utils;

public class Sale
implements Comparable {
    private double price;
    private int idPlatou = -1;
    private String modPreparare;
    private int idServire = -1;
    private int idPromotie = -1;
    private String promotie;
    private double cantitateMarcata;
    private double cantitateNoua;
    private int idProduct;
    private String productName;
    private String sectieName;
    private Vector<Integer> idSales = new Vector();
    private int idOrder;
    private long saledate;
    private double ppuOriginal;
    private double discount;
    private int idSectie;
    private int idCategorie;
    private int clientIndex = 0;
    private boolean printed;
    private boolean selectedForIntermediara;
    private boolean facturata;
    private int idCalendar;
    private int freeI1 = -1;
    private String freeS1 = "";
    private String freeS2 = "";
    private double freeD1 = -1.0;
    private double freeD2 = -1.0;
    private boolean ignorePromotions = false;
    private String img = null;
    private int idLot;

    public int getClientIndex() {
        return this.clientIndex;
    }

    public void setClientIndex(int clientIndex) {
        this.clientIndex = clientIndex;
    }

    public double getFreeD1() {
        return this.freeD1;
    }

    public void setFreeD1(double freeD1) {
        this.freeD1 = freeD1;
    }

    public double getFreeD2() {
        return this.freeD2;
    }

    public void setFreeD2(double freeD2) {
        this.freeD2 = freeD2;
    }

    public int getFreeI1() {
        return this.freeI1;
    }

    public void setFreeI1(int freeI1) {
        this.freeI1 = freeI1;
    }

    public String getFreeS1() {
        return this.freeS1;
    }

    public void setFreeS1(String freeS1) {
        this.freeS1 = freeS1;
    }

    public String getFreeS2() {
        return this.freeS2;
    }

    public void setFreeS2(String freeS2) {
        this.freeS2 = freeS2;
    }

    public int getIdCalendar() {
        return this.idCalendar;
    }

    public void setIdCalendar(int idCalendar) {
        this.idCalendar = idCalendar;
    }

    public boolean isFacturata() {
        return this.facturata;
    }

    public void setFacturata(boolean facturata) {
        this.facturata = facturata;
    }

    public boolean isSelectedForIntermediara() {
        return this.selectedForIntermediara;
    }

    public void setSelectedForIntermediara(boolean selectedForIntermediara) {
        this.selectedForIntermediara = selectedForIntermediara;
    }

    public boolean isPrinted() {
        return this.printed;
    }

    public void setPrinted(boolean printed) {
        this.printed = printed;
    }

    public Sale clone() {
        Sale s = new Sale();
        s.price = this.price;
        s.idPlatou = this.idPlatou;
        s.modPreparare = this.modPreparare;
        s.idServire = this.idServire;
        s.idPromotie = this.idPromotie;
        s.cantitateMarcata = this.cantitateMarcata;
        s.cantitateNoua = this.cantitateNoua;
        s.idProduct = this.idProduct;
        s.productName = this.productName;
        s.sectieName = this.sectieName;
        s.idOrder = this.idOrder;
        s.saledate = this.saledate;
        s.ppuOriginal = this.ppuOriginal;
        s.discount = this.discount;
        s.idSectie = this.idSectie;
        s.idCategorie = this.idCategorie;
        return s;
    }

    public Sale cloneWithBooleans() {
        Sale s = new Sale();
        s.price = this.price;
        s.idPlatou = this.idPlatou;
        s.modPreparare = this.modPreparare;
        s.idServire = this.idServire;
        s.idPromotie = this.idPromotie;
        s.cantitateMarcata = this.cantitateMarcata;
        s.cantitateNoua = this.cantitateNoua;
        s.idProduct = this.idProduct;
        s.productName = this.productName;
        s.sectieName = this.sectieName;
        s.idOrder = this.idOrder;
        s.saledate = this.saledate;
        s.ppuOriginal = this.ppuOriginal;
        s.discount = this.discount;
        s.idSectie = this.idSectie;
        s.idCategorie = this.idCategorie;
        s.facturata = this.isFacturata();
        s.printed = this.isPrinted();
        s.selectedForIntermediara = this.isSelectedForIntermediara();
        return s;
    }

    public Sale() {
    }

    public Sale(double cantitateMarcata, double cantitateNoua, double discount, int idCategorie, int idOrder, int idPlatou, int idProduct, int idPromotie, int idSectie, int idServire, String modPreparare, double ppuOriginal, double price, String productName, String sectieName, String promotie, long saledate, int clientIndex) {
        this.cantitateMarcata = cantitateMarcata;
        this.cantitateNoua = cantitateNoua;
        this.discount = discount;
        this.idCategorie = idCategorie;
        this.idOrder = idOrder;
        this.idPlatou = idPlatou;
        this.idProduct = idProduct;
        this.idPromotie = idPromotie;
        this.idSectie = idSectie;
        this.idServire = idServire;
        this.modPreparare = modPreparare;
        this.ppuOriginal = ppuOriginal;
        this.price = price;
        this.productName = productName;
        this.sectieName = sectieName;
        this.promotie = promotie;
        this.saledate = saledate;
        this.clientIndex = clientIndex;
    }

    public Sale(double cantitateMarcata, double cantitateNoua, double discount, int idCategorie, int idOrder, int idPlatou, int idProduct, int idPromotie, int idSectie, int idServire, String modPreparare, double ppuOriginal, double price, String productName, String sectieName, String promotie, long saledate, int clientIndex, boolean ignorePromotions) {
        this(cantitateMarcata, cantitateNoua, discount, idCategorie, idOrder, idPlatou, idProduct, idPromotie, idSectie, idServire, modPreparare, ppuOriginal, price, productName, sectieName, promotie, saledate, clientIndex);
        this.ignorePromotions = ignorePromotions;
    }

    public int getIdSectie() {
        return this.idSectie;
    }

    public void setIdSectie(int idSectie) {
        this.idSectie = idSectie;
    }

    public int getIdCategorie() {
        return this.idCategorie;
    }

    public void setIdCategorie(int idCategorie) {
        this.idCategorie = idCategorie;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public int getIdOrder() {
        return this.idOrder;
    }

    public void setIdOrder(int idOrder) {
        this.idOrder = idOrder;
    }

    public void addIdSale(int idSale) {
        this.idSales.add(idSale);
    }

    public void addIdSales(Vector<Integer> idsToAdd) {
        this.idSales.addAll(idsToAdd);
    }

    public int getFirstIdSale() {
        int result = -1;
        if (this.idSales.size() > 0) {
            result = this.idSales.get(0);
        }
        return result;
    }

    public Vector<Integer> getIdSales() {
        return this.idSales;
    }

    public double getPpuOriginal() {
        return this.ppuOriginal;
    }

    public void setPpuOriginal(double ppuOriginal) {
        this.ppuOriginal = ppuOriginal;
    }

    public long getSaledate() {
        return this.saledate;
    }

    public void setSaledate(long saledate) {
        this.saledate = saledate;
    }

    public int getIdProduct() {
        return this.idProduct;
    }

    public void setIdProduct(int idProduct) {
        this.idProduct = idProduct;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getSectieName() {
        return this.sectieName;
    }

    public void setSectieName(String sectieName) {
        this.sectieName = sectieName;
    }

    public double getCantitateMarcata() {
        return this.cantitateMarcata;
    }

    public void setCantitateMarcata(double cantitateMarcata) {
        this.cantitateMarcata = cantitateMarcata;
    }

    public double getCantitateNoua() {
        return this.cantitateNoua;
    }

    public void setCantitateNoua(double cantitateNoua) {
        this.cantitateNoua = cantitateNoua;
    }

    public int getIdPlatou() {
        return this.idPlatou;
    }

    public void setIdPlatou(int idPlatou) {
        this.idPlatou = idPlatou;
    }

    public int getIdPromotie() {
        return this.idPromotie;
    }

    public void setIdPromotie(int idPromotie) {
        this.idPromotie = idPromotie;
    }

    public int getIdServire() {
        return this.idServire;
    }

    public void setIdServire(int idServire) {
        this.idServire = idServire;
    }

    public String getModPreparare() {
        return this.modPreparare;
    }

    public void setModPreparare(String modPreparare) {
        this.modPreparare = modPreparare;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public String getPromotie() {
        return this.promotie;
    }

    public void setPromotie(String promotie) {
        this.promotie = promotie;
    }

    public boolean isEmpty() {
        return this.cantitateMarcata == 0.0 && this.cantitateNoua == 0.0;
    }

    public boolean hasCantitateNoua() {
        return this.cantitateNoua != 0.0;
    }

    public String getQuantity() {
        String result = "<html>";
        if (this.cantitateMarcata > 0.0) {
            result = result + Utils.getString3Decimals(this.cantitateMarcata);
        }
        if (this.cantitateMarcata > 0.0 && this.cantitateNoua > 0.0) {
            result = result + " + ";
        }
        if (this.cantitateNoua > 0.0) {
            result = result + "<strong><font color=\"red\">" + Utils.getString3Decimals(this.cantitateNoua) + "</font></strong>";
        }
        return result + "</html>";
    }

    public String getQuantityForKeys() {
        String result = "<html>";
        result = this.cantitateMarcata > 0.0 ? result + Utils.getString3Decimals(this.cantitateMarcata) : result + "<strong><font color=\"red\">" + Utils.getString3Decimals(this.cantitateMarcata) + "</font></strong>";
        return result + "</html>";
    }

    public double getTotal() {
        return (this.cantitateMarcata + this.cantitateNoua) * this.price;
    }

    public int compareTo(Object o) {
        if (!(o instanceof Sale)) {
            return -1;
        }
        Sale s1 = this;
        Sale s2 = (Sale)o;
        if (s1.getIdPlatou() == s2.getIdPlatou()) {
            if (s1.getIdSectie() == s2.getIdSectie()) {
                if (s1.getIdServire() == s2.getIdServire()) {
                    return (int)(s1.getSaledate() - s2.getSaledate());
                }
                return s1.getIdServire() - s2.getIdServire();
            }
            return s1.getIdSectie() - s2.getIdSectie();
        }
        return s1.getIdPlatou() - s2.getIdPlatou();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Sale)) {
            return false;
        }
        Sale s = (Sale)obj;
        return s.idOrder == this.idOrder && s.idProduct == this.idProduct && s.price == this.price && s.idPlatou == this.idPlatou && s.idServire == this.idServire && s.printed == this.printed && (s.modPreparare != null && this.modPreparare != null && s.modPreparare.equals(this.modPreparare) || s.modPreparare == null && this.modPreparare == null);
    }

    public boolean equalsForPrint(Object obj) {
        if (!(obj instanceof Sale)) {
            return false;
        }
        Sale s = (Sale)obj;
        return s.idOrder == this.idOrder && s.idProduct == this.idProduct && s.price == this.price;
    }

    public boolean equalsForTipPlata(Object obj) {
        if (!(obj instanceof Sale)) {
            return false;
        }
        Sale s = (Sale)obj;
        return s.idOrder == this.idOrder && s.idProduct == this.idProduct && s.price == this.price && s.isPrinted() == this.printed && s.isFacturata() == this.facturata;
    }

    public boolean equalsForTipPlataIntermediara(Object obj) {
        if (!(obj instanceof Sale)) {
            return false;
        }
        Sale s = (Sale)obj;
        return s.idOrder == this.idOrder && s.idProduct == this.idProduct && s.price == this.price && s.isPrinted() == this.printed && s.isFacturata() == this.facturata && s.isSelectedForIntermediara() == this.isSelectedForIntermediara();
    }

    public boolean ignorePromotion() {
        return this.ignorePromotions;
    }

    public void setIgnorePromotion(boolean ignorePromotions) {
        this.ignorePromotions = ignorePromotions;
    }

    public String getImg() {
        return this.img;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public int getIdLot() {
        return this.idLot;
    }

    public void setIdLot(int idLot) {
        this.idLot = idLot;
    }
}

