/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.clinicabase;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import ro.atreides.clienti.BiCi;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.ProductAttribute;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.print.PrintLogic;
import ro.atreides.promo.ClientPromotieView;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.clinicabase.AnalizeEntry;
import ro.atreides.restaurant.clinicabase.AnalizeReportEntry;
import ro.atreides.restaurant.clinicabase.BiletTrimitere;
import ro.atreides.restaurant.clinicabase.ClinicaAnalizeInterface;
import ro.atreides.restaurant.clinicabase.ClinicaDao;
import ro.atreides.restaurant.clinicabase.Consultatie;
import ro.atreides.restaurant.clinicabase.DayProgram;
import ro.atreides.restaurant.clinicabase.Diagnostic;
import ro.atreides.restaurant.clinicabase.Functie;
import ro.atreides.restaurant.clinicabase.Medic;
import ro.atreides.restaurant.clinicabase.MedicProcent;
import ro.atreides.restaurant.clinicabase.MedicProgram;
import ro.atreides.restaurant.clinicabase.OraOk;
import ro.atreides.restaurant.clinicabase.ProdusSpecialitate;
import ro.atreides.restaurant.gui.clinica.ProgramareEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.MailUtils;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Order;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.documente.DocumenteLogic;

public class ClinicaLogic
extends EventGenerator {
    private static ClinicaLogic instance;
    private ConnectionPool pool = ConnectionPool.getInstance();
    public static final String KEY_GRUP_CASE_SANATATE = "pers_juridice_groups_clinica_case_sanatate";
    public static int DURATA_VIZITA;
    public static final String GRUP_SEF_LABORATOR = "group_sef_laborator";
    public static final String BILET_SERIE = "BILET_SERIE";
    public static final String BILET_NUMAR = "BILET_NUMAR";
    public static final String BILET_COD_DIAGNOSTIC = "BILET_COD_DIAGNOSTIC";
    public static final String BILET_DIAGNOSTIC = "BILET_DIAGNOSTIC";
    public static final String BILET_COD_ASIGURAT = "BILET_COD_ASIGURAT";
    public static final String BILET_COD_PARAFA = "BILET_COD_PARAFA";
    public static final String BILET_ID_PLATITOR = "BILET_PLATITOR";
    public static final String BILET_ID_CLIENT = "BILET_CLIENT";
    public static final String BILET_TRIMITERE_KEY = "Bilet trimitere";
    public static final String COD_BARE_COMANDA_KEY = "Cod bare comanda";
    public static final String CASA_SANATATE_KEY = "Casa sanatate";

    public static synchronized ClinicaLogic getInstance() {
        if (instance == null) {
            instance = new ClinicaLogic();
        }
        return instance;
    }

    private ClinicaLogic() {
        final String externaKey = Config.getInstance().getString("clinicaExternaKey");
        RestLogic.getInstance().setClinicaInterface(new ClinicaAnalizeInterface(){

            @Override
            public void addAnaliza(int idSale, int idProduct) {
                Vector attributes = NomeclaturaLogic.getInstance().getProductAttributes(idProduct);
                for (int i = 0; i < attributes.size(); ++i) {
                    ProductAttribute productAttribute = (ProductAttribute)attributes.elementAt(i);
                    if (!productAttribute.getLabel().equalsIgnoreCase(externaKey)) continue;
                    String val = productAttribute.getValue();
                    boolean externa = false;
                    if (Utils.isYes(val)) {
                        externa = true;
                    }
                    ClinicaLogic.getInstance().addAnaliza(idSale, externa);
                    break;
                }
            }
        });
    }

    private synchronized ClinicaDao getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        ClinicaDao dao = null;
        while (dao == null) {
            dao = (ClinicaDao)this.pool.getDao(ClinicaDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(ClinicaDao.class.getName(), connection);
        }
        return dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFunctii() {
        try {
            Vector vector = this.getDao().getFunctii();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunctie(String name) {
        try {
            this.getDao().addFunctie(name);
            this.pool.commit();
            this.notifyListeners(74);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFunctie(Functie toUpdate) {
        try {
            this.getDao().updateFunctie(toUpdate);
            this.pool.commit();
            this.notifyListeners(74);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFunctie(Functie toDelete) {
        try {
            this.getDao().deleteFunctie(toDelete);
            this.pool.commit();
            this.notifyListeners(74);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDiagnostice() {
        try {
            Vector vector = this.getDao().getDiagnostice();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Diagnostic getDiagnosticByCod(String cod) {
        try {
            Diagnostic diagnostic = this.getDao().getDiagnosticByCod(cod);
            return diagnostic;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Diagnostic diagnostic = null;
            return diagnostic;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiagnostic(String name, String cod) {
        try {
            this.getDao().addDiagnostic(name, cod);
            this.pool.commit();
            this.notifyListeners(77);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDiagnostic(Diagnostic toUpdate) {
        try {
            this.getDao().updateDiagnostic(toUpdate);
            this.pool.commit();
            this.notifyListeners(77);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDiagnostic(Diagnostic toDelete) {
        try {
            this.getDao().deleteDiagnostic(toDelete);
            this.pool.commit();
            this.notifyListeners(77);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMedic(String nume, String prenume, int fct, String locMunca, String telefon, String mobil, String adresa) {
        try {
            this.getDao().addMedic(nume, prenume, fct, locMunca, telefon, mobil, adresa);
            int idMedic = this.pool.getIdentityLocal();
            this.pool.commit();
            this.notifyListeners(71);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMedic(Medic toUpdate) {
        try {
            this.getDao().updateMedic(toUpdate);
            this.pool.commit();
            this.notifyListeners(71);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMedic(Medic toDelete) {
        try {
            this.getDao().deleteMedic(toDelete);
            this.pool.commit();
            this.notifyListeners(71);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMedicProcent(int idMedic, int idCategory, double procentMedic) {
        try {
            if (this.getDao().getCountProcentByMedicAndCategoryId(idMedic, idCategory) == 0) {
                this.getDao().addMedicProcent(idMedic, idCategory, procentMedic);
            } else {
                this.getDao().updateMedicProcent(idMedic, idCategory, procentMedic);
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMedicProcentById(MedicProcent toUpdate) {
        try {
            this.getDao().updateMedicProcentById(toUpdate);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllProcente() {
        try {
            Vector vector = this.getDao().getAllProcente();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMedicProcent(MedicProcent toDelete) {
        try {
            this.getDao().deleteMedicProcent(toDelete);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector orePosibile(Date d, int idMedic) {
        Vector<OraOk> result = new Vector<OraOk>();
        int week = DateUtils.getWeekInYear(d);
        int an = DateUtils.getYear(d);
        try {
            DayProgram prog;
            int idZiSaptamana = d.getDay();
            if (idZiSaptamana == 0) {
                idZiSaptamana = 7;
            }
            if ((prog = this.getDao().isMedicPresent(idZiSaptamana, idMedic, an, week)) == null || prog.getStart() == null || prog.getStop() == null) {
                Vector<OraOk> vector = result;
                return vector;
            }
            Time s1 = prog.getStart();
            Time s2 = prog.getStop();
            long offset1 = (s1.getHours() * 3600 + s1.getMinutes() * 60) * 1000;
            long offset2 = (s2.getHours() * 3600 + s2.getMinutes() * 60) * 1000;
            Timestamp startDate = new Timestamp(DateUtils.getStartOfDay(d).getTime() + offset1);
            Timestamp timeLimit = new Timestamp(DateUtils.getStartOfDay(d).getTime() + offset2);
            Timestamp stopDate = new Timestamp(DateUtils.addMinutesToDate(startDate, DURATA_VIZITA).getTime());
            System.out.println("startDate : " + startDate + " stopDate : " + stopDate);
            boolean stop = false;
            while (!stop) {
                if (!this.getDao().isMedicBusy(startDate, stopDate, idMedic)) {
                    OraOk ok = new OraOk();
                    ok.setOra(startDate);
                    result.add(ok);
                }
                startDate = stopDate;
                stopDate = new Timestamp(DateUtils.addMinutesToDate(stopDate, DURATA_VIZITA).getTime());
                if (!startDate.after(timeLimit)) continue;
                stop = true;
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getProgramariForInterval(Date d, int idMedic) {
        try {
            Date startOfDay = DateUtils.getStartOfDay(d);
            Timestamp start = new Timestamp(startOfDay.getTime());
            Timestamp stop = new Timestamp(DateUtils.addDaysToDate(startOfDay, 1).getTime());
            Vector vector = this.getDao().getProgramariForDay(start, stop, idMedic);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProgramare(int idVizita) {
        try {
            this.getDao().deleteVizita(idVizita);
            this.pool.commit();
            this.notifyListeners(73);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgramare(int idMedic, int idPacient, int idSpecializare, Timestamp startDate, int durata, Timestamp stopTime, String consultatie) {
        try {
            this.getDao().addProgramare(idMedic, idPacient, idSpecializare, startDate, stopTime, durata, consultatie);
            int idVizita = this.pool.getIdentityLocal();
            this.getDao().addProgramareReferrers(idVizita, idMedic);
            this.pool.commit();
            this.notifyListeners(73);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Vector getPacheteCAS() {
        Categorie c = NomeclaturaLogic.getInstance().getCategoryByName(Config.getInstance().getString("clinicaCategoriePacheteCAS"));
        Vector produse = NomeclaturaLogic.getInstance().getProductsForCategorie(c);
        return produse;
    }

    public Vector getCaseSanatate() {
        return ClientLogic.getInstance().getPartnersInGroup(KEY_GRUP_CASE_SANATATE, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMedicProgram(MedicProgram toUpdate, int an, int week) {
        try {
            DayProgram[] items = toUpdate.getItems();
            for (int i = 0; i < items.length; ++i) {
                DayProgram dp = items[i];
                if (dp == null) {
                    dp = new DayProgram();
                    dp.setAn(an);
                    dp.setWeek(week);
                    dp.setIdDay(i + 1);
                    items[i] = dp;
                }
                if (dp.getId() > 0) {
                    this.getDao().updateMedicProgram(dp.getId(), dp.getStart(), dp.getStop());
                    continue;
                }
                this.getDao().addMedicProgram(toUpdate.getIdMedic(), dp.getIdDay(), dp.getStart(), dp.getStop(), dp.getAn(), dp.getWeek());
                int id = this.pool.getIdentityLocal();
                dp.setId(id);
            }
            this.pool.commit();
            this.notifyListeners(73);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Vector getProgramMedici(int an, int week) {
        Vector<MedicProgram> result = new Vector<MedicProgram>();
        for (Medic element : this.getAllMedici()) {
            result.add(this.getProgramByMedicId(element.getId(), element.getNume() + " " + element.getPrenume(), an, week));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MedicProgram getProgramByMedicId(int idMedic, String numeMedic, int an, int week) {
        MedicProgram mp = new MedicProgram(idMedic, numeMedic);
        try {
            DayProgram[] items = this.getDao().getProgramByMedicId(idMedic, an, week);
            mp.setItems(items);
            MedicProgram medicProgram = mp;
            return medicProgram;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            MedicProgram medicProgram = null;
            return medicProgram;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllMedici() {
        try {
            Vector vector = this.getDao().getAllMedici();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private String makeRaportProgramariFoFile(Vector entries, String fisaFile, String fisaLine, Date dataCurenta) throws IOException, SQLException {
        String modelFile = "conf" + File.separator + fisaFile;
        String lineFile = "conf" + File.separator + fisaLine;
        String foFile = FileUtils.readFileToString(modelFile);
        String date = "";
        boolean i = true;
        String medic = "";
        for (ProgramareEntry ps : entries) {
            String linie = FileUtils.readFileToString(lineFile);
            medic = ps.getMedic();
            String specializare = TextUtils.escapeForXML(ps.getSpecializare());
            String consultatie = TextUtils.escapeForXML(ps.getConsultatie());
            String pacient = TextUtils.escapeForXML(String.valueOf(ps.getPacient()));
            String ora = TextUtils.escapeForXML(String.valueOf(ps.getOra()));
            linie = this.replaceNotNull(linie, "%%Specializare%%", specializare);
            linie = this.replaceNotNull(linie, "%%consultatie%%", consultatie);
            linie = this.replaceNotNull(linie, "%%pacient%%", pacient);
            linie = this.replaceNotNull(linie, "%%ora%%", ora);
            date = date + linie + "\n";
        }
        String dataProgramare = Formatters.DATE_FORMAT.format(dataCurenta);
        foFile = this.replaceNotNull(foFile, "%%medic%%", medic);
        foFile = this.replaceNotNull(foFile, "%%data%%", dataProgramare);
        foFile = this.replaceNotNull(foFile, "%%entries%%", date);
        String filename = "programari_1.fo";
        FileWriter fw = new FileWriter(filename);
        fw.write(foFile);
        fw.close();
        return filename;
    }

    public void printProgramariMedic(int idMedic, Date dataProgramare) {
        try {
            Vector programari = this.getProgramariForInterval(dataProgramare, idMedic);
            String foFile = this.makeRaportProgramariFoFile(programari, "program.txt", "linie_program.txt", dataProgramare);
            PrintLogic.getInstance().printPdf(foFile, 1);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void printFoaieConsultatieIntegral(int idVizita, JFrame parent) {
    }

    private void printFoaieConsultatie(int idVizita, JFrame parent, Vector produse, Consultatie cons) throws IOException, SQLException {
        String foFile = this.makeRaportGestiuneFoFile(produse, "fisa.txt", "linie.txt", 2, cons.getDataConsultatie(), cons.getSpecialitate(), cons.getIdVizita(), cons.getPacient(), cons.getDataNasterii(), cons.getNumeMedic(), cons.getFunctieMedic(), cons.getAdresa(), cons.getFix(), cons.getMobil(), cons.getCnp(), cons.getEmail());
        PrintLogic.getInstance().printPdf(foFile, 1);
        this.getDao().setVizitaProcessing(idVizita);
    }

    public void printFoaieConsultatieCuSelectie(int idVizita, JFrame parent) {
    }

    private String makeRaportGestiuneFoFile(Vector entries, String fisaFile, String fisaLine, int liniiPerCol, Date data, String specialitate, int visitId, String numePacient, String dataNasteriiPacient, String numeMedic, String functie, String adresa, String telFix, String telMobil, String cnp, String email) throws IOException, SQLException {
        String modelFile = "conf" + File.separator + fisaFile;
        String lineFile = "conf" + File.separator + fisaLine;
        String foFile = FileUtils.readFileToString(modelFile);
        String date1 = "";
        String date2 = "";
        int i = 1;
        for (ProdusSpecialitate ps : entries) {
            String linie = FileUtils.readFileToString(lineFile);
            String productEscaped = TextUtils.escapeForXML(ps.getProdus());
            linie = this.replaceNotNull(linie, "%%Articol%%", productEscaped);
            if (i > liniiPerCol) {
                date2 = date2 + linie + "\n";
            } else {
                date1 = date1 + linie + "\n";
            }
            ++i;
        }
        String startDate = Formatters.DATE_AND_TIME_FORMAT.format(data);
        foFile = this.replaceNotNull(foFile, "%%data%%", startDate);
        foFile = this.replaceNotNull(foFile, "%%dataTiparire%%", Formatters.DATE_AND_TIME_FORMAT.format(new Date()));
        foFile = this.replaceNotNull(foFile, "%%visitId%%", visitId + "");
        foFile = this.replaceNotNull(foFile, "%%specialitate%%", specialitate);
        foFile = this.replaceNotNull(foFile, "%%medic%%", numeMedic);
        foFile = this.replaceNotNull(foFile, "%%nume%%", numePacient);
        foFile = this.replaceNotNull(foFile, "%%dataNasterii%%", dataNasteriiPacient);
        foFile = this.replaceNotNull(foFile, "%%functieMedic%%", functie);
        foFile = this.replaceNotNull(foFile, "%%email%%", email);
        foFile = this.replaceNotNull(foFile, "%%mobil%%", telMobil);
        foFile = this.replaceNotNull(foFile, "%%cnp%%", cnp);
        foFile = this.replaceNotNull(foFile, "%%telefon%%", telFix);
        foFile = this.replaceNotNull(foFile, "%%address%%", adresa);
        foFile = this.replaceNotNull(foFile, "%%entries1%%", date1);
        foFile = this.replaceNotNull(foFile, "%%entries2%%", date2);
        String filename = "fisa_1.fo";
        FileWriter fw = new FileWriter(filename);
        fw.write(foFile);
        fw.close();
        return filename;
    }

    private String replaceNotNull(String total, String field, String value) {
        String newValue = "";
        if (value != null) {
            newValue = value;
        }
        return total.replaceAll(field, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBiletTrimitere(int idPlatitor, int idPachetCAS, String serie, String numar, String codDiagnostic, String diagnostic, String codParafa, String codAsigurat, String scanFile, int idOrder, int idFile) {
        try {
            this.getDao().addBiletTrimitere(idPlatitor, idPachetCAS, serie, numar, codDiagnostic, diagnostic, codParafa, codAsigurat, idFile);
            int idBilet = this.pool.getIdentityLocal();
            this.getDao().linkBiletToOrder(idOrder, idBilet);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBiletTrimitere(int idPlatitor, int idPachetCAS, String serie, String numar, String codDiagnostic, String diagnostic, String codParafa, String codAsigurat, String scanFile, int idBiletTrimitere, int idFile) {
        try {
            this.getDao().updateBiletTrimitere(idPlatitor, idPachetCAS, serie, numar, codDiagnostic, diagnostic, codParafa, codAsigurat, idBiletTrimitere, idFile);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BiletTrimitere getBiletForOrder(int idOrder) {
        try {
            BiletTrimitere bt;
            BiletTrimitere biletTrimitere = bt = this.getDao().getBiletTrimitereForOrder(idOrder);
            return biletTrimitere;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incarcaBiletTrimitere(String file) {
        try {
            int idFile;
            File f = new File(file);
            int size = (int)f.length();
            FileInputStream fin = new FileInputStream(file);
            int n = idFile = DocumenteLogic.getInstance().addFileNoCommit(file, "", file, "", fin, size);
            return n;
        }
        catch (FileNotFoundException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return -1;
    }

    public boolean tiparesteOdtDupaTemplate(ClientPersFizica cpf, String template, String title) {
        String templateFile = FileUtils.getCurrentDir() + File.separator + VpConfig.getInstance().documentGeneratorTemplatesPath + File.separator + template;
        String outputFile = FileUtils.getTempDir() + File.separator + "generated.odt";
        Hashtable<String, String> mapping = new Hashtable<String, String>();
        mapping.put("data", Formatters.DATE_FORMAT_RO.format(new Date()));
        String angajator = "";
        int idCompanie = cpf.getIdPersJuridica();
        if (idCompanie > 0) {
            ClientPersJuridica cpj = ClientLogic.getInstance().getPersJuridicaById(idCompanie);
            angajator = cpj.getCompanyName();
        }
        mapping.put("angajator", angajator);
        mapping.put("prenume", cpf.getFirstname());
        mapping.put("nume", cpf.getLastname());
        int idBuletin = cpf.getIdBuletin();
        BiCi buletin = ClientLogic.getInstance().getBiCiById(idBuletin);
        if (buletin != null) {
            mapping.put("cnp", buletin.getCnp());
        } else {
            mapping.put("cnp", "");
        }
        mapping.put("data_nasterii", Formatters.DATE_FORMAT_RO.format(cpf.getDataNasterii()));
        String path = PrintLogic.getInstance().generateOdtDocument(templateFile, mapping, outputFile);
        boolean ok = PrintLogic.getInstance().printFacturaOpenOffice(path, "printer_items_facturi");
        ClientLogic.getInstance().addDocumentToClient(path, title, "Documente generate", cpf.getId());
        return ok;
    }

    public boolean tiparesteFisaLucru(ClientPersFizica cpf, Vector items, User user, Order o) {
        int i;
        String templateFile = FileUtils.getCurrentDir() + File.separator + "conf" + File.separator + "clinica_template_fisa_lucru.odt";
        String outputFile = FileUtils.getTempDir() + File.separator + "template_fisa_lucru.odt";
        Hashtable<String, Object> mapping = new Hashtable<String, Object>();
        String angajator = "";
        int idCompanie = cpf.getIdPersJuridica();
        if (idCompanie > 0) {
            ClientPersJuridica cpj = ClientLogic.getInstance().getPersJuridicaById(idCompanie);
            angajator = cpj.getCompanyName();
        }
        mapping.put("angajator", angajator);
        mapping.put("prenume", cpf.getFirstname());
        mapping.put("nume", cpf.getLastname());
        mapping.put("operator", user.getName());
        String barcodePath = RestLogic.getInstance().generateBarcodeForOrder(o);
        ArrayList tableItems = new ArrayList();
        HashMap<String, String> line1 = new HashMap<String, String>();
        line1.put("description", "_____");
        line1.put("quantity", Formatters.DATE_FORMAT_RO.format(new Date()));
        line1.put("picture", barcodePath);
        tableItems.add(line1);
        mapping.put("items", tableItems);
        int idBuletin = cpf.getIdBuletin();
        BiCi buletin = ClientLogic.getInstance().getBiCiById(idBuletin);
        if (buletin != null) {
            mapping.put("cnp", buletin.getCnp());
        } else {
            mapping.put("cnp", "");
        }
        mapping.put("data_nasterii", Formatters.DATE_FORMAT_RO.format(cpf.getDataNasterii()));
        int maxLines = 10;
        for (i = 0; i < items.size(); ++i) {
            AnalizeEntry item = (AnalizeEntry)items.elementAt(i);
            mapping.put("a" + i, "" + item.getDenumire());
            mapping.put("b" + i, item.getCodBare());
        }
        for (i = items.size(); i < maxLines; ++i) {
            mapping.put("a" + i, " ");
            mapping.put("b" + i, " ");
        }
        String path = PrintLogic.getInstance().generateOdtDocument(templateFile, mapping, outputFile);
        boolean ok = PrintLogic.getInstance().printFacturaOpenOffice(path, "printer_items_facturi");
        ClientLogic.getInstance().addDocumentToClient(path, "Fisa lucru", "Documente generate", cpf.getId());
        return ok;
    }

    public boolean tiparesteRezultatAnalize(ClientPersFizica cpf, Vector analize) {
        String templateFile = FileUtils.getCurrentDir() + File.separator + "conf" + File.separator + "clinica_rezultat_analize.odt";
        String outputFile = FileUtils.getTempDir() + File.separator + "result_clinica_rezultat_analize.odt";
        Hashtable<String, Object> mapping = new Hashtable<String, Object>();
        String angajator = "";
        int idCompanie = cpf.getIdPersJuridica();
        if (idCompanie > 0) {
            ClientPersJuridica cpj = ClientLogic.getInstance().getPersJuridicaById(idCompanie);
            angajator = cpj.getCompanyName();
        }
        mapping.put("angajator", angajator);
        mapping.put("prenume", cpf.getFirstname());
        mapping.put("nume", cpf.getLastname());
        ArrayList tableItems = new ArrayList();
        for (int i = 0; i < analize.size(); ++i) {
            AnalizeReportEntry ae = (AnalizeReportEntry)analize.elementAt(i);
            HashMap<String, String> line1 = new HashMap<String, String>();
            line1.put("description", ae.getNumeProdus());
            line1.put("quantity", ae.getRezultatAsString());
            line1.put("minvalue", Utils.getString2Decimals(ae.getLimitaMinima()));
            line1.put("maxvalue", Utils.getString2Decimals(ae.getLimitaMaxima()));
            tableItems.add(line1);
        }
        mapping.put("items", tableItems);
        int idBuletin = cpf.getIdBuletin();
        BiCi buletin = ClientLogic.getInstance().getBiCiById(idBuletin);
        if (buletin != null) {
            mapping.put("cnp", buletin.getCnp());
        } else {
            mapping.put("cnp", "");
        }
        mapping.put("data_nasterii", Formatters.DATE_FORMAT_RO.format(cpf.getDataNasterii()));
        String path = PrintLogic.getInstance().generateOdtDocument(templateFile, mapping, outputFile);
        boolean ok = PrintLogic.getInstance().printFacturaOpenOffice(path, "printer_items_facturi");
        ClientLogic.getInstance().addDocumentToClient(path, "Buletin analiza", "Documente generate", cpf.getId());
        this.exportRezultatAnalizeToWebsite(path);
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportAnalizeToSiui(Vector analize, String casaAsigurari, Date reportStart, Date reportStop) {
        try {
            String s = FileUtils.readFileToString("conf/clinica_export_siui.xml");
            StringBuffer services = new StringBuffer();
            double total = 0.0;
            for (int i = 0; i < analize.size(); ++i) {
                AnalizeReportEntry ae = (AnalizeReportEntry)analize.elementAt(i);
                if (ae.getStatus() != 5) continue;
                String s1 = this.getSiuiExportForAnaliza(ae, casaAsigurari);
                services.append(s1);
                services.append("\n\n");
                total += ae.getPret();
            }
            s = s.replaceAll("%%platitor%%", casaAsigurari);
            s = s.replaceAll("%%report_date%%", Formatters.DATE_FORMAT_RO.format(new Date()));
            s = s.replaceAll("%%report_start%%", Formatters.DATE_FORMAT_RO.format(reportStart));
            s = s.replaceAll("%%report_stop%%", Formatters.DATE_FORMAT_RO.format(reportStop));
            s = s.replaceAll("%%total_analisys%%", Utils.getString2Decimals(total));
            s = s.replaceAll("%%services%%", services.toString());
            FileUtils.writeTextToFile("tmp/export_SIUI.xml", s);
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private String getSiuiExportForAnaliza(AnalizeReportEntry ae, String casaAsigurari) throws IOException, SQLException {
        String s = FileUtils.readFileToString("conf/clinica_export_siui_service.xml");
        int idPacient = ae.getIdPersFizica();
        ClientPersFizica pacient = ClientLogic.getInstance().getPersFizicaByIdNoCommit(idPacient);
        int idBuletin = pacient.getIdBuletin();
        BiCi buletin = ClientLogic.getInstance().getBiCiById(idBuletin);
        s = s.replaceAll("%%cnp%%", buletin.getCnp());
        s = s.replaceAll("%%data_serviciului%%", ae.getDataComenzii());
        s = s.replaceAll("%%casa_asigurari%%", casaAsigurari);
        int idOrder = ae.getIdOrder();
        BiletTrimitere bt = this.getBiletForOrder(idOrder);
        if (bt != null) {
            s = s.replaceAll("%%cod_asigurat%%", bt.getCodAsigurat());
            s = s.replaceAll("%%cod_diagnostic%%", bt.getCodDiagnostic());
            s = s.replaceAll("%%cod_parafa%%", bt.getCodParafa());
            s = s.replaceAll("%%numar_bilet%%", bt.getNumar());
            s = s.replaceAll("%%serie_bilet%%", bt.getSerie());
            int idPachet = bt.getIdPachet();
            Product pachet = NomeclaturaLogic.getInstance().getProductById(idPachet);
            s = s.replaceAll("%%pachet_cas%%", pachet.getName());
            s = s.replaceAll("%%pret%%", Utils.getString2Decimals(ae.getPret()));
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportRezultatAnalizeToWebsite(String lcalPath) {
        try {
            String command = FileUtils.readFileToString("conf/export_file_to_external_server_command.txt");
            command = command.replaceAll("%%file%%", lcalPath);
            try {
                Process onlineProcess = Runtime.getRuntime().exec(command);
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
            }
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRaportBileteTrimitere(Hashtable criteria, boolean siNoteDeschise, int what) {
        try {
            Vector vector = this.getDao().getRaportBileteTrimitere(criteria, siNoteDeschise, what);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return new Vector();
    }

    public double getCreditConsumatThisMonth(ClientPersJuridica platitor) {
        double value = 0.0;
        if (platitor != null) {
            Hashtable<String, Object> result = new Hashtable<String, Object>();
            Date d = new Date();
            Date startDate = DateUtils.getStartOfMonth(d);
            result.put(Constants.START_KEY, startDate);
            result.put(Constants.STOP_KEY, d);
            result.put(BILET_ID_PLATITOR, platitor.getId() + "");
            Vector allBilete = this.getRaportBileteTrimitere(result, true, 2);
            for (int i = 0; i < allBilete.size(); ++i) {
                NoteView nv = (NoteView)allBilete.elementAt(i);
                value += nv.getSuma();
            }
        }
        return value;
    }

    public void trimiteSMS(Vector items, String data) {
        String text = Config.getInstance().getString("clinicaProgramariSmsText");
        for (int i = 0; i < items.size(); ++i) {
            ProgramareEntry programareEntry = (ProgramareEntry)items.elementAt(i);
            int itPacient = programareEntry.getIdPacient();
            ClientPersFizica cpf = ClientLogic.getInstance().getPersFizicaById(itPacient);
            String ora = programareEntry.getOra();
            String text1 = text.replaceAll("%data%", data);
            text1 = text1.replaceAll("%ora%", ora);
            String mobil = cpf.getTelefonMobil();
            MailUtils.sendSms(mobil, text1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAnalizeReport(Hashtable criteria) {
        String sectieAnalize = Config.getInstance().getString("clinicaSectieAnalize");
        Sectie sec = NomeclaturaLogic.getInstance().getSectieByName(sectieAnalize);
        int idSectie = sec.getId();
        String valMinimaS = Config.getInstance().getString("clinicaValoareMinimaKey");
        ProductAttribute valMinAttr = NomeclaturaLogic.getInstance().getAttributeByName(valMinimaS);
        String valMaximaS = Config.getInstance().getString("clinicaValoareMaximaKey");
        ProductAttribute valMaxAttr = NomeclaturaLogic.getInstance().getAttributeByName(valMaximaS);
        int idAtributMinim = valMinAttr.getIdAttribute();
        int idAtributMaxim = valMaxAttr.getIdAttribute();
        try {
            Vector result;
            Vector vector = result = this.getDao().getAnalizeReport(criteria, idSectie, idAtributMinim, idAtributMaxim);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnaliza(int idSale, boolean externa) {
        try {
            this.getDao().addAnaliza(idSale, externa);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValoareForAnaliza(int id, double valoare) {
        try {
            this.getDao().setValoareToAnaliza(id, valoare);
            this.getDao().updateStatusForAnaliza(id, 4);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusForAnaliza(int id, int newStatus) {
        try {
            this.getDao().updateStatusForAnaliza(id, newStatus);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public static int getValueForStatusAnaliza(String status) {
        if (status.equalsIgnoreCase("Noua")) {
            return 1;
        }
        if (status.equalsIgnoreCase("In lucru")) {
            return 2;
        }
        if (status.equalsIgnoreCase("Lipsa proba")) {
            return 3;
        }
        if (status.equalsIgnoreCase("Finalizata")) {
            return 4;
        }
        if (status.equalsIgnoreCase("Validata")) {
            return 5;
        }
        if (status.equalsIgnoreCase("Predata")) {
            return 5;
        }
        if (status.equalsIgnoreCase("Nefinalizata")) {
            return 6;
        }
        return -1;
    }

    public Vector getCategoriiAnalize() {
        String sectieAnalize = Config.getInstance().getString("clinicaSectieAnalize");
        Sectie sec = NomeclaturaLogic.getInstance().getSectieByName(sectieAnalize);
        if (sec != null) {
            Comparator comp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    Categorie c1 = (Categorie)o1;
                    Categorie c2 = (Categorie)o2;
                    return c1.getName().compareToIgnoreCase(c2.getName());
                }
            };
            Vector categories = NomeclaturaLogic.getInstance().getCategorii(sec.getId(), comp);
            return categories;
        }
        return new Vector();
    }

    public Promotion getPromotieForCasaSanatate(int idCasaSanatate) {
        Vector<ClientPromotieView> promotii = PromotionLogic.getInstance().getPromotiiClient();
        for (int i = 0; i < promotii.size(); ++i) {
            ClientPromotieView clientPromotieView = promotii.elementAt(i);
            if (clientPromotieView.getIdClient() != idCasaSanatate) continue;
            Promotion p = PromotionLogic.getInstance().getPromotionById(clientPromotieView.getIdPromotie());
            return p;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getComisionReport(Hashtable criteria) {
        try {
            int idUser = (Integer)criteria.get(Constants.WAITER_KEY);
            Date start = (Date)criteria.get(Constants.START_KEY);
            Date stop = (Date)criteria.get(Constants.STOP_KEY);
            Vector vector = this.getDao().getComisionMediciReport(idUser, new Timestamp(start.getTime()), new Timestamp(stop.getTime()));
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector getTemplateFiles() {
        String templatesPath = VpConfig.getInstance().documentGeneratorTemplatesPath;
        File f = new File(FileUtils.getCurrentDir() + File.separator + templatesPath);
        Vector<String> result = new Vector<String>();
        if (f.exists()) {
            String[] files = f.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".odt");
                }
            });
            for (int i = 0; i < files.length; ++i) {
                String el = files[i];
                result.add(el);
            }
        }
        return result;
    }

    static {
        DURATA_VIZITA = 20;
    }
}

