/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.clinicabase;

import java.sql.Time;
import java.util.StringTokenizer;
import ro.atreides.restaurant.clinicabase.DayProgram;
import ro.atreides.utils.Formatters;

public class MedicProgram {
    private String numeMedic;
    private int idMedic;
    private DayProgram[] items = new DayProgram[7];

    public MedicProgram(int idMedic, String numeMedic) {
        this.idMedic = idMedic;
        this.numeMedic = numeMedic;
    }

    public int getIdMedic() {
        return this.idMedic;
    }

    public void setIdMedic(int idMedic) {
        this.idMedic = idMedic;
    }

    public String getNumeMedic() {
        return this.numeMedic;
    }

    public void setNumeMedic(String numeMedic) {
        this.numeMedic = numeMedic;
    }

    public String getTimeAsString(int column) {
        DayProgram dp = this.items[column];
        if (dp != null) {
            Time start = dp.getStart();
            Time stop = dp.getStop();
            String startS = "";
            String stopS = "";
            if (start != null && stop != null) {
                startS = Formatters.TIME_FORMAT.format(start);
                stopS = Formatters.TIME_FORMAT.format(dp.getStop());
                return startS + "-" + stopS;
            }
        }
        return "";
    }

    public boolean setTimesFromString(int column, String newTimes, int currentYear, int currentWeek) {
        DayProgram dp = this.items[column];
        try {
            StringTokenizer token = new StringTokenizer(newTimes, "-");
            String start = token.nextToken();
            String stop = token.nextToken();
            Time t1 = Time.valueOf(start + ":00");
            Time t2 = Time.valueOf(stop + ":00");
            if (t1.after(t2)) {
                return false;
            }
            if (dp == null) {
                dp = new DayProgram();
                dp.setAn(currentYear);
                dp.setWeek(currentWeek);
                dp.setIdDay(column + 1);
                this.items[column] = dp;
            }
            dp.setStart(t1);
            dp.setStop(t2);
            return true;
        }
        catch (RuntimeException e) {
            dp.setStart(null);
            dp.setStop(null);
            return true;
        }
    }

    public DayProgram[] getItems() {
        return this.items;
    }

    public void setItems(DayProgram[] items) {
        this.items = items;
    }
}

