/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.imports.ciel.CielFacturiCumparareImporter;
import ro.atreides.contabilitate.imports.ciel.CielFacturiVanzareImporter;
import ro.atreides.contabilitate.imports.ciel.CielTransferuriImportFromExcel;
import ro.atreides.contabilitate.imports.magister.MagisterImporter;
import ro.atreides.contabilitate.saga.SagaExportLogic;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.imports.asscon.AssconImporter;
import ro.atreides.restaurant.imports.csv.CsvRetetarImporter;
import ro.atreides.restaurant.imports.nessus.NessusImporter;
import ro.atreides.restaurant.logic.ImportProduseFiniteImpl;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.logic.imports.DeverStardardImporter;
import ro.atreides.restaurant.logic.imports.ciel.CielPersJuridiceImporter;
import ro.atreides.restaurant.logic.imports.ciel.CielProductsImporter;
import ro.atreides.restaurant.logic.winmentor.WinmentorExportLogic;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.multilang.LangRoAll;

public class ActiuniPanel
extends ReflectedJPanel
implements CleanupRequired {
    private RestLogic logic = RestLogic.getInstance();

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.getOperatiuniCurente(), c);
        ++c.gridy;
        this.add((Component)this.getOperatiuniInitializare(), c);
    }

    private JPanel getOperatiuniInitializare() {
        int idSocietateaNoastra = -1;
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        final ActiuniPanel panel = this;
        c.gridx = 0;
        c.gridy = 0;
        JButton importProduse = new JButton("Import produse xml");
        importProduse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de produse", "xml");
                if (inputFile != null) {
                    ActiuniPanel.this.logic.importProductsInPOS(inputFile);
                }
            }
        });
        result.add((Component)importProduse, c);
        ++c.gridx;
        JButton importNote = new JButton("Import note");
        importNote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de note", "xml");
                if (inputFile != null) {
                    ActiuniPanel.this.logic.importOrdersFromXml(inputFile);
                }
            }
        });
        result.add((Component)importNote, c);
        ++c.gridx;
        JButton importProduseExcel = new JButton("Import produse excel");
        importProduseExcel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile;
                if (DialogUtils.confirmDialog(panel, "Format fisier: Sectie, Categorie, Nume, CodIntern, Pret, UM, Pret/cantitate, Unitate ambalare, Termen estimat de aprovizionare,Cod furnizor/bare 1, Cod furnizor/bare 2, ....", "Continuam") && (inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de importat", "xls")) != null) {
                    ActiuniPanel.this.logic.importProduseFromExcel(inputFile, new ImportProduseFiniteImpl(false));
                    StockLogic.getInstance().refreshStocks();
                    DialogUtils.okDialog(panel, "Import efectuat", LangRoAll.succes);
                }
            }
        });
        result.add((Component)importProduseExcel, c);
        ++c.gridx;
        JButton importNiruriXML = new JButton("Import niruri xml");
        importNiruriXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile;
                if (DialogUtils.confirmDialog(panel, "Importam nirurile din xml", "Continuam") && (inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de importat", "xml")) != null) {
                    ContaLogic.getInstance().importNiruriFromXml(inputFile, -1);
                    DialogUtils.okDialog(panel, "Import efectuat", LangRoAll.succes);
                }
            }
        });
        result.add((Component)importNiruriXML, c);
        ++c.gridx;
        JButton generareCarduri = new JButton("Generare carduri fidelitate");
        generareCarduri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PromotionLogic.getInstance().generateCarduriFidelitate(panel);
            }
        });
        result.add((Component)generareCarduri, c);
        ++c.gridy;
        c.gridx = 0;
        JButton modificaCodBare = new JButton("Modifica cod bare");
        modificaCodBare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile;
                if (DialogUtils.confirmDialog(panel, "Fisierul text trebuie de forma cod_intern|cod_bare . Confirmati", "Continuam") && (inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de import", "txt")) != null) {
                    boolean ok = NomeclaturaLogic.getInstance().updateCoduriBare(inputFile);
                    if (ok) {
                        DialogUtils.okDialog(panel, "Operatie efectuata", LangRoAll.succes);
                    } else {
                        DialogUtils.errorDialog(panel, "Operatie anulata. Nu s-au efectuat modificari.", LangRoAll.eroare);
                    }
                }
            }
        });
        result.add((Component)modificaCodBare, c);
        ++c.gridx;
        JButton modificaPreturi = new JButton("Modifica preturi");
        modificaPreturi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile;
                if (DialogUtils.confirmDialog(panel, "Fisierul text trebuie de forma cod_intern|pret . Confirmati", "Continuam") && (inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de import", "txt")) != null) {
                    boolean ok = RestLogic.getInstance().updatePreturiPentruCoduriIntern(inputFile);
                    if (ok) {
                        DialogUtils.okDialog(panel, "Operatie efectuata", LangRoAll.succes);
                    } else {
                        DialogUtils.errorDialog(panel, "Operatie anulata. Nu s-au efectuat modificari.", LangRoAll.eroare);
                    }
                }
            }
        });
        result.add((Component)modificaPreturi, c);
        ++c.gridx;
        JButton importRetetarCSV = new JButton("Import retetar CSV");
        importRetetarCSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de retete (Cod intern produs|Ingredient|Cantitate)", "csv");
                if (inputFile != null) {
                    CsvRetetarImporter.getInstance().importRetetar(inputFile, panel);
                    DialogUtils.okDialog(panel, "Import efectuat", LangRoAll.succes);
                }
            }
        });
        result.add((Component)importRetetarCSV, c);
        ++c.gridx;
        JButton importRetetarXLS = new JButton("Import produse si retetar XLS");
        importRetetarXLS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de produse si retete - vezi model!", "xls,XLS");
                if (inputFile != null) {
                    CsvRetetarImporter.getInstance().importRetetarFromExcel(inputFile);
                    DialogUtils.okDialog(panel, "Import efectuat", LangRoAll.succes);
                }
            }
        });
        result.add((Component)importRetetarXLS, c);
        ++c.gridx;
        JButton importPersJuridiceStandard = new JButton("Import persoane juridice CSV");
        importPersJuridiceStandard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de persoane juridice (nume|alias|cui|platitoaretva|platitoaretvaincasare|j|adresa|oras|tara|zip|banca|iban|persoanacontact|email|fix|mobil|fax|website|observatii|zilescandeta|credit)!", "csv");
                if (inputFile != null) {
                    DeverStardardImporter.getInstance().importClientiPersJuridice(inputFile);
                    DialogUtils.okDialog(panel, "Import efectuat", LangRoAll.succes);
                }
            }
        });
        result.add((Component)importPersJuridiceStandard, c);
        c.gridx = 0;
        ++c.gridy;
        JButton importProduseFiniteCiel = new JButton("Import produse finite Ciel");
        importProduseFiniteCiel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile;
                if (DialogUtils.confirmDialog(panel, "Export din Ciel (articole) , separator = | , fisier txt. Confirmati", "Continuam") && (inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de import", "txt")) != null) {
                    CielProductsImporter.getInstance().importProduse(inputFile);
                    DialogUtils.okDialog(panel, "Import efectuat", LangRoAll.succes);
                }
            }
        });
        result.add((Component)importProduseFiniteCiel, c);
        ++c.gridx;
        JButton importPersoaneJuridiceCiel = new JButton("Import persoane juridice Ciel");
        importPersoaneJuridiceCiel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile;
                if (DialogUtils.confirmDialog(panel, "Export din Ciel (clienti) , separator = | , fisier txt. Confirmati", "Continuam") && (inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de import", "txt")) != null) {
                    CielPersJuridiceImporter.getInstance().importPersoaneJuridice(inputFile);
                    DialogUtils.okDialog(panel, "Import efectuat", LangRoAll.succes);
                }
            }
        });
        result.add((Component)importPersoaneJuridiceCiel, c);
        ++c.gridx;
        JButton importIntrareMarfaCiel = new JButton("Import intrare marfa Ciel");
        importIntrareMarfaCiel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogUtils.confirmDialog(panel, "Export din Ciel (intrare marfa) , separator = | , fisier txt. Confirmati", "Continuam")) {
                    String inputFile1 = FileDialog.getLoadDialogLocation(panel, "Selectati borderoul de import marfa", "txt,csv");
                    String inputFile2 = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de tranzatii import marfa", "txt,csv");
                    if (inputFile1 != null && inputFile2 != null) {
                        new CielFacturiCumparareImporter().importFacturiCumparare(inputFile1, inputFile2, -1);
                        DialogUtils.okDialog(panel, "Import efectuat", LangRoAll.succes);
                    }
                }
            }
        });
        result.add((Component)importIntrareMarfaCiel, c);
        ++c.gridx;
        JButton importVanzareCiel = new JButton("Import facturi vanzare Ciel");
        importVanzareCiel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogUtils.confirmDialog(panel, "Export din Ciel (facturi vanzare) , separator = | , fisier txt. Confirmati", "Continuam")) {
                    String inputFile1 = FileDialog.getLoadDialogLocation(panel, "Selectati borderoul de facturi emise", "txt,csv");
                    String inputFile2 = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de tranzatii facturi emise", "txt,csv");
                    if (inputFile1 != null && inputFile2 != null) {
                        new CielFacturiVanzareImporter().importFacturiVanzare(inputFile1, inputFile2, -1);
                        DialogUtils.okDialog(panel, "Import efectuat", LangRoAll.succes);
                    }
                }
            }
        });
        result.add((Component)importVanzareCiel, c);
        ++c.gridx;
        JButton importTransferuriCiel = new JButton("Import transferuri Ciel");
        importTransferuriCiel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile1;
                if (DialogUtils.confirmDialog(panel, "Export din Ciel (transferuri) excel . Confirmati", "Continuam") && (inputFile1 = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de transferuri", "xls")) != null) {
                    new CielTransferuriImportFromExcel().importTransferuri(inputFile1);
                    DialogUtils.okDialog(panel, "Import efectuat", LangRoAll.succes);
                }
            }
        });
        result.add((Component)importTransferuriCiel, c);
        ++c.gridy;
        c.gridx = 0;
        JButton importRetetarMasterERP = new JButton("Import retetar MasterERP");
        importRetetarMasterERP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de retete", "xls");
                if (inputFile != null) {
                    ActiuniPanel.this.logic.importRetetarMasterERP(inputFile);
                    DialogUtils.okDialog(panel, "Import efectuat", LangRoAll.succes);
                }
            }
        });
        result.add((Component)importRetetarMasterERP, c);
        ++c.gridx;
        JButton importMateriiPrimeMasterERP = new JButton("Import produse finite MasterERP");
        importMateriiPrimeMasterERP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de produse finite", "xls");
                if (inputFile != null) {
                    ActiuniPanel.this.logic.importMateriiPrimeMasterERP(inputFile);
                    DialogUtils.okDialog(panel, "Import efectuat", LangRoAll.succes);
                }
            }
        });
        result.add((Component)importMateriiPrimeMasterERP, c);
        ++c.gridx;
        JButton importExcelMagisterNiruri = new JButton("Import Stoc Magister pe Furnizori");
        importExcelMagisterNiruri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile;
                String coloane = "magazia,furnizorul,numeprodus,unitate masura,codbare,cantitate,pretachizitie,pretvanzare";
                if (DialogUtils.confirmDialog(panel, "Fisierul trebuie sa aiba coloanele \"" + coloane + "\". Continuam", LangRoAll.confirmare) && (inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de importat", "xls")) != null) {
                    MagisterImporter.importFacturiPeFurnizori(new File(inputFile), -1);
                }
            }
        });
        result.add((Component)importExcelMagisterNiruri, c);
        ++c.gridx;
        JButton importBazaNessus = new JButton("Import Nessus");
        importBazaNessus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String retetaFile;
                String produseFile;
                if (DialogUtils.confirmDialog(panel, "Ati efectuat corect operatia de export si procesare.", LangRoAll.confirmare) && (produseFile = FileDialog.getLoadDialogLocation(panel, "Meniul", "csv")) != null && (retetaFile = FileDialog.getLoadDialogLocation(panel, "Retetarul", "csv")) != null) {
                    new NessusImporter().importNessus(produseFile, retetaFile);
                    DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                }
            }
        });
        result.add((Component)importBazaNessus, c);
        ++c.gridx;
        JButton importASSCON = new JButton("Import ASSCON");
        importASSCON.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String banci;
                String firme;
                String stocuri;
                AssconImporter importer = new AssconImporter();
                String nomenclator = FileDialog.getLoadDialogLocation(panel, "nomstoc.dbf", "dbf");
                if (nomenclator != null) {
                    boolean ok = importer.importNomenclatorStocuri(nomenclator);
                    if (ok) {
                        DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                    } else {
                        DialogUtils.okDialog(panel, LangRoAll.operatieEsuata, LangRoAll.eroare);
                        return;
                    }
                }
                if ((stocuri = FileDialog.getLoadDialogLocation(panel, "stocuri.dbf", "dbf")) != null) {
                    boolean ok = importer.importStocuri(stocuri, -1);
                    if (ok) {
                        DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                    } else {
                        DialogUtils.okDialog(panel, LangRoAll.operatieEsuata, LangRoAll.eroare);
                        return;
                    }
                }
                if ((firme = FileDialog.getLoadDialogLocation(panel, "firme.dbf", "dbf")) != null) {
                    boolean ok = importer.importFirme(firme);
                    if (ok) {
                        DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                    } else {
                        DialogUtils.okDialog(panel, LangRoAll.operatieEsuata, LangRoAll.eroare);
                        return;
                    }
                }
                if ((banci = FileDialog.getLoadDialogLocation(panel, "banci.dbf", "dbf")) != null) {
                    boolean ok = importer.importBanci(banci);
                    if (ok) {
                        DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                    } else {
                        DialogUtils.okDialog(panel, LangRoAll.operatieEsuata, LangRoAll.eroare);
                        return;
                    }
                }
            }
        });
        result.add((Component)importASSCON, c);
        result.setBorder(new TitledBorder("Operatiuni initializare"));
        return result;
    }

    private JPanel getOperatiuniCurente() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        final ActiuniPanel panel = this;
        c.gridx = 0;
        c.gridy = 0;
        JButton exportWinmentor = new JButton("Export WinMentor");
        exportWinmentor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DialogUtils.confirmDialog(panel, "Exportam datele pentru WinMentor", LangRoAll.confirmare)) {
                    String saveDir = WinmentorExportLogic.getInstance().exportDateWinMentor(panel, ActiuniPanel.this.logic);
                    if (saveDir != null) {
                        DialogUtils.okDialog(panel, "Datele au fost salvate la " + saveDir, LangRoAll.succes);
                    } else {
                        DialogUtils.errorDialog(panel, "Export esuat", LangRoAll.eroare);
                    }
                }
            }
        });
        result.add((Component)exportWinmentor, c);
        ++c.gridx;
        JButton importWinmentor = new JButton("Import Winmentor Articole");
        importWinmentor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String produseFile;
                if (DialogUtils.confirmDialog(panel, "Importam articolele din Winmentor", LangRoAll.confirmare) && (produseFile = FileDialog.getLoadDialogLocation(panel, "Alegeti fisierul de articole", "txt")) != null) {
                    WinmentorExportLogic.getInstance().importArticole(produseFile, panel);
                    DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                }
            }
        });
        result.add((Component)importWinmentor, c);
        ++c.gridx;
        JButton exportPlatforma = new JButton("Export Platphorma");
        exportPlatforma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DialogUtils.confirmDialog(panel, "Exportam datele pentru Platphorma 9", LangRoAll.confirmare)) {
                    String saveDir = ActiuniPanel.this.logic.exportDatePlatforma(panel);
                    if (saveDir != null) {
                        DialogUtils.okDialog(panel, "Datele au fost salvate la " + saveDir, LangRoAll.succes);
                    } else {
                        DialogUtils.errorDialog(panel, "Export esuat", LangRoAll.eroare);
                    }
                }
            }
        });
        result.add((Component)exportPlatforma, c);
        ++c.gridx;
        JButton exportSaga = new JButton("Export Saga");
        exportSaga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DialogUtils.confirmDialog(panel, "Exportam datele pentru Saga", LangRoAll.confirmare)) {
                    String saveDir = SagaExportLogic.getInstance().exportDateSaga(panel, ActiuniPanel.this.logic);
                    if (saveDir != null) {
                        DialogUtils.okDialog(panel, "Datele au fost salvate la " + saveDir, LangRoAll.succes);
                    } else {
                        DialogUtils.errorDialog(panel, "Export esuat", LangRoAll.eroare);
                    }
                }
            }
        });
        result.add((Component)exportSaga, c);
        result.setBorder(new TitledBorder("Sincronizare programe contabile"));
        return result;
    }

    @Override
    public void doStuff() {
        this.display();
    }

    @Override
    public void cleanup() {
    }
}

