/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.PreparareEntry;
import ro.atreides.restaurant.RaportProductieEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.util.CompareUtils;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.SwitchToList;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class AddProductiePanel
extends ReflectedJPanel
implements CleanupRequired {
    private RestLogic logic;
    private StockLogic stockLogic = StockLogic.getInstance();
    private JComboBox produse;
    private JComboBox magazie;
    private JTextField time;
    private JTextField cantitate;
    private JButton adauga;
    private MDateEntryField data;
    private JLabel totalFacturaCuTva;
    private AbstractTM itemsTm;
    private double totalGeneral;
    private SwitchToList action;
    private RaportProductieEntry toEdit = null;
    private JButton salveaza;
    private JButton sterge;
    public static final String[] columns = new String[]{LangRoAll.produs, LangRoAll.cantitate, "Valoare la vanzare"};
    public static final String SALVEAZA_ADD = LangRoAll.adauga;
    public static final String SALVEAZA_EDIT = LangRoAll.salveaza;
    public static final String STERGE_ADD = "Golire";
    public static final String STERGE_EDIT = LangRoAll.sterge;

    public AddProductiePanel() {
        this.logic = RestLogic.getInstance();
        this.init();
    }

    public SwitchToList getAction() {
        return this.action;
    }

    public void setAction(SwitchToList action) {
        this.action = action;
    }

    private void init() {
        this.produse = new JComboBox();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        this.add((Component)this.getTopPanel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        JPanel total = this.getTotalFacturaPanel();
        this.add((Component)total, c);
        ++c.gridx;
        JPanel buttons = this.getButtonsPanel();
        this.add((Component)buttons, c);
    }

    private JPanel getTopPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.5;
        JPanel dateFactura = this.getFacturaPanel();
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)dateFactura, c);
        c.weightx = 1.0;
        JPanel dateProdus = this.getProdusPanel();
        ++c.gridx;
        result.add((Component)dateProdus, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 1.0;
        JPanel nirTable = this.getTablePanel();
        result.add((Component)nirTable, c);
        this.stockLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                AddProductiePanel.this.refreshMagaziiCombo();
            }

            @Override
            public String getName() {
                return "ProductiePanel_magazii";
            }
        }, 27);
        this.logic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                AddProductiePanel.this.refreshProductsCombo();
            }

            @Override
            public String getName() {
                return "ProductiePanel_products";
            }
        }, 2);
        this.refreshMagaziiCombo();
        return result;
    }

    private JPanel getProdusPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date produse"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.produs), c);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.produse, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.cantitate), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.cantitate = new JTextField(10);
        result.add((Component)this.cantitate, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.adauga = new JButton(LangRoAll.adauga);
        this.adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddProductiePanel.this.addEntry();
            }
        });
        result.add((Component)this.adauga, c);
        this.refreshProductsCombo();
        this.initFields();
        return result;
    }

    private void refreshProductsCombo() {
        Vector<Product> sorted = this.logic.getAllRetetaProducts(true);
        Collections.sort(sorted, new Comparator(){

            public int compare(Object o1, Object o2) {
                return CompareUtils.compareProductsByName(o1, o2);
            }
        });
        ComboUtils.replaceItemsForCombo(this.produse, sorted, false);
    }

    private void refreshMagaziiCombo() {
        AddProductiePanel addProductiePanel = this;
        Vector<Magazie> magazii = addProductiePanel.stockLogic.getInstance().getMagazii();
        ComboUtils.replaceItemsForCombo(this.magazie, magazii, false);
    }

    private void initFields() {
        this.cantitate.setText("");
    }

    private JPanel getFacturaPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date productie"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Magazie"), c);
        ++c.gridx;
        this.magazie = new JComboBox();
        c.gridwidth = 2;
        result.add((Component)this.magazie, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.data), c);
        ++c.gridx;
        this.data = new MDateEntryField();
        this.data.setValue(new Date());
        this.data.setEditable(false);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 3;
        this.data.setConstraints((MDateSelectorConstraints)c1);
        this.data.setToolTipText("Alege data");
        result.add((Component)this.data, c);
        ++c.gridx;
        this.time = new JTextField();
        this.time.setText("00:00");
        result.add((Component)this.time, c);
        return result;
    }

    private JPanel getTotalFacturaPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.total));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.total), c);
        ++c.gridx;
        this.totalFacturaCuTva = new JLabel("0");
        result.add((Component)this.totalFacturaCuTva, c);
        return result;
    }

    private JPanel getButtonsPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        final AddProductiePanel parent = this;
        ++c.gridx;
        JButton toBC = new JButton("Creare bon consum");
        toBC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector entries = AddProductiePanel.this.logic.getBonConsumItems(AddProductiePanel.this.itemsTm.getData(), AdministrationPanel.loggedUser);
                if (DialogUtils.confirmDialog(parent, "Salvam data si ora pentru Bon Cosum", LangRoAll.salvam)) {
                    Date d = DateUtils.setTimeToDate((Component)parent, AddProductiePanel.this.data, AddProductiePanel.this.time);
                    StockLogic.getInstance().getAddConsumPanel().setDate(d);
                    StockLogic.getInstance().getAddConsumPanel().setTime(AddProductiePanel.this.time.getText());
                }
                AddProductiePanel.this.stockLogic.getAddConsumPanel().addBonEntries(entries);
            }
        });
        result.add((Component)toBC, c);
        ++c.gridx;
        this.salveaza = new JButton(LangRoAll.salveaza);
        this.salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Magazie m = (Magazie)AddProductiePanel.this.magazie.getSelectedItem();
                Date d = DateUtils.setTimeToDate((Component)parent, AddProductiePanel.this.data, AddProductiePanel.this.time);
                if (d == null) {
                    return;
                }
                if (AddProductiePanel.this.toEdit == null) {
                    AddProductiePanel.this.logic.preparareProduse(AddProductiePanel.this.itemsTm.getData(), m.getId(), new Timestamp(d.getTime()));
                    AddProductiePanel.this.resetFields();
                } else if (AddProductiePanel.this.logic.updateFabricatie(AddProductiePanel.this.toEdit.getIdProductie(), m.getId(), AddProductiePanel.this.toEdit.getDateadd(), new Timestamp(d.getTime()), AddProductiePanel.this.itemsTm.getData(), parent)) {
                    AddProductiePanel.this.setProductieToEdit(null);
                    AddProductiePanel.this.action.doAction();
                }
            }
        });
        result.add((Component)this.salveaza, c);
        ++c.gridx;
        this.sterge = new JButton(LangRoAll.sterge);
        this.sterge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AddProductiePanel.this.toEdit != null) {
                    if (DialogUtils.confirmDialog(parent, "Stergem aceasta productie", LangRoAll.confirmare)) {
                        AddProductiePanel.this.logic.deleteProductie(AddProductiePanel.this.toEdit.getIdProductie(), parent, AddProductiePanel.this.toEdit.getDateadd());
                        AddProductiePanel.this.setProductieToEdit(null);
                        AddProductiePanel.this.action.doAction();
                    }
                } else if (DialogUtils.confirmDialog(parent, "Golim ecranul", LangRoAll.confirmare)) {
                    AddProductiePanel.this.setProductieToEdit(null);
                }
            }
        });
        result.add((Component)this.sterge, c);
        return result;
    }

    private void resetFields() {
        this.initFields();
        Vector data = this.itemsTm.getData();
        if (data != null) {
            data.removeAllElements();
        }
        this.itemsTm.fireTableDataChanged();
        this.totalGeneral = 0.0;
        this.updateTotals();
    }

    private void addEntry() {
        double cant = 0.0;
        Product p = (Product)this.produse.getSelectedItem();
        if (!this.logic.isReteta(p.getId())) {
            DialogUtils.errorDialog(this, "Nu puteti prepara decat produse cu reteta", LangRoAll.nuPotContinua);
            return;
        }
        String cantS = this.cantitate.getText();
        if (!Validators.correctDouble(cantS)) {
            DialogUtils.errorDialog(this, "Cantitatea trebuie sa fie un numar", LangRoAll.nuPotContinua);
            this.cantitate.requestFocus();
            return;
        }
        cant = Utils.parseDouble(cantS);
        if (cant <= 0.0) {
            DialogUtils.errorDialog(this, "Cantitatea trebuie sa fie > 0", LangRoAll.nuPotContinua);
            this.cantitate.requestFocus();
            return;
        }
        Date d = DateUtils.setTimeToDate((Component)this, this.data, this.time);
        if (d == null) {
            return;
        }
        PreparareEntry pp = new PreparareEntry();
        double price = this.logic.getPriceForProductCommit(p.getId());
        pp.setCantitate(cant);
        pp.setProdus(p.getName());
        double value = cant * price;
        pp.setPretVanzare(price);
        pp.setValoareVanzare(value);
        pp.setIdProdusReteta(this.logic.getIdReteta(p.getId()));
        this.totalGeneral += value;
        Vector entries = this.itemsTm.getData();
        entries.add(pp);
        this.itemsTm.fireTableDataChanged();
        this.initFields();
        this.updateTotals();
    }

    private void updateTotals() {
        this.totalGeneral = 0.0;
        Vector d = this.itemsTm.getData();
        for (int i = 0; i < d.size(); ++i) {
            PreparareEntry pp = (PreparareEntry)d.elementAt(i);
            this.totalGeneral += pp.getValoareVanzare();
        }
        this.totalFacturaCuTva.setText(Utils.getString2Decimals(this.totalGeneral));
    }

    private JPanel getTablePanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date productie"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        this.itemsTm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                PreparareEntry p = (PreparareEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return p.getProdus();
                    }
                    case 1: {
                        return Utils.getString3Decimals(p.getCantitate());
                    }
                    case 2: {
                        return Utils.getString2Decimals(p.getValoareVanzare());
                    }
                }
                return null;
            }
        });
        final AddProductiePanel panel = this;
        JTable table = new JTable(this.itemsTm);
        table.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                int selRow = source.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getClickCount() == 2 && DialogUtils.confirmDialog(panel, "Doriti sa stergeti aceasta inregistrare", LangRoAll.confirmare)) {
                    AddProductiePanel.this.eraseEntry(selRow);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        JScrollPane scroll = new JScrollPane(table);
        result.add((Component)scroll, c);
        return result;
    }

    private void eraseEntry(int selRow) {
        this.itemsTm.getData().removeElementAt(selRow);
        this.itemsTm.fireTableDataChanged();
        this.updateTotals();
    }

    @Override
    public void doStuff() {
    }

    @Override
    public void cleanup() {
        this.produse.removeAllItems();
        this.magazie.removeAllItems();
    }

    public void setProductieToEdit(RaportProductieEntry toEdit) {
        if (toEdit != null) {
            Magazie m = this.stockLogic.getMagazieById(toEdit.getIdMagazie());
            this.magazie.setSelectedItem(m);
            this.data.setValue((Date)toEdit.getDateadd());
            this.time.setText(DateUtils.getTimeFromDate(toEdit.getDateadd()));
            Vector values = this.logic.getFabricareItems(toEdit.getIdProductie());
            this.itemsTm.getData().removeAllElements();
            this.itemsTm.getData().addAll(values);
            this.itemsTm.fireTableDataChanged();
            this.updateTotals();
            this.salveaza.setText(SALVEAZA_EDIT);
            this.sterge.setText(STERGE_EDIT);
        } else {
            Timestamp now = DateUtils.getCurrentTimestamp();
            this.data.setValue((Date)now);
            this.time.setText(DateUtils.getTimeFromDate(now));
            this.resetFields();
            this.salveaza.setText(SALVEAZA_ADD);
            this.sterge.setText(STERGE_ADD);
        }
        this.toEdit = toEdit;
    }
}

