/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JTabbedPane;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.nomenclatura.gui.CategoriesPanel;
import ro.atreides.nomenclatura.gui.SectiiPanel;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.base.ModPreparare;
import ro.atreides.restaurant.base.OrdineServire;
import ro.atreides.restaurant.gui.ModPrepararePanel;
import ro.atreides.restaurant.gui.OrdineServirePanel;
import ro.atreides.restaurant.gui.admin.prices.PricesPanel;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataPanel;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaPanel;

public class FoodLiteModificationsPanel
extends ReflectedJPanel
implements CleanupRequired {
    private JTabbedPane _tabbedPane = null;
    private SectiiPanel sectiiPanel;
    private CategoriesPanel subcategoriesPanel = null;
    private PricesPanel _pricesPanel = null;
    private TipPlataPanel tipPlataPanel;
    private TvaPanel tvaPanel;

    @Override
    public void doStuff() {
        this.init();
        this.display();
    }

    @Override
    public void cleanup() {
        this._pricesPanel.cleanup();
        this.subcategoriesPanel.cleanup();
    }

    private void init() {
        this._tabbedPane = new JTabbedPane();
        this._pricesPanel = new PricesPanel();
        this._tabbedPane.add(LangRoAll.preturi, this._pricesPanel);
        this.subcategoriesPanel = new CategoriesPanel(true, false, true, true);
        this.subcategoriesPanel.doStuff();
        this._tabbedPane.add(LangRoAll.categorii, this.subcategoriesPanel);
        this.sectiiPanel = new SectiiPanel(false);
        this.sectiiPanel.doStuff();
        this._tabbedPane.add(LangRoAll.sectii, this.sectiiPanel);
        final ModPrepararePanel mp = new ModPrepararePanel();
        mp.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                RestLogic.getInstance().deleteModPreparare((ModPreparare)o);
                mp.refreshTable();
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        mp.doStuff();
        this._tabbedPane.add(LangRoAll.modPreparare, mp);
        final OrdineServirePanel op = new OrdineServirePanel();
        op.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                RestLogic.getInstance().deleteOrdineServire((OrdineServire)o);
                op.refreshTable();
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        op.doStuff();
        this._tabbedPane.add(LangRoAll.ordineServire, op);
        this.tipPlataPanel = new TipPlataPanel();
        this.tipPlataPanel.setPromoInterface(PromotionLogic.getInstance());
        this.tipPlataPanel.setConturiInterface(ClientLogic.getInstance());
        this.tipPlataPanel.doStuff();
        this.tipPlataPanel.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                TipPlata tip = (TipPlata)o;
                FoodLiteModificationsPanel.this.tipPlataPanel.setTipPlata(tip);
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        this._tabbedPane.add(LangRoAll.tipuriPlata, this.tipPlataPanel);
        this.tvaPanel = new TvaPanel();
        this.tvaPanel.doStuff();
        this.tvaPanel.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                Tva tva = (Tva)o;
                FoodLiteModificationsPanel.this.tvaPanel.setTvaToEdit(tva);
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        this._tabbedPane.add(LangRoAll.tva, this.tvaPanel);
        int max = this._tabbedPane.getTabCount();
        for (int i = 0; i < max; ++i) {
            ReflectedJPanel panel = (ReflectedJPanel)this._tabbedPane.getComponentAt(i);
            panel.setUserLogInterface(this.userLogInterface);
            this._tabbedPane.setBackgroundAt(i, Constants.BO_TAB_LEVEL_TWO_COLOR);
        }
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._tabbedPane, c);
    }
}

