/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import ro.atreides.facturi.gui.AddFacturaDialog;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.ModPreparare;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.gui.AdministrationDialog;
import ro.atreides.restaurant.gui.ModPreparareDialog;
import ro.atreides.restaurant.logic.PlataLaCazareFacturareInterface;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.ConsumTransferInterface;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.StockTransferItem;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.CancelException;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Order;
import ro.atreides.utils.PointerLaFunctieInterface;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Shift;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.TransferIntreMagaziiDialog;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tricky.TrickyInterface;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class GuiUtilsRest
extends LangRoAll {
    public static void doAdminLogin(TrickyInterface tricky) {
        try {
            AdministrationPanel adminPanel = UsersLogic.getInstance().getAdminPanel(tricky);
            if (adminPanel != null) {
                AdministrationDialog adminFrame = new AdministrationDialog(adminPanel);
                adminFrame.setVisible(true);
            }
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    public static void searaButtonPressed(JComponent panel, RestLogic logic, int whatToPrint, User user) {
        Vector<Shift> shifts = logic.getShifts();
        Shift lastShift = shifts.lastElement();
        String message = "Doriti sa inchideti ziua " + lastShift.getNr() + " deschisa la " + Formatters.DATE_AND_TIME_FORMAT.format(lastShift.getStart());
        boolean sure = DialogUtils.confirmDialog(panel, message, LangRoAll.confirmare);
        if (sure) {
            boolean ordersOk = logic.checkSearaOrders();
            if (!ordersOk) {
                DialogUtils.okFocusEaterDialog("Va rog inchideti toate notele de plata", LangRoAll.nuPotContinua);
                return;
            }
            DialogUtils.okFocusEaterDialog("NU inchideti programul inainte de \"Ziua a fost inchisa.\" !! Apasati OK pentru a continua", "ATENTIE");
            boolean result = logic.seara(whatToPrint, lastShift, user, panel);
            if (result) {
                DialogUtils.okFocusEaterDialog("Ziua a fost inchisa.", LangRoAll.operatieExecutata);
                if (VpConfig.getInstance().piratMode && VpConfig.getInstance().trickySeara) {
                    if (DialogUtils.confirmDialog(panel, "Raport tiparit corect", LangRoAll.confirmare)) {
                        boolean ok = logic.deleteNFOrders();
                        if (ok) {
                            DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                        } else {
                            DialogUtils.errorDialog(panel, "Eroare. Contactati suport tehnic", "Operatie neefectuata");
                        }
                    } else {
                        DialogUtils.errorDialog(panel, "Verificati rapoartele", LangRoAll.atentie);
                    }
                }
            } else {
                DialogUtils.okFocusEaterDialog("Erori la inchiderea zilei. Contactati suport tehnic", LangRoAll.operatieEsuata);
            }
        }
    }

    public static Color getTableBgColor(int id) {
        int maxColors = 6;
        if (id == -1) {
            return Color.WHITE;
        }
        int offset = id % maxColors;
        switch (offset) {
            case 0: {
                return Color.YELLOW;
            }
            case 1: {
                return Color.CYAN;
            }
            case 2: {
                return Color.GREEN;
            }
            case 3: {
                return Color.ORANGE;
            }
            case 4: {
                return Color.PINK;
            }
            case 5: {
                return Color.LIGHT_GRAY;
            }
        }
        return Color.WHITE;
    }

    public static String chooseModPreparare(int idProduct, String numeProdus, String moduriPreparareAlese) {
        Hashtable<String, String> attributes = NomeclaturaLogic.getInstance().getProductAtrributesAsHash(idProduct);
        String val = attributes.get(LangRoAll.modPreparareKey);
        String method = attributes.get(LangRoAll.regulaPreparareKey);
        Vector moduriPtProdus = new Vector();
        int buttonsPerLine = 4;
        if (Validators.correctString(val) && Validators.correctString(method)) {
            moduriPtProdus = Utils.splitString(val, ',');
            if (method.equalsIgnoreCase(LangRoAll.regulaPreparareValueAdd)) {
                Vector<String> aleseCuPrefix = Utils.splitString(moduriPreparareAlese, ',');
                int sizePrefix = LangRoAll.regulaPreparareValueAddPrefix.length();
                Vector<String> faraPrefix = GuiUtilsRest.stripPrefixes(aleseCuPrefix, sizePrefix);
                GuiUtilsRest.buildModPrepararePopupAdaugare(numeProdus, moduriPtProdus, faraPrefix, new ModPreparareOperatie(){

                    @Override
                    public void select(JButton btn, boolean selected) {
                        GuiUtilsRest.buttonSelectedAdaugare(btn, selected);
                    }

                    @Override
                    public String getOperationTitle() {
                        return "CU ...";
                    }
                }, buttonsPerLine);
                aleseCuPrefix = GuiUtilsRest.addPrefixes(faraPrefix, LangRoAll.regulaPreparareValueAddPrefix);
                return Utils.pasteString(aleseCuPrefix, ',');
            }
            if (method.equalsIgnoreCase(LangRoAll.regulaPreparareValueExclude)) {
                Vector<String> aleseCuPrefix = Utils.splitString(moduriPreparareAlese, ',');
                int sizePrefix = LangRoAll.regulaPreparareValueExcludePrefix.length();
                Vector<String> faraPrefix = GuiUtilsRest.stripPrefixes(aleseCuPrefix, sizePrefix);
                GuiUtilsRest.buildModPrepararePopupAdaugare(numeProdus, moduriPtProdus, faraPrefix, new ModPreparareOperatie(){

                    @Override
                    public void select(JButton btn, boolean selected) {
                        GuiUtilsRest.buttonSelectedExcludere(btn, selected);
                    }

                    @Override
                    public String getOperationTitle() {
                        return "FARA ...";
                    }
                }, buttonsPerLine);
                aleseCuPrefix = GuiUtilsRest.addPrefixes(faraPrefix, LangRoAll.regulaPreparareValueExcludePrefix);
                return Utils.pasteString(aleseCuPrefix, ',');
            }
        } else {
            Vector moduriPrepararePosibile = RestLogic.getInstance().getModuriPreparare();
            for (ModPreparare modPreparare : moduriPrepararePosibile) {
                moduriPtProdus.add(modPreparare.getModPreparare());
            }
            if (moduriPrepararePosibile.size() > 0) {
                ModPreparareDialog mpd = new ModPreparareDialog(buttonsPerLine, moduriPrepararePosibile, numeProdus);
                String newMpd = mpd.getModPreparare();
                if (!Validators.correctString(newMpd)) {
                    return "";
                }
                if (!Validators.correctString(moduriPreparareAlese)) {
                    return newMpd;
                }
                return moduriPreparareAlese + "," + newMpd;
            }
        }
        return "";
    }

    public static void addPiratGuiMouseListenerForReports(final JTabbedPane _tabbedPane) {
        final Vector neededKeys = new Vector();
        GuiUtilsRest.fillInNeededKeys(neededKeys);
        MouseListener listener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (neededKeys.size() == 0) {
                    int index = _tabbedPane.getSelectedIndex();
                    ReflectedJPanel report = (ReflectedJPanel)_tabbedPane.getComponentAt(index);
                    report.switchMode();
                    report.updateForeground(_tabbedPane, index);
                    _tabbedPane.getParent().requestFocus();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        GuiUtilsRest.addPiratGuiMouseListener(_tabbedPane, listener, neededKeys);
    }

    public static void addPiratGuiMouseListenerForLabels(final Component component, final PointerLaFunctieInterface pointerLaFunctie) {
        final Vector neededKeys = new Vector();
        GuiUtilsRest.fillInNeededKeys(neededKeys);
        MouseListener listener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (neededKeys.size() == 0) {
                    pointerLaFunctie.doStuff();
                } else {
                    component.requestFocus();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        GuiUtilsRest.addPiratGuiMouseListener(component, listener, neededKeys);
    }

    private static void addPiratGuiMouseListener(Component component, MouseListener listener, final Vector neededKeys) {
        component.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                Character c = new Character(e.getKeyChar());
                if (neededKeys.contains(c)) {
                    neededKeys.remove(c);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        component.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GuiUtilsRest.fillInNeededKeys(neededKeys);
            }
        });
        if (Config.getInstance().getBoolean("piratMode")) {
            component.addMouseListener(listener);
        }
    }

    private static void fillInNeededKeys(Vector neededKeys) {
        String chars = Config.getInstance().getString("piratModeCharsForClick");
        for (int i = 0; i < chars.length(); ++i) {
            Character c = new Character(chars.charAt(i));
            neededKeys.add(c);
        }
    }

    public static void switchToWindowMode(boolean backOffice) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        JFrame frame = new JFrame(gc);
        frame.setContentPane(GuiUtils.currentFrame.getContentPane());
        frame.validate();
        gs.setFullScreenWindow(null);
        frame.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        d.setSize(d.getWidth(), d.getHeight() - 30.0);
        frame.setExtendedState(2);
        frame.setSize(d);
        boolean ignoreCloseButton = false;
        if (!backOffice) {
            ignoreCloseButton = Config.getInstance().getBoolean("ignoreCloseButton");
        }
        frame.setTitle(GuiUtils.appTitle + "      build " + GuiUtils.currentVersion + " - " + GuiUtils.clientName);
        int closeStatus = ignoreCloseButton ? 0 : 3;
        frame.setDefaultCloseOperation(closeStatus);
        frame.setVisible(true);
        GuiUtils.currentFrame.dispose();
        GuiUtils.currentFrame = frame;
        GuiUtils.isFullScreen = false;
    }

    public static void switchToWindowMode() {
        GuiUtilsRest.switchToWindowMode(false);
    }

    public static void switchToFullScreen() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        JFrame frame = new JFrame(gc);
        frame.setContentPane(GuiUtils.currentFrame.getContentPane());
        frame.validate();
        frame.setUndecorated(true);
        gs.setFullScreenWindow(frame);
        GuiUtils.currentFrame.dispose();
        GuiUtils.currentFrame = frame;
        GuiUtils.isFullScreen = true;
    }

    private static Vector<String> stripPrefixes(Vector<String> aleseCuPrefix, int sizePrefix) {
        Vector<String> aleseFaraPrefix = new Vector<String>();
        for (String cuprefix : aleseCuPrefix) {
            String faraPrefix = cuprefix.substring(sizePrefix + 1);
            aleseFaraPrefix.add(faraPrefix);
        }
        return aleseFaraPrefix;
    }

    private static Vector<String> addPrefixes(Vector<String> faraPrefix, String prefix) {
        Vector<String> result = new Vector<String>();
        for (String s : faraPrefix) {
            result.add(prefix + " " + s);
        }
        return result;
    }

    private static void buildModPrepararePopupAdaugare(String numeProdus, Vector<String> moduri, final Vector<String> dejaAlese, final ModPreparareOperatie oper, int buttonsPerLine) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        for (final String mod : moduri) {
            final JButton btn = new JButton(mod);
            oper.select(btn, dejaAlese.contains(mod));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (dejaAlese.contains(mod)) {
                        dejaAlese.remove(mod);
                    } else {
                        dejaAlese.add(mod);
                    }
                    oper.select(btn, dejaAlese.contains(mod));
                }
            });
            panel.add((Component)btn, c);
            ++c.gridx;
            if (c.gridx != buttonsPerLine) continue;
            c.gridx = 0;
            ++c.gridy;
        }
        JDialog dia = DialogUtils.getJDialogOKButton(panel, GuiUtils.currentFrame, "Mod preparare " + numeProdus + " - " + oper.getOperationTitle(), 2.0);
        dia.setVisible(true);
    }

    private static void buttonSelectedAdaugare(JButton btn, boolean selected) {
        Font bonItemFont = null;
        if (selected) {
            btn.setForeground(Color.BLUE);
            bonItemFont = new Font(null, 1, VpConfig.getInstance().touchKeypadFontSize + 6);
        } else {
            btn.setForeground(Color.BLACK);
            bonItemFont = new Font(null, 0, VpConfig.getInstance().touchKeypadFontSize + 6);
        }
        btn.setFont(bonItemFont);
    }

    private static void buttonSelectedExcludere(JButton btn, boolean selected) {
        Font bonItemFont = null;
        if (!selected) {
            btn.setForeground(Color.BLUE);
            bonItemFont = new Font(null, 1, VpConfig.getInstance().touchKeypadFontSize + 6);
        } else {
            btn.setForeground(Color.BLACK);
            Font font = new Font(null, 0, VpConfig.getInstance().touchKeypadFontSize + 6);
            Map<TextAttribute, ?> attributes = font.getAttributes();
            attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            bonItemFont = new Font(attributes);
        }
        btn.setFont(bonItemFont);
    }

    public static boolean bonTransfer(Component panel, boolean restituire, int tipPret, Vector<Sale> sales, double totalF, User user) {
        TransferIntreMagaziiDialog itemChooserDialog = new TransferIntreMagaziiDialog(StockLogic.getInstance().getMagazii());
        Magazie destinatie = itemChooserDialog.getDestinatie();
        Magazie sursa = itemChooserDialog.getSursa();
        if (destinatie == null && sursa == null) {
            return false;
        }
        Vector<ConsumTransferInterface> toTransfer = new Vector<ConsumTransferInterface>();
        for (Sale sale : sales) {
            StockTransferItem bci = new StockTransferItem();
            bci.setQuantity(sale.getCantitateMarcata());
            bci.setDenumire(sale.getProductName());
            int idProduct = sale.getIdProduct();
            int idStock = RestLogic.getInstance().getIdStock(idProduct);
            if (idStock <= 0) continue;
            bci.setIdStock(idStock);
            double pretIesire = StockLogic.getInstance().getCatalogPriceForStock(idStock);
            if (pretIesire < 0.0) {
                pretIesire = 0.0;
            }
            bci.setSellPrice(pretIesire);
            bci.setBuyPrice(0.0);
            String imgSrc = RestLogic.getInstance().getImgSrcFromSalesPictures(sale.getFirstIdSale());
            if (imgSrc != null) {
                bci.setImg(imgSrc);
            }
            toTransfer.add(bci);
        }
        if (sursa == null) {
            DialogUtils.errorDialog(panel, "Magazia " + sursa.getLabel() + " nu exista", LangRoAll.nuPotContinua);
            return false;
        }
        return StockLogic.getInstance().addAndPrintTransfer(panel, new Date(), restituire ? destinatie : sursa, restituire ? sursa : destinatie, toTransfer, totalF, tipPret, user);
    }

    public static void facturareDinComanda(Order order, User waiter, Component parent, int clientIndex) {
        String coduri;
        VpConfig config = VpConfig.getInstance();
        Hashtable<String, Integer> h = new Hashtable<String, Integer>();
        h.put("id_order_key", order.getId());
        final Vector<NoteView> newData = RestLogic.getInstance().getNote(h, true, 1);
        User emitent = waiter;
        if (config.touch2FacturaRequestEmitent) {
            emitent = UsersLogic.getInstance().requestWaiterLogin(GuiUtils.currentFrame, true, true);
        }
        if (Validators.correctString(coduri = config.facturareProdusGeneric) && DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.adaugamProdusulGeneric, new String[0]), LangRoAll.confirmare)) {
            newData.clear();
            boolean buildProduseOk = RestLogic.getInstance().buildProdusePlataLaCazare(order, parent, new PlataLaCazareFacturareInterface(){

                @Override
                public void addSale(Product p, double total) {
                    NoteView nv = new NoteView();
                    nv.setCantitate(1.0);
                    nv.setProdus(p.getName());
                    nv.setIdProdus(p.getId());
                    nv.setSuma(total);
                    nv.setIdOrder(-1);
                    newData.add(nv);
                }
            }, coduri, clientIndex);
            if (!buildProduseOk) {
                return;
            }
        }
        if (emitent != null) {
            new AddFacturaDialog(true, parent, newData, order.getIdClient(), emitent);
        }
    }

    public static JFrame switchToFullScreen(JFrame currentFrame) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        JFrame frame = new JFrame(gc);
        frame.setContentPane(currentFrame.getContentPane());
        frame.validate();
        frame.setUndecorated(true);
        frame.setDefaultCloseOperation(0);
        frame.setExtendedState(6);
        gs.setFullScreenWindow(frame);
        currentFrame.dispose();
        frame.setVisible(true);
        return frame;
    }

    public static void setCodFiscalToOrder(Component panel, Order order) {
        String cui = DialogUtils.inputDialog(panel, order.getCodFiscal(), Utils.getTranslation(LangRoAll.introducetiCodulFiscal, new String[0]));
        if (Validators.correctString(cui)) {
            String formattedReqObj = cui.replaceAll("[^0-9]", "");
            boolean platitorTva = DialogUtils.confirmDialog(GuiUtils.currentFrame, "Clientul este platitor de tva?", LangRoAll.confirmare);
            if (platitorTva) {
                formattedReqObj = "RO" + formattedReqObj;
            }
            order.setCodFiscal(formattedReqObj);
            RestLogic.getInstance().setCodFiscalToOrder(order.getId(), formattedReqObj);
        } else {
            DialogUtils.errorDialog(panel, "Introduceti un cui valid!", LangRoAll.eroare);
        }
    }

    static interface ModPreparareOperatie {
        public void select(JButton var1, boolean var2);

        public String getOperationTitle();
    }
}

