/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Location;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class LocationsPanel
extends AbstractListPanel {
    @Override
    public String[] buildColumns() {
        return new String[]{LangRoAll.locatie};
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public Vector buildData() {
        return RestLogic.getInstance().getLocations();
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Location mp = (Location)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return mp.getName();
                    }
                }
                return null;
            }
        });
        return tm;
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel(LangRoAll.locatie), c);
        ++c.gridx;
        final JTextField mpText = new JTextField(10);
        result.add((Component)mpText, c);
        final LocationsPanel parent = this;
        ++c.gridx;
        JButton adaugare = new JButton(LangRoAll.adauga);
        adaugare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String toAdd = mpText.getText();
                if (Validators.correctString(toAdd)) {
                    RestLogic.getInstance().addLocation(toAdd, 1, toAdd);
                    LocationsPanel.this.refreshTable();
                    mpText.setText("");
                    mpText.requestFocus();
                } else {
                    DialogUtils.errorDialog(parent, LangRoAll.completatiNumelelocatiei, LangRoAll.nuPotContinua);
                    mpText.requestFocus();
                }
            }
        });
        result.add((Component)adaugare, c);
        result.setBorder(new TitledBorder(Utils.getTranslation(LangRoAll.actiuni)));
        return result;
    }

    @Override
    public void doStuff() {
        this.display();
    }
}

