/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JTabbedPane;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.nomenclatura.gui.CategoriesPanel;
import ro.atreides.nomenclatura.gui.SectiiPanel;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.ModPreparare;
import ro.atreides.restaurant.base.OrdineServire;
import ro.atreides.restaurant.gui.ModPrepararePanel;
import ro.atreides.restaurant.gui.OrdineServirePanel;
import ro.atreides.restaurant.gui.SectiiMagaziiPanel;
import ro.atreides.restaurant.gui.admin.prices.PricesReport;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.gui.MagaziiPanel;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Unit;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataPanel;
import ro.atreides.utils.tags.Tag;
import ro.atreides.utils.tags.TagsLogic;
import ro.atreides.utils.tags.gui.TagsPanel;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaPanel;
import ro.atreides.utils.units.UnitsLogic;
import ro.atreides.utils.units.gui.UnitsPanel;
import ro.atreides.utils.valute.ValutePanel;

public class ModificationsPanel
extends ReflectedJPanel
implements CleanupRequired {
    private JTabbedPane _tabbedPane = null;
    private SectiiPanel sectiiPanel;
    private CategoriesPanel subcategoriesPanel = null;
    private SectiiMagaziiPanel sectiiMagazii;
    private MagaziiPanel magaziiPanel;
    private TipPlataPanel tipPlataPanel;
    private TvaPanel tvaPanel;
    private UnitsPanel unitsPanel;
    private ValutePanel valutePanel;
    private TagsPanel tagsPanel;

    @Override
    public void doStuff() {
        this.init();
        this.display();
    }

    @Override
    public void cleanup() {
        this.subcategoriesPanel.cleanup();
    }

    private void init() {
        this._tabbedPane = new JTabbedPane();
        PricesReport pricesReport = new PricesReport();
        pricesReport.doStuff();
        this._tabbedPane.add("Preturi", pricesReport);
        this.subcategoriesPanel = new CategoriesPanel(true, false, true, true);
        this.subcategoriesPanel.doStuff();
        this._tabbedPane.add("Categorii", this.subcategoriesPanel);
        this.sectiiPanel = new SectiiPanel(true);
        this.sectiiPanel.doStuff();
        this._tabbedPane.add("Sectii", this.sectiiPanel);
        this.magaziiPanel = new MagaziiPanel();
        this.magaziiPanel.doStuff();
        this._tabbedPane.add("Magazii", this.magaziiPanel);
        this.sectiiMagazii = new SectiiMagaziiPanel();
        this.sectiiMagazii.doStuff();
        this._tabbedPane.add("Sectii - Magazii", this.sectiiMagazii);
        final ModPrepararePanel mp = new ModPrepararePanel();
        mp.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                RestLogic.getInstance().deleteModPreparare((ModPreparare)o);
                mp.refreshTable();
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        mp.doStuff();
        this._tabbedPane.add("Mod preparare", mp);
        final OrdineServirePanel op = new OrdineServirePanel();
        op.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                RestLogic.getInstance().deleteOrdineServire((OrdineServire)o);
                op.refreshTable();
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        op.doStuff();
        if (VpConfig.getInstance().showServireFields) {
            this._tabbedPane.add("Ordine servire", op);
        }
        this.tipPlataPanel = new TipPlataPanel();
        this.tipPlataPanel.setPromoInterface(PromotionLogic.getInstance());
        this.tipPlataPanel.setConturiInterface(ClientLogic.getInstance());
        this.tipPlataPanel.doStuff();
        this.tipPlataPanel.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                TipPlata tip = (TipPlata)o;
                ModificationsPanel.this.tipPlataPanel.setTipPlata(tip);
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        this._tabbedPane.add("Tipuri de plata", this.tipPlataPanel);
        this.tvaPanel = new TvaPanel();
        this.tvaPanel.doStuff();
        this.tvaPanel.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                Tva tva = (Tva)o;
                ModificationsPanel.this.tvaPanel.setTvaToEdit(tva);
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        this._tabbedPane.add(LangRoAll.tva, this.tvaPanel);
        this.unitsPanel = new UnitsPanel();
        this.unitsPanel.doStuff();
        this.unitsPanel.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                if (DialogUtils.confirmDialog(GuiUtils.currentFrame, LangRoAll.unitateMasuraStergem, LangRoAll.confirmare)) {
                    UnitsLogic.getInstance().deleteUnit((Unit)o);
                    ModificationsPanel.this.unitsPanel.refreshTable();
                }
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        this._tabbedPane.add(LangRoAll.unitati, this.unitsPanel);
        this.valutePanel = new ValutePanel();
        this.valutePanel.doStuff();
        this._tabbedPane.add("Valute", this.valutePanel);
        this.tagsPanel = new TagsPanel();
        this.tagsPanel.doStuff();
        this.tagsPanel.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                if (DialogUtils.confirmDialog(GuiUtils.currentFrame, LangRoAll.tagStergem, LangRoAll.confirmare)) {
                    TagsLogic.getInstance().deleteTag((Tag)o);
                    ModificationsPanel.this.tagsPanel.refreshTable();
                    StockLogic.getInstance().notifyListeners(Constants.TAGS_CHANGED);
                }
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        this._tabbedPane.add("Taguri", this.tagsPanel);
        int max = this._tabbedPane.getTabCount();
        for (int i = 0; i < max; ++i) {
            ReflectedJPanel panel = (ReflectedJPanel)this._tabbedPane.getComponentAt(i);
            panel.setUserLogInterface(this.userLogInterface);
            this._tabbedPane.setBackgroundAt(i, Constants.BO_TAB_LEVEL_TWO_COLOR);
        }
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._tabbedPane, c);
    }
}

