/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.EditTablesModel;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Location;
import ro.atreides.utils.Order;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class TablesNoPanel
extends ReflectedJPanel
implements CleanupRequired {
    private RestLogic logic = RestLogic.getInstance();
    private Vector tables;
    private JTable tabel;
    private EditTablesModel model;
    private JButton addButton;
    private JButton stergeButton;
    private JLabel locatieLabel;
    private JLabel numeLabel;
    private JComboBox locatii;
    private JTextField numeTF;
    private Table selected;

    public TablesNoPanel() {
        this.setData();
        this.init();
        this.display();
    }

    @Override
    public void doStuff() {
        RestLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(TablesNoPanel.this.locatii, (Collection)TablesNoPanel.this.logic.getLocations(), false);
            }

            @Override
            public String getName() {
                return "TablesNoPanel_locatii";
            }
        }, 54);
    }

    private void refresh() {
        this.model.setData(this.tables);
    }

    private void setData() {
        this.tables = new Vector<Table>(this.logic.getTables());
    }

    private void init() {
        this.model = new EditTablesModel(this.tables);
        this.tabel = new JTable(this.model);
        this.tabel.setSelectionMode(0);
        this.tabel.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = TablesNoPanel.this.tabel.rowAtPoint(e.getPoint());
                if (selRow != -1) {
                    Table t = (Table)TablesNoPanel.this.tables.elementAt(selRow);
                    TablesNoPanel.this.numeTF.setText(t.getLabel());
                    TablesNoPanel.this.numeTF.selectAll();
                    Location l = TablesNoPanel.this.logic.getLocationById(t.getIdLocatie());
                    TablesNoPanel.this.locatii.setSelectedItem(l);
                    TablesNoPanel.this.selected = t;
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        String save = LangRoAll.adauga;
        String erase = LangRoAll.sterge;
        this.addButton = new JButton(save);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String nume = TablesNoPanel.this.numeTF.getText();
                Location l = (Location)TablesNoPanel.this.locatii.getSelectedItem();
                if (nume == null || nume.length() == 0) {
                    return;
                }
                TablesNoPanel.this.logic.newTable(nume, 4, false, "", l.getId());
                TablesNoPanel.this.setData();
                TablesNoPanel.this.refresh();
            }
        });
        this.stergeButton = new JButton(erase);
        final TablesNoPanel panel = this;
        this.stergeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Order o = TablesNoPanel.this.logic.getOpenOrderAtTable(TablesNoPanel.this.selected);
                if (o != null) {
                    DialogUtils.errorDialog(panel, "Inchideti bonurile deschise la aceasta comanda", LangRoAll.nuPotContinua);
                    return;
                }
                TablesNoPanel.this.logic.deleteTable(TablesNoPanel.this.selected);
                TablesNoPanel.this.setData();
                TablesNoPanel.this.refresh();
            }
        });
        this.locatieLabel = new JLabel(LangRoAll.locatie);
        this.numeLabel = new JLabel("Nume comanda");
        this.numeTF = new JTextField(10);
        this.locatii = new JComboBox();
        ComboUtils.replaceItemsForCombo(this.locatii, (Collection)this.logic.getLocations(), false);
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(20, 5, 10, 5);
        JPanel titlePanel = this.getTitlePanel("Adauga / modifica / sterge comenzi");
        this.add((Component)titlePanel, c);
        c.gridy = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JPanel buttonsPanel = this.getButtonsPanel();
        buttonsPanel.setBorder(new TitledBorder("Modifica comanda"));
        this.add((Component)buttonsPanel, c);
        c.gridy = 2;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        JPanel tablePanel = this.getTablePanel();
        tablePanel.setBorder(new TitledBorder("Vizualizare comenzi"));
        this.add((Component)tablePanel, c);
    }

    private JPanel getTitlePanel(String title) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(title), c);
        return p;
    }

    private JPanel getTablePanel() {
        JPanel tablePanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.insets = new Insets(5, 5, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        tablePanel.add((Component)new JScrollPane(this.tabel), c);
        return tablePanel;
    }

    private JPanel getButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        buttonsPanel.add((Component)this.numeLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 11;
        buttonsPanel.add((Component)this.numeTF, c);
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 12;
        buttonsPanel.add((Component)this.addButton, c);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        buttonsPanel.add((Component)this.locatieLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 10;
        buttonsPanel.add((Component)this.locatii, c);
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 13;
        buttonsPanel.add((Component)this.stergeButton, c);
        return buttonsPanel;
    }

    @Override
    public void cleanup() {
        this.model.setData(new Vector());
    }
}

