/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.CenteredJDialog;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class TransferDialog
extends CenteredJDialog {
    private RestLogic logic;
    private Table source;
    private Table dest;
    private Hashtable salesHash = new Hashtable();
    private Hashtable tmHash = new Hashtable();
    private JTable leftTable;
    private JTable rightTable;

    public TransferDialog(RestLogic logic, Table source, Table dest) {
        super("Transfer " + source + " -> " + dest);
        this.logic = logic;
        this.source = source;
        this.dest = dest;
        this.display();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        this.leftTable = this.getTableWithButtons(this.source, this.dest);
        JScrollPane scroll = new JScrollPane(this.leftTable);
        this.add((Component)scroll, c);
        ++c.gridx;
        this.rightTable = this.getTableWithButtons(this.dest, this.source);
        JScrollPane scroll2 = new JScrollPane(this.rightTable);
        this.add((Component)scroll2, c);
        ++c.gridy;
        c.gridx = 0;
        JButton allToRight = new JButton(">>");
        allToRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector data = (Vector)TransferDialog.this.salesHash.get(TransferDialog.this.leftTable);
                for (int i = 0; i < data.size(); ++i) {
                    Sale o = (Sale)data.elementAt(i);
                    TransferDialog.this.logic.transferaComanda(TransferDialog.this.source, TransferDialog.this.dest, o, o.getCantitateMarcata());
                }
                TransferDialog.this.refresh();
            }
        });
        this.add((Component)allToRight, c);
        ++c.gridx;
        JButton allToLeft = new JButton("<<");
        allToLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector data = (Vector)TransferDialog.this.salesHash.get(TransferDialog.this.rightTable);
                for (int i = 0; i < data.size(); ++i) {
                    Sale o = (Sale)data.elementAt(i);
                    TransferDialog.this.logic.transferaComanda(TransferDialog.this.dest, TransferDialog.this.source, o, o.getCantitateMarcata());
                }
                TransferDialog.this.refresh();
            }
        });
        this.add((Component)allToLeft, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TransferDialog.this.dispose();
            }
        });
        ok.setForeground(Color.RED);
        this.add((Component)ok, c);
        this.refresh();
        this.pack();
        this.center(2.0, 2.0);
        this.setVisible(true);
    }

    private JTable getTableWithButtons(final Table sourceTable, final Table destTable) {
        AbstractTM sourceTm = new AbstractTM(new String[]{LangRoAll.produs, LangRoAll.cantitate}, new Class[]{String.class, String.class}, new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Sale o = (Sale)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        String s = o.getProductName();
                        String mp = o.getModPreparare();
                        if (Validators.correctString(mp)) {
                            s = s + " (" + mp + ")";
                        }
                        return s;
                    }
                    case 1: {
                        return o.getQuantity();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        final JTable table = new JTable(sourceTm);
        this.tmHash.put(table, sourceTm);
        table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                int selRow = source.rowAtPoint(e.getPoint());
                Vector data = (Vector)TransferDialog.this.salesHash.get(table);
                if (selRow != -1) {
                    Sale o = (Sale)data.elementAt(selRow);
                    double quantity = 0.0;
                    boolean mustAct = false;
                    int modifiers = e.getModifiers();
                    if ((modifiers & 4) > 0 || (modifiers & 8) > 0) {
                        String value = DialogUtils.inputDialog(GuiUtils.currentFrame, Utils.getString3Decimals(o.getCantitateMarcata()), "Cantitatea");
                        if (Validators.correctDouble(value)) {
                            quantity = Utils.parseDouble(value);
                            mustAct = true;
                        }
                    } else {
                        quantity = Math.min(1.0, o.getCantitateMarcata());
                        mustAct = true;
                    }
                    if (mustAct) {
                        TransferDialog.this.logic.transferaComanda(sourceTable, destTable, o, quantity);
                        TransferDialog.this.refresh();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        GuiUtils.updateJTableRowSize(table, VpConfig.getInstance().touchTableFontSize);
        return table;
    }

    private void refresh() {
        Order order = this.logic.getOpenOrderAtTable(this.source);
        Vector<Sale> sales = this.logic.getSales(order.getId(), false, -1, new ScreenSaleInterface());
        this.salesHash.put(this.leftTable, sales);
        AbstractTM left = (AbstractTM)this.tmHash.get(this.leftTable);
        left.refresh(sales);
        order = this.logic.getOpenOrderAtTable(this.dest);
        sales = this.logic.getSales(order.getId(), false, -1, new ScreenSaleInterface());
        this.salesHash.put(this.rightTable, sales);
        AbstractTM right = (AbstractTM)this.tmHash.get(this.rightTable);
        right.refresh(sales);
    }
}

