/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.admin.multiserver;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import ro.atreides.restaurant.gui.admin.multiserver.MultiServerBean;
import ro.atreides.restaurant.gui.admin.multiserver.MultiServerLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class MultiServerPanel
extends AbstractListPanel
implements CleanupRequired {
    @Override
    public String[] buildColumns() {
        return new String[]{LangRoAll.denumire + ": IP:port", "Val tura curenta", "Val totala", "Ultima inchidere", "Note deschise: numar/valoare", "Nr linii actiuni"};
    }

    @Override
    public Vector buildData() {
        return MultiServerLogic.getInstance().getInitialData();
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        JButton refresh = new JButton("Refresh");
        refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiServerPanel.this.refresh();
            }
        });
        result.add((Component)refresh, c);
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        return new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                MultiServerBean m = (MultiServerBean)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return m.getServerDetails();
                    }
                    case 1: {
                        return Utils.getString2Decimals(m.getValTura());
                    }
                    case 2: {
                        return Utils.getString2Decimals(m.getValTotala());
                    }
                    case 3: {
                        return m.getUltimaInchidere();
                    }
                    case 4: {
                        return m.getNoteDeschise() + " / " + Utils.getString2Decimals(m.getValNoteDeschise());
                    }
                    case 5: {
                        return m.getNrLiniiUserLog();
                    }
                }
                return null;
            }
        });
    }

    private void refreshLine(final int j, MultiServerBean bean) {
        MultiServerAsyncRefresh inter = new MultiServerAsyncRefresh(){

            @Override
            public void refresh(MultiServerBean newdata) {
                MultiServerPanel.this.updateOneLine(j, newdata);
            }
        };
        MultiServerLogic.getInstance().asyncRefresh(inter, bean);
    }

    private void refresh() {
        Vector data = this.tm.getData();
        for (int i = 0; i < data.size(); ++i) {
            this.refreshLine(i, (MultiServerBean)data.get(i));
        }
    }

    private void updateOneLine(int line, MultiServerBean newData) {
        this.tm.setObjectAt(line, newData);
        this.tm.fireTableRowsUpdated(line, line);
    }

    @Override
    public void doStuff() {
        this.display();
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                final int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final MultiServerBean nv = (MultiServerBean)MultiServerPanel.this.tm.getObjectAt(selRow);
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) <= 0) {
                    final JPopupMenu popup = new JPopupMenu();
                    JMenuItem closeDay = new JMenuItem(LangRoAll.seara);
                    popup.add(closeDay);
                    JMenuItem closeOpenOrders = new JMenuItem("Inchide comenzi deschise");
                    popup.add(closeOpenOrders);
                    popup.setInvoker(MultiServerPanel.this.table);
                    closeDay.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MultiServerLogic.getInstance().closeDay(nv);
                            popup.setVisible(false);
                            MultiServerPanel.this.refreshLine(selRow, nv);
                        }
                    });
                    closeOpenOrders.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MultiServerLogic.getInstance().closeOpenOrders(nv);
                            popup.setVisible(false);
                            MultiServerPanel.this.refreshLine(selRow, nv);
                        }
                    });
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.refresh();
    }

    @Override
    public void cleanup() {
    }

    public static interface MultiServerAsyncRefresh {
        public void refresh(MultiServerBean var1);
    }
}

