/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.admin.prices;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.restaurant.gui.admin.prices.PricePanelEntry;
import ro.atreides.restaurant.logic.PrintEticheteInterface;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class PricesPanel
extends ReflectedJPanel {
    private JLabel _oldPriceLabel = null;
    private JTextField _oldPriceField = null;
    private JLabel _newPriceLabel = null;
    private JTextField _newPriceField = null;
    private JButton _modifyButton = null;
    private AbstractTM _pricesTableModel = null;
    private JTable _pricesTable = null;
    private RestLogic logic = RestLogic.getInstance();
    private EventListener productsListener = new EventListener(){

        @Override
        public void dataChanged() {
            PricesPanel.this._pricesTableModel.refresh(PricesPanel.this.logic.getPricesPanelEntries());
        }

        @Override
        public String getName() {
            return LangRoAll.preturi;
        }
    };
    private boolean fiscal = true;

    @Override
    public void doStuff() {
    }

    public PricesPanel() {
        this.logic.addListener(this.productsListener, 2);
        this.init();
        this.display();
    }

    public void cleanup() {
        this.logic.removeListener(this.productsListener);
        this._pricesTableModel.refresh(new Vector());
    }

    private void init() {
        this._oldPriceLabel = new JLabel(LangRoAll.vechiulPret);
        this._oldPriceField = new JTextField(7);
        this._oldPriceField.setForeground(Color.BLACK);
        this._oldPriceField.setEditable(false);
        this._newPriceLabel = new JLabel(LangRoAll.nouPret);
        this._newPriceField = new JTextField(7);
        String[] _columnNames = new String[]{LangRoAll.categorie, LangRoAll.denumire, LangRoAll.pret};
        Class[] _columnTypes = new Class[]{String.class, String.class, String.class, Boolean.class};
        this._pricesTableModel = new AbstractTM(_columnNames, _columnTypes, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                Boolean b = (Boolean)aValue;
                PricePanelEntry pe = (PricePanelEntry)data.elementAt(rowIndex);
                pe.setMustPrint(b);
                NomeclaturaLogic.getInstance().updateToPrint(pe.isMustPrint(), pe.getIdProduct());
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 3;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                PricePanelEntry pe = (PricePanelEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return pe.getCategory();
                    }
                    case 1: {
                        return pe.getProduct();
                    }
                    case 2: {
                        return Utils.getString2Decimals(pe.getPret());
                    }
                    case 3: {
                        return pe.isMustPrint();
                    }
                }
                return null;
            }
        });
        this._pricesTable = new JTable(this._pricesTableModel);
        this._pricesTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = PricesPanel.this._pricesTable.rowAtPoint(e.getPoint());
                if (selRow != -1) {
                    PricePanelEntry re = (PricePanelEntry)PricesPanel.this._pricesTableModel.getObjectAt(selRow);
                    PricesPanel.this._oldPriceField.setText(Utils.getString2Decimals(re.getPret()));
                    PricesPanel.this._newPriceField.requestFocus();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this._modifyButton = new JButton(LangRoAll.modificaPret);
        this._modifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String newPriceText = PricesPanel.this._newPriceField.getText();
                if (newPriceText == null || newPriceText.length() <= 0 || PricesPanel.this._pricesTable.getSelectedRowCount() == 0) {
                    return;
                }
                try {
                    double newPrice = Utils.parseDouble(newPriceText);
                    int selectedRow = PricesPanel.this._pricesTable.getSelectedRow();
                    PricePanelEntry re = (PricePanelEntry)PricesPanel.this._pricesTableModel.getObjectAt(selectedRow);
                    if (re.getIdReteta() > 0) {
                        PricesPanel.this.logic.setPriceForRetetaProduct(re.getIdReteta(), newPrice, true);
                    } else {
                        StockLogic.getInstance().modificaPret(re.getIdStock(), newPrice, true, DateUtils.getCurrentTimestamp());
                    }
                    NomeclaturaLogic.getInstance().updateToPrint(re.isMustPrint(), re.getIdProduct());
                    re.setPret(newPrice);
                    PricesPanel.this._pricesTableModel.fireTableRowsUpdated(selectedRow, selectedRow);
                    PricesPanel.this._oldPriceField.setText("");
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
                PricesPanel.this._newPriceField.setText("");
                PricesPanel.this._newPriceField.requestFocus();
            }
        });
        this._pricesTableModel.refresh(this.logic.getPricesPanelEntries());
    }

    private JPanel buildPricesPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 0, 2, 0);
        c.anchor = 17;
        JPanel pricesPanel = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        pricesPanel.add((Component)this._oldPriceLabel, c);
        ++c.gridx;
        pricesPanel.add((Component)this._oldPriceField, c);
        c.gridx = 0;
        ++c.gridy;
        pricesPanel.add((Component)this._newPriceLabel, c);
        ++c.gridx;
        pricesPanel.add((Component)this._newPriceField, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.anchor = 10;
        pricesPanel.add((Component)this._modifyButton, c);
        pricesPanel.setBorder(new TitledBorder(LangRoAll.modificaPret));
        return pricesPanel;
    }

    private JPanel buildEtichetePanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 0, 2, 0);
        c.anchor = 10;
        c.fill = 2;
        JPanel labelPanel = new JPanel(new GridBagLayout());
        final PricesPanel panel = this;
        c.gridx = 0;
        c.gridy = 0;
        JButton selectAll = new JButton(LangRoAll.selecteazaToate);
        selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!DialogUtils.confirmDialog(panel, LangRoAll.selectiaSeVaPierder, LangRoAll.confirmare)) {
                    return;
                }
                boolean print = true;
                Vector data = PricesPanel.this._pricesTableModel.getData();
                for (int i = 0; i < data.size(); ++i) {
                    PricePanelEntry pricePanelEntry = (PricePanelEntry)data.elementAt(i);
                    pricePanelEntry.setMustPrint(print);
                }
                NomeclaturaLogic.getInstance().updateToPrint(print, -1);
                PricesPanel.this._pricesTableModel.fireTableDataChanged();
            }
        });
        labelPanel.add((Component)selectAll, c);
        ++c.gridy;
        JButton deselectAll = new JButton(LangRoAll.stergeSelectia);
        deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!DialogUtils.confirmDialog(panel, LangRoAll.selectiaSeVaPierder, LangRoAll.confirmare)) {
                    return;
                }
                boolean print = false;
                Vector data = PricesPanel.this._pricesTableModel.getData();
                for (int i = 0; i < data.size(); ++i) {
                    PricePanelEntry pricePanelEntry = (PricePanelEntry)data.elementAt(i);
                    pricePanelEntry.setMustPrint(print);
                }
                NomeclaturaLogic.getInstance().updateToPrint(print, -1);
                PricesPanel.this._pricesTableModel.fireTableDataChanged();
            }
        });
        labelPanel.add((Component)deselectAll, c);
        ++c.gridy;
        JButton tiparesteEticheta = new JButton(LangRoAll.tiparesteEtichetele);
        tiparesteEticheta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String copiiS = DialogUtils.inputDialog(panel, "1", LangRoAll.numarCopii);
                if (Validators.correctInteger(copiiS)) {
                    final int copii = Integer.parseInt(copiiS);
                    PrintEticheteInterface interf = new PrintEticheteInterface(){

                        @Override
                        public int getCopyCount(PricePanelEntry currentItem) {
                            return copii;
                        }
                    };
                    String path = PricesPanel.this.logic.printEticheteRaftA4(PricesPanel.this._pricesTableModel.getData(), interf);
                    if (path != null) {
                        DialogUtils.okDialog(panel, LangRoAll.eticheteleAuFostSalvateLa + path, LangRoAll.succes);
                    }
                    PricesPanel.this._pricesTableModel.refresh(PricesPanel.this.logic.getPricesPanelEntries());
                }
            }
        });
        labelPanel.add((Component)tiparesteEticheta, c);
        labelPanel.setBorder(new TitledBorder(LangRoAll.tiparesteEtichetele));
        return labelPanel;
    }

    private void display() {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 2, 0, 0);
        c.anchor = 17;
        this.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 18;
        c.fill = 0;
        this.add((Component)this.buildPricesPanel(), c);
        ++c.gridy;
        this.add((Component)this.buildEtichetePanel(), c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 2;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        this.add((Component)new JScrollPane(this._pricesTable), c);
    }
}

