/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.admin.prices;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumnModel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.gui.admin.prices.PricePanelEntry;
import ro.atreides.restaurant.logic.PrintEticheteInterface;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.gui.StockModifiedInterface;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.licensing.LicenseManager;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class PricesReport
extends AbstractReportPanel
implements CleanupRequired,
StockModifiedInterface {
    private static final String[] _columnNames = new String[]{LangRoAll.denumire, LangRoAll.pret, "Adaos", "Ultimul pret acz", LangRoAll.print};
    private static final Class[] _columnTypes = new Class[]{String.class, Double.class, Double.class, String.class, Boolean.class};
    private JLabel selectedForPrint;
    private JComboBox _subCategoryComboBox;
    private JTextField codBareField;
    private JLabel _subcategoryLabel;
    private XComboBox produseCombo;
    private Hashtable printCriteria = new Hashtable();
    private boolean showAdaosFields = true;
    private DoubleClicked action;
    private ReportInterface pdfReportInterface;
    private ReportInterface asciiReportInterface;
    private FilterableComboBoxModel productsComboModel;
    private EventListener productsListener;
    private static Comparator product_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((PricePanelEntry)o1).getProduct();
            String c2 = ((PricePanelEntry)o2).getProduct();
            return c1.compareToIgnoreCase(c2);
        }
    };
    private static Comparator price_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            double c1 = ((PricePanelEntry)o1).getPret();
            double c2 = ((PricePanelEntry)o2).getPret();
            return (int)(c1 - c2);
        }
    };
    private static Comparator adaos_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            double c1 = ((PricePanelEntry)o1).getAdaos();
            double c2 = ((PricePanelEntry)o2).getAdaos();
            return (int)(c1 - c2);
        }
    };
    private static Comparator print_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            boolean c1 = ((PricePanelEntry)o1).isMustPrint();
            boolean c2 = ((PricePanelEntry)o2).isMustPrint();
            if (c1 && !c2) {
                return -1;
            }
            if (c2 && !c1) {
                return 1;
            }
            return 0;
        }
    };

    public PricesReport() {
        this.productsListener = new EventListener(){

            @Override
            public void dataChanged() {
                PricesReport.this.productsComboModel.refresh(NomeclaturaLogic.getInstance().getPowerSearchProducts(-1));
            }

            @Override
            public String getName() {
                return "PricesReportProducts";
            }
        };
        NomeclaturaLogic.getInstance().addListener(this.productsListener, 2);
    }

    public PricesReport(boolean showAdaosFields) {
        this.showAdaosFields = showAdaosFields;
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        if (ComboUtils.anythingButAllSelected(this.produseCombo)) {
            Product m = (Product)this.produseCombo.getSelectedItem();
            result.put("Product", m.getId());
            this.printCriteria.put("Product", m.getName());
        } else {
            result.put("Product", -1);
            this.printCriteria.remove("Product");
        }
        if (ComboUtils.anythingButAllSelected(this._subCategoryComboBox)) {
            Categorie c = (Categorie)this._subCategoryComboBox.getSelectedItem();
            result.put("Categorie", c.getId());
            this.printCriteria.put("Categorie", c.getName());
        } else {
            result.put("Categorie", -1);
            this.printCriteria.remove("Categorie");
        }
        String codBare = this.codBareField.getText();
        if (Validators.correctString(codBare)) {
            result.put("Cod bare", codBare);
            this.printCriteria.put("Cod bare", codBare);
        } else {
            result.put("Cod bare", "NULL");
            this.printCriteria.remove("Cod bare");
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        this._subcategoryLabel = new JLabel(LangRoAll.categorie);
        this._subCategoryComboBox = new JComboBox();
        this.productsComboModel = new FilterableComboBoxModel(NomeclaturaLogic.getInstance().getPowerSearchProducts(-1));
        JPanel categPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        categPanel.add((Component)this._subcategoryLabel, c);
        ++c.gridx;
        categPanel.add((Component)this._subCategoryComboBox, c);
        ++c.gridy;
        c.gridx = 0;
        JLabel codBare = new JLabel(LangRoAll.codBare);
        categPanel.add((Component)codBare, c);
        ++c.gridx;
        this.codBareField = new JTextField(10);
        categPanel.add((Component)this.codBareField, c);
        c.gridx = 0;
        ++c.gridy;
        JLabel produseLabel = new JLabel(LangRoAll.produs);
        categPanel.add((Component)produseLabel, c);
        ++c.gridx;
        boolean xComboSearchInProduct = Config.getInstance().getBoolean("XComboSearchInProduct");
        this.produseCombo = new XComboBox(this.productsComboModel, xComboSearchInProduct);
        this.produseCombo.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.produseCombo.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                PricesReport.this.produseCombo.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        categPanel.add((Component)this.produseCombo, c);
        return categPanel;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(_columnNames, _columnTypes, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                PricePanelEntry pe = (PricePanelEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 1: {
                        Double f = (Double)aValue;
                        if (pe.getIdReteta() > 0) {
                            RestLogic.getInstance().setPriceForRetetaProduct(pe.getIdReteta(), f, true);
                        } else {
                            StockLogic.getInstance().modificaPret(pe.getIdStock(), f, true, DateUtils.getCurrentTimestamp());
                        }
                        pe.setPret(f);
                        pe.setMustPrint(true);
                        PricesReport.this.tm.fireTableRowsUpdated(rowIndex, rowIndex);
                        PricesReport.this.refreshTotalPanel();
                        break;
                    }
                    case 4: {
                        Boolean b = (Boolean)aValue;
                        pe.setMustPrint(b);
                        NomeclaturaLogic.getInstance().updateToPrint(pe.isMustPrint(), pe.getIdProduct());
                        PricesReport.this.refreshTotalPanel();
                    }
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1 || columnIndex == 2 || columnIndex == 4;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                PricePanelEntry pe = (PricePanelEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return pe.getProduct();
                    }
                    case 1: {
                        return pe.getPret();
                    }
                    case 2: {
                        return pe.getAdaos();
                    }
                    case 3: {
                        return pe.getLastPretAcz();
                    }
                    case 4: {
                        return pe.isMustPrint();
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }

    @Override
    public JPanel buildTotalPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 10;
        c.fill = 2;
        JPanel result = new JPanel(new GridBagLayout());
        final PricesReport panel = this;
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Selectate"), c);
        ++c.gridx;
        this.selectedForPrint = new JLabel();
        result.add((Component)this.selectedForPrint, c);
        ++c.gridx;
        JButton selectAll = new JButton("Selecteaza toate");
        selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!DialogUtils.confirmDialog(panel, "Selectam toate produsele pt print ", LangRoAll.confirmare)) {
                    return;
                }
                boolean print = true;
                for (int i = 0; i < PricesReport.this.data.size(); ++i) {
                    PricePanelEntry pricePanelEntry = (PricePanelEntry)PricesReport.this.data.elementAt(i);
                    pricePanelEntry.setMustPrint(print);
                }
                NomeclaturaLogic.getInstance().updateToPrint(print, -1);
                PricesReport.this.raport();
            }
        });
        result.add((Component)selectAll, c);
        ++c.gridx;
        JButton deselectAll = new JButton("Sterge selectia");
        deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!DialogUtils.confirmDialog(panel, "Selectia curenta se va pierde. Continuam", LangRoAll.confirmare)) {
                    return;
                }
                boolean print = false;
                for (int i = 0; i < PricesReport.this.data.size(); ++i) {
                    PricePanelEntry pricePanelEntry = (PricePanelEntry)PricesReport.this.data.elementAt(i);
                    pricePanelEntry.setMustPrint(print);
                }
                NomeclaturaLogic.getInstance().updateToPrint(print, -1);
                PricesReport.this.raport();
            }
        });
        result.add((Component)deselectAll, c);
        ++c.gridx;
        JButton selectByCodBare = new JButton("Selecteaza/Deselecteaza produs");
        selectByCodBare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String codBare = DialogUtils.inputDialog(panel, "", LangRoAll.codBare);
                Product p = NomeclaturaLogic.getInstance().getProductByCodBare(codBare);
                if (p == null) {
                    DialogUtils.errorDialog(panel, LangRoAll.codIncorect, LangRoAll.nuPotContinua);
                    return;
                }
                NomeclaturaLogic.getInstance().toggleToPrint(p.getId());
                PricesReport.this.raport();
            }
        });
        result.add((Component)selectByCodBare, c);
        ++c.gridx;
        JButton calculeazaPretCost = new JButton("Calculeaza pret cost");
        calculeazaPretCost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestLogic.getInstance().updatePretCostForPricePanelEntries(PricesReport.this.data);
                PricesReport.this.tm.fireTableDataChanged();
            }
        });
        result.add(calculeazaPretCost);
        ++c.gridy;
        c.gridx = 2;
        JButton tiparesteEticheta = new JButton("Tipareste etichetele A4");
        tiparesteEticheta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String copiiS = DialogUtils.inputDialog(panel, "1", "Numar copii");
                if (Validators.correctInteger(copiiS)) {
                    final int copii = Integer.parseInt(copiiS);
                    PrintEticheteInterface interf = new PrintEticheteInterface(){

                        @Override
                        public int getCopyCount(PricePanelEntry currentItem) {
                            return copii;
                        }
                    };
                    String path = RestLogic.getInstance().printEticheteRaftA4(PricesReport.this.data, interf);
                    if (path != null) {
                        DialogUtils.okDialog(panel, "Etichetele au fost salvate la : \"" + path + "\"", LangRoAll.succes);
                    }
                    PricesReport.this.raport();
                }
            }
        });
        result.add((Component)tiparesteEticheta, c);
        ++c.gridx;
        JButton tiparesteBarcode = new JButton("Tipareste Barcode");
        tiparesteBarcode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String copiiS = DialogUtils.inputDialog(panel, "1", "Numar copii");
                if (Validators.correctInteger(copiiS)) {
                    int copii = Integer.parseInt(copiiS);
                    boolean ok = RestLogic.getInstance().printEticheteBarcodeRaft(PricesReport.this.data, copii);
                    if (ok) {
                        DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                    }
                    PricesReport.this.raport();
                }
            }
        });
        result.add((Component)tiparesteBarcode, c);
        if (LicenseManager.getInstance().isFunctionLicensed("cantar")) {
            final RestLogic logic = RestLogic.getInstance();
            JButton exportCantar = new JButton("Export cantar");
            exportCantar.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem datecsDT15 = new JMenuItem("Datecs DT15");
                    datecsDT15.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (DialogUtils.confirmDialog(panel, "Salvam codurile cantar pentru Datecs DT15", LangRoAll.confirmare)) {
                                String saveDir = logic.salveazaCoduriCantarDatecsDT15(panel);
                                if (saveDir != null) {
                                    DialogUtils.okDialog(panel, "Datele au fost salvate la " + saveDir, LangRoAll.succes);
                                } else {
                                    DialogUtils.errorDialog(panel, "Export esuat", LangRoAll.eroare);
                                }
                                if (DialogUtils.confirmDialog(panel, "Lansam programul de cantar", LangRoAll.confirmare)) {
                                    logic.lanseazaProgramCantar();
                                }
                            }
                        }
                    });
                    popup.add(datecsDT15);
                    JMenuItem digi = new JMenuItem("Digi");
                    digi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (DialogUtils.confirmDialog(panel, "Salvam codurile cantar pentru Digi", LangRoAll.confirmare)) {
                                String saveDir = logic.salveazaCoduriCantarDigi(panel);
                                if (saveDir != null) {
                                    DialogUtils.okDialog(panel, "Datele au fost salvate la " + saveDir, LangRoAll.succes);
                                } else {
                                    DialogUtils.errorDialog(panel, "Export esuat", LangRoAll.eroare);
                                }
                                if (DialogUtils.confirmDialog(panel, "Lansam programul de cantar", LangRoAll.confirmare)) {
                                    logic.lanseazaProgramCantar();
                                }
                            }
                        }
                    });
                    popup.add(digi);
                    JMenuItem aclas = new JMenuItem("Aclas");
                    aclas.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (DialogUtils.confirmDialog(panel, "Salvam codurile cantar pentru Aclas", LangRoAll.confirmare)) {
                                String saveDir = logic.salveazaCoduriCantarAclas(panel);
                                if (saveDir != null) {
                                    DialogUtils.okDialog(panel, "Datele au fost salvate la " + saveDir, LangRoAll.succes);
                                } else {
                                    DialogUtils.errorDialog(panel, "Export esuat", LangRoAll.eroare);
                                }
                                if (DialogUtils.confirmDialog(panel, "Lansam programul de cantar", LangRoAll.confirmare)) {
                                    logic.lanseazaProgramCantar();
                                }
                            }
                        }
                    });
                    popup.add(aclas);
                    JMenuItem bizerba = new JMenuItem("Bizerba");
                    bizerba.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (DialogUtils.confirmDialog(panel, "Salvam codurile cantar pentru Bizerba", LangRoAll.confirmare)) {
                                String saveDir = logic.salveazaCoduriCantarBizerba(panel);
                                if (saveDir != null) {
                                    DialogUtils.okDialog(panel, "Datele au fost salvate la " + saveDir, LangRoAll.succes);
                                } else {
                                    DialogUtils.errorDialog(panel, "Export esuat", LangRoAll.eroare);
                                }
                                if (DialogUtils.confirmDialog(panel, "Lansam programul de cantar", LangRoAll.confirmare)) {
                                    logic.lanseazaProgramCantar();
                                }
                            }
                        }
                    });
                    popup.add(bizerba);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            });
            ++c.gridx;
            result.add((Component)exportCantar, c);
        }
        ++c.gridx;
        JButton modificaPreturi = new JButton("Modifica preturi");
        modificaPreturi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile;
                if (DialogUtils.confirmDialog(panel, "Fisierul text trebuie de forma cod_intern|pret . Confirmati", "Continuam") && (inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de import", "txt")) != null) {
                    boolean ok = RestLogic.getInstance().updatePreturiPentruCoduriIntern(inputFile);
                    if (ok) {
                        DialogUtils.okDialog(panel, "Operatie efectuata", LangRoAll.succes);
                    } else {
                        DialogUtils.errorDialog(panel, "Operatie anulata. Nu s-au efectuat modificari.", LangRoAll.eroare);
                    }
                }
            }
        });
        result.add((Component)modificaPreturi, c);
        return result;
    }

    @Override
    public String getName() {
        return "Preturi";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return RestLogic.getInstance().getPricesPanelEntries(criteria);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, this.asciiReportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void refreshTotalPanel() {
        int forPrint = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            PricePanelEntry e = (PricePanelEntry)this.data.elementAt(i);
            if (!e.isMustPrint()) continue;
            ++forPrint;
        }
        this.selectedForPrint.setText("" + forPrint);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    PricePanelEntry sve = (PricePanelEntry)o;
                    try {
                        int column = 0;
                        Label label = new Label(column, row, sve.getProduct());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(++column, row, sve.getPret()));
                        sheet.addCell((WritableCell)new Label(++column, row, sve.getCodIntern()));
                        ++column;
                        if (PricesReport.this.showAdaosFields) {
                            sheet.addCell((WritableCell)new Number(column, row, sve.getAdaos()));
                            sheet.addCell((WritableCell)new Number(++column, row, sve.getLastPretAcz()));
                            ++column;
                        }
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    String[] result = new String[PricesReport.this.showAdaosFields ? 5 : 3];
                    String[] _columnNames = new String[]{LangRoAll.denumire, LangRoAll.pret, LangRoAll.codIntern, "Adaos", "Ultimul pret acz", LangRoAll.print};
                    System.arraycopy(_columnNames, 0, result, 0, result.length);
                    return result;
                }

                @Override
                public String getSheetName() {
                    return PricesReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this._subCategoryComboBox, NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(-1));
        this.rebuildAllProducts();
        this.codBareField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        PricesReport.this.raport();
                        break;
                    }
                }
            }
        });
        TableColumnModel colModel = this.table.getColumnModel();
        if (!this.showAdaosFields) {
            colModel.getColumn(2).setMaxWidth(0);
            colModel.getColumn(3).setMaxWidth(0);
        }
        final PricesReport parent = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                final int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                int modifiers = e.getModifiers();
                if ((modifiers & 8) > 0 || (modifiers & 4) > 0) {
                    final PricePanelEntry pe = (PricePanelEntry)PricesReport.this.data.elementAt(selRow);
                    final JPopupMenu popup = new JPopupMenu();
                    if (pe.getIdStock() > 0) {
                        JMenuItem edit = new JMenuItem(LangRoAll.modifica);
                        popup.add(edit);
                        edit.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Stock s = StockLogic.getInstance().getStockById(pe.getIdStock());
                                PricesReport.this.action.doubleClicked(s, pe, selRow);
                                popup.setVisible(false);
                            }
                        });
                        JMenuItem stergeStock = new JMenuItem("Sterge produs");
                        popup.add(stergeStock);
                        stergeStock.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                boolean action = false;
                                if (DialogUtils.confirmDialog(parent, "Doriti sa stergeti acest produs", LangRoAll.confirmare)) {
                                    action = RestLogic.getInstance().deleteStockAndNotifyListeners(pe, parent);
                                }
                                popup.setVisible(false);
                                if (action) {
                                    PricesReport.this.raport();
                                }
                            }
                        });
                    }
                    popup.setInvoker(PricesReport.this.table);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                if (PricesReport.this.showAdaosFields) {
                    return 4;
                }
                return 2;
            }

            @Override
            public int getColumnSize(int column) {
                if (PricesReport.this.showAdaosFields) {
                    switch (column) {
                        case 0: {
                            return 10;
                        }
                        case 1: {
                            return 3;
                        }
                        case 2: {
                            return 4;
                        }
                        case 3: {
                            return 3;
                        }
                    }
                    return 1;
                }
                switch (column) {
                    case 0: {
                        return 7;
                    }
                    case 1: {
                        return 3;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return _columnNames[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return "Produse";
                    }
                    case 1: {
                        return "" + PricesReport.this.data.size();
                    }
                }
                return null;
            }

            @Override
            public String getReportTitle() {
                return PricesReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return PricesReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                PricePanelEntry sve = (PricePanelEntry)row;
                if (PricesReport.this.showAdaosFields) {
                    switch (column) {
                        case 0: {
                            return sve.getProduct();
                        }
                        case 1: {
                            return Utils.getString2Decimals(sve.getPret());
                        }
                        case 2: {
                            return Utils.getString2Decimals(sve.getAdaos());
                        }
                        case 3: {
                            return Utils.getString2Decimals(sve.getLastPretAcz());
                        }
                    }
                } else {
                    switch (column) {
                        case 0: {
                            return sve.getProduct();
                        }
                        case 1: {
                            return Utils.getString2Decimals(sve.getPret());
                        }
                    }
                }
                return null;
            }
        };
        this.asciiReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.produs;
                    }
                    case 1: {
                        return LangRoAll.pret;
                    }
                }
                return null;
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return "Produse";
                    }
                    case 1: {
                        return "" + PricesReport.this.data.size();
                    }
                }
                return null;
            }

            @Override
            public String getReportTitle() {
                return PricesReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return PricesReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                PricePanelEntry sve = (PricePanelEntry)row;
                switch (column) {
                    case 0: {
                        return sve.getProduct();
                    }
                    case 1: {
                        return Utils.getString2Decimals(sve.getPret());
                    }
                }
                return null;
            }
        };
    }

    @Override
    public void cleanup() {
    }

    private void rebuildAllProducts() {
        Vector<Product> all = NomeclaturaLogic.getInstance().getAllProducts(-1);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return product_sorter;
            }
            case 1: {
                return price_sorter;
            }
            case 2: {
                return adaos_sorter;
            }
            case 4: {
                return print_sorter;
            }
        }
        return null;
    }

    @Override
    public void stockModified(Object sourceVe1, int selRow) {
        this.raport();
    }

    public final void setAction(DoubleClicked action) {
        this.action = action;
    }
}

