/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.admin.recipe;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.ProductAttribute;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.nomenclatura.gui.ProductPicturePanel;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.NewRecipeEntry;
import ro.atreides.restaurant.gui.admin.recipe.AddRecipeTableModel;
import ro.atreides.restaurant.gui.admin.recipe.RecipesPanel;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.NotEnoughIngredientsException;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.BarCodesPanel;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.units.UnitsLogic;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class AddRecipePanel
extends ReflectedJPanel {
    private JLabel _categoriesLabel;
    private JLabel _nameLabel;
    private JLabel _priceLabel;
    private JLabel _codeLabel;
    private JLabel unitValue;
    private JLabel _valoareIngrediente;
    private JLabel _adaosCoeficient;
    private JLabel _adaosProcent;
    private JLabel _fontLabel;
    private JComboBox _categoriesComboBox;
    private JComboBox _fontCombo;
    private XComboBox ingredient;
    private XComboBox produse;
    private JButton addIngredient;
    private JButton _addRecipeButton;
    private JButton _removeRecipeButton;
    private JButton _backButton;
    private JButton addProduct;
    private JButton prev;
    private JButton next;
    private JButton preview;
    private JButton addProductAsRelated;
    private JTextField _nameField;
    private JTextField _priceField;
    private JTextField _codeField;
    private JTextField quantity;
    private JTextField prodQuantity;
    private JTextField casaText;
    private JTextField sectieText;
    private JTextField free1Text;
    private JTextField free2Text;
    private JTextArea modPreparare;
    private AddRecipeTableModel _ingredientsListTableModel = null;
    private JTable _ingredientsListTable = null;
    private AbstractListPanel produseRelatedTable;
    private Sectie _sectie;
    private Product _product;
    private RestLogic logic = RestLogic.getInstance();
    private JTabbedPane parent;
    private RecipesPanel recipesPanel;
    private EventListener subcategoriesListener;
    private EventListener productsListener;
    private EventListener stockListener;
    private JCheckBox uzIntern;
    private JCheckBox productie;
    private String font;
    private int fontSize;
    private FilterableComboBoxModel ingredientsComboModel;
    private FilterableComboBoxModel produseComboModel;
    private AbstractListPanel atribute;
    private ProductPicturePanel ppp;
    private BarCodesPanel barCodesPanel;

    public AddRecipePanel(Sectie sectie) {
        this._sectie = sectie;
        this._product = null;
        this.stockListener = new EventListener(){

            @Override
            public void dataChanged() {
                AddRecipePanel.this.ingredientsComboModel.refresh(StockLogic.getInstance().getPowerSearchStocks());
            }

            @Override
            public String getName() {
                return "AddRecipePanelIngredients";
            }
        };
        this.logic.getStockLogic().addListener(this.stockListener, 26);
        this.subcategoriesListener = new EventListener(){

            @Override
            public void dataChanged() {
                AddRecipePanel.this.rebuildSubcategoriesCombo();
            }

            @Override
            public String getName() {
                return "AddRecipePanelSubcategories";
            }
        };
        NomeclaturaLogic.getInstance().addListener(this.subcategoriesListener, 1);
        this.productsListener = new EventListener(){

            @Override
            public void dataChanged() {
                AddRecipePanel.this.produseComboModel.refresh(NomeclaturaLogic.getInstance().getAllProducts(-1));
                AddRecipePanel.this.updateCodeAfterAdd();
            }

            @Override
            public String getName() {
                return "AddRecipePanelProducts";
            }
        };
        this.logic.addListener(this.productsListener, 2);
        this.init();
        this.display();
    }

    @Override
    public void doStuff() {
        AddRecipePanel parent = this;
        this._ingredientsListTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                JTable t = (JTable)e.getSource();
                final int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem edit = new JMenuItem(LangRoAll.modifica);
                popup.add(edit);
                edit.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NewRecipeEntry sc = (NewRecipeEntry)AddRecipePanel.this._ingredientsListTableModel.getIngredientAtRow(selRow);
                        if (AddRecipePanel.this._product != null) {
                            AddRecipePanel.this.logic.removeIngredientFromProduct(AddRecipePanel.this._product.getName(), sc.getId(), sc.getName(), sc.getQuantity());
                            AddRecipePanel.this.refreshIngredients();
                        } else {
                            AddRecipePanel.this._ingredientsListTableModel.removeIngredient(sc);
                        }
                        AddRecipePanel.this._ingredientsListTableModel.fireTableDataChanged();
                        if (sc.getIdStock() > 0) {
                            Stock s = StockLogic.getInstance().getStockById(sc.getIdStock());
                            AddRecipePanel.this.ingredient.setSelectedItem(s);
                            AddRecipePanel.this.ingredient.setText(sc.getName());
                            AddRecipePanel.this.ingredient.selectAllText();
                            AddRecipePanel.this.unitValue.setText(sc.getUm());
                            AddRecipePanel.this.quantity.setText(Utils.getString6Decimals(sc.getQuantity()));
                            AddRecipePanel.this.quantity.select(0, sc.getName().length());
                            AddRecipePanel.this.ingredient.requestFocus();
                        } else {
                            Product p = NomeclaturaLogic.getInstance().getProductById(sc.getIdProduct());
                            AddRecipePanel.this.produse.setSelectedItem(p);
                            AddRecipePanel.this.prodQuantity.setText(Utils.getString6Decimals(sc.getQuantity()));
                            AddRecipePanel.this.prodQuantity.select(0, sc.getName().length());
                            AddRecipePanel.this.prodQuantity.requestFocus();
                        }
                        popup.setVisible(false);
                    }
                });
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    public void cleanup() {
        this.logic.removeListener(this.subcategoriesListener);
        this.logic.removeListener(this.productsListener);
        this._categoriesComboBox.removeAllItems();
    }

    public void setProduct(Product p) {
        this._product = p;
        this.populatePanel();
        this._addRecipeButton.setText(LangRoAll.salveazaReteta);
        this._removeRecipeButton.setEnabled(true);
        this._backButton.setEnabled(true);
        this._valoareIngrediente.setText("");
        this._adaosCoeficient.setText("");
        this._adaosProcent.setText("");
        this.ppp.reload(p.getId());
    }

    private void rebuildSubcategoriesCombo() {
        Vector sc = NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(this._sectie.getId());
        this._categoriesComboBox.removeAllItems();
        for (Categorie sub : sc) {
            this._categoriesComboBox.addItem(sub);
        }
    }

    private void setUnitValue() {
        Stock selected = (Stock)this.ingredient.getSelectedItem();
        if (selected != null) {
            Unit u = UnitsLogic.getInstance().getUnitById(selected.getIdUnit());
            String unitName = u.getLabel();
            this.unitValue.setText(unitName);
        } else {
            this.unitValue.setText("");
        }
    }

    private void fontChosen(String family) {
        Font newFont = new Font(family, 1, this.fontSize);
        this._categoriesComboBox.setFont(newFont);
        this._nameField.setFont(newFont);
        this._priceField.setFont(newFont);
        this._codeField.setFont(newFont);
        this.casaText.setFont(newFont);
        this.sectieText.setFont(newFont);
        this.free1Text.setFont(newFont);
        this.free2Text.setFont(newFont);
        this.produse.setFont(newFont);
        this.ingredient.setFont(newFont);
    }

    private void init() {
        final AddRecipePanel panel = this;
        this._categoriesLabel = new JLabel(LangRoAll.categorie + " (*)");
        Font f = this._categoriesLabel.getFont();
        this.font = f.getName();
        this.fontSize = f.getSize();
        Vector sc = NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(this._sectie.getId());
        this._categoriesComboBox = new JComboBox(new Vector(sc));
        this._fontLabel = new JLabel(LangRoAll.font);
        this._fontCombo = new JComboBox<String>(GuiUtils.getAllFonts());
        this._fontCombo.setSelectedItem(this.font);
        this._fontCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String f = (String)AddRecipePanel.this._fontCombo.getSelectedItem();
                AddRecipePanel.this.fontChosen(f);
            }
        });
        this._nameLabel = new JLabel(LangRoAll.denumire + " (*)");
        this._nameField = new JTextField(20);
        this._priceLabel = new JLabel(LangRoAll.pret + " (*)");
        this._priceField = new JTextField(10);
        this._codeLabel = new JLabel(LangRoAll.codIntern + " (*)");
        this._codeField = new JTextField(10);
        this._codeField.setText("" + NomeclaturaLogic.getInstance().getNextProductCode());
        this.casaText = new JTextField(10);
        this.sectieText = new JTextField(10);
        this.free1Text = new JTextField(10);
        this.free2Text = new JTextField(10);
        this.uzIntern = new JCheckBox();
        this.productie = new JCheckBox();
        this.productie.setSelected(true);
        this.unitValue = new JLabel();
        this.initializeCombos();
        this.quantity = new JTextField(7);
        this._ingredientsListTableModel = new AddRecipeTableModel(new Vector(), this.logic);
        this._ingredientsListTable = new JTable(this._ingredientsListTableModel);
        this.prodQuantity = new JTextField(7);
        this.addProduct = new JButton(LangRoAll.adaugaProdusCaMP);
        this.addProduct.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                String q = AddRecipePanel.this.prodQuantity.getText();
                if (Validators.correctDouble(q)) {
                    try {
                        double qf = Utils.parseDouble(q);
                        Product selected = (Product)AddRecipePanel.this.produse.getSelectedItem();
                        if (AddRecipePanel.this._product != null) {
                            boolean recursed = AddRecipePanel.this.logic.isRecipeRecursed(selected.getId(), AddRecipePanel.this._product.getId());
                            if (recursed) {
                                DialogUtils.errorDialog(panel, LangRoAll.operatieNepermisa, LangRoAll.nuPotContinua);
                                return;
                            }
                            int idReteta = AddRecipePanel.this.logic.getIdReteta(AddRecipePanel.this._product.getId());
                            AddRecipePanel.this.logic.addIngredientToProduct(idReteta, -1, selected.getId(), qf, selected.getName(), AddRecipePanel.this._product.getName());
                            AddRecipePanel.this.refreshIngredients();
                        } else {
                            AddRecipePanel.this._ingredientsListTableModel.addProduct(selected.getId(), qf, selected.getName(), LangRoAll.buc);
                        }
                        AddRecipePanel.this._ingredientsListTableModel.fireTableDataChanged();
                        AddRecipePanel.this.produse.requestFocus();
                    }
                    catch (NumberFormatException e1) {
                        AddRecipePanel.this.prodQuantity.requestFocus();
                    }
                    finally {
                        AddRecipePanel.this.prodQuantity.setText("");
                        RestLogic.getInstance().notifyListeners(2);
                    }
                }
            }
        });
        this.addProductAsRelated = new JButton(LangRoAll.adaugaProdusRelated);
        this.addProductAsRelated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AddRecipePanel.this._product == null) {
                    return;
                }
                Product selected = (Product)AddRecipePanel.this.produse.getSelectedItem();
                if (selected != null) {
                    NomeclaturaLogic.getInstance().addProduseRelated(AddRecipePanel.this._product.getId(), selected.getId());
                    AddRecipePanel.this.produseRelatedTable.refreshTable();
                    AddRecipePanel.this.produse.clearAllText();
                }
            }
        });
        this.addIngredient = new JButton(LangRoAll.adauga);
        this.addIngredient.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Stock selectedIngr = (Stock)AddRecipePanel.this.ingredient.getSelectedItem();
                String quantityString = AddRecipePanel.this.quantity.getText();
                if (selectedIngr == null || quantityString == null || quantityString.length() <= 0) {
                    return;
                }
                try {
                    double toAdd = Utils.parseDouble(quantityString);
                    if (AddRecipePanel.this._product != null) {
                        int idReteta = AddRecipePanel.this.logic.getIdReteta(AddRecipePanel.this._product.getId());
                        AddRecipePanel.this.logic.addIngredientToProduct(idReteta, selectedIngr.getId(), -1, toAdd, selectedIngr.getLabel(), AddRecipePanel.this._product.getName());
                        AddRecipePanel.this.refreshIngredients();
                    } else {
                        AddRecipePanel.this._ingredientsListTableModel.addIngredient(selectedIngr.getId(), toAdd, selectedIngr.getLabel(), AddRecipePanel.this.unitValue.getText());
                    }
                    AddRecipePanel.this._ingredientsListTableModel.fireTableDataChanged();
                    AddRecipePanel.this.ingredient.requestFocus();
                    AddRecipePanel.this.ingredient.selectAllText();
                }
                catch (NumberFormatException ex) {
                    AddRecipePanel.this.quantity.requestFocus();
                }
                finally {
                    AddRecipePanel.this.quantity.setText("");
                }
            }
        });
        this.addIngredient.setMnemonic(68);
        this.prev = new JButton("<<");
        this.prev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                boolean save = DialogUtils.confirmDialog(panel, LangRoAll.salvam, LangRoAll.confirmare);
                if (save) {
                    AddRecipePanel.this._addRecipeButton.doClick();
                }
                AddRecipePanel.this.switchRecipe(-1);
            }
        });
        this.next = new JButton(">>");
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                boolean save = DialogUtils.confirmDialog(panel, LangRoAll.salvam, LangRoAll.confirmare);
                if (save) {
                    AddRecipePanel.this._addRecipeButton.doClick();
                }
                AddRecipePanel.this.switchRecipe(1);
            }
        });
        this.preview = new JButton(LangRoAll.previewReteta);
        this.preview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AddRecipePanel.this._product != null) {
                    RestLogic.getInstance().previewReteta(AddRecipePanel.this._product.getId());
                } else {
                    DialogUtils.errorDialog(panel, LangRoAll.salvatiProdusulIntai, LangRoAll.nuPotContinua);
                }
            }
        });
        this._addRecipeButton = new JButton(LangRoAll.adaugaReteta);
        this._addRecipeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sectieName;
                Categorie sc = (Categorie)AddRecipePanel.this._categoriesComboBox.getSelectedItem();
                String name = AddRecipePanel.this._nameField.getText();
                String priceString = AddRecipePanel.this._priceField.getText();
                Vector recipeItems = AddRecipePanel.this._ingredientsListTableModel.getRecipeItems();
                if (sc == null || name == null || name.length() <= 0 || priceString == null || priceString.length() <= 0) {
                    return;
                }
                String casaName = AddRecipePanel.this.casaText.getText();
                if (!Validators.correctString(casaName)) {
                    casaName = name;
                }
                if (!Validators.correctString(sectieName = AddRecipePanel.this.sectieText.getText())) {
                    sectieName = name;
                }
                String free1 = AddRecipePanel.this.free1Text.getText();
                String free2 = AddRecipePanel.this.free2Text.getText();
                String mp = AddRecipePanel.this.modPreparare.getText();
                boolean uzI = AddRecipePanel.this.uzIntern.isSelected();
                boolean produc = AddRecipePanel.this.productie.isSelected();
                try {
                    if (AddRecipePanel.this._product == null) {
                        int cod = -1;
                        try {
                            cod = Integer.parseInt(AddRecipePanel.this._codeField.getText());
                            if (NomeclaturaLogic.getInstance().getProductByCod(cod) != null) {
                                DialogUtils.errorDialog(panel, LangRoAll.codDejaFolosit, LangRoAll.nuPotContinua);
                                AddRecipePanel.this._codeField.setText(NomeclaturaLogic.getInstance().getNextProductCode() + "");
                                AddRecipePanel.this._codeField.requestFocus();
                                return;
                            }
                            AddRecipePanel.this._nameField.requestFocus();
                        }
                        catch (NumberFormatException n) {
                            DialogUtils.errorDialog(panel, LangRoAll.codIncorect, LangRoAll.nuPotContinua);
                            AddRecipePanel.this._codeField.setText("");
                            AddRecipePanel.this._codeField.setText(NomeclaturaLogic.getInstance().getNextProductCode() + "");
                            AddRecipePanel.this._codeField.requestFocus();
                            return;
                        }
                        double price = Utils.parseDouble(priceString);
                        String codBareS = "" + cod;
                        if (NomeclaturaLogic.getInstance().isProductDefined(name) && !VpConfig.getInstance().allowProduseDuplicate) {
                            DialogUtils.errorDialog(panel, LangRoAll.existaUnProdusCuAcestNume, LangRoAll.nuPotContinua);
                            return;
                        }
                        int id = AddRecipePanel.this.logic.newRetetaProduct(sc.getId(), name, price, recipeItems, cod, casaName, sectieName, free1, free2, mp, uzI, produc, false, AddRecipePanel.this.atribute.getTm().getData(), AddRecipePanel.this.ppp.getNewPictureFile(), codBareS, AddRecipePanel.this.barCodesPanel.getModifiedBarcodes());
                        AddRecipePanel.this.barCodesPanel.setProduct(null);
                    } else {
                        int cod = -1;
                        try {
                            cod = Integer.parseInt(AddRecipePanel.this._codeField.getText());
                            AddRecipePanel.this._product.setCod(cod);
                        }
                        catch (NumberFormatException n) {
                            AddRecipePanel.this._codeField.setText("");
                            AddRecipePanel.this._codeField.requestFocus();
                            return;
                        }
                        double price = Utils.parseDouble(priceString);
                        int idReteta = AddRecipePanel.this.logic.getIdReteta(AddRecipePanel.this._product.getId());
                        AddRecipePanel.this.logic.setPriceForRetetaProduct(idReteta, price, false);
                        AddRecipePanel.this._product.setIdCategorie(sc.getId());
                        AddRecipePanel.this._product.setName(name);
                        AddRecipePanel.this._product.setNumeCasa(casaName);
                        AddRecipePanel.this._product.setNumeSectie(sectieName);
                        AddRecipePanel.this._product.setLiber1(free1);
                        AddRecipePanel.this._product.setLiber2(free2);
                        AddRecipePanel.this.logic.setModPreparareForReteta(idReteta, mp);
                        AddRecipePanel.this._product.setUzIntern(uzI);
                        AddRecipePanel.this._product.setExportCantar(false);
                        AddRecipePanel.this.logic.setProductieForReteta(idReteta, produc);
                        Product existingProduct = NomeclaturaLogic.getInstance().getProductByName(name);
                        if (existingProduct != null && existingProduct.getId() != AddRecipePanel.this._product.getId() && !VpConfig.getInstance().allowProduseDuplicate) {
                            DialogUtils.errorDialog(panel, LangRoAll.existaUnProdusCuAcestNume, LangRoAll.nuPotContinua);
                            return;
                        }
                        AddRecipePanel.this._product.setPictureFile(AddRecipePanel.this.ppp.getNewPictureFile());
                        NomeclaturaLogic.getInstance().updateProduct(AddRecipePanel.this._product, price, AddRecipePanel.this.atribute.getTm().getData());
                        NomeclaturaLogic.getInstance().updateBarcodesForProductById(AddRecipePanel.this._product.getId(), AddRecipePanel.this.barCodesPanel.getModifiedBarcodes());
                        NomeclaturaLogic.getInstance().updatePowerSearchProducts(AddRecipePanel.this._product.getId(), AddRecipePanel.this.barCodesPanel.getModifiedBarcodes());
                        AddRecipePanel.this.logic.modifiedRetetaProduct();
                        AddRecipePanel.this.barCodesPanel.setProduct(null);
                        AddRecipePanel.this.backToList();
                    }
                    AddRecipePanel.this.resetFields();
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                    return;
                }
            }
        });
        this._addRecipeButton.setMnemonic(65);
        this._removeRecipeButton = new JButton(LangRoAll.stergeReteta);
        this._removeRecipeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AddRecipePanel.this._product != null) {
                    String promos = PromotionLogic.getInstance().getPromotionsThatUseProduct(AddRecipePanel.this._product.getId());
                    if (promos.equals("")) {
                        if (DialogUtils.confirmDialog(AddRecipePanel.this.parent, LangRoAll.aceastaRetetaVaFiStersa, LangRoAll.confirmare)) {
                            AddRecipePanel.this.logic.removeProduct(AddRecipePanel.this._product);
                            AddRecipePanel.this.resetFields();
                            AddRecipePanel.this.backToList();
                            DialogUtils.okDialog(AddRecipePanel.this.parent, LangRoAll.operatieExecutata, LangRoAll.succes);
                        }
                    } else {
                        DialogUtils.errorDialog(AddRecipePanel.this.parent, LangRoAll.urmatoarelePromotiiFolosescAcestProdus + promos, LangRoAll.nuPotContinua);
                    }
                } else {
                    AddRecipePanel.this.backToList();
                }
            }
        });
        this._removeRecipeButton.setEnabled(false);
        this._backButton = new JButton(LangRoAll.inapoi);
        this._backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRecipePanel.this.resetFields();
                AddRecipePanel.this.backToList();
            }
        });
        this._backButton.setEnabled(false);
        this.barCodesPanel = new BarCodesPanel();
    }

    private void switchRecipe(int direction) {
        this._backButton.doClick();
        this.recipesPanel.navigate(direction);
    }

    private void initializeCombos() {
        Vector powerSearchStocks = StockLogic.getInstance().getPowerSearchStocks();
        this.ingredientsComboModel = new FilterableComboBoxModel(powerSearchStocks);
        this.ingredient = new XComboBox(this.ingredientsComboModel);
        this.ingredient.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.ingredient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRecipePanel.this.setUnitValue();
            }
        });
        Vector<Product> products = NomeclaturaLogic.getInstance().getAllProducts(-1);
        this.produseComboModel = new FilterableComboBoxModel(products);
        this.produse = new XComboBox(this.produseComboModel);
        this.produse.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.produse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRecipePanel.this.setUnitValue();
            }
        });
    }

    private void updateCodeAfterAdd() {
        this._codeField.setText("" + NomeclaturaLogic.getInstance().getNextProductCode());
    }

    private void resetFields() {
        this._nameField.setText("");
        this._priceField.setText("");
        this.quantity.setText("");
        this._codeField.setText("" + NomeclaturaLogic.getInstance().getNextProductCode());
        this.unitValue.setText("");
        this._ingredientsListTableModel.removeAllIngredients();
        this._product = null;
        this._valoareIngrediente.setText("");
        this._adaosCoeficient.setText("");
        this._adaosProcent.setText("");
        this.casaText.setText("");
        this.sectieText.setText("");
        this.free1Text.setText("");
        this.free2Text.setText("");
        this.modPreparare.setText("");
        this.uzIntern.setSelected(false);
        this.productie.setSelected(true);
        this.atribute.refreshTable();
        this.ppp.reload(-1);
        this.barCodesPanel.setProduct(null);
    }

    private void backToList() {
        this._addRecipeButton.setText(LangRoAll.adaugaReteta);
        this._removeRecipeButton.setEnabled(false);
        this._backButton.setEnabled(false);
        this.parent.setSelectedComponent(this.recipesPanel);
    }

    private JPanel getPretCostPanel(final Component parent) {
        JPanel pricePanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        pricePanel.add((Component)new JLabel(LangRoAll.valoareIngrediente), c);
        ++c.gridx;
        this._valoareIngrediente = new JLabel("");
        pricePanel.add((Component)this._valoareIngrediente, c);
        ++c.gridy;
        c.gridx = 0;
        pricePanel.add((Component)new JLabel(LangRoAll.adaosCoeficient), c);
        ++c.gridx;
        this._adaosCoeficient = new JLabel("");
        pricePanel.add((Component)this._adaosCoeficient, c);
        ++c.gridy;
        c.gridx = 0;
        pricePanel.add((Component)new JLabel(LangRoAll.adaosProcentual), c);
        ++c.gridx;
        this._adaosProcent = new JLabel("");
        pricePanel.add((Component)this._adaosProcent, c);
        c.gridy = 0;
        ++c.gridx;
        c.weightx = 0.0;
        JButton calcul = new JButton(LangRoAll.calculeaza);
        calcul.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AddRecipePanel.this._product == null) {
                    DialogUtils.errorDialog(parent, LangRoAll.salvatiProdusulIntai, LangRoAll.nuPotContinua);
                } else {
                    double pretIngrediente = 0.0;
                    try {
                        pretIngrediente = AddRecipePanel.this.getPretIngrediente(AddRecipePanel.this._product.getId());
                    }
                    catch (NotEnoughIngredientsException e) {
                        Vector missing = e.getMissing();
                        String adaosText = AddRecipePanel.this.logic.getAdaosNecesar(missing);
                        DialogUtils.errorDialog(parent, adaosText, LangRoAll.nuPotContinua);
                        return;
                    }
                    AddRecipePanel.this._valoareIngrediente.setText(Utils.getString2Decimals(pretIngrediente));
                    String vanzare = AddRecipePanel.this._priceField.getText();
                    if (Validators.correctDouble(vanzare)) {
                        double v = Utils.parseDouble(vanzare);
                        Tva tvaProdus = AddRecipePanel.this.logic.getTvaForProduct(AddRecipePanel.this._product.getId());
                        double adaos = v / ((1.0 + tvaProdus.getCota()) * pretIngrediente);
                        AddRecipePanel.this._adaosCoeficient.setText(Utils.getString2Decimals(adaos));
                        double adaosProcent = (adaos - 1.0) * 100.0;
                        AddRecipePanel.this._adaosProcent.setText(Utils.getString2Decimals(adaosProcent));
                    } else {
                        AddRecipePanel.this._adaosCoeficient.setText("");
                        AddRecipePanel.this._adaosProcent.setText("");
                    }
                }
            }
        });
        pricePanel.add((Component)calcul, c);
        pricePanel.setBorder(new TitledBorder(LangRoAll.valoareIngrediente));
        return pricePanel;
    }

    private double getPretIngrediente(int idProduct) throws NotEnoughIngredientsException {
        int idReteta = this.logic.getIdReteta(idProduct);
        Vector stack = new Vector();
        double result = this.logic.getPretIngredienteCommit(idReteta, new NotEnoughIngredientsException(), stack);
        return result;
    }

    private JPanel getRecipePanel() {
        JPanel recipePanel = new JPanel(new GridBagLayout());
        recipePanel.setBorder(new TitledBorder(LangRoAll.reteta));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        recipePanel.add((Component)this._categoriesLabel, c);
        ++c.gridx;
        c.fill = 2;
        recipePanel.add((Component)this._categoriesComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        recipePanel.add((Component)this._fontLabel, c);
        ++c.gridx;
        c.fill = 2;
        recipePanel.add((Component)this._fontCombo, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        recipePanel.add((Component)this._nameLabel, c);
        ++c.gridx;
        c.fill = 2;
        recipePanel.add((Component)this._nameField, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        recipePanel.add((Component)this._priceLabel, c);
        ++c.gridx;
        c.fill = 2;
        recipePanel.add((Component)this._priceField, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        recipePanel.add((Component)this._codeLabel, c);
        ++c.gridx;
        c.fill = 2;
        recipePanel.add((Component)this._codeField, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        recipePanel.add((Component)new JLabel(LangRoAll.numeCasaMarcat), c);
        ++c.gridx;
        c.fill = 2;
        recipePanel.add((Component)this.casaText, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        recipePanel.add((Component)new JLabel(LangRoAll.numeSectie), c);
        ++c.gridx;
        c.fill = 2;
        recipePanel.add((Component)this.sectieText, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        recipePanel.add((Component)new JLabel(LangRoAll.textLiber1), c);
        ++c.gridx;
        c.fill = 2;
        recipePanel.add((Component)this.free1Text, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        recipePanel.add((Component)new JLabel(LangRoAll.textLiber2), c);
        ++c.gridx;
        c.fill = 2;
        recipePanel.add((Component)this.free2Text, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        recipePanel.add((Component)new JLabel(LangRoAll.uzIntern), c);
        ++c.gridx;
        c.fill = 2;
        recipePanel.add((Component)this.uzIntern, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        recipePanel.add((Component)new JLabel(LangRoAll.productie), c);
        ++c.gridx;
        c.fill = 2;
        recipePanel.add((Component)this.productie, c);
        return recipePanel;
    }

    private JPanel getQuantityPanel() {
        JPanel quantityPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(5, 2, 5, 2);
        c.gridx = 0;
        c.gridy = 0;
        quantityPanel.add((Component)new JLabel(LangRoAll.cantitate), c);
        c.gridx = 1;
        c.gridy = 0;
        quantityPanel.add((Component)this.quantity, c);
        c.gridx = 2;
        c.gridy = 0;
        quantityPanel.add((Component)this.unitValue, c);
        c.gridx = 3;
        c.gridy = 0;
        c.anchor = 13;
        quantityPanel.add((Component)this.addIngredient, c);
        return quantityPanel;
    }

    private JPanel getProductsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.fill = 2;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        result.add((Component)new JLabel(LangRoAll.produs), c);
        ++c.gridy;
        result.add((Component)this.produse, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        c.anchor = 17;
        result.add((Component)new JLabel(LangRoAll.cantitate), c);
        ++c.gridx;
        result.add((Component)this.prodQuantity, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)this.addProduct, c);
        ++c.gridx;
        result.add((Component)this.addProductAsRelated, c);
        result.setBorder(new TitledBorder(LangRoAll.produse));
        return result;
    }

    private JPanel getIngredientsPanel() {
        JPanel ingredientsPanel = new JPanel(new GridBagLayout());
        ingredientsPanel.setBorder(new TitledBorder(LangRoAll.ingrediente));
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        ingredientsPanel.add((Component)new JLabel(LangRoAll.numeIngredient), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.anchor = 17;
        ingredientsPanel.add((Component)this.ingredient, c);
        c.gridx = 0;
        ++c.gridy;
        ingredientsPanel.add((Component)this.getQuantityPanel(), c);
        return ingredientsPanel;
    }

    private JPanel getLeftPanel() {
        JPanel leftPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 11;
        c.insets = new Insets(5, 5, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        JTabbedPane leftTabs = new JTabbedPane();
        leftPanel.add((Component)this.getRecipePanel(), c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        leftPanel.add((Component)leftTabs, c);
        AddRecipePanel parent = this;
        leftTabs.addTab(LangRoAll.ingrediente, this.getIngredientsPanel());
        leftTabs.addTab(LangRoAll.produse, this.getProductsPanel());
        leftTabs.addTab(LangRoAll.valoareIngrediente, this.getPretCostPanel(parent));
        c.fill = 2;
        c.weighty = 0.0;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 0;
        leftPanel.add((Component)this._addRecipeButton, c);
        c.gridx = 1;
        leftPanel.add((Component)this._removeRecipeButton, c);
        c.gridx = 2;
        leftPanel.add((Component)this._backButton, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        leftPanel.add((Component)this.prev, c);
        ++c.gridx;
        leftPanel.add((Component)this.preview, c);
        ++c.gridx;
        leftPanel.add((Component)this.next, c);
        return leftPanel;
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(3, 3, 3, 3);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 2;
        this.add((Component)this.getLeftPanel(), c);
        ++c.gridy;
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.5;
        this.add((Component)new JScrollPane(this._ingredientsListTable), c);
        ++c.gridy;
        this.add((Component)this.getDetaliiPanel(), c);
    }

    private JPanel getDetaliiPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 10;
        JTabbedPane _tabbedPane = new JTabbedPane();
        JPanel instructiuni = this.getInstructiuniPanel();
        this.atribute = new AbstractListPanel(){

            @Override
            public String[] buildColumns() {
                return new String[]{LangRoAll.atribut, LangRoAll.valoare};
            }

            @Override
            public Vector buildData() {
                int idProduct = -1;
                if (AddRecipePanel.this._product != null) {
                    idProduct = AddRecipePanel.this._product.getId();
                }
                Vector data = NomeclaturaLogic.getInstance().getProductAttributes(idProduct);
                return data;
            }

            @Override
            public AbstractTM buildTableModel() {
                this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        ProductAttribute op = (ProductAttribute)data.elementAt(rowIndex);
                        switch (columnIndex) {
                            case 0: {
                                return op.getLabel();
                            }
                            case 1: {
                                return op.getValue();
                            }
                        }
                        return null;
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return columnIndex == 1;
                    }

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                        if (columnIndex == 1) {
                            ProductAttribute op = (ProductAttribute)data.elementAt(rowIndex);
                            String s = (String)aValue;
                            op.setValue(s);
                        }
                    }
                });
                return this.tm;
            }

            @Override
            public Class[] buildTypes() {
                return Utils.getStringClass(this.buildColumns().length);
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public void doStuff() {
                this.display();
            }
        };
        this.atribute.doStuff();
        JPanel produseRelated = this.getProduseRelatedPanel();
        this.ppp = new ProductPicturePanel(VpConfig.getInstance().productPictureDx);
        _tabbedPane.add((Component)this.ppp, "Imagine");
        this.ppp.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                String inputFile;
                if (DialogUtils.confirmDialog(AddRecipePanel.this.parent, "Incarcam alta poza", LangRoAll.confirmare) && (inputFile = FileDialog.getLoadDialogLocation(AddRecipePanel.this.parent, "Selectati poza in format jpg/png/gif", "gif,jpg,jpeg,png")) != null) {
                    AddRecipePanel.this.ppp.reload(inputFile);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        _tabbedPane.add((Component)this.atribute, LangRoAll.atribute);
        _tabbedPane.add((Component)instructiuni, LangRoAll.instructiuni);
        _tabbedPane.addTab(LangRoAll.produseRelated, produseRelated);
        _tabbedPane.add(LangRoAll.coduriDeBare, this.barCodesPanel);
        result.add((Component)_tabbedPane, c);
        return result;
    }

    private JPanel getInstructiuniPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 10;
        this.modPreparare = new JTextArea(100, 30);
        this.modPreparare.setLineWrap(true);
        JScrollPane s = new JScrollPane(this.modPreparare);
        result.add((Component)s, c);
        return result;
    }

    private JPanel getProduseRelatedPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 10;
        this.produseRelatedTable = new AbstractListPanel(){

            @Override
            public AbstractTM buildTableModel() {
                this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        Product currentP = (Product)data.get(rowIndex);
                        return currentP.toString();
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }
                });
                return this.tm;
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public Vector buildData() {
                if (AddRecipePanel.this._product != null) {
                    return NomeclaturaLogic.getInstance().getProduseRelated(AddRecipePanel.this._product);
                }
                return new Vector();
            }

            @Override
            public String[] buildColumns() {
                return new String[]{LangRoAll.produseRelated};
            }

            @Override
            public Class[] buildTypes() {
                return new Class[]{String.class};
            }

            @Override
            public void doStuff() {
                this.display();
                this.table.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        Point p;
                        int modifiers = e.getModifiers();
                        if ((modifiers & 0x10) > 0) {
                            return;
                        }
                        JTable t = (JTable)e.getSource();
                        int selRow = t.rowAtPoint(p = e.getPoint());
                        if (selRow == -1) {
                            return;
                        }
                        if (AddRecipePanel.this._product == null) {
                            return;
                        }
                        final JPopupMenu popup = new JPopupMenu();
                        final Product child = (Product)tm.getData().get(selRow);
                        JMenuItem edit = new JMenuItem(LangRoAll.sterge);
                        popup.add(edit);
                        edit.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                NomeclaturaLogic.getInstance().deleteProduseRelated(AddRecipePanel.this._product.getId(), child.getId());
                                popup.setVisible(false);
                                this.refreshTable();
                            }
                        });
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                });
            }
        };
        this.produseRelatedTable.doStuff();
        result.add((Component)this.produseRelatedTable, c);
        return result;
    }

    private void populatePanel() {
        Integer scId = this._product.getIdCategorie();
        Categorie sc = this.logic.getCategorieById(scId);
        this._categoriesComboBox.setSelectedItem(sc);
        this._nameField.setText(this._product.getName());
        this._priceField.setText("" + this.logic.getPriceForProductCommit(this._product.getId()));
        this._codeField.setText("" + this._product.getCod());
        this.casaText.setText(this._product.getNumeCasa());
        this.sectieText.setText(this._product.getNumeSectie());
        this.free1Text.setText(this._product.getLiber1());
        this.free2Text.setText(this._product.getLiber2());
        int idReteta = this.logic.getIdReteta(this._product.getId());
        String mp = this.logic.getModPreparareForReteta(idReteta);
        boolean productie1 = this.logic.isProductie(this._product.getId());
        this.modPreparare.setText(mp);
        this.uzIntern.setSelected(this._product.isUzIntern());
        this.productie.setSelected(productie1);
        this.ingredient.setSelectedIndex(-1);
        this.quantity.setText("");
        this.atribute.refreshTable();
        this.barCodesPanel.setProduct(this._product);
        this.refreshIngredients();
    }

    private void refreshIngredients() {
        Vector<Object> all = new Vector();
        if (this._product != null) {
            int idReteta = this.logic.getIdReteta(this._product.getId());
            all = this.logic.getRecipesForProdusReteta(idReteta, AdministrationPanel.loggedUser.getLanguage());
        }
        this._ingredientsListTableModel.setIngredients(all);
    }

    public void setParent(JTabbedPane parent) {
        this.parent = parent;
    }

    public void setRecipesPanel(RecipesPanel recipesPanel) {
        this.recipesPanel = recipesPanel;
    }

    public Sectie getCategoryAssociatedToPanel() {
        return this._sectie;
    }
}

