/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.admin.recipe;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.admin.recipe.AddRecipePanel;
import ro.atreides.restaurant.gui.admin.recipe.RecipeEntry;
import ro.atreides.restaurant.logic.LocationsFilter;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.logic.TablesFilter;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Location;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class RecipesPanel
extends ReflectedJPanel {
    private AbstractTM _tableModel;
    private JTable _table;
    private JPanel _panel;
    private Sectie _sectie;
    private RestLogic logic;
    private AddRecipePanel addRecipePanel;
    private JTabbedPane parent;
    private EventListener productsListener;
    private int currentRaw;

    @Override
    public void doStuff() {
    }

    public RecipesPanel(Sectie sectie) {
        this._sectie = sectie;
        this.logic = RestLogic.getInstance();
        this.productsListener = new EventListener(){

            @Override
            public void dataChanged() {
                RecipesPanel.this._tableModel.refresh(RecipesPanel.this.logic.getRecipesForCategory(RecipesPanel.this._sectie.getId(), -1, -1));
            }

            @Override
            public String getName() {
                return "RecipesPanelProducts";
            }
        };
        this.logic.addListener(this.productsListener, 2);
        this.init();
        this.display();
        this._tableModel.refresh(this.logic.getRecipesForCategory(this._sectie.getId(), -1, -1));
    }

    public void cleanup() {
        this.logic.removeListener(this.productsListener);
        this._tableModel.refresh(new Vector());
    }

    private void init() {
        String[] columns = new String[]{LangRoAll.categorie, LangRoAll.produs, LangRoAll.pret, LangRoAll.uzIntern};
        this._tableModel = new AbstractTM(columns, new Class[]{String.class, String.class, String.class, Boolean.class}, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                if (columnIndex == 3) {
                    RecipeEntry rp = (RecipeEntry)data.elementAt(rowIndex);
                    Product p = NomeclaturaLogic.getInstance().getProductById(rp.getIdProdus());
                    Boolean b = (Boolean)aValue;
                    p.setUzIntern(b);
                    NomeclaturaLogic.getInstance().updateProduct(p, rp.getPret(), NomeclaturaLogic.getInstance().getProductAttributes(p.getId()));
                    RecipesPanel.this.logic.modifiedRetetaProduct();
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 3;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                RecipeEntry rp = (RecipeEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return rp.getCategorie();
                    }
                    case 1: {
                        return rp.getDenumire();
                    }
                    case 2: {
                        return rp.getPret();
                    }
                    case 3: {
                        return new Boolean(rp.isUzIntern());
                    }
                }
                return null;
            }
        });
        this._table = new JTable(this._tableModel);
        this._table.setSelectionMode(0);
        this._table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                final int selRow = RecipesPanel.this._table.rowAtPoint(e.getPoint());
                int selCol = RecipesPanel.this._table.columnAtPoint(e.getPoint());
                if (selRow != -1 && selCol != 3) {
                    final JPopupMenu popup = new JPopupMenu();
                    JMenuItem modifica = new JMenuItem(LangRoAll.modifica);
                    JMenuItem toProdusFinit = new JMenuItem(LangRoAll.transformaInProdusFinit);
                    JMenuItem preview = new JMenuItem(LangRoAll.previewReteta);
                    JMenuItem print = new JMenuItem(LangRoAll.printReteta);
                    popup.add(modifica);
                    popup.add(preview);
                    popup.add(print);
                    popup.add(toProdusFinit);
                    popup.setInvoker(RecipesPanel.this._table);
                    modifica.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RecipesPanel.this.currentRaw = selRow;
                            RecipeEntry re = (RecipeEntry)RecipesPanel.this._tableModel.getObjectAt(selRow);
                            RecipesPanel.this.editRecipe(re.getIdProdus());
                            popup.setVisible(false);
                        }
                    });
                    toProdusFinit.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (DialogUtils.confirmDialog(RecipesPanel.this.parent, Utils.getTranslation(LangRoAll.transformamInProdusFinit, new String[0]), LangRoAll.confirmare)) {
                                RecipeEntry re = (RecipeEntry)RecipesPanel.this._tableModel.getObjectAt(selRow);
                                RecipesPanel.this.logic.transformaRetetaInProdusFinit(re.getIdReteta(), re.getIdProdus());
                                popup.setVisible(false);
                                RecipesPanel.this._tableModel.refresh(RecipesPanel.this.logic.getRecipesForCategory(RecipesPanel.this._sectie.getId(), -1, -1));
                            }
                        }
                    });
                    preview.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RecipeEntry re = (RecipeEntry)RecipesPanel.this._tableModel.getObjectAt(selRow);
                            RestLogic.getInstance().previewReteta(re.getIdProdus());
                            popup.setVisible(false);
                        }
                    });
                    print.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RecipeEntry re = (RecipeEntry)RecipesPanel.this._tableModel.getObjectAt(selRow);
                            RestLogic.getInstance().printReteta(re.getIdProdus());
                            popup.setVisible(false);
                        }
                    });
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this._panel = new JPanel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void navigate(int direction) {
        if (direction > 0) {
            if (this.currentRaw >= this._tableModel.getData().size() - 1) return;
            ++this.currentRaw;
        } else {
            if (this.currentRaw <= 0) return;
            --this.currentRaw;
        }
        RecipeEntry re = (RecipeEntry)this._tableModel.getObjectAt(this.currentRaw);
        this.editRecipe(re.getIdProdus());
    }

    private void editRecipe(int idProdus) {
        Product p = NomeclaturaLogic.getInstance().getProductById(idProdus);
        if (p != null) {
            this.addRecipePanel.setProduct(p);
            this.parent.setSelectedComponent(this.addRecipePanel);
        }
    }

    public void setAddRecipePanel(AddRecipePanel addRecipePanel) {
        this.addRecipePanel = addRecipePanel;
    }

    public void setParent(JTabbedPane parent) {
        this.parent = parent;
    }

    private void display() {
        this._panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        this._panel.add((Component)new JScrollPane(this._table), c);
        ++c.gridy;
        c.weighty = 0.0;
        this._panel.add((Component)this.getActionsPanel(), c);
        this.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this._panel, c);
    }

    private JPanel getActionsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        if (this.logic.getPluPrinter() != null) {
            JButton printPLU = new JButton(LangRoAll.printPLU);
            printPLU.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RecipesPanel.this.logic.printPLU(RecipesPanel.this.parent);
                }
            });
            result.add((Component)printPLU, c);
        }
        ++c.gridx;
        JButton produseExcel = new JButton(LangRoAll.produseInExcel);
        produseExcel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = RecipesPanel.this.logic.excelProduse();
                if (path != null) {
                    DialogUtils.okDialog(RecipesPanel.this.parent, LangRoAll.fisierulAFostSalvatLaLocatia + path, LangRoAll.succes);
                } else {
                    DialogUtils.errorDialog(RecipesPanel.this.parent, LangRoAll.operatieEsuata, LangRoAll.eroare);
                }
            }
        });
        result.add((Component)produseExcel, c);
        ++c.gridx;
        JButton retetePdf = new JButton(LangRoAll.printRetete);
        retetePdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = RecipesPanel.this.logic.printRetete(RecipesPanel.this._sectie.getId());
                if (path != null) {
                    DialogUtils.okDialog(RecipesPanel.this.parent, LangRoAll.fisierulAFostSalvatLaLocatia + path, LangRoAll.succes);
                } else {
                    DialogUtils.errorDialog(RecipesPanel.this.parent, LangRoAll.operatieEsuata, LangRoAll.eroare);
                }
            }
        });
        result.add((Component)retetePdf, c);
        ++c.gridx;
        JButton meniuPdf = new JButton(LangRoAll.printMeniu);
        meniuPdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = RecipesPanel.this.logic.pdfMenu(RecipesPanel.this._sectie.getId(), -1);
                if (path != null) {
                    DialogUtils.okDialog(RecipesPanel.this.parent, LangRoAll.fisierulAFostSalvatLaLocatia + path, LangRoAll.succes);
                } else {
                    DialogUtils.errorDialog(RecipesPanel.this.parent, LangRoAll.operatieEsuata, LangRoAll.eroare);
                }
            }
        });
        result.add((Component)meniuPdf, c);
        ++c.gridx;
        JButton produseXml = new JButton(LangRoAll.exportXml);
        produseXml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = RecipesPanel.this.logic.exportProductsToPOS(new TablesFilter(){

                    @Override
                    public boolean acceptTable(Table u) {
                        return true;
                    }
                }, new LocationsFilter(){

                    @Override
                    public boolean acceptLocation(Location u) {
                        return true;
                    }
                });
                if (path != null) {
                    DialogUtils.okDialog(RecipesPanel.this.parent, LangRoAll.fisierulAFostSalvatLaLocatia + path, LangRoAll.succes);
                } else {
                    DialogUtils.errorDialog(RecipesPanel.this.parent, LangRoAll.operatieEsuata, LangRoAll.eroare);
                }
            }
        });
        result.add((Component)produseXml, c);
        return result;
    }
}

