/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.clinica;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import ro.atreides.restaurant.clinicabase.AnalizeReportEntry;
import ro.atreides.utils.gui.table.AbstractTM;

public class AnalizeCellRenderer
extends DefaultTableCellRenderer {
    private AbstractTM model;

    public AnalizeCellRenderer(AbstractTM model) {
        this.model = model;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        AnalizeReportEntry se = (AnalizeReportEntry)this.model.getData().elementAt(row);
        String dateContact = se.getTooltip("<br><li>");
        String text = "<html> Detalii:" + dateContact + "</html>";
        this.setToolTipText(text);
        switch (column) {
            case 0: {
                if (se.isSelected()) {
                    this.setBackground(Color.YELLOW);
                    this.setForeground(Color.BLACK);
                    break;
                }
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                break;
            }
            case 2: {
                if (!se.isCompleted()) {
                    this.setBackground(Color.CYAN);
                    this.setForeground(Color.BLACK);
                    break;
                }
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                break;
            }
            case 3: {
                double minValue = se.getLimitaMinima();
                double maxValue = se.getLimitaMaxima();
                double val = se.getRezultatAnaliza();
                if (se.isCompleted() && (val > maxValue || val < minValue)) {
                    this.setBackground(Color.YELLOW);
                    this.setForeground(Color.BLACK);
                    break;
                }
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                break;
            }
            default: {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
            }
        }
        return this;
    }
}

