/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.clinica;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.restaurant.clinicabase.ClinicaLogic;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class BileteTrimitereReport
extends AbstractReportPanel {
    private FilterableComboBoxModel clientsComboModel;
    private FilterableComboBoxModel platitoriComboModel;
    private XComboBox clienti;
    private XComboBox platitori;
    private JTextField serieBilet;
    private JTextField numarBilet;
    private JTextField codDiagnostic;
    private JTextField codParafa;
    private JTextField codAsigurat;
    public static final String[] columns = new String[]{"Identificare", LangRoAll.produs, LangRoAll.cantitate, LangRoAll.valoare, "Inchidere"};
    private Hashtable printCriteria = new Hashtable();
    private JComboBox waiters;
    private JLabel totalSuma;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Object waiter = this.waiters.getSelectedItem();
        if (waiter instanceof User) {
            result.put("user_fo", waiter);
            this.printCriteria.put(LangRoAll.utilizator, waiter);
        } else {
            this.printCriteria.remove(LangRoAll.utilizator);
        }
        if (Validators.correctString(this.serieBilet.getText())) {
            result.put("BILET_SERIE", this.serieBilet.getText());
            this.printCriteria.put("BILET_SERIE", this.serieBilet.getText());
        } else {
            this.printCriteria.remove("BILET_SERIE");
        }
        if (Validators.correctString(this.numarBilet.getText())) {
            result.put("BILET_NUMAR", this.numarBilet.getText());
            this.printCriteria.put("BILET_NUMAR", this.numarBilet.getText());
        } else {
            this.printCriteria.remove("BILET_NUMAR");
        }
        if (Validators.correctString(this.codAsigurat.getText())) {
            result.put("BILET_COD_ASIGURAT", this.codAsigurat.getText());
            this.printCriteria.put("BILET_COD_ASIGURAT", this.codAsigurat.getText());
        } else {
            this.printCriteria.remove("BILET_COD_ASIGURAT");
        }
        if (Validators.correctString(this.codDiagnostic.getText())) {
            result.put("BILET_COD_DIAGNOSTIC", this.codDiagnostic.getText());
            this.printCriteria.put("BILET_COD_DIAGNOSTIC", this.codDiagnostic.getText());
        } else {
            this.printCriteria.remove("BILET_COD_DIAGNOSTIC");
        }
        if (Validators.correctString(this.codParafa.getText())) {
            result.put("BILET_COD_PARAFA", this.codParafa.getText());
            this.printCriteria.put("BILET_COD_PARAFA", this.codParafa.getText());
        } else {
            this.printCriteria.remove("BILET_COD_PARAFA");
        }
        ClientPersJuridica c = (ClientPersJuridica)this.platitori.getSelectedItem();
        if (c != null) {
            result.put("BILET_PLATITOR", c.getId() + "");
            this.printCriteria.put("BILET_PLATITOR", c.getCompanyName());
        } else {
            this.printCriteria.remove("BILET_PLATITOR");
        }
        ClientPersFizica cpf = (ClientPersFizica)this.clienti.getSelectedItem();
        if (cpf != null) {
            result.put("BILET_CLIENT", cpf.getId() + "");
            this.printCriteria.put("BILET_CLIENT", cpf.toString());
        } else {
            this.printCriteria.remove("BILET_CLIENT");
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Platitor"), c);
        ++c.gridx;
        this.platitoriComboModel = new FilterableComboBoxModel(ClinicaLogic.getInstance().getCaseSanatate());
        this.platitori = new XComboBox(this.platitoriComboModel, true);
        this.platitori.setPrototypeDisplayValue("111111111111111111111111111111111");
        result.add((Component)this.platitori, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        this.clientsComboModel = new FilterableComboBoxModel(ClientLogic.getInstance().getAllPersFiziceSorted());
        this.clienti = new XComboBox(this.clientsComboModel, true);
        this.clienti.setPrototypeDisplayValue("111111111111111111111111111111111");
        result.add((Component)this.clienti, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.operator), c);
        ++c.gridx;
        this.waiters = new JComboBox();
        result.add((Component)this.waiters, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Serie"), c);
        ++c.gridx;
        this.serieBilet = new JTextField(20);
        result.add((Component)this.serieBilet, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Numar"), c);
        ++c.gridx;
        this.numarBilet = new JTextField(20);
        result.add((Component)this.numarBilet, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Cod diagnostic"), c);
        ++c.gridx;
        this.codDiagnostic = new JTextField(20);
        result.add((Component)this.codDiagnostic, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Cod asigurat"), c);
        ++c.gridx;
        this.codAsigurat = new JTextField(20);
        result.add((Component)this.codAsigurat, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Cod parafa"), c);
        ++c.gridx;
        this.codParafa = new JTextField(20);
        result.add((Component)this.codParafa, c);
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        Class[] types = Utils.getStringClass(columns.length);
        AbstractTM tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                NoteView fe = (NoteView)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return fe.getData() != null ? fe.getOspatarMasa() + "," + Utils.getString2Decimals(fe.getTotalNota()) : "";
                    }
                    case 1: {
                        return fe.getProdus();
                    }
                    case 2: {
                        return Utils.getString3Decimals(fe.getCantitate());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getSuma());
                    }
                    case 4: {
                        return fe.getData() != null ? Formatters.DATE_AND_TIME_FORMAT.format(fe.getData()) : "";
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.total), c);
        ++c.gridx;
        this.totalSuma = new JLabel("");
        result.add((Component)this.totalSuma, c);
        return result;
    }

    @Override
    public String getName() {
        return "Bilete trimitere";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return ClinicaLogic.getInstance().getRaportBileteTrimitere(criteria, false, this.whatToPrint);
    }

    @Override
    public void printPreview() {
    }

    @Override
    public void printReport() {
    }

    @Override
    public void refreshTotalPanel() {
        this.updateTotals(this.data);
    }

    @Override
    public void writeExcel(File reportFile) {
    }

    public void updateTotals(Vector items) {
        double suma = 0.0;
        double discount = 0.0;
        for (NoteView element : items) {
            suma += element.getSuma();
            discount += element.getDiscount();
        }
        this.totalSuma.setText(Utils.getString2Decimals(suma));
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.waiters, RestLogic.getInstance().getWaiters());
        ClientLogic clientLogic = ClientLogic.getInstance();
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "NoteReport_persJuridice";
            }

            @Override
            public void dataChanged() {
                BileteTrimitereReport.this.clientsComboModel.refresh(ClientLogic.getInstance().getAllClientsSorted());
            }
        }, 42);
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "NoteReport_persFizice";
            }

            @Override
            public void dataChanged() {
                BileteTrimitereReport.this.clientsComboModel.refresh(ClientLogic.getInstance().getAllClientsSorted());
            }
        }, 41);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public boolean showXmlButton() {
        return true;
    }

    @Override
    public void exportToXml() {
    }
}

