/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.clinica;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.gui.ClientEditDialog;
import ro.atreides.clienti.gui.ClientEditPanelProvider;
import ro.atreides.clienti.gui.PersFizicaAddEditPanel;
import ro.atreides.clienti.gui.PersJuridicaAddEditPanel;
import ro.atreides.facturi.gui.AddFacturaDialog;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.promo.ClientPromotieView;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.promo.gui.PromotiiDialog;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.clinicabase.AnalizeEntry;
import ro.atreides.restaurant.clinicabase.BiletTrimitere;
import ro.atreides.restaurant.clinicabase.ClinicaLogic;
import ro.atreides.restaurant.gui.clinica.AnalizeCheckboxChooserPanel;
import ro.atreides.restaurant.gui.clinica.BiletTrimiterePanel;
import ro.atreides.restaurant.gui.clinica.IstoricClientPanel;
import ro.atreides.restaurant.gui.touch2.TouchMain2;
import ro.atreides.restaurant.gui.touch2.TouchOrder2;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.keyssonorom.PacientSelectDialog;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.ObjectEventListener;
import ro.atreides.utils.Utils;
import ro.atreides.utils.documente.DocumentTemplateChooserDialog;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.CardInputDialog;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.users.gui.ChooseUserDialog;

public class ClinicaOrderPanel
extends TouchOrder2 {
    public ClinicaOrderPanel(RestLogic logic, TouchMain2 main, VpConfig config, Vector sectii, boolean autoMarcaj, boolean deleteAllPlateau) {
        super(logic, main, config, sectii, autoMarcaj, deleteAllPlateau);
    }

    @Override
    protected JButton getServireButton() {
        JButton detaliiButton = new JButton("<html><center>Bilet<br>trimitere</center></html>");
        ClinicaOrderPanel parent = this;
        detaliiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BiletTrimitere bt;
                BiletTrimiterePanel btp = new BiletTrimiterePanel();
                if (ClinicaOrderPanel.this.order != null && (bt = ClinicaLogic.getInstance().getBiletForOrder(ClinicaOrderPanel.this.order.getId())) != null) {
                    btp.setBiletToEdit(bt);
                    btp.setEdit(true);
                }
                JDialog dialog = DialogUtils.getJDialog(btp, GuiUtils.currentFrame, "Bilet trimitere", 2.5);
                btp.setDialog(dialog);
                dialog.setVisible(true);
                if (btp.isSave()) {
                    int idPachetCAS;
                    if (ClinicaOrderPanel.this.order == null) {
                        ClinicaOrderPanel.this.order = ClinicaOrderPanel.this.createOrderIfNull();
                    }
                    int idFile = btp.getIdFile();
                    int idPlatitor = -1;
                    if (btp.isEdit()) {
                        idPlatitor = btp.getIdPlatitor();
                        idPachetCAS = btp.getIdPachetCAS();
                        ClinicaLogic.getInstance().updateBiletTrimitere(idPlatitor, idPachetCAS, btp.getSerie(), btp.getNumar(), btp.getCodDiagnostic(), btp.getDiagnostic(), btp.getCodParafa(), btp.getCodAsigurat(), btp.getScanFile(), btp.getIdBiletTrimitere(), idFile);
                    } else {
                        idPlatitor = btp.getIdPlatitor();
                        idPachetCAS = btp.getIdPachetCAS();
                        ClinicaLogic.getInstance().addBiletTrimitere(idPlatitor, idPachetCAS, btp.getSerie(), btp.getNumar(), btp.getCodDiagnostic(), btp.getDiagnostic(), btp.getCodParafa(), btp.getCodAsigurat(), btp.getScanFile(), ClinicaOrderPanel.this.order.getId(), idFile);
                    }
                    Promotion p = ClinicaLogic.getInstance().getPromotieForCasaSanatate(idPlatitor);
                    if (p != null) {
                        ClinicaOrderPanel.this.createOrderIfNull();
                        if (!ClinicaOrderPanel.this.order.isLaPlata()) {
                            ClinicaOrderPanel.this.order.setIdPromotie(p.getId());
                            ClinicaOrderPanel.this.setPromotionText();
                        }
                    }
                }
            }
        });
        return detaliiButton;
    }

    @Override
    protected JButton getPlatouButton() {
        JButton factura = new JButton(LangRoAll.factura);
        final ClinicaOrderPanel parent = this;
        factura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClinicaOrderPanel.this.order != null) {
                    Hashtable<String, Integer> h = new Hashtable<String, Integer>();
                    h.put("id_order_key", ClinicaOrderPanel.this.order.getId());
                    Vector<NoteView> newData = ClinicaOrderPanel.this.logic.getNote(h, true, 1);
                    User emitent = ClinicaOrderPanel.this.waiter;
                    if (((ClinicaOrderPanel)ClinicaOrderPanel.this).config.touch2FacturaRequestEmitent) {
                        emitent = UsersLogic.getInstance().requestWaiterLogin(GuiUtils.currentFrame, true, true);
                    }
                    if (emitent != null) {
                        new AddFacturaDialog(true, parent, newData, ClinicaOrderPanel.this.order.getIdClient(), emitent);
                    }
                } else {
                    DialogUtils.errorDialog(parent, LangRoAll.comandaGoala, LangRoAll.nuPotContinua);
                }
            }
        });
        return factura;
    }

    @Override
    protected void setPlatouButtonText() {
    }

    @Override
    public String getMeseName() {
        return LangRoAll.inapoi;
    }

    @Override
    protected JButton getFreeButton2() {
        JButton istoricClient = new JButton("<html><center>Istoric<br>pacient</center></html>\"v");
        istoricClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ClinicaOrderPanel.this.order != null && ClinicaOrderPanel.this.order.getIdClient() > 0) {
                    ClientPersFizica cpf = (ClientPersFizica)ClientLogic.getInstance().getClientById(ClinicaOrderPanel.this.order.getIdClient());
                    IstoricClientPanel icp = new IstoricClientPanel(cpf);
                    JDialog dialog = DialogUtils.getJDialog(icp, GuiUtils.currentFrame, "Istoric pacient", 1.1);
                    dialog.setVisible(true);
                }
            }
        });
        return istoricClient;
    }

    @Override
    protected JButton getFreeButton1() {
        JButton clientButton = new JButton("Pacient");
        ClinicaOrderPanel parent = this;
        final ClientEditPanelProvider provider = new ClientEditPanelProvider(){

            @Override
            public PersFizicaAddEditPanel getPfPanel() {
                return new PersFizicaAddEditPanel();
            }

            @Override
            public PersJuridicaAddEditPanel getPjPanel() {
                return new PersJuridicaAddEditPanel();
            }
        };
        clientButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClinicaOrderPanel.this.createOrderIfNull();
                PacientSelectDialog dia = new PacientSelectDialog(GuiUtils.currentFrame);
                int sel = dia.getSelected();
                Client c = dia.getSelectedClient();
                if (sel != -1) {
                    if (((ClinicaOrderPanel)ClinicaOrderPanel.this).config.showClientEditDialogAtClientSelection) {
                        ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), c, c instanceof ClientPersJuridica, provider);
                    }
                } else if (dia.isMustAdd()) {
                    boolean pf = true;
                    ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), null, !pf, provider);
                    sel = cDia.getClientId();
                }
                if (sel != -1) {
                    ClinicaOrderPanel.this.logic.setClientForOrder(ClinicaOrderPanel.this.order, sel, "");
                    ClinicaOrderPanel.this.setClientText();
                }
            }
        });
        return clientButton;
    }

    @Override
    protected JButton getFreeButton0() {
        JButton analize = new JButton("Analize");
        final ClinicaOrderPanel parent = this;
        analize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClinicaOrderPanel.this.createOrderIfNull();
                AnalizeCheckboxChooserPanel analizeChooser = new AnalizeCheckboxChooserPanel();
                JDialog dialog = DialogUtils.getJDialog(analizeChooser, GuiUtils.currentFrame, "Alegere analize", 1.1);
                dialog.setVisible(true);
                Vector products = analizeChooser.getChosenProducts();
                for (int i = 0; i < products.size(); ++i) {
                    Product product = (Product)products.elementAt(i);
                    ClinicaOrderPanel.this.addLaPrecomanda(product, 1.0, parent);
                }
            }
        });
        return analize;
    }

    @Override
    protected JPopupMenu buildOptiuniPopup() {
        final ClinicaOrderPanel parent = this;
        Font bonItemFont = new Font(null, 1, this.config.touchKeypadFontSize + 6);
        JPopupMenu popup = new JPopupMenu();
        try {
            JMenuItem btn;
            if (VpConfig.getInstance().showProtocolButton) {
                JMenuItem protocol = new JMenuItem(LangRoAll.protocol);
                protocol.setFont(bonItemFont);
                popup.add(protocol);
                protocol.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        User supervizor = null;
                        if (((ClinicaOrderPanel)ClinicaOrderPanel.this).config.passwordForProtocol) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !((ClinicaOrderPanel)ClinicaOrderPanel.this).config.passwordForProtocol) {
                            ClinicaOrderPanel.this.createOrderIfNull();
                            if (!ClinicaOrderPanel.this.order.isLaPlata()) {
                                boolean isProtocol = ClinicaOrderPanel.this.order.isProtocol();
                                boolean newState = !isProtocol;
                                ClinicaOrderPanel.this.logic.setProtocolForOrder(ClinicaOrderPanel.this.order, newState);
                                ClinicaOrderPanel.this.order.setProtocol(newState);
                                ClinicaOrderPanel.this.setPromotionText();
                            }
                        }
                    }
                });
            }
            if (this.logic.getCashRegister().numerarInputReady()) {
                JMenuItem btn2 = new JMenuItem(LangRoAll.incarcaCasa);
                popup.add(btn2);
                btn2.setFont(bonItemFont);
                btn2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        String s = DialogUtils.inputDialog(parent, "0", LangRoAll.valoareIncarcaCasa);
                        if (!Validators.correctDouble(s)) {
                            DialogUtils.errorDialog(parent, "Valoare incorecta", LangRoAll.nuPotContinua);
                            return;
                        }
                        double value = Utils.parseDouble(s);
                        ClinicaOrderPanel.this.logic.introduNumerar(value);
                    }
                });
            }
            JMenuItem recomputePrices = new JMenuItem(LangRoAll.recalculeazaNota);
            popup.add(recomputePrices);
            recomputePrices.setFont(bonItemFont);
            recomputePrices.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ClinicaOrderPanel.this.logic.recomputePrices(ClinicaOrderPanel.this.order);
                    ClinicaOrderPanel.this.orderTm.updateTable(ClinicaOrderPanel.this.logic.getSales(ClinicaOrderPanel.this.order.getId(), true, -1, new ScreenSaleInterface()));
                    ClinicaOrderPanel.this.updateOrderTotal();
                }
            });
            if (VpConfig.getInstance().showProformaButton) {
                btn = new JMenuItem(LangRoAll.proforma);
                popup.add(btn);
                btn.setFont(bonItemFont);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        User supervizor = null;
                        if (((ClinicaOrderPanel)ClinicaOrderPanel.this).config.passwordForProforma) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !((ClinicaOrderPanel)ClinicaOrderPanel.this).config.passwordForProforma) {
                            ClinicaOrderPanel.this.logic.notaProforma(ClinicaOrderPanel.this.order, ClinicaOrderPanel.this.table, null);
                        }
                    }
                });
            }
            if (VpConfig.getInstance().showIntermediaraButton) {
                btn = new JMenuItem(LangRoAll.intermediara);
                popup.add(btn);
                btn.setFont(bonItemFont);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        User supervizor = null;
                        if (((ClinicaOrderPanel)ClinicaOrderPanel.this).config.passwordForIntermediara) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !((ClinicaOrderPanel)ClinicaOrderPanel.this).config.passwordForIntermediara) {
                            ClinicaOrderPanel.this.logic.notaIntermediara(ClinicaOrderPanel.this.order, ClinicaOrderPanel.this.table, null);
                        }
                    }
                });
            }
            btn = new JMenuItem(LangRoAll.factura);
            popup.add(btn);
            btn.setFont(bonItemFont);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ClinicaOrderPanel.this.order != null) {
                        Vector<NoteView> newData = new Vector();
                        Hashtable<String, Integer> h = new Hashtable<String, Integer>();
                        h.put("id_order_key", ClinicaOrderPanel.this.order.getId());
                        newData = ClinicaOrderPanel.this.logic.getNote(h, true, 1);
                        User emitent = ClinicaOrderPanel.this.waiter;
                        if (((ClinicaOrderPanel)ClinicaOrderPanel.this).config.touch2FacturaRequestEmitent) {
                            emitent = UsersLogic.getInstance().requestWaiterLogin(GuiUtils.currentFrame, true, true);
                        }
                        if (emitent != null) {
                            new AddFacturaDialog(true, parent, newData, ClinicaOrderPanel.this.order.getIdClient(), emitent);
                        }
                    } else {
                        DialogUtils.errorDialog(parent, LangRoAll.comandaGoala, LangRoAll.nuPotContinua);
                    }
                }
            });
            JMenuItem fidelitate = new JMenuItem(LangRoAll.fidelitate);
            fidelitate.setFont(bonItemFont);
            popup.add(fidelitate);
            fidelitate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    User supervizor = null;
                    if (((ClinicaOrderPanel)ClinicaOrderPanel.this).config.passwordForFidelitate) {
                        supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    }
                    if (supervizor != null || !((ClinicaOrderPanel)ClinicaOrderPanel.this).config.passwordForFidelitate) {
                        CardInputDialog dialog;
                        final StringBuffer card = new StringBuffer();
                        EventGenerator soyal = ClinicaOrderPanel.this.logic.getAccesInterface();
                        if (soyal != null) {
                            dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().codFidelitateLength);
                            ClinicaOrderPanel.this.main.requestFocus();
                            ObjectEventListener l = new ObjectEventListener(){

                                @Override
                                public void dataChanged(Object o) {
                                    card.append(o);
                                    dialog.dispose();
                                }

                                @Override
                                public String getName() {
                                    return "touch3_soyal_fidelitate";
                                }
                            };
                            soyal.addObjectListener(l, 701);
                            dialog.setVisible(true);
                            soyal.removeObjectListener(l);
                        } else {
                            dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().codFidelitateLength);
                            dialog.setVisible(true);
                            ClinicaOrderPanel.this.main.requestFocus();
                            card.append(dialog.getCodAutentificare());
                        }
                        ClientPromotieView cpv = PromotionLogic.getInstance().getClientPromotieForCard(card.toString());
                        if (cpv != null) {
                            ClinicaOrderPanel.this.createOrderIfNull();
                            double totalOrder1 = ClinicaOrderPanel.this.logic.getTotal(ClinicaOrderPanel.this.order);
                            Vector premii = ClinicaOrderPanel.this.logic.getPremiiForClient(cpv.getIdClient(), totalOrder1);
                            if (premii.size() > 0) {
                                String message = Utils.getStringForJDialogList(LangRoAll.premiiPosibile, "", premii);
                                DialogUtils.okDialog(parent, message, LangRoAll.premiiPosibile);
                            }
                            if (!ClinicaOrderPanel.this.order.isLaPlata()) {
                                ClinicaOrderPanel.this.order.setIdPromotie(cpv.getIdPromotie());
                                ClinicaOrderPanel.this.order.setIdClient(cpv.getIdClient());
                                ClinicaOrderPanel.this.logic.setClientAndPromotionForOrder(ClinicaOrderPanel.this.order, cpv.getIdClient(), cpv.getIdPromotie());
                                ClinicaOrderPanel.this.setPromotionText();
                                ClinicaOrderPanel.this.setClientText();
                            }
                        }
                    }
                }
            });
            JMenuItem promotie = new JMenuItem(LangRoAll.promotie);
            promotie.setFont(bonItemFont);
            popup.add(promotie);
            promotie.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    User supervizor = null;
                    if (((ClinicaOrderPanel)ClinicaOrderPanel.this).config.passwordForPromo) {
                        supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    }
                    if (supervizor != null || !((ClinicaOrderPanel)ClinicaOrderPanel.this).config.passwordForPromo) {
                        Vector<Promotion> promotii;
                        ClinicaOrderPanel.this.createOrderIfNull();
                        if (!ClinicaOrderPanel.this.order.isLaPlata() && (promotii = PromotionLogic.getInstance().getFidelitatePromotions()).size() > 0) {
                            PromotiiDialog dialog = new PromotiiDialog(4, promotii);
                            int idPromotie = dialog.getSelected();
                            ClinicaOrderPanel.this.logic.setPromotionForOrder(ClinicaOrderPanel.this.order, idPromotie);
                            ClinicaOrderPanel.this.order.setIdPromotie(idPromotie);
                            ClinicaOrderPanel.this.setPromotionText();
                        }
                    }
                }
            });
            Location loc = this.logic.getLocationById(this.table.getIdLocatie());
            if (loc.getTip() == 1) {
                JMenuItem schimbaOspatar = new JMenuItem("Schimba operator");
                schimbaOspatar.setFont(bonItemFont);
                popup.add(schimbaOspatar);
                schimbaOspatar.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (ClinicaOrderPanel.this.order == null) {
                            return;
                        }
                        if (!DialogUtils.confirmDialog(parent, "Schimbam operatorul", LangRoAll.confirmare)) {
                            return;
                        }
                        Vector users = ClinicaOrderPanel.this.logic.getRealWaiters();
                        User supervizor = null;
                        if (((ClinicaOrderPanel)ClinicaOrderPanel.this).config.passwordForSchimbareOspatar) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (!(supervizor == null && ((ClinicaOrderPanel)ClinicaOrderPanel.this).config.passwordForSchimbareOspatar || ClinicaOrderPanel.this.order.isLaPlata() || users.size() <= 0)) {
                            ChooseUserDialog dialog1 = new ChooseUserDialog(4, users);
                            int idUser = dialog1.getSelected();
                            ClinicaOrderPanel.this.logic.setUserToOrder(idUser, ClinicaOrderPanel.this.order);
                            ClinicaOrderPanel.this.goToMese();
                        }
                    }
                });
            }
            JMenuItem tiparesteFoaieLucru = new JMenuItem("Tipareste foaie lucru");
            popup.add(tiparesteFoaieLucru);
            tiparesteFoaieLucru.setFont(bonItemFont);
            tiparesteFoaieLucru.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (ClinicaOrderPanel.this.order == null) {
                        DialogUtils.errorDialog(parent, LangRoAll.comandaGoala, LangRoAll.nuPotContinua);
                        return;
                    }
                    int idClient = ClinicaOrderPanel.this.order.getIdClient();
                    if (idClient <= 0) {
                        DialogUtils.errorDialog(parent, "Selectati pacientul!!", LangRoAll.nuPotContinua);
                        return;
                    }
                    ClientPersFizica c = (ClientPersFizica)ClientLogic.getInstance().getClientById(idClient);
                    Vector sales = ClinicaOrderPanel.this.orderTm.getAllSales();
                    Vector<AnalizeEntry> analize = new Vector<AnalizeEntry>();
                    for (int i = 0; i < sales.size(); ++i) {
                        Sale sale = (Sale)sales.elementAt(i);
                        AnalizeEntry ae = new AnalizeEntry();
                        int idProduct = sale.getIdProduct();
                        Product p = NomeclaturaLogic.getInstance().getProductById(idProduct);
                        ae.setCodBare("");
                        ae.setDenumire(p.getName());
                        analize.add(ae);
                    }
                    ClinicaLogic.getInstance().tiparesteFisaLucru(c, analize, ClinicaOrderPanel.this.waiter, ClinicaOrderPanel.this.order);
                }
            });
            JMenuItem generareDocumente = new JMenuItem("Generare documente");
            popup.add(generareDocumente);
            generareDocumente.setFont(bonItemFont);
            generareDocumente.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (ClinicaOrderPanel.this.order == null) {
                        DialogUtils.errorDialog(parent, LangRoAll.comandaGoala, LangRoAll.nuPotContinua);
                        return;
                    }
                    int idClient = ClinicaOrderPanel.this.order.getIdClient();
                    if (idClient <= 0) {
                        DialogUtils.errorDialog(parent, "Selectati pacientul!!", LangRoAll.nuPotContinua);
                        return;
                    }
                    ClientPersFizica c = (ClientPersFizica)ClientLogic.getInstance().getClientById(idClient);
                    Vector templates = ClinicaLogic.getInstance().getTemplateFiles();
                    DocumentTemplateChooserDialog dia = new DocumentTemplateChooserDialog(5, templates);
                    String selected = dia.getSelected();
                    if (Validators.correctString(selected)) {
                        ClinicaLogic.getInstance().tiparesteOdtDupaTemplate(c, selected, selected);
                    } else {
                        DialogUtils.errorDialog(parent, "Nu ati selectat un document", LangRoAll.nuPotContinua);
                    }
                }
            });
            if (VpConfig.getInstance().showDetaliiNota) {
                JMenuItem detaliiNota = new JMenuItem("Observatii pacient");
                detaliiNota.setFont(bonItemFont);
                popup.add(detaliiNota);
                detaliiNota.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        String detalii;
                        if (ClinicaOrderPanel.this.order == null) {
                            return;
                        }
                        String fost = ClinicaOrderPanel.this.order.getDetalii();
                        if (fost == null) {
                            fost = "";
                        }
                        if ((detalii = DialogUtils.inputDialog(parent, fost, "Observatii pacient")) != null) {
                            ClinicaOrderPanel.this.order.setDetalii(detalii);
                            ClinicaOrderPanel.this.logic.setDetalii(ClinicaOrderPanel.this.order);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
        return popup;
    }
}

