/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.clinica;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.DocumenteClient;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.clinicabase.BiletTrimitere;
import ro.atreides.restaurant.clinicabase.ClinicaLogic;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.IncasareClientView;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.documente.DocumenteLogic;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class IstoricClientPanel
extends JPanel {
    private ClientPersFizica client;

    public IstoricClientPanel(ClientPersFizica client) {
        this.client = client;
        this.display();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.2;
        c.fill = 2;
        JPanel datepacient = this.buildDatePacient();
        datepacient.setBorder(new TitledBorder("Client"));
        this.add((Component)datepacient, c);
        ++c.gridx;
        c.gridheight = 2;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel comentarii = this.buildComentarii();
        comentarii.setBorder(new TitledBorder("Observatii"));
        this.add((Component)comentarii, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridheight = 1;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel istoric = this.buildIstoricVanzari();
        istoric.setBorder(new TitledBorder("Istoric"));
        this.add((Component)istoric, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weighty = 0.2;
        c.fill = 2;
        JPanel documente = this.buildDocumentePanel();
        documente.setBorder(new TitledBorder("Documente"));
        this.add((Component)documente, c);
    }

    private JPanel buildDatePacient() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        JLabel numeL = new JLabel("Nume");
        result.add((Component)numeL, c);
        ++c.gridx;
        JLabel nume = new JLabel(this.client.toString());
        result.add((Component)nume, c);
        ++c.gridy;
        c.gridx = 0;
        numeL = new JLabel("CNP");
        result.add((Component)numeL, c);
        ++c.gridx;
        nume = new JLabel(ClientLogic.getInstance().getCNPForClient(this.client));
        result.add((Component)nume, c);
        ++c.gridy;
        c.gridx = 0;
        JLabel varstaL = new JLabel("Varsta");
        result.add((Component)varstaL, c);
        ++c.gridx;
        JLabel varsta = new JLabel(ClientLogic.getInstance().getVarstaForPF(this.client));
        result.add((Component)varsta, c);
        ++c.gridy;
        c.gridx = 0;
        numeL = new JLabel("Valoare cont - total");
        result.add((Component)numeL, c);
        ++c.gridx;
        double total = RestLogic.getInstance().getTotalIncasari(this.client, DateUtils.getStartOfDays());
        nume = new JLabel(Utils.getString2Decimals(total));
        result.add((Component)nume, c);
        ++c.gridy;
        c.gridx = 0;
        numeL = new JLabel("Valoare cont - 6 luni");
        result.add((Component)numeL, c);
        ++c.gridx;
        total = RestLogic.getInstance().getTotalIncasari(this.client, DateUtils.addDaysToDate(new Date(), -180));
        nume = new JLabel(Utils.getString2Decimals(total));
        result.add((Component)nume, c);
        return result;
    }

    private JPanel buildComentarii() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 1;
        Vector<IncasareClientView> orders = RestLogic.getInstance().getIncasariByIdClient(this.client.getId());
        AbstractTM tm = new AbstractTM(new String[]{"Observatii"}, Utils.getStringClass(1), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                IncasareClientView icv = (IncasareClientView)data.get(rowIndex);
                Order o = RestLogic.getInstance().getOrderById(icv.getIdOrder());
                String detalii = o.getDetalii();
                return detalii;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        JTable items = new JTable(tm);
        tm.refresh(orders);
        JScrollPane scroll = new JScrollPane(items);
        result.add((Component)scroll, c);
        return result;
    }

    private JPanel buildIstoricVanzari() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        String[] columns = new String[]{(VpConfig.getInstance().showDetaliiNota ? LangRoAll.detalii + "," : "") + LangRoAll.operatorMasaTotal, LangRoAll.produs, LangRoAll.cantitate, LangRoAll.pret, LangRoAll.inchisNota};
        Class[] types = Utils.getStringClass(columns.length);
        AbstractTM tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                NoteView fe = (NoteView)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return fe.getData() != null ? (VpConfig.getInstance().showDetaliiNota ? fe.getDetalii() + "," : "") + fe.getOspatarMasa() + "," + Utils.getString2Decimals(fe.getTotalNota()) : "";
                    }
                    case 1: {
                        return fe.getProdus();
                    }
                    case 2: {
                        return Utils.getString3Decimals(fe.getCantitate());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getSuma());
                    }
                    case 4: {
                        return fe.getData() != null ? Formatters.DATE_AND_TIME_FORMAT.format(fe.getData()) : "";
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        Hashtable<String, Comparable<Date>> criteria = new Hashtable<String, Comparable<Date>>();
        criteria.put(Constants.START_KEY, DateUtils.getStartOfDays());
        criteria.put(Constants.STOP_KEY, DateUtils.getEndOfDays());
        criteria.put("client_pf", this.client);
        Vector<NoteView> istoricVz = RestLogic.getInstance().getNote(criteria, false, -1);
        JTable items = new JTable(tm);
        JScrollPane scroll = new JScrollPane(items);
        result.add((Component)scroll, c);
        tm.refresh(istoricVz);
        return result;
    }

    private JPanel buildDocumentePanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Bilete trimitere", this.buildBileteTrimiterePanel());
        tabs.addTab("Documente generate", this.buildDocumenteGeneratePanel());
        result.add((Component)tabs, c);
        return result;
    }

    private JPanel buildBileteTrimiterePanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 1;
        Vector<IncasareClientView> orders = RestLogic.getInstance().getIncasariByIdClient(this.client.getId());
        final AbstractTM tm = new AbstractTM(new String[]{"Data", "Detalii"}, Utils.getStringClass(2), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                IncasareClientView icv = (IncasareClientView)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return icv.getData();
                    }
                    case 1: {
                        BiletTrimitere bt = ClinicaLogic.getInstance().getBiletForOrder(icv.getIdOrder());
                        if (bt == null) break;
                        return bt.toString();
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        JTable items = new JTable(tm);
        tm.refresh(orders);
        JScrollPane scroll = new JScrollPane(items);
        result.add((Component)scroll, c);
        items.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(final MouseEvent e) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem open = new JMenuItem("Open");
                open.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        Point p;
                        JTable t = (JTable)e.getSource();
                        int selRow = t.rowAtPoint(p = e.getPoint());
                        if (selRow == -1) {
                            return;
                        }
                        IncasareClientView icv = (IncasareClientView)tm.getObjectAt(selRow);
                        BiletTrimitere bt = ClinicaLogic.getInstance().getBiletForOrder(icv.getIdOrder());
                        DocumenteLogic.getInstance().openFile(bt.getIdFile(), "123.odt");
                    }
                });
                popup.add(open);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        return result;
    }

    private JPanel buildDocumenteGeneratePanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 1;
        Vector documente = ClientLogic.getInstance().getDocumenteClient(this.client.getId());
        final AbstractTM tm = new AbstractTM(new String[]{"Data", "Tip document", "Titlu"}, Utils.getStringClass(3), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                DocumenteClient dv = (DocumenteClient)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return Formatters.DATE_AND_TIME_FORMAT.format(dv.getData());
                    }
                    case 1: {
                        return dv.getCategorieDocument();
                    }
                    case 2: {
                        return dv.getTitle();
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        JTable items = new JTable(tm);
        tm.refresh(documente);
        JScrollPane scroll = new JScrollPane(items);
        result.add((Component)scroll, c);
        items.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(final MouseEvent e) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem open = new JMenuItem("Open");
                open.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        Point p;
                        JTable t = (JTable)e.getSource();
                        int selRow = t.rowAtPoint(p = e.getPoint());
                        if (selRow == -1) {
                            return;
                        }
                        DocumenteClient pve = (DocumenteClient)tm.getObjectAt(selRow);
                        DocumenteLogic.getInstance().openFile(pve.getIdFile(), "123.odt");
                    }
                });
                popup.add(open);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        return result;
    }
}

