/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.clinica;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ro.atreides.clienti.BiCi;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.utils.Client;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;

public class PacientSelectPanel
extends JPanel {
    private XComboBox clienti;
    private FilterableComboBoxModel clientsComboModel;
    private Client selectedClient;
    private int selected = -1;
    private boolean mustAdd = false;
    private JTextField cnp;
    private JDialog dialog;

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    private void updateClient(ClientPersFizica c) {
        if (c != null) {
            int idBuletin = c.getIdBuletin();
            if (idBuletin > 0) {
                BiCi bici = ClientLogic.getInstance().getBiCiById(idBuletin);
                this.cnp.setText(bici.getCnp());
            } else {
                this.cnp.setText(c.getAddress1());
            }
        } else {
            this.cnp.setText("");
        }
    }

    public int getSelected() {
        return this.selected;
    }

    public boolean isMustAdd() {
        return this.mustAdd;
    }

    public Client getSelectedClient() {
        return this.selectedClient;
    }

    public PacientSelectPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        final JButton newClient = new JButton("Pacient nou");
        final JButton ok = new JButton("OK");
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new JLabel("CNP"), c);
        ++c.gridx;
        this.cnp = new JTextField(10);
        this.cnp.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    ClientPersFizica c = (ClientPersFizica)ClientLogic.getInstance().getClient(PacientSelectPanel.this.cnp.getText());
                    PacientSelectPanel.this.updateClient(c);
                    if (c == null) {
                        newClient.requestFocus();
                    } else {
                        ok.requestFocus();
                        PacientSelectPanel.this.clienti.setSelectedItem(c);
                    }
                }
            }
        });
        this.add((Component)this.cnp, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        this.clientsComboModel = new FilterableComboBoxModel(ClientLogic.getInstance().getAllPersFiziceSorted());
        this.clienti = new XComboBox(this.clientsComboModel, true);
        this.clienti.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.add((Component)this.clienti, c);
        this.clientsComboModel.refresh(ClientLogic.getInstance().getAllPersFiziceSorted());
        this.clienti.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(PacientSelectPanel.this.clienti)) {
                    ClientPersFizica c = (ClientPersFizica)PacientSelectPanel.this.clienti.getSelectedItem();
                    PacientSelectPanel.this.updateClient(c);
                }
            }
        });
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)ok, c);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object client = PacientSelectPanel.this.clienti.getSelectedItem();
                if (client instanceof Client) {
                    PacientSelectPanel.this.selected = ((Client)client).getId();
                    PacientSelectPanel.this.selectedClient = (Client)client;
                } else if (PacientSelectPanel.this.dialog != null) {
                    PacientSelectPanel.this.dialog.dispose();
                }
                if (PacientSelectPanel.this.dialog != null) {
                    PacientSelectPanel.this.dialog.dispose();
                }
            }
        });
        ++c.gridx;
        this.add((Component)newClient, c);
        newClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PacientSelectPanel.this.selected = -1;
                PacientSelectPanel.this.mustAdd = true;
                if (PacientSelectPanel.this.dialog != null) {
                    PacientSelectPanel.this.dialog.dispose();
                }
            }
        });
        this.cnp.requestFocus();
    }
}

