/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.clinica;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.Calendar.MFieldListener;
import mseries.ui.MChangeEvent;
import mseries.ui.MChangeListener;
import mseries.ui.MDateEntryField;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.restaurant.clinicabase.ClinicaLogic;
import ro.atreides.restaurant.clinicabase.Medic;
import ro.atreides.restaurant.clinicabase.OraOk;
import ro.atreides.restaurant.gui.clinica.ClinicaViewCellRenderer;
import ro.atreides.restaurant.gui.clinica.IstoricClientPanel;
import ro.atreides.restaurant.gui.clinica.ProgramareEntry;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class ProgramPanel
extends ReflectedJPanel {
    private ClinicaLogic logic;
    private AbstractTM model;
    private AbstractTM convenabilModel;
    private JComboBox medic;
    private JComboBox specialitate;
    private JComboBox pacienti;
    private JComboBox medicFiltru;
    private JTextField consultatie;
    private JTextField durataText;
    private JRadioButton existent;
    private JTextField nume;
    private JTextField prenume;
    private JTextField telefonMobil;
    private JTextField dataNasterii;
    private JTextField telefonFix;
    private JTextField adresa;
    private JTextField cnp;
    private Date dataProgramare = new Date();
    private Date dataCurenta = new Date();
    private int idMedic = -1;
    private int idMedicFiltru = -1;
    private AbstractListPanel listPanel;

    public ProgramPanel() {
        this.logic = ClinicaLogic.getInstance();
    }

    @Override
    public void doStuff() {
        this.display();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        JSplitPane split = new JSplitPane(1);
        split.setLeftComponent(this.getLeftPanel());
        split.setRightComponent(this.getRightPanel());
        this.add((Component)split, c);
    }

    private JPanel getLeftPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        result.add((Component)this.getNavigarePanel(), c);
        ++c.gridy;
        result.add((Component)this.getFiltruPanel(), c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        result.add((Component)this.getTable(), c);
        if (Config.getInstance().getBoolean("clinicaProgramariShowSendSmsButton")) {
            c.gridx = 0;
            ++c.gridy;
            JButton trimiteSmsConfirmare = new JButton("Sms confirmare");
            trimiteSmsConfirmare.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ClinicaLogic.getInstance().trimiteSMS(ProgramPanel.this.listPanel.getTm().getData(), Formatters.DATE_FORMAT_RO.format(ProgramPanel.this.dataProgramare));
                }
            });
            result.add((Component)trimiteSmsConfirmare, c);
        }
        return result;
    }

    private JPanel getRightPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        result.add((Component)this.getProgramarePanel(), c);
        return result;
    }

    private JPanel getNavigarePanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        final MDateEntryField entryField = new MDateEntryField();
        entryField.setValue(new Date());
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 3;
        entryField.setConstraints((MDateSelectorConstraints)c1);
        entryField.addMFieldListener(new MFieldListener(){

            public void fieldEntered(FocusEvent e) {
            }

            public void fieldExited(FocusEvent e) {
                try {
                    ProgramPanel.this.dataCurenta = entryField.getValue();
                }
                catch (ParseException e1) {
                    ProgramPanel.this.dataCurenta = new Date();
                }
            }
        });
        entryField.addMChangeListener(new MChangeListener(){

            public void valueChanged(MChangeEvent arg0) {
                System.out.println("data : " + arg0);
            }
        });
        entryField.setToolTipText("Alege data");
        result.add((Component)new JLabel("Data"), c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)entryField, c);
        JButton cauta = new JButton("Mergi la zi");
        cauta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramPanel.this.model.refresh(ProgramPanel.this.logic.getProgramariForInterval(ProgramPanel.this.dataCurenta, ProgramPanel.this.idMedicFiltru));
            }
        });
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)cauta, c);
        result.setBorder(new TitledBorder("Navigare"));
        return result;
    }

    private JPanel getProgramarePanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        result.add((Component)new JLabel("Medic"), c);
        ++c.gridx;
        this.medic = new JComboBox();
        result.add((Component)this.medic, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Specialitate"), c);
        ++c.gridx;
        this.specialitate = new JComboBox();
        result.add((Component)this.specialitate, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Consultatie"), c);
        ++c.gridx;
        this.consultatie = new JTextField();
        result.add((Component)this.consultatie, c);
        ++c.gridy;
        c.gridx = 0;
        this.existent = new JRadioButton("Pacient existent");
        result.add((Component)this.existent, c);
        ++c.gridx;
        this.pacienti = new JComboBox();
        result.add((Component)this.pacienti, c);
        final MDateEntryField entryField = new MDateEntryField();
        entryField.setValue(new Date());
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 3;
        entryField.setConstraints((MDateSelectorConstraints)c1);
        entryField.addMFieldListener(new MFieldListener(){

            public void fieldEntered(FocusEvent e) {
            }

            public void fieldExited(FocusEvent e) {
                try {
                    ProgramPanel.this.dataProgramare = entryField.getValue();
                }
                catch (ParseException e1) {
                    ProgramPanel.this.dataProgramare = null;
                }
            }
        });
        entryField.setToolTipText("Alege data");
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.data), c);
        ++c.gridx;
        this.durataText = new JTextField(10);
        result.add((Component)entryField, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Durata(min)"), c);
        ++c.gridx;
        this.durataText = new JTextField(10);
        result.add((Component)this.durataText, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        JButton cauta = new JButton("Cauta");
        cauta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Medic m = (Medic)ProgramPanel.this.medic.getSelectedItem();
                int idMedic = m.getId();
                if (ProgramPanel.this.dataProgramare != null) {
                    ProgramPanel.this.convenabilModel.refresh(ProgramPanel.this.logic.orePosibile(ProgramPanel.this.dataProgramare, idMedic));
                }
            }
        });
        result.add((Component)cauta, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        c.weighty = 1.0;
        result.add((Component)this.getChoices(), c);
        this.logic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ProgramPanel.this.refreshCombo(ProgramPanel.this.medic, ProgramPanel.this.logic.getAllMedici());
            }

            @Override
            public String getName() {
                return "ProgramPanel_medici";
            }
        }, 71);
        NomeclaturaLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ProgramPanel.this.refreshCombo(ProgramPanel.this.specialitate, NomeclaturaLogic.getInstance().getCategorii());
            }

            @Override
            public String getName() {
                return "ProgramPanel_subcategories";
            }
        }, 1);
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ProgramPanel.this.refreshCombo(ProgramPanel.this.pacienti, ClientLogic.getInstance().getAllPersFiziceSorted());
            }

            @Override
            public String getName() {
                return "ProgramPanel_pacienti";
            }
        }, 41);
        this.refreshCombo(this.medic, this.logic.getAllMedici());
        this.refreshCombo(this.specialitate, NomeclaturaLogic.getInstance().getCategorii());
        this.refreshCombo(this.pacienti, ClientLogic.getInstance().getAllPersFiziceSorted());
        this.existent.setSelected(true);
        result.setBorder(new TitledBorder("Programare"));
        return result;
    }

    private JPanel getChoices() {
        AbstractListPanel result = new AbstractListPanel(){

            @Override
            public void doStuff() {
                this.display();
            }

            @Override
            public AbstractTM buildTableModel() {
                ProgramPanel.this.convenabilModel = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                        OraOk ora = (OraOk)data.elementAt(rowIndex);
                        String d = ProgramPanel.this.durataText.getText();
                        if (!Validators.correctInteger(d)) {
                            ProgramPanel.this.durataText.requestFocus();
                            return;
                        }
                        int idPacient = -1;
                        if (ProgramPanel.this.existent.isSelected()) {
                            ClientPersFizica cpf = (ClientPersFizica)ProgramPanel.this.pacienti.getSelectedItem();
                            idPacient = cpf.getIdPersFizica();
                        } else {
                            if (!Validators.correctString(ProgramPanel.this.nume.getText().trim())) {
                                ProgramPanel.this.nume.requestFocus();
                                return;
                            }
                            if (!Validators.correctString(ProgramPanel.this.prenume.getText().trim())) {
                                ProgramPanel.this.prenume.requestFocus();
                                return;
                            }
                            ProgramPanel.this.resetPacientNewPanel();
                        }
                        int durata = Integer.parseInt(d);
                        Categorie s = (Categorie)ProgramPanel.this.specialitate.getSelectedItem();
                        Medic m = (Medic)ProgramPanel.this.medic.getSelectedItem();
                        Date stop = DateUtils.addMinutesToDate(new Date(ora.getOra().getTime()), durata);
                        ProgramPanel.this.logic.addProgramare(m.getId(), idPacient, s.getId(), ora.getOra(), durata, new Timestamp(stop.getTime()), ProgramPanel.this.consultatie.getText());
                        ProgramPanel.this.consultatie.setText("");
                        ProgramPanel.this.convenabilModel.refresh(new Vector());
                        ProgramPanel.this.model.refresh(ProgramPanel.this.logic.getProgramariForInterval(ProgramPanel.this.dataCurenta, ProgramPanel.this.idMedicFiltru));
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return columnIndex != 0;
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        OraOk ok = (OraOk)data.elementAt(rowIndex);
                        switch (columnIndex) {
                            case 0: {
                                return Formatters.TIME_FORMAT.format(ok.getOra());
                            }
                            case 1: {
                                return new Boolean(false);
                            }
                        }
                        return null;
                    }
                });
                return ProgramPanel.this.convenabilModel;
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public Class[] buildTypes() {
                Class[] types = new Class[]{String.class, Boolean.class};
                return types;
            }

            @Override
            public Vector buildData() {
                if (ProgramPanel.this.dataProgramare != null && ProgramPanel.this.idMedic != -1) {
                    return ProgramPanel.this.logic.orePosibile(ProgramPanel.this.dataProgramare, ProgramPanel.this.idMedic);
                }
                return new Vector();
            }

            @Override
            public String[] buildColumns() {
                return new String[]{"Ora", "Convenabil"};
            }
        };
        result.doStuff();
        return result;
    }

    private JPanel getFiltruPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Medic"), c);
        ++c.gridx;
        this.medicFiltru = new JComboBox();
        result.add((Component)this.medicFiltru, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        JButton filtreaza = new JButton("Filtreaza");
        filtreaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Medic m = (Medic)ProgramPanel.this.medicFiltru.getSelectedItem();
                ProgramPanel.this.idMedicFiltru = m.getId();
                ProgramPanel.this.model.refresh(ProgramPanel.this.logic.getProgramariForInterval(ProgramPanel.this.dataCurenta, ProgramPanel.this.idMedicFiltru));
            }
        });
        result.add((Component)filtreaza, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        JButton reset = new JButton("Sterge Filtru");
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramPanel.this.idMedicFiltru = -1;
                ProgramPanel.this.medicFiltru.setSelectedIndex(0);
                ProgramPanel.this.model.refresh(ProgramPanel.this.logic.getProgramariForInterval(ProgramPanel.this.dataCurenta, ProgramPanel.this.idMedicFiltru));
            }
        });
        result.add((Component)reset, c);
        this.logic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "Program";
            }

            @Override
            public void dataChanged() {
                ProgramPanel.this.refreshComboFiltru();
            }
        }, 71);
        this.refreshComboFiltru();
        result.setBorder(new TitledBorder("Medici"));
        return result;
    }

    private void refreshComboFiltru() {
        this.medicFiltru.removeAllItems();
        Vector items = this.logic.getAllMedici();
        Medic elementMedic = new Medic(LangRoAll.toti, "", -1);
        this.medicFiltru.addItem(elementMedic);
        for (Object element : items) {
            this.medicFiltru.addItem(element);
        }
    }

    private void refreshCombo(JComboBox combo, Vector items) {
        combo.removeAllItems();
        for (Object element : items) {
            combo.addItem(element);
        }
    }

    private JPanel getTable() {
        this.listPanel = new AbstractListPanel(){

            @Override
            public void doStuff() {
                this.display();
            }

            @Override
            public AbstractTM buildTableModel() {
                ProgramPanel.this.model = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        ProgramareEntry pe = (ProgramareEntry)data.elementAt(rowIndex);
                        switch (columnIndex) {
                            case 0: {
                                return pe.getOra();
                            }
                            case 1: {
                                return pe.getMedic();
                            }
                            case 2: {
                                return pe.getPacient();
                            }
                            case 3: {
                                return pe.getSpecializare();
                            }
                            case 4: {
                                return pe.getConsultatie();
                            }
                        }
                        return null;
                    }
                });
                return ProgramPanel.this.model;
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public Class[] buildTypes() {
                return Utils.getStringClass(this.buildColumns().length);
            }

            @Override
            public Vector buildData() {
                return ProgramPanel.this.logic.getProgramariForInterval(new Date(), ProgramPanel.this.idMedicFiltru);
            }

            @Override
            public String[] buildColumns() {
                return new String[]{"Ora", "Medic", "Pacient", "Specializare", "Consultatie"};
            }
        };
        this.listPanel.doStuff();
        final JTable table = this.listPanel.getJTable();
        table.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final ProgramareEntry pe = (ProgramareEntry)ProgramPanel.this.model.getData().elementAt(selRow);
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem anuleaza = new JMenuItem("Anuleaza");
                JMenuItem tiparesteIntegral = new JMenuItem("Tipareste fisa integral");
                JMenuItem tiparesteSelectie = new JMenuItem("Tipareste fisa cu selectie");
                JMenuItem tiparesteIstoric = new JMenuItem("Istoric pacient");
                JMenuItem tiparesteProgramariMedic = new JMenuItem("Tipareste programari medic");
                popup.add(anuleaza);
                popup.add(tiparesteProgramariMedic);
                popup.add(tiparesteIstoric);
                popup.setInvoker(table);
                anuleaza.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ProgramPanel.this.logic.deleteProgramare(pe.getIdProgramare());
                        ProgramPanel.this.model.refresh(ProgramPanel.this.logic.getProgramariForInterval(ProgramPanel.this.dataCurenta, ProgramPanel.this.idMedicFiltru));
                        popup.setVisible(false);
                    }
                });
                tiparesteSelectie.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ProgramPanel.this.logic.printFoaieConsultatieCuSelectie(pe.getIdProgramare(), null);
                        ProgramPanel.this.model.refresh(ProgramPanel.this.logic.getProgramariForInterval(ProgramPanel.this.dataCurenta, ProgramPanel.this.idMedicFiltru));
                        popup.setVisible(false);
                    }
                });
                tiparesteIntegral.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ProgramPanel.this.logic.printFoaieConsultatieIntegral(pe.getIdProgramare(), null);
                        ProgramPanel.this.model.refresh(ProgramPanel.this.logic.getProgramariForInterval(ProgramPanel.this.dataCurenta, ProgramPanel.this.idMedicFiltru));
                        popup.setVisible(false);
                    }
                });
                tiparesteProgramariMedic.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ProgramPanel.this.logic.printProgramariMedic(ProgramPanel.this.idMedicFiltru, ProgramPanel.this.dataCurenta);
                        ProgramPanel.this.model.refresh(ProgramPanel.this.logic.getProgramariForInterval(ProgramPanel.this.dataCurenta, ProgramPanel.this.idMedicFiltru));
                        popup.setVisible(false);
                    }
                });
                tiparesteIstoric.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        ClientPersFizica cpf = (ClientPersFizica)ClientLogic.getInstance().getClientById(pe.getIdPacient());
                        IstoricClientPanel icp = new IstoricClientPanel(cpf);
                        JDialog dialog = DialogUtils.getJDialog(icp, GuiUtils.currentFrame, "Istoric pacient", 1.1);
                        dialog.setVisible(true);
                    }
                });
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        GuiUtils.updateJTableColumns(table, new ClinicaViewCellRenderer(this.model));
        return this.listPanel;
    }

    private void resetPacientNewPanel() {
        this.nume.setText("");
        this.prenume.setText("");
        this.telefonMobil.setText("");
        this.telefonFix.setText("");
        this.dataNasterii.setText("");
        this.adresa.setText("");
        this.cnp.setText("");
    }
}

