/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.erpsales;

import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.gui.livrari.LivrariTableModel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.valute.ValuteLogic;

public class ErpLivrariTableModel
extends LivrariTableModel {
    @Override
    protected void set_columnNamesAndClass() {
        this._columnNames = new String[]{LangRoAll.produs, LangRoAll.cantitate, LangRoAll.valoare, LangRoAll.valute};
        this._columnTypes = new Class[]{String.class, String.class, String.class, String.class};
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this._sales == null) {
            return null;
        }
        if (rowIndex > this._sales.size() || rowIndex < 0 || columnIndex < 0 || columnIndex >= this._columnNames.length) {
            return null;
        }
        String s = "";
        Sale o = (Sale)this._sales.elementAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                String s2 = o.getProductName();
                String mp = o.getModPreparare();
                s = "<html><b>" + s2 + "</b><br/><i>(" + mp + " )</i></html>";
                break;
            }
            case 1: {
                s = s + o.getQuantity();
                break;
            }
            case 2: {
                s = s + Utils.getStringXDecimals(o.getTotal(), VpConfig.getInstance().frontOfficeRoundDecimals);
                break;
            }
            case 3: {
                s = s + ValuteLogic.getInstance().getValutaFromProduct(o.getIdProduct());
            }
        }
        return s;
    }
}

