/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.erpsales;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.gui.ClientEditDialog;
import ro.atreides.clienti.gui.ClientEditPanelProvider;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.gui.erpsales.ErpSalesOrderPanel;
import ro.atreides.restaurant.gui.livrari.ClientButtonPressedInterface;
import ro.atreides.restaurant.gui.livrari.LivrariMainPanel;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Legenda;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;

public class ErpMainPanel
extends LivrariMainPanel {
    private Hashtable currentOrdersInTableHash = new Hashtable();

    @Override
    protected void buildOrderPanel() {
        this.orderPanel = new ErpSalesOrderPanel(this.logic, this, VpConfig.getInstance(), sectii, autoMarcaj, deleteAllPlateau, marcajOnly);
    }

    @Override
    protected JPanel getOpenOrdersPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        result.add((Component)this.getSortButtonsPanel(), c);
        ++c.gridy;
        c.weighty = 1.0;
        this.tm = new AbstractTM(new String[]{"Comenzi in lucru"}, new Class[]{String.class}, new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Order o = (Order)data.get(rowIndex);
                int idCLient = o.getIdClient();
                long started = o.getStartTime();
                Timestamp d = new Timestamp(started);
                Timestamp now = DateUtils.getCurrentTimestamp();
                String dateAndTime = "<html>";
                dateAndTime = DateUtils.sameDay(d, now) ? dateAndTime + Formatters.TIME_FORMAT.format(d) : dateAndTime + Formatters.SHORT_DATE_AND_TIME_FORMAT.format(d);
                String client = o.getId() + " ";
                if (idCLient > 0) {
                    Client c = ClientLogic.getInstance().getClientById(idCLient);
                    if (c != null) {
                        dateAndTime = dateAndTime + " " + o.getAdresaLivrare() + "<br>";
                        client = client + c.toString();
                        dateAndTime = dateAndTime + " " + client;
                    }
                    dateAndTime = dateAndTime + " = " + Utils.getString2Decimals(ErpMainPanel.this.logic.getTotal(o));
                    dateAndTime = dateAndTime + "</html>";
                }
                return dateAndTime;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        this.ordersTable = new JTable(this.tm);
        this.ordersTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                Order o = (Order)ErpMainPanel.this.tm.getObjectAt(selRow);
                Order dbOrder = RestLogic.getInstance().getOrderById(o.getId());
                ErpMainPanel.this.selectOrder(dbOrder, false, false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        final Font f = this.ordersTable.getFont();
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Order order1 = (Order)ErpMainPanel.this.tm.getData().get(row);
                if (order1.getUser() == ErpMainPanel.this.currentUser.getId()) {
                    this.setFont(new Font(null, 1, f.getSize()));
                } else {
                    this.setFont(new Font(null, 0, f.getSize()));
                }
                Color c = null;
                switch (order1.getStatus()) {
                    case 1: {
                        if (ErpMainPanel.this.logic.isOrderGataDeLivrare(order1)) {
                            c = Color.RED;
                            break;
                        }
                        c = Color.BLACK;
                        break;
                    }
                    case 6: {
                        c = Color.MAGENTA;
                        break;
                    }
                    case 5: {
                        if (ErpMainPanel.this.logic.isOrderGataDeLivrare(order1)) {
                            c = Color.RED;
                            break;
                        }
                        c = Color.BLUE;
                        break;
                    }
                }
                this.setForeground(c);
                return this;
            }
        };
        TableColumnModel colModel = this.ordersTable.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(cellRenderer);
        }
        GuiUtils.updateJTableRowSize(this.ordersTable, (int)((double)VpConfig.getInstance().touchTableFontSize * 1.5));
        JScrollPane scroll = new JScrollPane(this.ordersTable, 20, 30);
        result.add((Component)scroll, c);
        return result;
    }

    private JPanel getSortButtonsPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("fill"));
        JButton cerereButton = new JButton("Cereri");
        JButton oferteButton = new JButton("Oferte");
        JButton comandaFermaButton = new JButton("Comenzi ferme");
        JButton gataDeLivrare = new JButton("Gata de livrare");
        final JTextField idSearchField = new JTextField();
        JButton search = new JButton("Search");
        Legenda legenda = new Legenda(new String[]{"Cereri", "Oferte", "Comenzi ferme", "Gata de livrare"}, new Color[]{Color.BLACK, Color.MAGENTA, Color.BLUE, Color.RED});
        cerereButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErpMainPanel.this.refreshTableWithFilteredData(1, false);
                ErpMainPanel.this.clearRightComponent();
            }
        });
        oferteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErpMainPanel.this.refreshTableWithFilteredData(6, false);
                ErpMainPanel.this.clearRightComponent();
            }
        });
        comandaFermaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErpMainPanel.this.refreshTableWithFilteredData(5, false);
                ErpMainPanel.this.clearRightComponent();
            }
        });
        gataDeLivrare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErpMainPanel.this.refreshTableWithFilteredData(1, true);
                ErpMainPanel.this.clearRightComponent();
            }
        });
        search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String idText = idSearchField.getText();
                if (Validators.correctInteger(idText)) {
                    String idOrderText = idSearchField.getText();
                    if (Validators.correctInteger(idOrderText)) {
                        Integer idOrder = Integer.valueOf(idOrderText);
                        Vector ordersFound = new Vector();
                        ordersFound.add(ErpMainPanel.this.currentOrdersInTableHash.get(idOrder));
                        ErpMainPanel.this.tm.refresh(ordersFound);
                        idSearchField.setText("");
                    }
                    ErpMainPanel.this.clearRightComponent();
                } else if (idText.isEmpty()) {
                    ErpMainPanel.this.refreshTableWithFilteredData(-1, false);
                }
                ErpMainPanel.this.clearRightComponent();
            }
        });
        result.add((Component)legenda, "growx, spany 4");
        result.add((Component)cerereButton, "grow, wrap");
        result.add((Component)oferteButton, "grow, wrap");
        result.add((Component)comandaFermaButton, "grow, wrap");
        result.add((Component)gataDeLivrare, "grow, wrap");
        result.add((Component)idSearchField, "grow");
        result.add((Component)search, "grow, wrap");
        result.setBorder(new TitledBorder("Filtre"));
        return result;
    }

    private void buildSearchableOrdersHash(Vector orders) {
        for (Object obj : orders) {
            if (!(obj instanceof Order)) continue;
            Order o = (Order)obj;
            this.currentOrdersInTableHash.put(o.getId(), o);
        }
    }

    private Hashtable buildCriteriaForFilters() {
        Hashtable<String, Serializable> criteria = new Hashtable<String, Serializable>();
        criteria.put(Constants.CLIENT_KEY, Integer.valueOf(this.idClient));
        criteria.put("user", Integer.valueOf(-1));
        if (this.locations.size() > 0) {
            Vector<Integer> locationsId = new Vector<Integer>();
            for (Object obj : this.locations) {
                Location loc = (Location)obj;
                locationsId.add(loc.getId());
            }
            criteria.put(Constants.LOCATIE_KEY, locationsId);
        }
        return criteria;
    }

    private void refreshTableWithFilteredData(int status, boolean forLivrare) {
        Hashtable criteria = this.buildCriteriaForFilters();
        criteria.put(Constants.STATUS, status);
        Vector<Order> filteredOrders = this.logic.getFilteredOrders(criteria);
        if (forLivrare) {
            Vector<Order> gataDeLivrareOrders = this.logic.getGataDeLivrareOrders(filteredOrders);
            filteredOrders.removeAllElements();
            filteredOrders.addAll(gataDeLivrareOrders);
        }
        this.tm.refresh(filteredOrders);
        this.buildSearchableOrdersHash(filteredOrders);
    }

    public Vector<Order> getAllOrders() {
        Hashtable criteria = this.buildCriteriaForFilters();
        criteria.put(Constants.STATUS, -1);
        Vector<Order> filteredOrders = this.logic.getFilteredOrders(criteria);
        return filteredOrders;
    }

    @Override
    protected Vector<Order> refreshOrders(Order o, boolean fromMarcaj, boolean fromRefresh) {
        Vector<Order> orders = this.getAllOrders();
        this.tm.refresh(orders);
        this.selectOrder(o, fromMarcaj, fromRefresh);
        this.buildSearchableOrdersHash(orders);
        return orders;
    }

    private void clearRightComponent() {
        this.split.setRightComponent(this.emptyPanel);
    }

    @Override
    protected void showClientSelectDialog(ClientButtonPressedInterface inter, String callerId, String adresa, String numeAdd, String emailAdd, Component parent, Order order) {
        super.showClientSelectDialog(inter, callerId, adresa, numeAdd, emailAdd, parent, order);
        this.adressPromotion(order);
    }

    @Override
    protected void doComandaNoua() {
        super.doComandaNoua();
        if (this.idClient != -1) {
            this.adressPromotion(this.orderPanel.getOrder());
        } else {
            this.orderPanel.doOrderPanelClientSelectDialog(this.orderPanel);
        }
    }

    private void adressPromotion(Order order) {
        if (order.getIdClient() != -1) {
            Vector<Promotion> promotiiClient = PromotionLogic.getInstance().getPromotiiForClientByIdClientV2(order.getIdClient());
            if (promotiiClient.size() > 0) {
                if (promotiiClient.size() > 1) {
                    Object obj = DialogUtils.getItemChooserDialog(promotiiClient, 4, false);
                    if (obj != null) {
                        Promotion p = (Promotion)obj;
                        order.setIdPromotie(p.getId());
                        RestLogic.getInstance().setPromotionForOrder(order, p.getId());
                    }
                } else {
                    Promotion p = promotiiClient.get(0);
                    order.setIdPromotie(p.getId());
                    RestLogic.getInstance().setPromotionForOrder(order, p.getId());
                }
            }
            this.orderPanel.setPromotionText();
        }
    }

    @Override
    protected void selectOrder(Order o, boolean fromMarcaj, boolean fromRefresh) {
        super.selectOrder(o, fromMarcaj, fromRefresh);
        this.orderPanel.readyForIncasat();
    }

    @Override
    protected ClientEditDialog getClientEditDialogGeneric(JFrame parent, ClientLogic logic, Client client, boolean persJuridica, ClientEditPanelProvider panelProvider, String telefonMobil, String adresa, String numeAdd, String emailAdd) {
        return new ClientEditDialog(parent, logic, client, true, panelProvider, telefonMobil, adresa, numeAdd, emailAdd);
    }
}

