/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.erpsales;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.ColumnSizeProvider;
import ro.atreides.utils.multilang.LangRoAll;

public class ErpSalesTableModel
extends AbstractTableModel
implements ColumnSizeProvider {
    protected String[] _columnNames = new String[]{LangRoAll.produs, LangRoAll.cantitate, LangRoAll.valoare};
    protected Class[] _columnTypes = new Class[]{String.class, String.class, String.class};
    protected Vector _sales = new Vector();

    public void updateTable(Vector data) {
        if (data == null) {
            throw new NullPointerException("data might not be null");
        }
        this._sales = data;
        this.fireTableDataChanged();
    }

    public void clear() {
        this.updateTable(new Vector());
    }

    @Override
    public int getColumnCount() {
        return this._columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this._sales == null) {
            return 0;
        }
        return this._sales.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this._sales == null) {
            return null;
        }
        if (rowIndex > this._sales.size() || rowIndex < 0 || columnIndex < 0 || columnIndex >= this._columnNames.length) {
            return null;
        }
        String s = "";
        Sale o = (Sale)this._sales.elementAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                String s2 = o.getProductName();
                String mp = o.getModPreparare();
                if (Validators.correctString(mp)) {
                    s2 = s2 + " (" + mp + ")";
                }
                s = s + s2;
                break;
            }
            case 1: {
                s = s + o.getQuantity();
                break;
            }
            case 2: {
                s = s + Utils.getString2Decimals(o.getTotal());
                break;
            }
        }
        return s;
    }

    public Sale getEntryAtRow(int row) {
        return (Sale)this._sales.elementAt(row);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex >= this._columnTypes.length) {
            return String.class;
        }
        return this._columnTypes[columnIndex];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex >= this._columnNames.length) {
            return "";
        }
        return this._columnNames[columnIndex];
    }

    public double getTotal() {
        double result = 0.0;
        for (Sale element : this._sales) {
            result += element.getTotal();
        }
        return result;
    }

    public void addSale(Sale s) {
        this._sales.add(s);
        int lastRow = this.getRowCount() - 1;
        this.fireTableRowsInserted(lastRow, lastRow + 1);
    }

    public Vector getAllSales() {
        return this._sales;
    }

    public void removeTempSale(Sale entry, int index) {
        if (entry.isEmpty()) {
            this._sales.remove(index);
        }
    }

    @Override
    public int getColumnSize(int column) {
        switch (column) {
            case 0: {
                return 7;
            }
        }
        return 1;
    }
}

