/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.fastsale;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.restaurant.gui.touch.TouchOrderColorProvider;
import ro.atreides.restaurant.gui.touch.TouchOrderTableModel;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Order;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.keypad.KeypadListener;
import ro.atreides.utils.gui.keypad.VirtualKeypad;
import ro.atreides.utils.gui.selector.DataProvider;
import ro.atreides.utils.gui.selector.Selector;
import ro.atreides.utils.gui.table.CustomCellRenderer;
import ro.atreides.utils.multilang.LangRoAll;

public class FastSaleMain
extends ReflectedJPanel
implements CleanupRequired {
    private Table table;
    private Order order;
    private User waiter;
    private RestLogic logic;
    private Product produsCurent;
    private JLabel selectie;
    private JLabel total;
    private TouchOrderTableModel tm;
    private Sale entry;
    private VpConfig config;
    private Insets insets = new Insets(1, 1, 1, 1);
    private double cantitateCurenta = 0.0;
    public static Vector sectii;
    private Vector sections;

    public FastSaleMain() {
        this.logic = RestLogic.getInstance();
        this.config = VpConfig.getInstance();
        Vector<Table> tables = this.logic.getTables();
        if (tables.size() > 0) {
            this.table = tables.get(0);
        } else {
            DialogUtils.errorDialog(this, "Adaugati o masa", LangRoAll.nuPotContinua);
        }
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JPanel notaPanel = this.getNotaPanel();
        this.add((Component)notaPanel, c);
        c.gridx = 1;
        c.weightx = 0.0;
        JPanel keypad = this.getKeypad();
        this.add((Component)keypad, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        Selector produse = this.getProdusePanel();
        this.add((Component)produse, c);
        int rightWidth = 250;
        int topHeight = 470;
        int bottomHeight = this.config.frameHeight - topHeight;
        keypad.setPreferredSize(new Dimension(rightWidth, topHeight));
        produse.setPreferredSize(new Dimension(this.config.frameWidth, bottomHeight));
    }

    private Selector getProdusePanel() {
        DataProvider simpleDataProvider = new DataProvider(){

            @Override
            public Vector getData(int level, Object selection) {
                switch (level) {
                    case 0: {
                        return FastSaleMain.this.getProductsRow();
                    }
                    case 1: {
                        FastSaleMain.this.productChosen(selection);
                        return null;
                    }
                }
                return new Vector();
            }
        };
        Selector sel = new Selector(simpleDataProvider, this.config.touchSelectorFontSize, this.config.selectorShowStartButton, this.config.touchSelectorItemsPerLine, this.config.touchSelectorLinesPerPage, this.config.selectorHtmlButtons);
        return sel;
    }

    private void productChosen(Object selection) {
        Product p = (Product)selection;
        if (!p.equals(this.produsCurent)) {
            this.cantitateCurenta = 0.0;
        }
        this.produsCurent = p;
        this.entry = null;
        this.cantitateCurenta += 1.0;
        String string = Utils.getString3Decimals(this.cantitateCurenta);
        this.setSelectie(this.selectie, string);
    }

    private Vector getProductsRow() {
        Vector products = new Vector();
        for (int i = 0; i < this.sections.size(); ++i) {
            Sectie o = (Sectie)this.sections.elementAt(i);
            Vector currentProducts = NomeclaturaLogic.getInstance().getProductsForSectie(o);
            products.addAll(currentProducts);
        }
        return products;
    }

    private JPanel getKeypad() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.selectie = new JLabel();
        this.selectie.setFont(new Font(null, 1, this.config.touchKeypadFontSize));
        this.selectie.setForeground(Color.RED);
        result.add((Component)this.selectie, c);
        ++c.gridy;
        result.add((Component)new JLabel(""), c);
        final FastSaleMain panel = this;
        ++c.gridy;
        VirtualKeypad kp = new VirtualKeypad(VpConfig.getInstance().touchSelectorFontSize);
        kp.addKeypadListener(new KeypadListener(){

            @Override
            public void keypadPressed(int digit) {
                String temp = Utils.getString3Decimals(FastSaleMain.this.cantitateCurenta) + digit;
                try {
                    FastSaleMain.this.cantitateCurenta = Integer.parseInt(temp);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                temp = Utils.getString3Decimals(FastSaleMain.this.cantitateCurenta);
                FastSaleMain.this.setSelectie(FastSaleMain.this.selectie, temp);
            }

            @Override
            public void enterPressed() {
            }

            @Override
            public void okPressed() {
                if (FastSaleMain.this.waiter == null) {
                    User u = UsersLogic.getInstance().requestWaiterLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, VpConfig.getInstance().requestPasswordForWaitersSelection);
                }
                if (FastSaleMain.this.waiter == null) {
                    DialogUtils.errorDialog(panel, LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
                    return;
                }
                if (FastSaleMain.this.entry == null) {
                    if (FastSaleMain.this.cantitateCurenta == 0.0) {
                        return;
                    }
                    if (FastSaleMain.this.produsCurent != null) {
                        long now = System.currentTimeMillis();
                        String modPreparare = "";
                        Sale s = FastSaleMain.this.logic.buildSale(FastSaleMain.this.produsCurent, 0.0, FastSaleMain.this.cantitateCurenta, modPreparare, -1, -1, -1, -1, -1, now, 0);
                        FastSaleMain.this.tm.addSale(s);
                    }
                } else {
                    FastSaleMain.this.entry.setCantitateNoua(FastSaleMain.this.cantitateCurenta);
                    FastSaleMain.this.tm.removeTempSale(FastSaleMain.this.entry);
                    FastSaleMain.this.tm.fireTableDataChanged();
                }
                FastSaleMain.this.produsCurent = null;
                FastSaleMain.this.entry = null;
                FastSaleMain.this.cantitateCurenta = 0.0;
                FastSaleMain.this.setSelectie(FastSaleMain.this.selectie, "");
                FastSaleMain.this.updateTotal();
            }

            @Override
            public void backspace() {
                FastSaleMain.this.eraseQuantity();
            }

            @Override
            public void decimalPressed() {
            }
        });
        result.add((Component)kp, c);
        return result;
    }

    private Order createOrderIfNull() {
        if (this.order == null) {
            this.order = this.logic.newOrder(this.table.getId(), this.waiter.getId());
        }
        return this.order;
    }

    private void eraseQuantity() {
        this.cantitateCurenta = 0.0;
        String t = Utils.getString3Decimals(this.cantitateCurenta);
        this.setSelectie(this.selectie, t);
    }

    private void setSelectie(JLabel selectie, String temp) {
        String prodString = "";
        if (this.produsCurent != null) {
            prodString = this.produsCurent.getName();
        }
        String selText = temp + " * " + prodString;
        selectie.setText(selText);
    }

    private void updateTotal() {
        String newTotal = Utils.getString2Decimals(this.tm.getTotal());
        this.total.setText(newTotal);
    }

    private JPanel getNotaPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.tm = new TouchOrderTableModel();
        JTable table = new JTable(this.tm);
        table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                int selRow = source.rowAtPoint(e.getPoint());
                if (selRow != -1) {
                    FastSaleMain.this.entry = FastSaleMain.this.tm.getEntryAtRow(selRow);
                    FastSaleMain.this.cantitateCurenta = 0.0;
                    if (FastSaleMain.this.entry.getCantitateNoua() != 0.0) {
                        FastSaleMain.this.cantitateCurenta = FastSaleMain.this.entry.getCantitateNoua();
                    } else if (!FastSaleMain.this.order.isLaPlata()) {
                        FastSaleMain.this.cantitateCurenta = 0.0;
                    }
                    String t = Utils.getString3Decimals(FastSaleMain.this.cantitateCurenta);
                    FastSaleMain.this.setSelectie(FastSaleMain.this.selectie, t);
                }
            }
        });
        TouchOrderColorProvider touchColor = new TouchOrderColorProvider(this.tm);
        CustomCellRenderer cellRender = new CustomCellRenderer(touchColor, this.tm);
        TableColumnModel colModel = table.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(cellRender);
        }
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        JScrollPane scroll = new JScrollPane(table);
        result.add((Component)scroll, c);
        c.gridy = 1;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.anchor = 17;
        result.add((Component)this.buildButtonsPanel(), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.anchor = 13;
        result.add((Component)this.buildTotalPanel(), c);
        return result;
    }

    private JPanel buildButtonsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = this.insets;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        final FastSaleMain panel = this;
        if (VpConfig.getInstance().showSearaButton) {
            JButton seara = new JButton("<html><center><b>Seara</b><br></center></html>");
            seara.setFont(new Font(null, 1, this.config.touchSelectorFontSize));
            seara.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    GuiUtilsRest.searaButtonPressed(panel, FastSaleMain.this.logic, 1, null);
                }
            });
            result.add((Component)seara, c);
        }
        result.setBorder(new TitledBorder("-"));
        return result;
    }

    private JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = this.insets;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        JLabel totalLabel = new JLabel(LangRoAll.total);
        totalLabel.setFont(new Font(null, 1, this.config.touchSelectorFontSize));
        result.add((Component)totalLabel, c);
        ++c.gridx;
        this.total = new JLabel("");
        this.total.setFont(new Font(null, 1, this.config.touchSelectorFontSize));
        result.add((Component)this.total, c);
        c.weightx = 1.0;
        c.anchor = 10;
        ++c.gridx;
        JButton nota = new JButton("<html><center><b>Nota</b><br></center></html>");
        nota.setFont(new Font(null, 1, this.config.touchSelectorFontSize));
        nota.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector categories = FastSaleMain.this.logic.getSectii();
                FastSaleMain.this.createOrderIfNull();
                for (Sectie element : categories) {
                    Vector<Sale> toAdd = FastSaleMain.this.logic.getTemporarySalesForCategory(element, FastSaleMain.this.tm.getAllSales());
                    if (toAdd.size() <= 0) continue;
                    FastSaleMain.this.logic.productsSold(toAdd, FastSaleMain.this.order, FastSaleMain.this.table, element, false, null);
                }
                Vector<Sale> s = FastSaleMain.this.logic.getSales(FastSaleMain.this.order.getId(), false, -1, new ScreenSaleInterface());
                FastSaleMain.this.tm.updateTable(s);
                FastSaleMain.this.logic.laPlataOrder(FastSaleMain.this.order, FastSaleMain.this.table, null);
                FastSaleMain.this.logic.printBonFiscalSeparat(FastSaleMain.this.order, true);
                FastSaleMain.this.logic.closeOrder(FastSaleMain.this.order);
                FastSaleMain.this.tm.clear();
                FastSaleMain.this.updateTotal();
                FastSaleMain.this.order = null;
            }
        });
        nota.setForeground(Color.RED);
        result.add((Component)nota, c);
        c.weightx = 1.0;
        c.anchor = 10;
        ++c.gridx;
        JButton proto = new JButton("<html><center><b>Protocol</b><br></center></html>");
        proto.setFont(new Font(null, 1, this.config.touchSelectorFontSize));
        proto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector categories = FastSaleMain.this.logic.getSectii();
                FastSaleMain.this.createOrderIfNull();
                for (Sectie element : categories) {
                    Vector<Sale> toAdd = FastSaleMain.this.logic.getTemporarySalesForCategory(element, FastSaleMain.this.tm.getAllSales());
                    if (toAdd.size() <= 0) continue;
                    FastSaleMain.this.logic.productsSold(toAdd, FastSaleMain.this.order, FastSaleMain.this.table, element, false, null);
                }
                Vector<Sale> s = FastSaleMain.this.logic.getSales(FastSaleMain.this.order.getId(), false, -1, new ScreenSaleInterface());
                FastSaleMain.this.tm.updateTable(s);
                FastSaleMain.this.logic.setProtocolForOrder(FastSaleMain.this.order, true);
                FastSaleMain.this.order.setProtocol(true);
                FastSaleMain.this.logic.laPlataOrder(FastSaleMain.this.order, FastSaleMain.this.table, null);
                FastSaleMain.this.logic.closeOrder(FastSaleMain.this.order);
                FastSaleMain.this.tm.clear();
                FastSaleMain.this.updateTotal();
                FastSaleMain.this.order = null;
            }
        });
        proto.setForeground(Color.GREEN);
        result.add((Component)proto, c);
        result.setBorder(new TitledBorder("-"));
        return result;
    }

    @Override
    public void doStuff() {
        this.sections = sectii.size() > 0 ? this.logic.getSectiiInSet(sectii) : this.logic.getSectii();
        this.display();
    }

    @Override
    public void cleanup() {
    }
}

