/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.festive;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.gui.festive.FestiveEntry;
import ro.atreides.restaurant.gui.festive.FestiveProductEntry;
import ro.atreides.restaurant.gui.festive.Servire;
import ro.atreides.restaurant.logic.FestiveLogic;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.SwitchToList;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class FestiveEditPanel
extends ReflectedJPanel {
    private FestiveLogic logic = FestiveLogic.getInstance();
    private JComboBox clienti;
    private JComboBox produse;
    private JComboBox feluri;
    private JTextField pret;
    private JTextField time;
    private JTextField cantitate;
    private JButton adaugaProdus;
    private JButton salveaza;
    private JButton inapoi;
    private JButton print;
    private MDateEntryField data;
    private JLabel total;
    private JLabel profit;
    private JLabel cost;
    private double totalFloat;
    private double profitFloat;
    private double costFloat;
    private SwitchToList action;
    private FestiveEntry eveniment;
    private AbstractTM itemsTm;
    public static final String[] columns = new String[]{LangRoAll.servire, LangRoAll.produs, LangRoAll.cantitate, LangRoAll.pret, LangRoAll.valoare};

    public FestiveEditPanel() {
        this.init();
    }

    @Override
    public void doStuff() {
    }

    public void setEveniment(FestiveEntry f) {
        this.eveniment = f;
        Vector newData = this.logic.getDataForEveniment(f.getIdEvent());
        this.itemsTm.refresh(newData);
        this.updateTotals();
        this.inapoi.setEnabled(true);
        this.total.setText(Utils.getString2Decimals(this.eveniment.getTotal()));
        this.profit.setText(Utils.getString2Decimals(this.eveniment.getProfit()));
        this.cost.setText(Utils.getString2Decimals(this.eveniment.getCost()));
        this.clienti.setSelectedItem(ClientLogic.getInstance().getClientById(this.eveniment.getIdClient()));
        this.data.setValue((Date)this.eveniment.getData());
    }

    public void setAction(SwitchToList action) {
        this.action = action;
    }

    private void init() {
        this.feluri = new JComboBox();
        this.produse = new JComboBox();
        this.clienti = new JComboBox();
        this.itemsTm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FestiveProductEntry e = (FestiveProductEntry)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return e.getServire();
                    }
                    case 1: {
                        return e.getProdus();
                    }
                    case 2: {
                        return Utils.getString3Decimals(e.getCantitate());
                    }
                    case 3: {
                        return Utils.getString2Decimals(e.getPret());
                    }
                    case 4: {
                        return Utils.getString2Decimals(e.getValoare());
                    }
                }
                return null;
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)this.getTopPanel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        JPanel buttons = this.getButtonsPanel();
        this.add((Component)buttons, c);
        this.refreshClientiCombo();
        this.refreshProduseCombo();
        this.refreshFeluriCombo();
        RestLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                FestiveEditPanel.this.refreshProduseCombo();
            }

            @Override
            public String getName() {
                return "FestiveEditPanelProductsChanged";
            }
        }, 2);
        this.logic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                FestiveEditPanel.this.refreshFeluriCombo();
            }

            @Override
            public String getName() {
                return "FestiveEditPanelFeluriChanged";
            }
        }, 2);
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                FestiveEditPanel.this.refreshClientiCombo();
            }

            @Override
            public String getName() {
                return "FestiveEditPanelPFChangedChanged";
            }
        }, 41);
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                FestiveEditPanel.this.refreshClientiCombo();
            }

            @Override
            public String getName() {
                return "FestiveEditPanelPJChangedChanged";
            }
        }, 42);
        this.itemsTm.refresh(new Vector());
    }

    private JPanel getTopPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        JPanel dateFactura = this.getEventPanel();
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)dateFactura, c);
        c.weightx = 1.0;
        JPanel dateProdus = this.getProdusPanel();
        ++c.gridx;
        result.add((Component)dateProdus, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JPanel nirTable = this.getNirTablePanel();
        result.add((Component)nirTable, c);
        return result;
    }

    private JPanel getEventPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Eveniment"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        c.gridx = 1;
        c.gridwidth = 2;
        result.add((Component)this.clienti, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.data), c);
        c.gridx = 1;
        c.gridwidth = 1;
        this.data = new MDateEntryField();
        this.data.setValue(new Date());
        this.data.setEditable(false);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 3;
        this.data.setConstraints((MDateSelectorConstraints)c1);
        this.data.setToolTipText("Alege data");
        result.add((Component)this.data, c);
        ++c.gridx;
        this.time = new JTextField();
        this.time.setText("00:00");
        result.add((Component)this.time, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Total cu tva"), c);
        ++c.gridx;
        this.total = new JLabel();
        result.add((Component)this.total, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Profit cu tva"), c);
        ++c.gridx;
        this.profit = new JLabel();
        result.add((Component)this.profit, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Cost cu tva"), c);
        ++c.gridx;
        this.cost = new JLabel();
        result.add((Component)this.cost, c);
        return result;
    }

    private void updateTotals() {
        double[] totaluri = this.logic.computeValoareEveniment(this.itemsTm.getData());
        this.totalFloat = totaluri[0];
        this.costFloat = totaluri[1];
        this.profitFloat = totaluri[2];
        this.total.setText(Utils.getString2Decimals(this.totalFloat));
        this.cost.setText(Utils.getString2Decimals(this.costFloat));
        this.profit.setText(Utils.getString2Decimals(this.profitFloat));
    }

    private void refreshClientiCombo() {
        Vector c = ClientLogic.getInstance().getAllClientsSorted();
        Collections.sort(c, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        ComboUtils.replaceItemsForCombo(this.clienti, (Collection)c, false);
    }

    private void refreshProduseCombo() {
        Vector<Product> c = NomeclaturaLogic.getInstance().getAllProducts(-1);
        Collections.sort(c, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        ComboUtils.replaceItemsForCombo(this.produse, c, false);
    }

    private void refreshFeluriCombo() {
        Vector c = this.logic.getFeluri();
        Collections.sort(c, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        ComboUtils.replaceItemsForCombo(this.feluri, (Collection)c, false);
    }

    private JPanel getButtonsPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        this.print = new JButton("Tipareste");
        this.print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FestiveEditPanel.this.printEvent();
            }
        });
        result.add((Component)this.print, c);
        ++c.gridx;
        this.salveaza = new JButton(LangRoAll.salveaza);
        this.salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FestiveEditPanel.this.saveEvent();
            }
        });
        result.add((Component)this.salveaza, c);
        ++c.gridx;
        this.inapoi = new JButton(LangRoAll.inapoi);
        this.inapoi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FestiveEditPanel.this.inapoi.setEnabled(false);
                FestiveEditPanel.this.action.doAction();
            }
        });
        this.inapoi.setEnabled(false);
        result.add((Component)this.inapoi, c);
        return result;
    }

    private void printEvent() {
        Client f = (Client)this.clienti.getSelectedItem();
        Date d = DateUtils.setTimeToDate((Component)this, this.data, this.time);
        if (d == null) {
            return;
        }
        Timestamp dataEveniment = new Timestamp(d.getTime());
        Vector items = this.itemsTm.getData();
        final Hashtable<String, Comparable> printCriteria = new Hashtable<String, Comparable>();
        printCriteria.put(LangRoAll.client, f);
        printCriteria.put(LangRoAll.data, dataEveniment);
        PrintLogic.getInstance().printReport(this, new ReportInterface(){

            @Override
            public String getCellContent(Object row, int column) {
                FestiveProductEntry e = (FestiveProductEntry)row;
                switch (column) {
                    case 0: {
                        return e.getServire();
                    }
                    case 1: {
                        return e.getProdus();
                    }
                    case 2: {
                        return Utils.getString3Decimals(e.getCantitate());
                    }
                    case 3: {
                        return Utils.getString2Decimals(e.getPret());
                    }
                    case 4: {
                        return Utils.getString2Decimals(e.getValoare());
                    }
                }
                return null;
            }

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 1;
                    }
                    case 4: {
                        return 2;
                    }
                }
                return 1;
            }

            @Override
            public Hashtable getCriteria() {
                return printCriteria;
            }

            @Override
            public String getReportTitle() {
                return "Detalii eveniment";
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 4: {
                        return Utils.getString2Decimals(FestiveEditPanel.this.totalFloat);
                    }
                }
                return "";
            }

            @Override
            public boolean isLandscape() {
                return false;
            }
        }, items);
    }

    private void saveEvent() {
        Client f = (Client)this.clienti.getSelectedItem();
        int idClient = f.getId();
        Date d = DateUtils.setTimeToDate((Component)this, this.data, this.time);
        if (d == null) {
            return;
        }
        Timestamp dataEveniment = new Timestamp(d.getTime());
        Vector items = this.itemsTm.getData();
        this.logic.addEveniment(items, dataEveniment, idClient, this.totalFloat, this.profitFloat, this.costFloat);
        this.itemsTm.refresh(new Vector());
        this.updateTotals();
    }

    private JPanel getProdusPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date produse"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.servire), c);
        ++c.gridx;
        result.add((Component)this.feluri, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.produs), c);
        ++c.gridx;
        result.add((Component)this.produse, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.pret), c);
        ++c.gridx;
        this.pret = new JTextField(10);
        result.add((Component)this.pret, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.cantitate), c);
        ++c.gridx;
        this.cantitate = new JTextField(10);
        result.add((Component)this.cantitate, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        this.adaugaProdus = new JButton(LangRoAll.adauga);
        this.adaugaProdus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FestiveEditPanel.this.addEntry();
            }
        });
        result.add((Component)this.adaugaProdus, c);
        result.setBorder(new TitledBorder(LangRoAll.produs));
        return result;
    }

    public void addEntry() {
        Product p = (Product)this.produse.getSelectedItem();
        Servire fel = (Servire)this.feluri.getSelectedItem();
        String pS = this.pret.getText();
        double pretF = -1.0;
        if (Validators.correctDouble(pS)) {
            pretF = Utils.parseDouble(pS);
        }
        String cS = this.cantitate.getText();
        double cantitateF = -1.0;
        if (Validators.correctDouble(cS)) {
            cantitateF = Utils.parseDouble(cS);
        }
        FestiveProductEntry fpe = new FestiveProductEntry();
        fpe.setServire(fel.getLabel());
        fpe.setProdus(p.getName());
        fpe.setPret(pretF);
        fpe.setCantitate(cantitateF);
        fpe.setIdProduct(p.getId());
        fpe.setIdServire(fel.getId());
        fpe.computeValoare();
        this.itemsTm.getData().add(fpe);
        this.itemsTm.fireTableDataChanged();
        this.updateTotals();
        this.pret.setText("");
        this.cantitate.setText("");
    }

    private JPanel getNirTablePanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date eveniment"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        final FestiveEditPanel panel = this;
        c.gridx = 0;
        c.gridy = 0;
        JTable table = new JTable(this.itemsTm);
        table.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                int selRow = source.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getClickCount() == 2 && DialogUtils.confirmDialog(panel, "Doriti sa stergeti acest produs", LangRoAll.confirmare)) {
                    FestiveEditPanel.this.eraseEntry(selRow);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        JScrollPane scroll = new JScrollPane(table);
        result.add((Component)scroll, c);
        return result;
    }

    private void eraseEntry(int selRow) {
        this.itemsTm.getData().removeElementAt(selRow);
        this.itemsTm.fireTableDataChanged();
        this.updateTotals();
    }
}

