/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.festive;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.gui.festive.FestiveEntry;
import ro.atreides.restaurant.gui.festive.FestiveTabel1;
import ro.atreides.restaurant.gui.festive.FestiveTabel2;
import ro.atreides.restaurant.gui.festive.FestiveTabel3;
import ro.atreides.restaurant.logic.FestiveLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class FestiveReport
extends AbstractReportPanel {
    private FestiveLogic logic;
    private JComboBox clientiCombo;
    private double total;
    private double profit;
    private double cost;
    private JLabel totalLabel;
    private JLabel profitLabel;
    private JLabel costLabel;
    private DoubleClicked action;
    private Hashtable printCriteria = new Hashtable();
    private ReportInterface pdfReportInterface;
    public static final String[] columns = new String[]{LangRoAll.data, LangRoAll.client, LangRoAll.total, "Profit", "Cost"};

    public FestiveReport() {
        this.logic = FestiveLogic.getInstance();
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Date>> result = new Hashtable<String, Comparable<Date>>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        Object client = this.clientiCombo.getSelectedItem();
        if (client instanceof Client) {
            Client f = (Client)client;
            result.put(Constants.CLIENT_KEY, Integer.valueOf(f.getId()));
        } else {
            result.put(Constants.CLIENT_KEY, Integer.valueOf(-1));
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        this.clientiCombo = new JComboBox();
        result.add((Component)this.clientiCombo, c);
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FestiveEntry fe = (FestiveEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return Formatters.DATE_FORMAT_RO.format(fe.getData());
                    }
                    case 1: {
                        return fe.getClient();
                    }
                    case 2: {
                        return Utils.getString2Decimals(fe.getTotal());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getProfit());
                    }
                    case 4: {
                        return Utils.getString2Decimals(fe.getCost());
                    }
                }
                return null;
            }
        });
        return model;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.total), c);
        ++c.gridx;
        this.totalLabel = new JLabel("");
        result.add((Component)this.totalLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Profit"), c);
        ++c.gridx;
        this.profitLabel = new JLabel("");
        result.add((Component)this.profitLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Costuri"), c);
        ++c.gridx;
        this.costLabel = new JLabel("");
        result.add((Component)this.costLabel, c);
        return result;
    }

    public void setAction(DoubleClicked action) {
        this.action = action;
    }

    @Override
    public String getName() {
        return "Evenimente";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return this.logic.getFestive(criteria);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, null, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void refreshTotalPanel() {
        this.computeTotals(this.data);
        this.totalLabel.setText(Utils.getString2Decimals(this.total));
        this.profitLabel.setText(Utils.getString2Decimals(this.profit));
        this.costLabel.setText(Utils.getString2Decimals(this.cost));
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    FestiveEntry entry = (FestiveEntry)o;
                    try {
                        int column = 0;
                        Label label = new Label(column, row, Formatters.DATE_FORMAT_RO.format(entry.getData()));
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, entry.getClient());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(++column, row, entry.getTotal()));
                        sheet.addCell((WritableCell)new Number(++column, row, entry.getProfit()));
                        sheet.addCell((WritableCell)new Number(++column, row, entry.getCost()));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return FestiveReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.clientiCombo, (Collection)ClientLogic.getInstance().getAllClientsSorted(), true);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final FestiveEntry fe = (FestiveEntry)FestiveReport.this.data.elementAt(selRow);
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem delete = new JMenuItem(LangRoAll.sterge);
                JMenuItem modifica = new JMenuItem(LangRoAll.modifica);
                JMenuItem tabel1 = new JMenuItem("Tabel 1");
                JMenuItem tabel2 = new JMenuItem("Tabel 2");
                JMenuItem tabel3 = new JMenuItem("Tabel 3");
                popup.add(delete);
                popup.add(modifica);
                popup.add(tabel1);
                popup.add(tabel2);
                popup.add(tabel3);
                delete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (DialogUtils.confirmDialog(FestiveReport.this.table, "Stergem acest eveniment", LangRoAll.confirmare) && FestiveLogic.getInstance().deleteEvent(fe.getIdEvent())) {
                            DialogUtils.okDialog(FestiveReport.this.table, "Operatie efectuata", LangRoAll.succes);
                        }
                        popup.setVisible(false);
                        FestiveReport.this.raport();
                    }
                });
                modifica.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        popup.setVisible(false);
                        FestiveReport.this.action.doubleClicked(fe);
                    }
                });
                tabel1.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        popup.setVisible(false);
                        FestiveTabel1 t1 = new FestiveTabel1(FestiveReport.this.logic.getFeluri(), fe.getIdEvent());
                        t1.doStuff();
                        JDialog dialog = DialogUtils.getJDialog(t1, GuiUtils.currentFrame, "Tabel 1", 1.1);
                        dialog.setVisible(true);
                    }
                });
                tabel2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        popup.setVisible(false);
                        FestiveTabel2 t2 = new FestiveTabel2(fe.getIdEvent());
                        t2.doStuff();
                        JDialog dialog = DialogUtils.getJDialog(t2, GuiUtils.currentFrame, "Tabel 2", 1.1);
                        dialog.setVisible(true);
                    }
                });
                tabel3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        popup.setVisible(false);
                        FestiveTabel3 t3 = new FestiveTabel3(fe.getIdEvent());
                        t3.doStuff();
                        JDialog dialog = DialogUtils.getJDialog(t3, GuiUtils.currentFrame, "Tabel 3", 1.1);
                        dialog.setVisible(true);
                    }
                });
                popup.setInvoker(FestiveReport.this.table);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 1: {
                        return "";
                    }
                    case 2: {
                        return FestiveReport.this.totalLabel.getText();
                    }
                    case 3: {
                        return FestiveReport.this.profitLabel.getText();
                    }
                    case 4: {
                        return FestiveReport.this.costLabel.getText();
                    }
                }
                return null;
            }

            @Override
            public String getReportTitle() {
                return FestiveReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return FestiveReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                FestiveEntry fe = (FestiveEntry)row;
                switch (column) {
                    case 0: {
                        return Formatters.DATE_FORMAT_RO.format(fe.getData());
                    }
                    case 1: {
                        return fe.getClient();
                    }
                    case 2: {
                        return Utils.getString2Decimals(fe.getTotal());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getProfit());
                    }
                    case 4: {
                        return Utils.getString2Decimals(fe.getCost());
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    private void computeTotals(Vector items) {
        this.total = 0.0;
        this.cost = 0.0;
        this.profit = 0.0;
        for (FestiveEntry element : items) {
            this.total += element.getTotal();
            this.profit += element.getProfit();
            this.cost += element.getCost();
        }
    }
}

