/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.festive;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.gui.festive.FestiveTabel2Entry;
import ro.atreides.restaurant.logic.FestiveLogic;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class FestiveTabel2
extends AbstractListPanel {
    private int idEvent;
    private double total6;
    private double total8;
    private double total9;
    private double total10;
    private double total11;
    private double total12;
    private double total15;
    private double total17;
    private double total18;

    public FestiveTabel2(int idEvent) {
        this.idEvent = idEvent;
    }

    @Override
    public String[] buildColumns() {
        return new String[]{LangRoAll.produs, "Cant normata", "Cant normala", "Pret inreg", "Val pret inreg normata", "Pret nou", "Val pret nou normata", "Dif normata", "Val pret inreg normala", "Val pret nou normala", "Dif normala", "Cant consumata", "Pret derivat", "Val pret derivat", "Pret inreg vechi", "Val pret inreg efectiva", "Dif cant efectiva"};
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FestiveTabel2Entry e = (FestiveTabel2Entry)data.elementAt(rowIndex);
                return FestiveTabel2.this.getValueAtRow(e, columnIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 11;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                FestiveTabel2Entry e = (FestiveTabel2Entry)data.elementAt(rowIndex);
                if (columnIndex == 11) {
                    double f = Utils.parseDouble((String)aValue);
                    e.setCantConsumata(f);
                    FestiveLogic.getInstance().updateCantitate(FestiveTabel2.this.idEvent, e.getIdProdus(), f);
                    e.compute();
                    FestiveTabel2.this.tm.fireTableRowsUpdated(rowIndex, rowIndex);
                }
            }
        });
        return this.tm;
    }

    private String getValueAtRow(FestiveTabel2Entry e, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return e.getProdus();
            }
            case 1: {
                return Utils.getString3Decimals(e.getCantNormata());
            }
            case 2: {
                return Utils.getString3Decimals(e.getCantNormala());
            }
            case 3: {
                return Utils.getString2Decimals(e.getPretInreg());
            }
            case 4: {
                return Utils.getString2Decimals(e.getValInregNormata());
            }
            case 5: {
                return Utils.getString2Decimals(e.getPretNou());
            }
            case 6: {
                return Utils.getString2Decimals(e.getValNouNormata());
            }
            case 7: {
                return Utils.getString2Decimals(e.getDiffNormata());
            }
            case 8: {
                return Utils.getString2Decimals(e.getValInregNormala());
            }
            case 9: {
                return Utils.getString2Decimals(e.getValNouNormala());
            }
            case 10: {
                return Utils.getString2Decimals(e.getDiffNormala());
            }
            case 11: {
                return Utils.getString3Decimals(e.getCantConsumata());
            }
            case 12: {
                return Utils.getString2Decimals(e.getPretDerivat());
            }
            case 13: {
                return Utils.getString2Decimals(e.getDiffNormala());
            }
            case 14: {
                return Utils.getString2Decimals(e.getPretInreg());
            }
            case 15: {
                return Utils.getString2Decimals(e.getValInregEfectiva());
            }
            case 16: {
                return Utils.getString2Decimals(e.getDifEfectiva());
            }
        }
        return null;
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        JButton print = new JButton(LangRoAll.print);
        print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                final Hashtable printCriteria = new Hashtable();
                ReportInterface reportInterface = new ReportInterface(){

                    @Override
                    public int getColumnCount() {
                        return FestiveTabel2.this.buildColumns().length;
                    }

                    @Override
                    public int getColumnSize(int column) {
                        return 1;
                    }

                    @Override
                    public String getColumnName(int column) {
                        return FestiveTabel2.this.buildColumns()[column];
                    }

                    @Override
                    public String getReportTitle() {
                        return "Tabel 2 - Consum efectiv de marfa";
                    }

                    @Override
                    public Hashtable getCriteria() {
                        return printCriteria;
                    }

                    @Override
                    public boolean isLandscape() {
                        return true;
                    }

                    @Override
                    public String getCellContent(Object row, int column) {
                        return FestiveTabel2.this.getValueAtRow((FestiveTabel2Entry)row, column);
                    }

                    @Override
                    public String getTotal(int column) {
                        switch (column) {
                            case 0: {
                                return LangRoAll.total;
                            }
                            case 4: {
                                return Utils.getString2Decimals(FestiveTabel2.this.total6);
                            }
                            case 6: {
                                return Utils.getString2Decimals(FestiveTabel2.this.total8);
                            }
                            case 8: {
                                return Utils.getString2Decimals(FestiveTabel2.this.total10);
                            }
                            case 9: {
                                return Utils.getString2Decimals(FestiveTabel2.this.total11);
                            }
                            case 10: {
                                return Utils.getString2Decimals(FestiveTabel2.this.total12);
                            }
                            case 13: {
                                return Utils.getString2Decimals(FestiveTabel2.this.total15);
                            }
                            case 15: {
                                return Utils.getString2Decimals(FestiveTabel2.this.total17);
                            }
                            case 16: {
                                return Utils.getString2Decimals(FestiveTabel2.this.total18);
                            }
                        }
                        return "";
                    }
                };
                String pdfFile = PrintLogic.getInstance().buildReportPdfText(FestiveTabel2.this.tm.getData(), reportInterface);
                PrintLogic.getInstance().printPreview(pdfFile);
            }
        });
        result.add((Component)print, c);
        return result;
    }

    @Override
    public Vector buildData() {
        Vector data = FestiveLogic.getInstance().getFestive3ForEveniment(this.idEvent);
        this.total18 = 0.0;
        this.total17 = 0.0;
        this.total15 = 0.0;
        this.total12 = 0.0;
        this.total11 = 0.0;
        this.total10 = 0.0;
        this.total9 = 0.0;
        this.total8 = 0.0;
        this.total6 = 0.0;
        for (int i = 0; i < data.size(); ++i) {
            FestiveTabel2Entry o = (FestiveTabel2Entry)data.elementAt(i);
            this.total6 += o.getValInregNormata();
            this.total8 += o.getValNouNormata();
            this.total9 += o.getDiffNormata();
            this.total10 += o.getValInregNormala();
            this.total11 += o.getValNouNormala();
            this.total12 += o.getDiffNormala();
            this.total15 += o.getDiffNormala();
            this.total17 += o.getValInregEfectiva();
            this.total18 += o.getDifEfectiva();
        }
        return data;
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public void doStuff() {
        this.display(true);
    }
}

