/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.hotel;

import java.awt.Color;
import java.util.Vector;
import javax.swing.JPanel;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.touch2.LocationPanel2;
import ro.atreides.restaurant.gui.touch2.TouchMain2;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.rezervari.ListaCamereCell;
import ro.atreides.restaurant.modules.rezervari.RezervareBean;
import ro.atreides.restaurant.modules.rezervari.RezervariLogic;
import ro.atreides.users.User;
import ro.atreides.utils.Order;
import ro.atreides.utils.gui.Legenda;

public class HotelLocationPanel
extends LocationPanel2 {
    public HotelLocationPanel(RestLogic logic, TouchMain2 parent, Vector locations) {
        super(logic, parent, locations);
    }

    @Override
    protected JPanel getLegenda() {
        Legenda l = new Legenda(new String[]{"Libera", "Cazari", "Checkout", "Virtuala"}, new Color[]{Color.WHITE, Color.ORANGE, Color.RED, Color.LIGHT_GRAY}, 1);
        return l;
    }

    @Override
    public Color[] getColorOrderAndUser(Order o, User u) {
        RezervareBean info = RezervariLogic.getInstance().getCurrentRezervareForOrder(o.getId(), o.getTable());
        if (info == null) {
            info = new RezervareBean();
            info.setStatus(1);
            info.setIdClient(-1);
        }
        Color[] result = new Color[2];
        RezervariLogic.getInstance();
        ListaCamereCell looks = RezervariLogic.getLooks(info.getStatus());
        result[0] = looks.getBackground();
        result[1] = Color.WHITE;
        Table table = RestLogic.getInstance().getTableById(o.getTable());
        if (table.isVirtuala()) {
            result[1] = Color.DARK_GRAY;
            result[0] = Color.LIGHT_GRAY;
        } else {
            result[1] = table.isMurdara() ? Color.MAGENTA : (table.isDefecta() ? Color.BLUE : Color.GREEN);
        }
        return result;
    }
}

