/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.livrari;

import com.google.gson.Gson;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import ro.atreides.acces.contracte.ContracteLogic;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.ValoareContClient;
import ro.atreides.clienti.gui.ClientEditDialog;
import ro.atreides.clienti.gui.ClientEditPanelProvider;
import ro.atreides.clienti.gui.ClientSelectDialog;
import ro.atreides.clienti.gui.PersFizicaAddEditPanel;
import ro.atreides.clienti.gui.PersFizicaAddEditPanelShort;
import ro.atreides.clienti.gui.PersJuridicaAddEditPanel;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.print.AbstractPrinter;
import ro.atreides.print.PrintLogic;
import ro.atreides.promo.ClientPromotieView;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.promo.gui.PromotiiDialog;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Meniu;
import ro.atreides.restaurant.base.OptiuneMeniu;
import ro.atreides.restaurant.base.OptiuneProdus;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.restaurant.gui.ModPreparareDialog;
import ro.atreides.restaurant.gui.livrari.ClientButtonPressedInterface;
import ro.atreides.restaurant.gui.livrari.LivrariColorProvider;
import ro.atreides.restaurant.gui.livrari.LivrariMainPanel;
import ro.atreides.restaurant.gui.livrari.LivrariTableModel;
import ro.atreides.restaurant.gui.meniuri.MeniuriChoosePanel;
import ro.atreides.restaurant.gui.meniuri.MeniuriChooserBean;
import ro.atreides.restaurant.gui.meniuri.MeniuriDialog;
import ro.atreides.restaurant.logic.PaymentLogic;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.livrariordersimport.Item;
import ro.atreides.restaurant.modules.livrariordersimport.OrderList;
import ro.atreides.restaurant.modules.scale.ScaleMessageConsumer;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.HttpUtils;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ObjectEventListener;
import ro.atreides.utils.Order;
import ro.atreides.utils.TipCont;
import ro.atreides.utils.UpdateSaleBeforeMarcaj;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.ColorProvider;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.CardInputDialog;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.LoginDialog;
import ro.atreides.utils.gui.keypad.VirtualKeypad2;
import ro.atreides.utils.gui.selector.DataProvider2;
import ro.atreides.utils.gui.selector.Selector2;
import ro.atreides.utils.gui.table.CustomCellRenderer;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.PlatiOperationsInterface;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataButtonPushed;
import ro.atreides.utils.plati.TipPlataProvider;
import ro.atreides.utils.users.gui.ChooseUserDialog;

public class LivrariOrderPanel
extends JPanel
implements ScaleMessageConsumer {
    protected Insets insets = new Insets(1, 1, 1, 1);
    protected RestLogic logic;
    protected LivrariMainPanel main;
    protected VpConfig config;
    protected JButton marcaj;
    protected JButton incasat;
    protected JButton platouButton;
    protected JButton nota;
    protected JButton productsAddButton;
    protected JButton logout;
    private Vector sectii;
    protected JTextField productsQuantity;
    protected JTextField productsPrice;
    protected JTextField availableQuantity;
    protected Order order;
    protected Table table;
    protected Table transferSource;
    protected User waiter;
    private int platouId = 0;
    private boolean platou;
    protected JLabel promoText;
    protected JLabel clientText;
    protected JLabel ospatarText;
    protected JLabel tableText;
    protected JLabel protocolText;
    protected JLabel totalOrder;
    protected JLabel totalPreorder;
    protected XComboBox produseCombo;
    private PlatiOperationsInterface op;
    protected LivrariTableModel orderTm;
    protected LivrariTableModel preorderTm;
    protected JButton importButton;
    protected final String transferString = "<html><center>" + LangRoAll.transfera + "</center></html>";
    protected final String transferStringStop = "<html><center><strong><font color=\"red\">" + LangRoAll.aici + "</font></strong></center></html>";
    private final String platouString = "<html><center>" + LangRoAll.platouStart + "</center></html>";
    private final String platouStringStop = "<html><center><strong><font color=\"red\">" + LangRoAll.platouGata + "</font></strong></center></html>";
    protected VirtualKeypad2 kp;
    private int scroolWidth = 500;
    private int scroolHeight = 200;
    private JTable preorderJTable;
    private JTable orderJTable;
    protected JTabbedPane tabs;
    private AbstractPrinter forcedPrinter = null;
    private static final int CHECK_ORDER_ALL_OK = 1;
    private static final int CHECK_ORDER_DIFFERENT_WAITERS = 2;
    private static final int CHECK_ORDER_SAME_WAITER_DIFFERENT_ORDERS = 3;
    private boolean marcajAtPrecomandaAdd = false;
    private boolean insideMenu = false;
    protected boolean deleteAllPlateau = true;
    private boolean marcajOnly = false;
    protected boolean readFromCantar = false;
    private static final String LIVRARI_TIPURI_DE_PLATA = "livrariTipuriDePlata";

    public LivrariOrderPanel(RestLogic logic, LivrariMainPanel main, VpConfig config, Vector sectii, boolean autoMarcaj, boolean deleteAllPlateau, boolean marcajOnly) {
        this.logic = logic;
        this.main = main;
        this.config = config;
        this.sectii = sectii;
        this.marcajAtPrecomandaAdd = autoMarcaj;
        this.deleteAllPlateau = deleteAllPlateau;
        this.marcajOnly = marcajOnly;
        this.display();
    }

    public User getWaiter() {
        return this.waiter;
    }

    public Order getOrder() {
        return this.order;
    }

    protected void display() {
        JPanel selector;
        this.setLayout((LayoutManager)new MigLayout("", "[grow] []", "[] [] [] [grow]"));
        this.add((Component)this.getDetaliiPanel(), "growx,wrap,span 2");
        this.tabs = new JTabbedPane();
        this.tabs.add((Component)this.getPrecomandaPanel(), LangRoAll.precomanda);
        this.tabs.add((Component)this.getComandaPanel(), LangRoAll.comanda);
        this.add((Component)this.tabs, "grow");
        this.add((Component)this.getRightPanel(), "grow,wrap");
        if (this.config.touch2ShowProductsFilter) {
            JPanel productSearch = this.getProductSearchPanel();
            this.add((Component)productSearch, "growx,wrap, span 2");
        }
        if ((selector = this.getSelectorPanel()) != null) {
            this.add((Component)selector, "grow, wrap, span 2");
        }
    }

    protected JPanel getProductSearchPanel() {
        this.productsQuantity = new JTextField(5);
        this.productsPrice = new JTextField(10);
        this.availableQuantity = new JTextField(10);
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        JLabel produseLabel = new JLabel(LangRoAll.produs);
        result.add((Component)produseLabel, c);
        c.weightx = 1.0;
        ++c.gridx;
        boolean xComboSearchInProduct = Config.getInstance().getBoolean("XComboSearchInProduct");
        this.produseCombo = new XComboBox(new FilterableComboBoxModel(NomeclaturaLogic.getInstance().getPowerSearchProducts(-1)), xComboSearchInProduct);
        this.produseCombo.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.produseCombo.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                LivrariOrderPanel.this.produseCombo.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add((Component)this.produseCombo, c);
        c.weightx = 0.0;
        if (VpConfig.getInstance().touch2ProductsFilterShowQuantity) {
            ++c.gridx;
            JLabel availableQuantityLabel = new JLabel(LangRoAll.totalDispBlocat);
            result.add((Component)availableQuantityLabel, c);
            ++c.gridx;
            result.add((Component)this.availableQuantity, c);
            this.availableQuantity.setFocusable(false);
            this.availableQuantity.setEditable(false);
        }
        ++c.gridx;
        JLabel productsQuantityLabel = new JLabel(LangRoAll.cantitate);
        result.add((Component)productsQuantityLabel, c);
        ++c.gridx;
        this.productsQuantity.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Utils.setSelectionForTextField(LivrariOrderPanel.this.productsQuantity);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add((Component)this.productsQuantity, c);
        ++c.gridx;
        JLabel productsPriceLabel = new JLabel(LangRoAll.pret);
        result.add((Component)productsPriceLabel, c);
        ++c.gridx;
        this.productsPrice.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Utils.setSelectionForTextField(LivrariOrderPanel.this.productsPrice);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        if (!VpConfig.getInstance().touch2ProductsFilterPriceEnabled) {
            this.productsPrice.setEditable(false);
        }
        result.add((Component)this.productsPrice, c);
        ++c.gridx;
        this.productsAddButton = new JButton(LangRoAll.adauga);
        this.productsAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String pr;
                Product p = (Product)LivrariOrderPanel.this.produseCombo.getSelectedItem();
                if (p == null) {
                    LivrariOrderPanel.this.produseCombo.requestFocus();
                    return;
                }
                String pq = LivrariOrderPanel.this.productsQuantity.getText();
                if (!Validators.correctDouble(pq)) {
                    LivrariOrderPanel.this.productsQuantity.setText("1");
                    LivrariOrderPanel.this.productsQuantity.requestFocus();
                }
                if (!Validators.correctDouble(pr = LivrariOrderPanel.this.productsPrice.getText())) {
                    LivrariOrderPanel.this.productsPrice.setText("");
                    LivrariOrderPanel.this.productsPrice.requestFocus();
                }
                double price = Utils.parseDouble(pr);
                double q = Utils.parseDouble(pq);
                LivrariOrderPanel.this.addLaPrecomanda(p, q, price, GuiUtils.currentFrame, "");
                LivrariOrderPanel.this.productsPrice.setText("");
                LivrariOrderPanel.this.productsQuantity.setText("1");
                LivrariOrderPanel.this.produseCombo.clearAllText();
                LivrariOrderPanel.this.produseCombo.requestFocus();
            }
        });
        this.productsAddButton.setMnemonic(65);
        result.add((Component)this.productsAddButton, c);
        FocusTraversalPolicy focus = new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                if (GuiUtils.isXComboBox(aComponent)) {
                    LivrariOrderPanel.this.updateProductPriceField();
                    return LivrariOrderPanel.this.productsQuantity;
                }
                if (aComponent.equals(LivrariOrderPanel.this.productsQuantity)) {
                    return LivrariOrderPanel.this.productsPrice;
                }
                if (aComponent.equals(LivrariOrderPanel.this.productsPrice)) {
                    return LivrariOrderPanel.this.productsAddButton;
                }
                if (aComponent.equals(LivrariOrderPanel.this.productsAddButton)) {
                    LivrariOrderPanel.this.updateProductName();
                    return LivrariOrderPanel.this.produseCombo;
                }
                return this.getDefaultComponent(aContainer);
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                return null;
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return LivrariOrderPanel.this.produseCombo;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return LivrariOrderPanel.this.produseCombo;
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return LivrariOrderPanel.this.productsAddButton;
            }
        };
        result.setFocusCycleRoot(true);
        result.setFocusTraversalPolicy(focus);
        return result;
    }

    protected void updateProductName() {
        Utils.setSelectionForTextField(this.productsPrice);
    }

    protected void updateProductPriceField() {
        Product p = (Product)this.produseCombo.getSelectedItem();
        if (p != null) {
            this.productsPrice.setText(Utils.getString2Decimals(RestLogic.getInstance().getPriceForProductCommit(p.getId())));
        }
    }

    protected void updateAvailableQuantity() {
        Product p = (Product)this.produseCombo.getSelectedItem();
        if (p != null) {
            String avai = RestLogic.getInstance().getStringDisponibilForMagazieAndStock(p.getId(), -1);
            this.availableQuantity.setText(avai);
        }
    }

    protected JPanel getDetaliiPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        Font font = new Font(null, 1, VpConfig.getInstance().touch2ClientFontSize);
        c.gridx = 0;
        c.gridy = 0;
        this.ospatarText = new JLabel();
        result.add((Component)this.ospatarText, c);
        this.ospatarText.setForeground(Color.RED);
        this.ospatarText.setFont(font);
        result.add((Component)this.ospatarText, c);
        ++c.gridx;
        this.tableText = new JLabel();
        result.add((Component)this.tableText, c);
        this.tableText.setForeground(Color.RED);
        this.tableText.setFont(font);
        result.add((Component)this.tableText, c);
        ++c.gridx;
        this.promoText = new JLabel();
        result.add((Component)this.promoText, c);
        this.promoText.setForeground(Color.RED);
        this.promoText.setFont(font);
        result.add((Component)this.promoText, c);
        ++c.gridx;
        this.clientText = new JLabel();
        result.add((Component)this.clientText, c);
        this.clientText.setForeground(Color.RED);
        this.clientText.setFont(font);
        result.add((Component)this.clientText, c);
        return result;
    }

    protected JPanel getPrecomandaPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.preorderTm = this.getPreorderTM();
        this.preorderJTable = new JTable(this.preorderTm);
        LivrariColorProvider touchColor = new LivrariColorProvider(this.preorderTm);
        CustomCellRenderer cellRender = new CustomCellRenderer(touchColor, this.preorderTm);
        GuiUtils.updateJTableColumnSize(this.preorderJTable, this.preorderTm);
        GuiUtils.updateJTableRowSize(this.preorderJTable, this.config.touchTableFontSize);
        TableColumnModel colModel = this.preorderJTable.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(cellRender);
        }
        c.gridwidth = 2;
        JScrollPane preorderScroll = new JScrollPane(this.preorderJTable);
        preorderScroll.setPreferredSize(new Dimension(this.scroolWidth, this.scroolHeight));
        result.add((Component)preorderScroll, c);
        this.preorderJTable.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                Sale s = LivrariOrderPanel.this.preorderTm.getEntryAtRow(selRow);
                int selCol = t.columnAtPoint(p);
                switch (selCol) {
                    case 0: {
                        if (LivrariOrderPanel.this.config.touch2ModPreparareLiber) {
                            String s1 = s.getModPreparare();
                            if (s1 == null) {
                                s1 = "";
                            }
                            String modPreparare = DialogUtils.inputDialog(GuiUtils.currentFrame, s1, LangRoAll.detaliiProdus);
                            s.setModPreparare(modPreparare);
                            break;
                        }
                        Vector moduriPreparare = LivrariOrderPanel.this.logic.getModuriPreparare();
                        if (moduriPreparare.size() <= 0) break;
                        ModPreparareDialog mpd = new ModPreparareDialog(5, moduriPreparare, s.getProductName());
                        String newMpd = mpd.getModPreparare();
                        if (!Validators.correctString(newMpd)) {
                            s.setModPreparare("");
                            break;
                        }
                        if (!Validators.correctString(s.getModPreparare())) {
                            s.setModPreparare(newMpd);
                            break;
                        }
                        s.setModPreparare(s.getModPreparare() + "," + newMpd);
                        break;
                    }
                    case 1: {
                        double toRemain;
                        double toDelete = s.getCantitateNoua();
                        if (LivrariOrderPanel.this.kp.getValue() > 0.0) {
                            toDelete = LivrariOrderPanel.this.kp.getValue();
                            LivrariOrderPanel.this.kp.reset();
                        }
                        if ((toRemain = s.getCantitateNoua() - toDelete) < 0.0) {
                            toRemain = 0.0;
                        }
                        s.setCantitateNoua(toRemain);
                        if (toRemain == 0.0) {
                            LivrariOrderPanel.this.preorderTm.removeTempSale(s, selRow);
                        }
                        LivrariOrderPanel.this.preorderTm.fireTableDataChanged();
                        LivrariOrderPanel.this.updateTotalPreorder();
                        break;
                    }
                    case 2: {
                        User supervizor = null;
                        if (LivrariOrderPanel.this.config.passwordForPret) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor == null && LivrariOrderPanel.this.config.passwordForPret) break;
                        String newPrice = LivrariOrderPanel.this.kp.getValueS();
                        if (Validators.correctDouble(newPrice)) {
                            double price = LivrariOrderPanel.this.kp.getValue();
                            s.setPrice(price);
                            s.setPpuOriginal(price);
                            LivrariOrderPanel.this.updateTotalPreorder();
                        } else {
                            double originalPrice = LivrariOrderPanel.this.logic.getPriceForProductCommit(s.getIdProduct());
                            s.setPrice(originalPrice);
                            s.setPpuOriginal(originalPrice);
                            LivrariOrderPanel.this.updateTotalPreorder();
                        }
                        LivrariOrderPanel.this.kp.reset();
                        break;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        ++c.gridy;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridx = 0;
        JLabel t1 = new JLabel(LangRoAll.total);
        t1.setForeground(Color.RED);
        result.add((Component)t1, c);
        ++c.gridx;
        this.totalPreorder = new JLabel("");
        this.totalPreorder.setForeground(Color.RED);
        result.add((Component)this.totalPreorder, c);
        return result;
    }

    private void updateTotalPreorder() {
        double total = this.preorderTm.getTotal();
        this.totalPreorder.setText(Utils.getString2Decimals(total));
    }

    protected boolean isTipPlataAllowed(TipPlata toFilter, String configName) {
        String configs = Config.getInstance().getString(configName);
        if (Validators.correctString(configs)) {
            Vector split = Utils.splitString(configs, ',');
            for (String s : split) {
                if (!s.equalsIgnoreCase(toFilter.getLabel())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected ColorProvider getColorProvider(LivrariTableModel orderTm) {
        return new LivrariColorProvider(orderTm);
    }

    protected JPanel getComandaPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        final LivrariOrderPanel panel = this;
        c.gridwidth = 3;
        this.orderTm = this.getOrderTM();
        this.orderJTable = new JTable(this.orderTm);
        this.orderJTable.addMouseListener(this.getOrderTableMouseListener(panel));
        CustomCellRenderer cellRender = new CustomCellRenderer(this.getColorProvider(this.orderTm), this.orderTm);
        GuiUtils.updateJTableColumnSize(this.orderJTable, this.orderTm);
        GuiUtils.updateJTableRowSize(this.orderJTable, this.config.touchTableFontSize);
        TableColumnModel colModel = this.orderJTable.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(cellRender);
        }
        JScrollPane scroll = new JScrollPane(this.orderJTable);
        scroll.setPreferredSize(new Dimension(this.scroolWidth, this.scroolHeight));
        result.add((Component)scroll, c);
        this.op = new PlatiOperationsInterface(){

            @Override
            public boolean canRunOperations() {
                return LivrariOrderPanel.this.order != null;
            }

            @Override
            public double getSumaForPlata(int elemId, int clientIndex) {
                return LivrariOrderPanel.this.logic.getSumaForPlataNoPlataSkip(LivrariOrderPanel.this.order, elemId, LivrariOrderPanel.this.orderTm.getTotal(), 0);
            }

            @Override
            public void addPlata(Plata p) {
                LivrariOrderPanel.this.logic.addPlataToOrder(LivrariOrderPanel.this.order, p);
                Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(LivrariOrderPanel.this.order.getId());
                TipPlataProvider.getInstance().updatePlatiLabels(plati, LivrariOrderPanel.this.op);
            }

            @Override
            public double getTotal() {
                return LivrariOrderPanel.this.orderTm.getTotal();
            }

            @Override
            public int getClientIndex() {
                return -1;
            }

            @Override
            public boolean filterTipPlata(TipPlata toFilter) {
                return LivrariOrderPanel.this.isTipPlataAllowed(toFilter, LivrariOrderPanel.LIVRARI_TIPURI_DE_PLATA);
            }
        };
        JPanel platiPanel = TipPlataProvider.getInstance().buildPlatiPanel(this, this.op, new TipPlataButtonPushed(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void startEditSuma(TipPlata tipPlata2) {
                if (!LivrariOrderPanel.this.op.canRunOperations()) {
                    DialogUtils.errorDialog(panel, LangRoAll.comandaGoala, LangRoAll.nuPotContinua);
                    return;
                }
                User supervizor = null;
                if (tipPlata2.isRequestPassword()) {
                    supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                }
                if (tipPlata2.isRequestPassword()) {
                    if (supervizor == null) return;
                }
                int idTipPlata = tipPlata2.getId();
                int idTipCont = tipPlata2.getIdTipCont();
                if (idTipCont != -1) {
                    int idClient = LivrariOrderPanel.this.order.getIdClient();
                    if (idClient <= 0) {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                        return;
                    }
                    Vector<ValoareContClient> contValues = ClientLogic.getInstance().getConturiClient(idClient, idTipCont);
                    if (contValues.size() <= 0) {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.contInexistentPtClient, LangRoAll.nuPotContinua);
                        return;
                    }
                    double val = contValues.get(0).getValoare();
                    if (val < 0.0 && !LivrariOrderPanel.this.config.incarcareContAllowStartOnMinus) {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.soldPeMinus, LangRoAll.nuPotContinua);
                        return;
                    }
                }
                double value = LivrariOrderPanel.this.logic.getSumaForPlataNoPlataSkip(LivrariOrderPanel.this.order, idTipPlata, LivrariOrderPanel.this.orderTm.getTotal(), 0);
                String valueS = LivrariOrderPanel.this.kp.getValueS();
                if (Validators.correctDouble(valueS)) {
                    value = LivrariOrderPanel.this.kp.getValue();
                }
                String comment = "";
                boolean commentSet = false;
                while (tipPlata2.isRequestComment() && !commentSet) {
                    String s;
                    if (LivrariOrderPanel.this.config.tipPlataDetaliiKeypad) {
                        s = DialogUtils.virtualKeyboardInputDialog(GuiUtils.currentFrame, LangRoAll.detalii, 3.0, VpConfig.getInstance().touchSelectorFontSize, false);
                        commentSet = true;
                        comment = s;
                        continue;
                    }
                    s = DialogUtils.inputDialog(panel, "", LangRoAll.detalii);
                    if (!Validators.correctString(s)) continue;
                    commentSet = true;
                    comment = s;
                }
                if (!Utils.isValueZero(value) && idTipCont != -1) {
                    if (LivrariOrderPanel.this.order == null) {
                        return;
                    }
                    int idClient = LivrariOrderPanel.this.order.getIdClient();
                    if (idClient <= 0) {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                        return;
                    }
                    Vector<ValoareContClient> contValues = ClientLogic.getInstance().getConturiClient(idClient, idTipCont);
                    if (contValues.size() <= 0) {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.contInexistentPtClient, LangRoAll.nuPotContinua);
                        return;
                    }
                    double valoareActualaCont = contValues.get(0).getValoare();
                    double canPayValue = valoareActualaCont + -VpConfig.getInstance().incarcareContAllowFinishValue;
                    if (value > canPayValue) {
                        String translation = Utils.getTranslation(LangRoAll.valoareMaximaPlatibila, Utils.getString2Decimals(canPayValue));
                        DialogUtils.errorDialog(panel, translation, LangRoAll.nuPotContinua);
                        return;
                    }
                }
                Plata plata = new Plata(idTipPlata, value, tipPlata2.getEcrMapping(), tipPlata2.getLabel(), comment, 0);
                LivrariOrderPanel.this.logic.addPlataToOrder(LivrariOrderPanel.this.order, plata);
                Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(LivrariOrderPanel.this.order.getId());
                TipPlataProvider.getInstance().updatePlatiLabels(plati, LivrariOrderPanel.this.op);
                LivrariOrderPanel.this.kp.reset();
            }
        });
        ++c.gridy;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridx = 0;
        JLabel t1 = new JLabel(LangRoAll.total);
        t1.setForeground(Color.RED);
        result.add((Component)t1, c);
        ++c.gridx;
        this.totalOrder = new JLabel("");
        this.totalOrder.setForeground(Color.RED);
        result.add((Component)this.totalOrder, c);
        c.weightx = 0.0;
        ++c.gridx;
        if (!this.marcajOnly) {
            result.add((Component)platiPanel, c);
        }
        return result;
    }

    protected MouseListener getOrderTableMouseListener(final Component panel) {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                Sale s = LivrariOrderPanel.this.orderTm.getEntryAtRow(selRow);
                int selCol = t.columnAtPoint(p);
                switch (selCol) {
                    case 1: {
                        if (LivrariOrderPanel.this.order != null && LivrariOrderPanel.this.order.isLaPlata() && !LivrariOrderPanel.this.config.allowStergereAfterNota) {
                            DialogUtils.errorDialog(panel, LangRoAll.nuPutetiEfectuaReturDupaNota, LangRoAll.nuPotContinua);
                            return;
                        }
                        if (!LivrariOrderPanel.this.config.allowRetur) break;
                        double toDelete = s.getCantitateMarcata();
                        if (LivrariOrderPanel.this.kp.getValue() > 0.0) {
                            toDelete = LivrariOrderPanel.this.kp.getValue();
                            LivrariOrderPanel.this.kp.reset();
                        }
                        if (toDelete > s.getCantitateMarcata()) {
                            toDelete = s.getCantitateMarcata();
                        }
                        if (s.getIdPlatou() > 0 && LivrariOrderPanel.this.deleteAllPlateau) {
                            LivrariOrderPanel.this.deleteAllPlateau(toDelete, panel, s);
                            break;
                        }
                        LivrariOrderPanel.this.deleteSingleProduct(toDelete, panel, s, selRow);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        };
    }

    protected JPanel getSelectorPanel() {
        DataProvider2 fullDataProvider = new DataProvider2(){

            @Override
            public int getLinesPerPage(int level) {
                switch (level) {
                    case 0: {
                        return LivrariOrderPanel.this.config.selector2Level1LinesPerPage;
                    }
                    case 1: {
                        return LivrariOrderPanel.this.config.selector2Level2LinesPerPage;
                    }
                    case 2: {
                        return LivrariOrderPanel.this.config.selector2Level3LinesPerPage;
                    }
                }
                return 0;
            }

            @Override
            public int getItemsPerLine(int level) {
                switch (level) {
                    case 0: {
                        return LivrariOrderPanel.this.config.selector2Level1ItemsPerLine;
                    }
                    case 1: {
                        return LivrariOrderPanel.this.config.selector2Level2ItemsPerLine;
                    }
                    case 2: {
                        return LivrariOrderPanel.this.config.selector2Level3ItemsPerLine;
                    }
                }
                return 0;
            }

            @Override
            public int getFontSize(int level) {
                switch (level) {
                    case 0: {
                        return LivrariOrderPanel.this.config.selector2Level1FontSize;
                    }
                    case 1: {
                        return LivrariOrderPanel.this.config.selector2Level2FontSize;
                    }
                    case 2: {
                        return LivrariOrderPanel.this.config.selector2Level3FontSize;
                    }
                }
                return 0;
            }

            @Override
            public int getFontStyle(int level) {
                return 1;
            }

            @Override
            public int getMaxLevels() {
                return 3;
            }

            @Override
            public String getTitle(int level) {
                switch (level) {
                    case 0: {
                        return LangRoAll.sectii;
                    }
                    case 1: {
                        return LangRoAll.categorii;
                    }
                    case 2: {
                        return LangRoAll.produse;
                    }
                }
                return "";
            }

            @Override
            public Vector getData(int level, Object selection) {
                switch (level) {
                    case 0: {
                        return LivrariOrderPanel.this.getSectiiRow();
                    }
                    case 1: {
                        return LivrariOrderPanel.this.getSubcategoriesRow(selection);
                    }
                    case 2: {
                        return LivrariOrderPanel.this.getProductsRow(selection);
                    }
                    case 3: {
                        LivrariOrderPanel.this.productChosen(selection, GuiUtils.currentFrame);
                        return null;
                    }
                }
                return new Vector();
            }

            @Override
            public int getMinBtnHeight(int level) {
                switch (level) {
                    case 0: {
                        return LivrariOrderPanel.this.config.selector2Level1MinHeight;
                    }
                    case 1: {
                        return LivrariOrderPanel.this.config.selector2Level2MinHeight;
                    }
                    case 2: {
                        return LivrariOrderPanel.this.config.selector2Level3MinHeight;
                    }
                }
                return 0;
            }

            @Override
            public int getMinBtnWidth(int level) {
                switch (level) {
                    case 0: {
                        return LivrariOrderPanel.this.config.selector2Level1MinWidth;
                    }
                    case 1: {
                        return LivrariOrderPanel.this.config.selector2Level2MinWidth;
                    }
                    case 2: {
                        return LivrariOrderPanel.this.config.selector2Level3MinWidth;
                    }
                }
                return 0;
            }
        };
        Selector2 sel = new Selector2(fullDataProvider);
        return sel;
    }

    private void productChosen(Object selection, Component panel) {
        double cantitateCurenta = 1.0;
        Product p = (Product)selection;
        if (this.kp.getValue() > 0.0) {
            cantitateCurenta = this.kp.getValue();
        }
        this.addLaPrecomanda(p, cantitateCurenta, panel, "");
        this.kp.reset();
    }

    private void addLaPrecomanda(Product p, double quantity, Component panel, String modPreparare) {
        double price = this.logic.getPriceForProductCommit(p.getId());
        if (price >= 0.0) {
            this.addLaPrecomanda(p, quantity, price, panel, modPreparare);
        }
    }

    protected void addLaPrecomanda(Product p, double quantity, double pret, Component panel, String modPreparare) {
        this.addLaPrecomanda(p, quantity, pret, panel, modPreparare, false);
    }

    protected void addLaPrecomanda(Product p, double quantity, double pret, Component panel, String modPreparare, boolean ignoresPromotion) {
        int checkAlreadyOpenStatus = this.checkNotaAlreadyOpened();
        switch (checkAlreadyOpenStatus) {
            case 2: {
                DialogUtils.errorDialog(panel, LangRoAll.comandaDejaDeschisaDeAlt + " " + LangRoAll.iesitiPePlan, LangRoAll.nuPotContinua);
                return;
            }
            case 3: {
                DialogUtils.errorDialog(panel, LangRoAll.masaDejaDeschisaDeTine + " " + LangRoAll.iesitiPePlan, LangRoAll.nuPotContinua);
                return;
            }
        }
        int idPlatou = -1;
        if (this.platou) {
            idPlatou = this.platouId;
        }
        int idPromotie = -1;
        long now = System.currentTimeMillis();
        String modPreparareNou = this.getModPreparare(modPreparare, p);
        if (VpConfig.getInstance().livrariUseBarcodePrinter) {
            double currentlot;
            if (quantity > 10.0 && !DialogUtils.confirmDialog(panel, "Cantitatea > 10!! Sunteti sigur ", LangRoAll.confirmare)) {
                return;
            }
            for (double deProcesat = quantity; deProcesat > 0.0; deProcesat -= currentlot) {
                currentlot = Math.min(1.0, deProcesat);
                Sale newSale = this.logic.buildSale(p, 0.0, currentlot, modPreparareNou, -1, idPlatou, idPromotie, -1, -1, now, pret, "", 0, ignoresPromotion);
                this.preorderTm.addSale(newSale);
            }
        } else {
            Sale newSale = this.logic.buildSale(p, 0.0, quantity, modPreparareNou, -1, idPlatou, idPromotie, -1, -1, now, pret, "", 0, ignoresPromotion);
            this.preorderTm.addSale(newSale);
        }
        if (VpConfig.getInstance().recomputePricesBeforeMarcaj) {
            Vector sales = this.preorderTm.getAllSales();
            RestLogic.getInstance().recomputePricesBeforeMarcaj(this.order, sales, new UpdateSaleBeforeMarcaj());
        }
        this.updateTotalPreorder();
        this.tabs.setSelectedIndex(0);
        this.preorderJTable.changeSelection(this.preorderTm.getRowCount() - 1, 0, false, false);
        if (this.marcajAtPrecomandaAdd) {
            this.marcaj.doClick();
        }
    }

    protected String getModPreparare(String modPreparare, Product p) {
        return modPreparare;
    }

    private Vector getProductsRow(Object selection) {
        Vector products = new Vector();
        if (selection != null) {
            if (selection instanceof Categorie) {
                Categorie sc = (Categorie)selection;
                products = NomeclaturaLogic.getInstance().getProductsForCategorie(sc);
                if (products.size() == 0) {
                    Logger.logDebug(this, "getProductsRow returned 0 for selection \"" + selection + "\"");
                }
            } else {
                Logger.logDebug(this, "getProductsRow class cast, received \"" + selection + "\"");
            }
        } else {
            Logger.logDebug(this, "getProductsRow selection is null");
        }
        return products;
    }

    private Vector getSubcategoriesRow(Object selection) {
        Vector subcats = new Vector();
        if (selection != null) {
            if (selection instanceof Sectie) {
                Sectie c = (Sectie)selection;
                subcats = NomeclaturaLogic.getInstance().getCategoriiForcedOrder(c.getId());
                if (subcats.size() == 0) {
                    Logger.logDebug(this, "getSubcategoriesRow returned 0 for selection \"" + selection + "\"");
                }
            } else {
                Logger.logDebug(this, "getSubcategoriesRow class cast, received \"" + selection + "\"");
            }
        } else {
            Logger.logDebug(this, "getSubcategoriesRow selection is null");
        }
        return subcats;
    }

    private Vector getSectiiRow() {
        if (this.sectii.size() > 0) {
            return this.logic.getSectiiInSet(this.sectii);
        }
        return this.logic.getSectii();
    }

    protected JButton getPlatouButton() {
        JButton platouButton = new JButton(this.platouString);
        platouButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LivrariOrderPanel.this.platou) {
                    LivrariOrderPanel.this.platou = false;
                } else {
                    LivrariOrderPanel.this.platou = true;
                    if (LivrariOrderPanel.this.platouId == -1) {
                        LivrariOrderPanel.this.platouId = LivrariOrderPanel.this.logic.getMaxPlatouIdForOrder(LivrariOrderPanel.this.order);
                    }
                    LivrariOrderPanel.this.platouId++;
                }
                LivrariOrderPanel.this.setPlatouButtonText();
            }
        });
        return platouButton;
    }

    protected JButton getFreeButton1() {
        return null;
    }

    protected JButton getFreeButton2() {
        return null;
    }

    private int checkNotaAlreadyOpened() {
        Order o = this.logic.getOpenOrderAtTable(this.table);
        if (o != null) {
            if (this.order != null) {
                if (o.getId() != this.order.getId()) {
                    if (this.waiter.getId() != o.getUser()) {
                        return 2;
                    }
                    return 3;
                }
                return 1;
            }
            if (this.waiter.getId() != o.getUser()) {
                return 2;
            }
            return 3;
        }
        return 1;
    }

    private void marcaj(boolean triggeredByNota, Component panel) {
        this.order = RestLogic.getInstance().getOrderById(this.order.getId());
        if (this.order.isLaPlata() && !this.config.allowMarcajAfterNota) {
            return;
        }
        int checkAlreadyOpenStatus = this.checkNotaAlreadyOpened();
        switch (checkAlreadyOpenStatus) {
            case 2: {
                DialogUtils.errorDialog(panel, LangRoAll.comandaDejaDeschisaDeAlt + " " + LangRoAll.iesitiPePlan, LangRoAll.nuPotContinua);
                return;
            }
            case 3: {
                DialogUtils.errorDialog(panel, LangRoAll.masaDejaDeschisaDeTine + " " + LangRoAll.iesitiPePlan, LangRoAll.nuPotContinua);
                return;
            }
        }
        this.createOrderIfNull();
        if (this.order.getIdClient() <= 0) {
            this.doOrderPanelClientSelectDialog(panel);
        }
        if (this.order.getIdClient() <= 0) {
            return;
        }
        if (this.forcedPrinter == null && VpConfig.getInstance().touch2PrintDialogForMarcaj) {
            this.forcedPrinter = PrintLogic.getInstance().printerSelectionDialog();
        }
        RestLogic.getInstance().switchAfisajClientOrderCommit(this.order.getId());
        if (this.platou && !this.insideMenu) {
            this.platouButton.doClick();
        }
        boolean proto = false;
        if (this.order.isProtocol()) {
            proto = true;
        }
        Vector categories = this.logic.getSectii();
        Vector allSales = this.preorderTm.getAllSales();
        if (VpConfig.getInstance().recomputePricesBeforeMarcaj) {
            this.logic.recomputePricesBeforeMarcaj(this.order, allSales, new UpdateSaleBeforeMarcaj());
        }
        for (Sectie element : categories) {
            Vector<Sale> toAdd = this.logic.getTemporarySalesForCategory(element, this.preorderTm.getAllSales());
            if (toAdd.size() == 0) continue;
            int idClient = this.order.getIdClient();
            Client c = ClientLogic.getInstance().getClientById(idClient);
            this.logic.productsSoldClientAsWaiter(toAdd, this.order, this.table, element, proto, this.forcedPrinter, c);
        }
        this.logic.recomputePrices(this.order);
        this.refreshOrderSales();
        this.preorderTm.clear();
        this.updateOrderTotal();
        this.updateTotalPreorder();
        this.tabs.setSelectedIndex(1);
        this.scrollOrderJTable();
        if (!triggeredByNota) {
            this.forcedPrinter = null;
        }
    }

    public void doOrderPanelClientSelectDialog(final Component panel) {
        this.main.showClientSelectDialog(new ClientButtonPressedInterface(){

            @Override
            public void setClient(Client client, String adresaLivrare) {
                if (client != null) {
                    if (!LivrariMainPanel.showIstoricInformations(LivrariOrderPanel.this.order, client, panel)) {
                        return;
                    }
                } else {
                    return;
                }
                LivrariOrderPanel.this.logic.setClientForOrder(LivrariOrderPanel.this.order, client.getId(), adresaLivrare);
                LivrariOrderPanel.this.setTable(LivrariOrderPanel.this.table, LivrariOrderPanel.this.waiter, LivrariOrderPanel.this.order, true, false);
                LivrariOrderPanel.this.main.refreshOrders(LivrariOrderPanel.this.order, true, false);
            }
        }, this.main._callerId, "", "", "", this, this.order);
    }

    protected JPanel getRightPanel() {
        final LivrariOrderPanel panel = this;
        JPanel result = new JPanel((LayoutManager)new MigLayout("insets 2"));
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        final LivrariOrderPanel parent = this;
        this.kp = new VirtualKeypad2(VpConfig.getInstance().touchSelectorFontSize, true);
        result.add((Component)this.kp, "span 2, wrap");
        this.platouButton = this.getPlatouButton();
        JButton meniu = new JButton("<html><center>" + LangRoAll.meniu + "<br>&nbsp;</center></html>");
        meniu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                double cantitateCurenta = 1.0;
                if (LivrariOrderPanel.this.kp.getValue() > 0.0) {
                    cantitateCurenta = LivrariOrderPanel.this.kp.getValue();
                }
                if ((double)((int)cantitateCurenta) != cantitateCurenta) {
                    DialogUtils.errorDialog(parent, "La meniuri cantitatea nu poate avea zecimale", LangRoAll.nuPotContinua);
                    return;
                }
                Vector<Meniu> meniuri = LivrariOrderPanel.this.logic.getAllMeniuri();
                if (meniuri.size() > 0) {
                    Meniu selected = meniuri.get(0);
                    if (meniuri.size() > 1) {
                        MeniuriDialog dia = new MeniuriDialog(5, meniuri);
                        selected = dia.getMeniu();
                    }
                    if (selected != null) {
                        Map<Object, Object> beans = Collections.synchronizedMap(new LinkedHashMap());
                        Vector optiuniMeniu = LivrariOrderPanel.this.logic.getOptiuniForMenu(selected.getId());
                        for (int i = 0; i < optiuniMeniu.size(); ++i) {
                            OptiuneMeniu optiuneMeniu = (OptiuneMeniu)optiuniMeniu.elementAt(i);
                            Vector<MeniuriChooserBean> bs = new Vector<MeniuriChooserBean>();
                            Vector produse = LivrariOrderPanel.this.logic.getOptiuniProdusFrontOffice(selected.getId(), optiuneMeniu.getIdOptiune());
                            for (OptiuneProdus optiuneProdus : produse) {
                                MeniuriChooserBean mcb = new MeniuriChooserBean();
                                mcb.setIdProduct(optiuneProdus.getIdProdus());
                                mcb.setNumeProdus(optiuneProdus.getProduct());
                                mcb.setOptiuni("");
                                mcb.setOp(optiuneProdus);
                                bs.add(mcb);
                            }
                            beans.put(optiuneMeniu.getNumeOptiune(), bs);
                        }
                        boolean stop = false;
                        while (!stop) {
                            LivrariOrderPanel.this.insideMenu = true;
                            LivrariOrderPanel.this.platouButton.doClick();
                            LivrariOrderPanel.this.platouButton.setEnabled(false);
                            MeniuriChoosePanel mcp = new MeniuriChoosePanel(beans, (int)cantitateCurenta);
                            mcp.display();
                            JDialog dia2 = DialogUtils.getJDialog(mcp, GuiUtils.currentFrame, "Meniu: " + selected.getLabel(), 1.1);
                            mcp.setParent(dia2);
                            dia2.setVisible(true);
                            cantitateCurenta = mcp.getQuantity();
                            if (!mcp.isCancel()) {
                                beans = mcp.getProducts();
                                Set<Object> keys = beans.keySet();
                                for (String string : keys) {
                                    Vector mcbs = (Vector)beans.get(string);
                                    MeniuriChooserBean selectedMCB = null;
                                    for (MeniuriChooserBean mcb : mcbs) {
                                        if (!mcb.isSelected()) continue;
                                        selectedMCB = mcb;
                                        break;
                                    }
                                    if (selectedMCB == null) continue;
                                    int idProdus = selectedMCB.getIdProduct();
                                    Product pr = NomeclaturaLogic.getInstance().getProductById(idProdus);
                                    OptiuneProdus op = selectedMCB.getOp();
                                    LivrariOrderPanel.this.addLaPrecomanda(pr, cantitateCurenta * op.getCantitate(), op.getPret(), GuiUtils.currentFrame, selectedMCB.getOptiuni());
                                }
                                if (mcp.isSaveAndQuit()) {
                                    stop = true;
                                }
                            } else {
                                stop = true;
                            }
                            LivrariOrderPanel.this.kp.reset();
                            LivrariOrderPanel.this.insideMenu = false;
                            LivrariOrderPanel.this.platouButton.setEnabled(true);
                            LivrariOrderPanel.this.platouButton.doClick();
                        }
                    }
                }
            }
        });
        if (!LivrariMainPanel.livrariDisabledButtons.contains("meniu")) {
            result.add((Component)meniu, "growx");
        }
        this.nota = new JButton("<html><center>" + LangRoAll.nota + "<br>&nbsp;</center></html>");
        this.nota.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                boolean duplicat;
                int nrPersoaneSetat;
                if (LivrariOrderPanel.this.tabs.getSelectedIndex() > 0 && LivrariOrderPanel.this.preorderTm.getRowCount() > 0) {
                    DialogUtils.errorDialog(panel, LangRoAll.existaProdNemarcate, LangRoAll.marcatiSauStergeti);
                    LivrariOrderPanel.this.tabs.setSelectedIndex(0);
                    return;
                }
                if (VpConfig.getInstance().livrariReplaceUserAtNota) {
                    int idUser = LivrariOrderPanel.this.main.getCurrentUser().getId();
                    LivrariOrderPanel.this.logic.setUserToOrder(idUser, LivrariOrderPanel.this.order);
                }
                if (LivrariOrderPanel.this.forcedPrinter == null && VpConfig.getInstance().touch2PrintDialogForNota) {
                    LivrariOrderPanel.this.forcedPrinter = PrintLogic.getInstance().printerSelectionDialog();
                }
                if (LivrariOrderPanel.this.config.notaTriggersBon && LivrariOrderPanel.this.preorderTm.getAllSales().size() > 0) {
                    LivrariOrderPanel.this.marcaj(true, panel);
                }
                if (LivrariOrderPanel.this.order == null) {
                    return;
                }
                int totalRows = LivrariOrderPanel.this.orderTm.getRowCount();
                int maxItems = LivrariOrderPanel.this.config.ecrMaxItems;
                if (maxItems > 0 && totalRows > maxItems) {
                    DialogUtils.errorDialog(parent, LangRoAll.maxProducts1 + maxItems + LangRoAll.maxProducts2, LangRoAll.atentie);
                    return;
                }
                if (RestLogic.getInstance().needPlatiCheckingAtNota(LivrariOrderPanel.this.order)) {
                    LivrariOrderPanel.this.logic.recomputePrices(LivrariOrderPanel.this.order);
                    if (!LivrariOrderPanel.this.logic.isTotalOrderEqualWithTotalPlati(LivrariOrderPanel.this.order)) {
                        DialogUtils.errorDialog(parent, LangRoAll.tipurileDePlataNuAcopera, LangRoAll.nuPotContinua);
                        return;
                    }
                }
                if ((nrPersoaneSetat = LivrariOrderPanel.this.logic.getNrPersoaneForOrder(LivrariOrderPanel.this.order.getId())) == -1 && !LivrariOrderPanel.this.order.isLaPlata()) {
                    boolean requestNrPersoaneAtNota = LivrariOrderPanel.this.config.requestNrPersoaneAtNota;
                    if (requestNrPersoaneAtNota) {
                        if (LivrariOrderPanel.this.orderTm.getRowCount() > 0) {
                            DialogUtils.errorDialog(parent, LangRoAll.nuAtiAlesNrPers, LangRoAll.nuPotContinua);
                            return;
                        }
                        LivrariOrderPanel.this.logic.setNrPersoaneToOrder(LivrariOrderPanel.this.order, 0);
                    } else if (LivrariOrderPanel.this.orderTm.getRowCount() > 0) {
                        LivrariOrderPanel.this.logic.setNrPersoaneToOrder(LivrariOrderPanel.this.order, 1);
                    } else {
                        LivrariOrderPanel.this.logic.setNrPersoaneToOrder(LivrariOrderPanel.this.order, 0);
                    }
                }
                if (LivrariOrderPanel.this.config.touch2RequestClientBeforeNota && LivrariOrderPanel.this.order.getIdClient() <= 0) {
                    DialogUtils.errorDialog(parent, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                    return;
                }
                if (LivrariOrderPanel.this.config.touch2RequestDetaliiBeforeNota && !Validators.correctString(LivrariOrderPanel.this.order.getDetalii())) {
                    DialogUtils.errorDialog(parent, LivrariOrderPanel.this.getDetaliiLipsaString(), LangRoAll.nuPotContinua);
                    return;
                }
                boolean bl = duplicat = LivrariOrderPanel.this.order != null && LivrariOrderPanel.this.order.isLaPlata();
                if (duplicat) {
                    if (LivrariOrderPanel.this.config.allowNoteDuplicate) {
                        if (!DialogUtils.confirmDialog(parent, LangRoAll.tiparimNotaDuplicat, LangRoAll.confirmare)) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                LivrariOrderPanel.this.nota(ev);
                if (!LivrariOrderPanel.this.config.touch3NotaGotoMese) {
                    LivrariOrderPanel.this.tabs.setSelectedIndex(1);
                }
                if (LivrariOrderPanel.this.config.livrariNotaTriggersIncasat) {
                    if (!duplicat) {
                        LivrariOrderPanel.this.incasat.doClick();
                    } else if (LivrariOrderPanel.this.config.allowNoteDuplicate) {
                        if (DialogUtils.confirmDialog(parent, LangRoAll.tiparimBonFiscal, LangRoAll.confirmare)) {
                            LivrariOrderPanel.this.incasat.doClick();
                        }
                    } else {
                        return;
                    }
                }
                LivrariOrderPanel.this.forcedPrinter = null;
            }
        });
        if (!LivrariMainPanel.livrariDisabledButtons.contains("nota")) {
            result.add((Component)this.nota, "wrap,growx");
        }
        this.marcaj = this.getMarcajButton(panel);
        if (!LivrariMainPanel.livrariDisabledButtons.contains("marcaj")) {
            result.add((Component)this.marcaj, "growx");
        }
        this.incasat = this.getIncasatButton(parent);
        if (!LivrariMainPanel.livrariDisabledButtons.contains("incasat")) {
            result.add((Component)this.incasat, "wrap,growx");
        }
        if (!LivrariMainPanel.livrariDisabledButtons.contains("platou")) {
            result.add((Component)this.platouButton, "grow");
        }
        JButton detaliiComanda = new JButton("<html><center>Detalii<br>Comanda</center></html>");
        detaliiComanda.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String detalii;
                LivrariOrderPanel.this.createOrderIfNull();
                String fost = LivrariOrderPanel.this.order.getDetalii();
                if (fost == null) {
                    fost = "";
                }
                if ((detalii = DialogUtils.inputDialog(parent, fost, LangRoAll.detaliiNota)) != null) {
                    LivrariOrderPanel.this.order.setDetalii(detalii);
                    LivrariOrderPanel.this.logic.setDetalii(LivrariOrderPanel.this.order);
                }
            }
        });
        if (!LivrariMainPanel.livrariDisabledButtons.contains("detalii")) {
            result.add((Component)detaliiComanda, "wrap,growx");
        }
        final JButton optiuni = new JButton("<html><center>" + LangRoAll.optiuni + "<br>&nbsp;</center></html>");
        optiuni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = LivrariOrderPanel.this.buildOptiuniPopup();
                popup.show(optiuni, 0, 50);
            }
        });
        if (!LivrariMainPanel.livrariDisabledButtons.contains("optiuni")) {
            result.add((Component)optiuni, "growx");
        }
        if (VpConfig.getInstance().scaleUseCantarButton) {
            JButton cantarButton = new JButton("<html><center>" + LangRoAll.cantar + "<br>&nbsp;</center></html>");
            cantarButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LivrariOrderPanel.this.readFromCantar = true;
                }
            });
            if (!LivrariMainPanel.livrariDisabledButtons.contains("cantar")) {
                result.add((Component)cantarButton, "wrap,growx");
            }
        }
        if (LivrariMainPanel.showImportButton) {
            this.importButton = new JButton(this.getImportButtonText(0));
            this.importButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LivrariOrderPanel.this.importFromJson();
                }
            });
            if (!LivrariMainPanel.livrariDisabledButtons.contains("import")) {
                result.add((Component)this.importButton, "wrap,growx");
            }
            Thread countThread = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        LivrariOrderPanel.this.countOnlineOrders();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            };
            countThread.start();
        }
        if (this.marcajOnly) {
            this.nota.setEnabled(false);
            this.incasat.setEnabled(false);
        }
        return result;
    }

    private String getImportButtonText(int onlineOrders) {
        String result = "<html><center>" + (onlineOrders > 0 ? "<font color=\"red\">" : "") + "Import" + "<br>(" + onlineOrders + ")</center>" + (onlineOrders > 0 ? "</font>" : "") + "</html>";
        return result;
    }

    private synchronized void countOnlineOrders() {
        Gson gson = new Gson();
        try {
            String url = Utils.getTranslation(LivrariMainPanel.importOrdersGetUrl);
            if (!Validators.correctString(url)) {
                return;
            }
            String fileContent = HttpUtils.getHttpPage(url);
            Logger.logDebugVerbose(this, "JSON file to import " + fileContent);
            final OrderList orderList = gson.fromJson(fileContent, OrderList.class);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    List<ro.atreides.restaurant.modules.livrariordersimport.Order> orders;
                    int size = 0;
                    if (orderList != null && (orders = orderList.getOrders()) != null) {
                        size = orders.size();
                    }
                    LivrariOrderPanel.this.importButton.setText(LivrariOrderPanel.this.getImportButtonText(size));
                }
            });
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
    }

    protected synchronized void importFromJson() {
        if (this.order != null && (this.orderTm.getAllSales().size() > 0 || this.preorderTm.getAllSales().size() > 0 || this.order.getIdClient() > 0)) {
            DialogUtils.errorDialog(this, "Aceasta functie se poate folosi numai pe o comanda noua", LangRoAll.nuPotContinua);
            return;
        }
        Gson gson = new Gson();
        try {
            String url = Utils.getTranslation(LivrariMainPanel.importOrdersGetUrl);
            if (!Validators.correctString(url)) {
                return;
            }
            String fileContent = HttpUtils.getHttpPage(url);
            Logger.logDebugVerbose(this, "JSON file to import " + fileContent);
            OrderList orderList = gson.fromJson(fileContent, OrderList.class);
            System.out.println(orderList);
            if (orderList.getCount() <= 0) {
                DialogUtils.okDialog(this, "Nu exista comenzi de importat", LangRoAll.succes);
                return;
            }
            for (ro.atreides.restaurant.modules.livrariordersimport.Order orderToImport : orderList.getOrders()) {
                String phone = orderToImport.getClient_phone().trim();
                String adresaDinJson = orderToImport.getClient_address().trim();
                String clientDinJson = orderToImport.getClient_first_name().trim();
                int clientIdToUse = -1;
                Client clientToUse = null;
                Vector<Client> allFound = ClientLogic.getInstance().getAllByTelefon(phone);
                for (Client foundClient : allFound) {
                    if (!foundClient.toString().trim().equalsIgnoreCase(clientDinJson)) continue;
                    clientToUse = foundClient;
                    clientIdToUse = clientToUse.getId();
                    Vector<String> adrese = foundClient.getAdrese();
                    boolean foundAddress = false;
                    for (String adresaCurenta : adrese) {
                        if (!adresaCurenta.equalsIgnoreCase(adresaDinJson)) continue;
                        foundAddress = true;
                    }
                    if (foundAddress) continue;
                    adrese.add(adresaDinJson);
                    String allAddresses = "";
                    for (String s : adrese) {
                        allAddresses = allAddresses + s + '|';
                    }
                    allAddresses = allAddresses.substring(0, allAddresses.length() - 1);
                    clientToUse.setAddress1(allAddresses);
                    ClientLogic.getInstance().savePersFizicaLocallyNoNotify((ClientPersFizica)clientToUse);
                }
                if (clientToUse == null) {
                    ClientEditPanelProvider provider = new ClientEditPanelProvider(){

                        @Override
                        public PersFizicaAddEditPanel getPfPanel() {
                            return new PersFizicaAddEditPanelShort();
                        }

                        @Override
                        public PersJuridicaAddEditPanel getPjPanel() {
                            return new PersJuridicaAddEditPanel();
                        }
                    };
                    ClientEditDialog cDia = this.main.getClientEditDialogGeneric(GuiUtils.currentFrame, ClientLogic.getInstance(), null, false, provider, phone, adresaDinJson, clientDinJson, orderToImport.getClient_email());
                    clientIdToUse = cDia.getClientId();
                }
                this.main.comandaNoua(clientIdToUse, adresaDinJson);
                List items = orderToImport.getItems();
                for (Item item : items) {
                    Product product = NomeclaturaLogic.getInstance().getProductByCod(item.getProduct_code());
                    if (product != null) {
                        double originalPrice = RestLogic.getInstance().getPriceForProductCommit(product.getId());
                        String mp = "";
                        if (item.getInstructions() != null) {
                            mp = item.getInstructions();
                        }
                        this.addLaPrecomanda(product, item.getQuantity(), originalPrice, this, mp);
                        continue;
                    }
                    String message = "Produs negasit in baza : " + item.getName() + " cantitate " + item.getQuantity() + " instructiuni  \"" + item.getInstructions() + "\" cod " + item.getProduct_code() + " orderId " + item.getOrder_id();
                    Logger.logWarning(this, "IMPORT " + message);
                    DialogUtils.errorDialog(this, message, "Adaugati produsul manual !!!");
                }
                this.main.pickup(phone, "1");
                this.marcaj.doClick();
                try {
                    Date saleDate = Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.parse(orderToImport.getRetrieved_at());
                    this.order.setStartTime(saleDate.getTime());
                    this.logic.updateStartTimeForOrder(this.order, saleDate);
                }
                catch (ParseException e) {
                    Logger.logException(this, (Exception)e);
                }
                if (DialogUtils.confirmDialog(this, "Ati procesat comanda OK", LangRoAll.confirmare)) {
                    String feedbackUrl = Utils.getTranslation(LivrariMainPanel.importOrdersFeedbackUrl, orderToImport.getId() + "");
                    if (!Validators.correctString(feedbackUrl)) continue;
                    HttpUtils.getHttpPage(feedbackUrl);
                    continue;
                }
                if (DialogUtils.confirmDialog(this, "Continuam cu urmatoarea comanda", LangRoAll.confirmare)) continue;
                break;
            }
            this.main._callerId = "";
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
    }

    protected JButton getIncasatButton(final JPanel parent) {
        JButton incasat = new JButton("<html><center>" + LangRoAll.incasat + "<br>&nbsp;</center></html>");
        incasat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RestLogic.getInstance().needPlatiCheckingAtIncasat(LivrariOrderPanel.this.order) && !LivrariOrderPanel.this.logic.isTotalOrderEqualWithTotalPlati(LivrariOrderPanel.this.order)) {
                    DialogUtils.errorDialog(parent, LangRoAll.tipurileDePlataNuAcopera, LangRoAll.nuPotContinua);
                    return;
                }
                LivrariOrderPanel.this.incasat();
                LivrariOrderPanel.this.main.nota(LivrariOrderPanel.this.order);
            }
        });
        incasat.setEnabled(false);
        return incasat;
    }

    protected JButton getMarcajButton(final Component panel) {
        JButton marcaj = new JButton("<html><center>" + LangRoAll.marcaj + "<br>&nbsp;</center></html>");
        marcaj.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LivrariOrderPanel.this.marcaj(false, panel);
            }
        });
        return marcaj;
    }

    public void tryLogout(Component parent) {
        if (this.preorderTm.getRowCount() > 0) {
            DialogUtils.errorDialog(parent, LangRoAll.existaProdNemarcate, LangRoAll.marcatiSauStergeti);
            this.tabs.setSelectedIndex(0);
            return;
        }
        this.transferSource = null;
    }

    protected String getDetaliiLipsaString() {
        return LangRoAll.nuAtiCompletatDetalii;
    }

    public String getMeseName() {
        return LangRoAll.mese;
    }

    public void golestePreorder() {
        this.preorderTm.clear();
        this.updateTotalPreorder();
    }

    protected void scrollOrderJTable() {
        this.orderJTable.changeSelection(this.orderJTable.getRowCount() - 1, 0, false, false);
    }

    protected JPopupMenu buildOptiuniPopup() {
        final LivrariOrderPanel parent = this;
        Font bonItemFont = new Font(null, 1, this.config.touchKeypadFontSize + 6);
        JPopupMenu popup = new JPopupMenu();
        try {
            int optiuneButton;
            JMenuItem btn;
            JMenuItem adresa = new JMenuItem("Adresa");
            adresa.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Client c = ClientLogic.getInstance().getClientById(LivrariOrderPanel.this.order.getIdClient());
                    String s = LivrariOrderPanel.this.main.showAdresaPopup(c);
                    if (s != null) {
                        RestLogic.getInstance().setClientForOrder(LivrariOrderPanel.this.order, c.getId(), s);
                        LivrariOrderPanel.this.main.refreshOrders(LivrariOrderPanel.this.order, false, false);
                    }
                }
            });
            adresa.setFont(bonItemFont);
            popup.add(adresa);
            JMenuItem oraLivrare = new JMenuItem("Ora Livrare");
            oraLivrare.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    LivrariOrderPanel.this.createOrderIfNull();
                    Date oraLivrare = DateUtils.addMinutesToDate(new Date(LivrariOrderPanel.this.order.getStartTime()), VpConfig.getInstance().productieViewAheadMinutes);
                    String hour = Formatters.TIME_FORMAT.format(oraLivrare);
                    boolean done = false;
                    while (!done) {
                        Date newStartTimeForOrder;
                        String detalii = DialogUtils.inputDialog(parent, hour, LangRoAll.oraLivrare + " - RESPECTATI FORMATUL!!");
                        if (detalii == null || (newStartTimeForOrder = DateUtils.setTimeToDate2(new Date(), detalii)) == null) continue;
                        done = true;
                        newStartTimeForOrder = DateUtils.addMinutesToDate(newStartTimeForOrder, -VpConfig.getInstance().productieViewAheadMinutes);
                        LivrariOrderPanel.this.order.setStartTime(newStartTimeForOrder.getTime());
                        LivrariOrderPanel.this.logic.updateStartTimeForOrder(LivrariOrderPanel.this.order, newStartTimeForOrder);
                    }
                }
            });
            oraLivrare.setFont(bonItemFont);
            popup.add(oraLivrare);
            if (!this.marcajOnly && VpConfig.getInstance().showProtocolButton) {
                JMenuItem protocol = new JMenuItem(LangRoAll.protocol);
                protocol.setFont(bonItemFont);
                popup.add(protocol);
                protocol.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        User supervizor = null;
                        if (LivrariOrderPanel.this.config.passwordForProtocol) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !LivrariOrderPanel.this.config.passwordForProtocol) {
                            LivrariOrderPanel.this.createOrderIfNull();
                            if (!LivrariOrderPanel.this.order.isLaPlata()) {
                                boolean isProtocol = LivrariOrderPanel.this.order.isProtocol();
                                boolean newState = !isProtocol;
                                LivrariOrderPanel.this.logic.setProtocolForOrder(LivrariOrderPanel.this.order, newState);
                                LivrariOrderPanel.this.order.setProtocol(newState);
                                LivrariOrderPanel.this.setPromotionText();
                            }
                        }
                    }
                });
            }
            if (!this.marcajOnly && VpConfig.getInstance().showTipsButton) {
                JMenuItem tips = new JMenuItem(LangRoAll.tips);
                tips.setFont(bonItemFont);
                popup.add(tips);
                tips.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (LivrariOrderPanel.this.order != null) {
                            double proposedTips = LivrariOrderPanel.this.logic.computeTipsForOrder(LivrariOrderPanel.this.order);
                            if (proposedTips >= 0.0) {
                                String value = DialogUtils.inputDialog(parent, Utils.getString2Decimals(proposedTips), LangRoAll.totalTips);
                                if (Validators.correctDouble(value)) {
                                    double totalTips = Utils.parseDouble(value);
                                    LivrariOrderPanel.this.logic.setTipsToOrder1(LivrariOrderPanel.this.order, totalTips, null);
                                    Vector<Sale> s = LivrariOrderPanel.this.logic.getSales(LivrariOrderPanel.this.order.getId(), true, -1, new ScreenSaleInterface());
                                    LivrariOrderPanel.this.orderTm.updateTable(s);
                                    LivrariOrderPanel.this.updateOrderTotal();
                                } else {
                                    DialogUtils.errorDialog(parent, LangRoAll.valoareIncorecta, LangRoAll.nuPotContinua);
                                }
                            } else if (proposedTips == -1.0) {
                                DialogUtils.errorDialog(parent, LangRoAll.completatiCodProdusTips, LangRoAll.nuPotContinua);
                            } else if (proposedTips == -2.0) {
                                DialogUtils.errorDialog(parent, LangRoAll.codProdusTipsIncorect, LangRoAll.nuPotContinua);
                            }
                        } else {
                            DialogUtils.errorDialog(parent, LangRoAll.comandaGoala, LangRoAll.nuPotContinua);
                        }
                    }
                });
            }
            if (!this.marcajOnly && this.logic.getCashRegister().numerarInputReady()) {
                btn = new JMenuItem(LangRoAll.incarcaCasa);
                popup.add(btn);
                btn.setFont(bonItemFont);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        String s = DialogUtils.inputDialog(parent, "0", LangRoAll.valoareIncarcaCasa);
                        if (!Validators.correctDouble(s)) {
                            DialogUtils.errorDialog(parent, LangRoAll.valoareIncorecta, LangRoAll.nuPotContinua);
                            return;
                        }
                        double value = Utils.parseDouble(s);
                        LivrariOrderPanel.this.logic.introduNumerar(value);
                    }
                });
            }
            if (!this.marcajOnly) {
                JMenuItem forceTotal = new JMenuItem(LangRoAll.totalCasaMarcat);
                popup.add(forceTotal);
                forceTotal.setFont(bonItemFont);
                forceTotal.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        LivrariOrderPanel.this.logic.forceEcrTotal();
                    }
                });
            }
            if (!this.marcajOnly) {
                JMenuItem recomputePrices = new JMenuItem(LangRoAll.recalculeazaNota);
                popup.add(recomputePrices);
                recomputePrices.setFont(bonItemFont);
                recomputePrices.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        LivrariOrderPanel.this.logic.recomputePrices(LivrariOrderPanel.this.order);
                        LivrariOrderPanel.this.refreshOrderSales();
                        LivrariOrderPanel.this.updateOrderTotal();
                    }
                });
            }
            if (!this.marcajOnly && VpConfig.getInstance().showProformaButton) {
                btn = new JMenuItem(LangRoAll.proforma);
                popup.add(btn);
                btn.setFont(bonItemFont);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        User supervizor = null;
                        if (LivrariOrderPanel.this.config.passwordForProforma) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !LivrariOrderPanel.this.config.passwordForProforma) {
                            LivrariOrderPanel.this.logic.notaProforma(LivrariOrderPanel.this.order, LivrariOrderPanel.this.table, null);
                        }
                    }
                });
            }
            if (!this.marcajOnly && VpConfig.getInstance().showIntermediaraButton) {
                btn = new JMenuItem(LangRoAll.intermediara);
                popup.add(btn);
                btn.setFont(bonItemFont);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        User supervizor = null;
                        if (LivrariOrderPanel.this.config.passwordForIntermediara) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !LivrariOrderPanel.this.config.passwordForIntermediara) {
                            LivrariOrderPanel.this.logic.notaIntermediara(LivrariOrderPanel.this.order, LivrariOrderPanel.this.table, null);
                        }
                    }
                });
            }
            if (!this.marcajOnly && VpConfig.getInstance().showFacturaButton) {
                btn = new JMenuItem(LangRoAll.factura);
                popup.add(btn);
                btn.setFont(bonItemFont);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (LivrariOrderPanel.this.order != null) {
                            if (LivrariOrderPanel.this.order.getIdClient() > 0) {
                                GuiUtilsRest.facturareDinComanda(LivrariOrderPanel.this.order, LivrariOrderPanel.this.waiter, parent, -1);
                            } else {
                                DialogUtils.errorDialog(parent, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                            }
                        } else {
                            DialogUtils.errorDialog(parent, LangRoAll.comandaGoala, LangRoAll.nuPotContinua);
                        }
                    }
                });
            }
            if (VpConfig.getInstance().showReloadClientiButton) {
                JMenuItem client = new JMenuItem(LangRoAll.reincarcaClienti);
                client.setFont(bonItemFont);
                popup.add(client);
                final ClientEditPanelProvider provider = new ClientEditPanelProvider(){

                    @Override
                    public PersFizicaAddEditPanel getPfPanel() {
                        return new PersFizicaAddEditPanelShort();
                    }

                    @Override
                    public PersJuridicaAddEditPanel getPjPanel() {
                        return new PersJuridicaAddEditPanel();
                    }
                };
                client.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LivrariOrderPanel.this.createOrderIfNull();
                        ClientSelectDialog dia = new ClientSelectDialog(GuiUtils.currentFrame);
                        int sel = dia.getSelected();
                        Client c = dia.getSelectedClient();
                        if (sel != -1) {
                            if (dia.isMustEdit() || LivrariOrderPanel.this.config.showClientEditDialogAtClientSelection) {
                                ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), c, c instanceof ClientPersJuridica, provider);
                            }
                        } else if (dia.isMustAdd()) {
                            boolean pf = DialogUtils.confirmDialog(parent, LangRoAll.adaugamPersFizica, LangRoAll.persFizicaJuridica);
                            ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), null, !pf, provider);
                            sel = cDia.getClientId();
                        }
                        if (sel != -1) {
                            LivrariOrderPanel.this.logic.setClientForOrder(LivrariOrderPanel.this.order, sel, dia.getSelectedAdresa());
                            LivrariOrderPanel.this.setClientText();
                            double totalOrder1 = LivrariOrderPanel.this.logic.getTotal(LivrariOrderPanel.this.order);
                            Vector premii = LivrariOrderPanel.this.logic.getPremiiForClient(sel, totalOrder1);
                            if (premii.size() > 0) {
                                String message = Utils.getStringForJDialogList(LangRoAll.premiiPosibile, "", premii);
                                DialogUtils.okDialog(parent, message, LangRoAll.premiiPosibile);
                            }
                        }
                    }
                });
            }
            if (VpConfig.getInstance().showFidelitateButton) {
                JMenuItem fidelitate = new JMenuItem(LangRoAll.fidelitate);
                fidelitate.setFont(bonItemFont);
                popup.add(fidelitate);
                fidelitate.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        User supervizor = null;
                        if (LivrariOrderPanel.this.config.passwordForFidelitate) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !LivrariOrderPanel.this.config.passwordForFidelitate) {
                            CardInputDialog dialog;
                            final StringBuffer card = new StringBuffer();
                            EventGenerator soyal = LivrariOrderPanel.this.logic.getAccesInterface();
                            if (soyal != null) {
                                dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().codFidelitateLength);
                                LivrariOrderPanel.this.main.requestFocus();
                                ObjectEventListener l = new ObjectEventListener(){

                                    @Override
                                    public void dataChanged(Object o) {
                                        card.append(o);
                                        dialog.dispose();
                                    }

                                    @Override
                                    public String getName() {
                                        return "touch3_soyal_fidelitate";
                                    }
                                };
                                soyal.addObjectListener(l, 701);
                                dialog.setVisible(true);
                                soyal.removeObjectListener(l);
                            } else {
                                dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().codFidelitateLength);
                                dialog.setVisible(true);
                                LivrariOrderPanel.this.main.requestFocus();
                                card.append(dialog.getCodAutentificare());
                            }
                            ClientPromotieView cpv = PromotionLogic.getInstance().getClientPromotieForCard(card.toString());
                            if (cpv != null) {
                                LivrariOrderPanel.this.createOrderIfNull();
                                double totalOrder1 = LivrariOrderPanel.this.logic.getTotal(LivrariOrderPanel.this.order);
                                Vector premii = LivrariOrderPanel.this.logic.getPremiiForClient(cpv.getIdClient(), totalOrder1);
                                if (premii.size() > 0) {
                                    String message = Utils.getStringForJDialogList(LangRoAll.premiiPosibile, "", premii);
                                    DialogUtils.okDialog(parent, message, LangRoAll.premiiPosibile);
                                }
                                if (!LivrariOrderPanel.this.order.isLaPlata()) {
                                    LivrariOrderPanel.this.order.setIdPromotie(cpv.getIdPromotie());
                                    LivrariOrderPanel.this.order.setIdClient(cpv.getIdClient());
                                    LivrariOrderPanel.this.logic.setClientAndPromotionForOrder(LivrariOrderPanel.this.order, cpv.getIdClient(), cpv.getIdPromotie());
                                    LivrariOrderPanel.this.setPromotionText();
                                    LivrariOrderPanel.this.setClientText();
                                }
                            }
                        }
                    }
                });
            }
            if (VpConfig.getInstance().showPromoButton) {
                JMenuItem promotie = new JMenuItem(LangRoAll.promotie);
                promotie.setFont(bonItemFont);
                popup.add(promotie);
                promotie.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        User supervizor = null;
                        if (LivrariOrderPanel.this.config.passwordForPromo) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !LivrariOrderPanel.this.config.passwordForPromo) {
                            Vector<Promotion> promotii;
                            LivrariOrderPanel.this.createOrderIfNull();
                            if (!LivrariOrderPanel.this.order.isLaPlata() && (promotii = PromotionLogic.getInstance().getFidelitatePromotions()).size() > 0) {
                                PromotiiDialog dialog = new PromotiiDialog(4, promotii);
                                int idPromotie = dialog.getSelected();
                                LivrariOrderPanel.this.logic.setPromotionForOrder(LivrariOrderPanel.this.order, idPromotie);
                                LivrariOrderPanel.this.order.setIdPromotie(idPromotie);
                                LivrariOrderPanel.this.setPromotionText();
                            }
                        }
                    }
                });
            }
            if (!this.marcajOnly && VpConfig.getInstance().showIncarcaContButtons) {
                Vector<TipCont> conturi = ClientLogic.getInstance().getAllConturi();
                for (int i = 0; i < conturi.size(); ++i) {
                    final TipCont tipCont = conturi.elementAt(i);
                    JMenuItem contButton = new JMenuItem(LangRoAll.incarca + " " + tipCont.getLabel());
                    contButton.setFont(bonItemFont);
                    popup.add(contButton);
                    contButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            if (LivrariOrderPanel.this.order == null) {
                                return;
                            }
                            if (LivrariOrderPanel.this.order.getIdClient() == -1) {
                                DialogUtils.errorDialog(parent, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                                return;
                            }
                            User supervizor = null;
                            if (LivrariOrderPanel.this.config.passwordForIncarcareCont) {
                                supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                            }
                            if (supervizor != null || !LivrariOrderPanel.this.config.passwordForIncarcareCont) {
                                String valueS = "";
                                if (tipCont.getProdusFictiv() > 0) {
                                    double value = LivrariOrderPanel.this.logic.getPriceForProductCommit(tipCont.getProdusFictiv());
                                    valueS = Utils.getString2Decimals(value);
                                }
                                String input = DialogUtils.inputDialog(parent, valueS, LangRoAll.valoare);
                                try {
                                    boolean printBF;
                                    if (!Validators.correctDouble(input)) {
                                        return;
                                    }
                                    double sum = Utils.parseDouble(input);
                                    ClientLogic.getInstance().adaugaTranzactieClient(tipCont.getId(), LivrariOrderPanel.this.order.getIdClient(), sum, LangRoAll.alimentareCont);
                                    if (tipCont.getProdusFictiv() > 0 && sum > 0.0 && (printBF = DialogUtils.confirmDialog(parent, LangRoAll.tiparimBonFiscal, LangRoAll.confirmare))) {
                                        RestLogic.getInstance().printBonFiscalAlimentareCont(tipCont.getProdusFictiv(), sum, LivrariOrderPanel.this.table, LivrariOrderPanel.this.waiter.getId(), LivrariOrderPanel.this.order.getIdClient());
                                    }
                                    LivrariOrderPanel.this.setClientText();
                                }
                                catch (NumberFormatException e) {
                                    Logger.logException(this, (Exception)e);
                                }
                            }
                        }
                    });
                    contButton.setFocusable(false);
                }
            }
            if (VpConfig.getInstance().touch2BonFiscalLiberShowButton) {
                String property = VpConfig.getInstance().touch2BonFiscalLiberOptions;
                Vector options = Utils.splitString(property, '|');
                for (int i = 0; i < options.size(); ++i) {
                    Product p;
                    String idS = (String)options.elementAt(i);
                    if (!Validators.correctInteger(idS) || (p = NomeclaturaLogic.getInstance().getProductByCod(Integer.parseInt(idS))) == null) continue;
                    JMenuItem contButton = new JMenuItem(LangRoAll.bonFiscal + " " + p.getName());
                    contButton.setFont(bonItemFont);
                    popup.add(contButton);
                    double pret = this.logic.getPriceForProductCommit(p.getId());
                    final String pretS = Utils.getString2Decimals(pret);
                    contButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            String valoare = DialogUtils.inputDialog(parent, pretS, LangRoAll.valoare);
                            if (Validators.correctDouble(valoare)) {
                                double val = Utils.parseDouble(valoare);
                                RestLogic.getInstance().printBonFiscalLiber(p, val, LivrariOrderPanel.this.waiter);
                            } else {
                                DialogUtils.errorDialog(parent, LangRoAll.valoareIncorecta, LangRoAll.nuPotContinua);
                            }
                        }
                    });
                    contButton.setFocusable(false);
                }
            }
            if (!this.marcajOnly) {
                Location loc = this.logic.getLocationById(this.table.getIdLocatie());
                JMenuItem schimbaOspatar = new JMenuItem(LangRoAll.schimbaOspatar);
                schimbaOspatar.setFont(bonItemFont);
                popup.add(schimbaOspatar);
                schimbaOspatar.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (LivrariOrderPanel.this.order == null) {
                            return;
                        }
                        if (!DialogUtils.confirmDialog(parent, LangRoAll.schimbamOspatarul, LangRoAll.confirmare)) {
                            return;
                        }
                        Vector users = LivrariOrderPanel.this.logic.getWaiters();
                        User supervizor = null;
                        if (LivrariOrderPanel.this.config.passwordForSchimbareOspatar) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (!(supervizor == null && LivrariOrderPanel.this.config.passwordForSchimbareOspatar || !VpConfig.getInstance().allowSchimbareOspatarAfterNota && LivrariOrderPanel.this.order.isLaPlata() || users.size() <= 0)) {
                            ChooseUserDialog dialog1 = new ChooseUserDialog(4, users);
                            int idUser = dialog1.getSelected();
                            LivrariOrderPanel.this.logic.setUserToOrder(idUser, LivrariOrderPanel.this.order);
                        }
                    }
                });
            }
            JMenuItem observatiiClient = new JMenuItem("Observatii client");
            observatiiClient.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    String detalii;
                    LivrariOrderPanel.this.createOrderIfNull();
                    if (LivrariOrderPanel.this.order.getIdClient() > 0 && (detalii = DialogUtils.inputDialog(parent, "", LangRoAll.detalii)) != null) {
                        String now = Formatters.DATE_AND_TIME_FORMAT.format(new Date());
                        ContracteLogic.getInstance().addComment(now + ": " + detalii, LivrariOrderPanel.this.order.getIdClient());
                    }
                }
            });
            observatiiClient.setFont(bonItemFont);
            observatiiClient.setFocusable(false);
            popup.add(observatiiClient);
            if (VpConfig.getInstance().bonFiscalPrintCodFiscal) {
                JMenuItem item = new JMenuItem(Utils.getTranslation(LangRoAll.codFiscal, new String[0]));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (LivrariOrderPanel.this.order != null) {
                            GuiUtilsRest.setCodFiscalToOrder(parent, LivrariOrderPanel.this.order);
                        }
                    }
                });
                item.setFont(bonItemFont);
                popup.add(item);
            }
            if ((optiuneButton = VpConfig.getInstance().showReducereValoricaButton) == 1 || optiuneButton == 2) {
                JMenuItem item = new JMenuItem(Utils.getTranslation(LangRoAll.reducereValorica));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        User supervizor = null;
                        if (optiuneButton == 1 && (supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true)) == null) {
                            return;
                        }
                        String reducereValorica = DialogUtils.inputDialog(parent, "", LangRoAll.reducereValorica);
                        if (reducereValorica != null && Validators.correctDouble(reducereValorica)) {
                            double reducereValoricaFloat = Utils.parseDouble(reducereValorica);
                            RestLogic.getInstance().applyAndSetReducereValoricaToOrder(LivrariOrderPanel.this.order, reducereValoricaFloat);
                            LivrariOrderPanel.this.order.setReducereValorica(reducereValoricaFloat);
                        } else {
                            DialogUtils.errorDialog(parent, "Introduceti o valoare corecta", LangRoAll.nuPotContinua);
                        }
                        LivrariOrderPanel.this.refreshOrderSales();
                        LivrariOrderPanel.this.updateOrderTotal();
                    }
                });
                item.setFont(bonItemFont);
                popup.add(item);
            }
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
        return popup;
    }

    public void setTable(Table t, User w, Order o, boolean fromMarcaj, boolean fromRefresh) {
        this.order = o;
        this.waiter = w;
        this.table = t;
        this.platou = false;
        this.platouId = -1;
        if (o != null) {
            this.platouId = this.logic.getMaxPlatouIdForOrder(o);
        }
        this.setPlatouButtonText();
        this.changeTabs(this.order);
        this.setFields(t, w);
        this.scrollOrderJTable();
        if (!fromMarcaj && this.preorderTm.getRowCount() > 0) {
            if (!fromRefresh) {
                DialogUtils.errorDialog(this, LangRoAll.existaProdNemarcate, LangRoAll.marcatiSauStergeti);
            }
            this.tabs.setSelectedIndex(0);
        }
    }

    protected void changeTabs(Order o) {
        if (o != null) {
            this.tabs.setSelectedIndex(1);
        } else {
            this.tabs.setSelectedIndex(0);
        }
    }

    protected void setFields(Table t, User w) {
        TipPlataProvider.getInstance().cleanPlatiLabel1();
        this.tableText.setText(t.getLabel());
        this.ospatarText.setText(w.getLogin());
        this.table = t;
        this.waiter = w;
        if (this.order != null) {
            if (this.order.isLaPlata()) {
                if (!this.marcajOnly) {
                    this.incasat.setEnabled(true);
                }
                if (!this.config.allowMarcajAfterNota) {
                    this.marcaj.setEnabled(false);
                }
            } else {
                this.incasat.setEnabled(false);
                this.marcaj.setEnabled(true);
            }
            this.refreshOrderSales();
            Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(this.order.getId());
            TipPlataProvider.getInstance().updatePlatiLabels(plati, this.op);
        } else {
            this.incasat.setEnabled(false);
            this.marcaj.setEnabled(true);
            this.orderTm.clear();
        }
        this.updateOrderTotal();
        this.setPromotionText();
        this.setClientText();
    }

    protected void refreshOrderSales() {
        this.orderTm.updateTable(this.logic.getSales(this.order.getId(), true, -1, new ScreenSaleInterface()));
    }

    protected void updateOrderTotal() {
        String newTotal = Utils.getString2Decimals(this.orderTm.getTotal());
        this.totalOrder.setText(newTotal);
    }

    public void setPromotionText() {
        if (this.order != null) {
            Promotion promo = PromotionLogic.getInstance().getPromotionById(this.order.getIdPromotie());
            if (promo != null) {
                String promoName = promo.getLabel();
                this.promoText.setText(promoName);
            } else {
                this.promoText.setText("");
            }
        } else {
            this.promoText.setText("");
        }
        if (this.order != null && this.order.isProtocol()) {
            this.promoText.setText(LangRoAll.protocol);
        }
    }

    protected void setClientText() {
        if (this.order != null) {
            Client c = ClientLogic.getInstance().getClientById(this.order.getIdClient());
            if (c != null) {
                this.clientText.setText(c.toString() + " " + ClientLogic.getInstance().getDetaliiConturi(c.getId()));
            } else {
                this.clientText.setText("");
            }
        } else {
            this.clientText.setText("");
        }
    }

    protected void incasat() {
        boolean ok = false;
        if (this.config.passwordForIncasat) {
            User supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
            if (supervizor != null) {
                ok = true;
            }
        } else {
            ok = true;
        }
        if (!ok) {
            return;
        }
        if (!this.config.bonFiscalAtNota) {
            if (this.logic.cashRegisterLikesPlati(this.order)) {
                this.logic.printBonFiscalSeparat(this.order, true);
            } else {
                DialogUtils.errorDialog(this, LangRoAll.casaMarcatUnModPlata, LangRoAll.nuPotContinua);
                return;
            }
        }
        this.logic.closeOrder(this.order);
        this.marcaj.setEnabled(true);
        this.incasat.setEnabled(false);
        this.order = null;
        TipPlataProvider.getInstance().cleanPlatiLabel1();
        RestLogic.getInstance().switchAfisajClientOrderCommit(-1);
        this.main.inchideClient();
    }

    private boolean nota(ActionEvent e) {
        if (this.order != null) {
            if (this.order.getIdClient() <= 0 && this.orderTm.getAllSales().size() > 0) {
                return false;
            }
            double maxValNota = VpConfig.getInstance().notaMaxValue;
            if (maxValNota > 0.0 && RestLogic.computeTotalForSales(this.orderTm.getAllSales()) >= maxValNota && !DialogUtils.confirmDialog(GuiUtils.currentFrame, "Valoare nota > " + maxValNota + " . Sunteti sigur ", LangRoAll.confirmare)) {
                return false;
            }
            this.logic.laPlataOrder(this.order, this.table, this.forcedPrinter);
            if (this.config.bonFiscalAtNota) {
                if (this.logic.cashRegisterLikesPlati(this.order)) {
                    this.logic.printBonFiscalSeparat(this.order, true);
                } else {
                    DialogUtils.errorDialog(this, LangRoAll.casaMarcatUnModPlata, LangRoAll.nuPotContinua);
                    return false;
                }
            }
            if (!this.config.allowMarcajAfterNota) {
                this.marcaj.setEnabled(false);
            }
            if (!this.marcajOnly) {
                this.incasat.setEnabled(true);
            }
            this.setFields(this.table, this.waiter);
            return true;
        }
        return false;
    }

    protected void setPlatouButtonText() {
        if (this.platou) {
            this.platouButton.setText(this.platouStringStop);
        } else {
            this.platouButton.setText(this.platouString);
        }
    }

    protected Order createOrderIfNull() {
        if (this.order == null) {
            this.order = this.logic.newOrder(this.table.getId(), this.waiter.getId());
        }
        return this.order;
    }

    protected void deleteSingleProduct(double toDelete, Component panel, Sale s, int selRow) {
        User supervizor = null;
        if (this.config.livrariPasswordForStergereRetur) {
            String previousTitle = LoginDialog.title;
            LoginDialog.title = "-" + Utils.getString3Decimals(toDelete) + " " + s.getProductName() + "?";
            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
            LoginDialog.title = previousTitle;
        }
        if (supervizor != null || !this.config.livrariPasswordForStergereRetur) {
            if (!DialogUtils.confirmDialog(panel, LangRoAll.retur + " " + Utils.getString3Decimals(toDelete) + " \"" + s.getProductName() + "\"", LangRoAll.confirmare)) {
                return;
            }
            User u = supervizor != null ? supervizor : this.waiter;
            this.logic.decrementSale(this.order, s, u, "", toDelete, this.table, null);
            if (s.getCantitateMarcata() == 0.0) {
                this.orderTm.removeTempSale(s, selRow);
            }
            this.orderTm.fireTableDataChanged();
            this.updateOrderTotal();
        } else {
            DialogUtils.errorDialog(panel, LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
        }
    }

    protected void deleteAllPlateau(double toDelete, Component panel, Sale s) {
        User supervizor = null;
        if (this.config.livrariPasswordForStergereRetur) {
            String previousTitle = LoginDialog.title;
            LoginDialog.title = "-" + Utils.getString3Decimals(toDelete) + " " + LangRoAll.platou + "?";
            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
            LoginDialog.title = previousTitle;
        }
        if (supervizor != null || !this.config.livrariPasswordForStergereRetur) {
            if (!DialogUtils.confirmDialog(panel, LangRoAll.retur + " " + Utils.getString3Decimals(toDelete) + " \"" + LangRoAll.platou + "\"", LangRoAll.confirmare)) {
                return;
            }
            User u = supervizor != null ? supervizor : this.waiter;
            int idPlatou = s.getIdPlatou();
            for (int i = 0; i < this.orderTm.getAllSales().size(); ++i) {
                Sale sale = (Sale)this.orderTm.getAllSales().elementAt(i);
                if (sale.getIdPlatou() != idPlatou) continue;
                this.logic.decrementSale(this.order, sale, u, "", toDelete, this.table, null);
            }
            this.refreshOrderSales();
            this.orderTm.fireTableDataChanged();
            this.updateOrderTotal();
        } else {
            DialogUtils.errorDialog(panel, LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
        }
    }

    @Override
    public void readQuantity(double f) {
        Logger.logDebug(this, "Received quantity: " + Utils.getString3Decimals(f));
        this.kp.setNumber(f);
        this.readFromCantar = false;
    }

    protected LivrariTableModel getOrderTM() {
        return new LivrariTableModel();
    }

    protected LivrariTableModel getPreorderTM() {
        return new LivrariTableModel();
    }

    public void readyForIncasat() {
    }
}

