/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.orders;

import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.multilang.LangRoAll;

public class BonTableModel
extends AbstractTableModel {
    private String[] _columnNames = new String[]{LangRoAll.denumire, "Nr. portii", "Preparare"};
    private Class[] _columnTypes = new Class[]{String.class, Double.class, String.class};
    private Hashtable categories = new Hashtable();
    private Vector allProducts = new Vector();
    public static final int CLIENT = 1;

    @Override
    public int getColumnCount() {
        return this._columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.allProducts.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.allProducts == null) {
            return null;
        }
        if (rowIndex >= this.allProducts.size() || columnIndex >= this._columnNames.length) {
            return null;
        }
        Sale o = (Sale)this.allProducts.elementAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                return o.getProductName();
            }
            case 1: {
                return new Double(o.getCantitateNoua());
            }
            case 2: {
                return o.getModPreparare();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex >= this._columnTypes.length) {
            return String.class;
        }
        return this._columnTypes[columnIndex];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex >= this._columnNames.length) {
            return "";
        }
        return this._columnNames[columnIndex];
    }

    public void addProduct(Product o, double nrPortii, String modPreparare, int idPlatou) {
        long now = System.currentTimeMillis();
        Sale s = RestLogic.getInstance().buildSale(o, 0.0, nrPortii, modPreparare, -1, idPlatou, -1, -1, -1, now, -1);
        Sectie c = RestLogic.getInstance().getSectieByCategorieId(o.getIdCategorie());
        Vector<Sale> prodsForCategory = (Vector<Sale>)this.categories.get(c.getId());
        if (prodsForCategory == null) {
            prodsForCategory = new Vector<Sale>();
            this.categories.put(c.getId(), prodsForCategory);
        }
        boolean found = false;
        for (int i = 0; i < prodsForCategory.size(); ++i) {
            Sale s1 = (Sale)prodsForCategory.elementAt(i);
            if (s1.getIdProduct() != s.getIdProduct() || s1.getIdPlatou() != s.getIdPlatou()) continue;
            s1.setCantitateNoua(s1.getCantitateNoua() + s.getCantitateNoua());
            found = true;
            break;
        }
        if (!found) {
            prodsForCategory.add(s);
            this.allProducts.add(s);
        }
        this.fireTableDataChanged();
    }

    public void removeProductAtRow(int row, double toRemove) {
        Sale o = (Sale)this.allProducts.get(row);
        o.setCantitateNoua(o.getCantitateNoua() - toRemove);
        if (o.getCantitateNoua() <= 0.0) {
            this.allProducts.remove(o);
            Vector prods = (Vector)this.categories.get(o.getIdSectie());
            prods.remove(o);
        }
        this.fireTableDataChanged();
    }

    public Vector getTemporarySales(int idCategory) {
        Vector salesForCategory = (Vector)this.categories.get(idCategory);
        return salesForCategory;
    }

    public void resetProducts() {
        this.allProducts = new Vector();
        this.categories = new Hashtable();
        this.fireTableDataChanged();
    }

    public Vector getAllTempSales() {
        return this.allProducts;
    }
}

