/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.orders;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.promo.ClientPromotieView;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class CardReaderInterface
extends ReflectedJPanel {
    public static final int FONT_SIZE = 30;
    private JButton ospatarBtn;
    private JButton adminBtn;
    private JButton alimenteaza;
    private JButton cancel;
    private JLabel codLabel;
    private JLabel clientLabel;
    private JLabel valoareContLabel;
    private JLabel codValue;
    private JLabel clientValue;
    private JLabel valoareContValue;
    private User waiter;
    private Client identified;

    public CardReaderInterface() {
        this.init();
        this.display();
    }

    private void init() {
        this.ospatarBtn = new JButton(LangRoAll.utilizator);
        this.adminBtn = new JButton(LangRoAll.administrare);
        this.ospatarBtn.setFocusable(false);
        this.adminBtn.setFocusable(false);
        this.adminBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CardReaderInterface.this.doAdminLogin();
            }
        });
        this.ospatarBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CardReaderInterface.this.loginUser();
            }
        });
    }

    public void cleanup() {
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.codLabel = new JLabel("Cod");
        this.codLabel.setFont(new Font(null, 0, 30));
        this.add((Component)this.codLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.codValue = new JLabel("");
        this.codValue.setFont(new Font(null, 0, 30));
        this.add((Component)this.codValue, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.clientLabel = new JLabel(LangRoAll.client);
        this.clientLabel.setFont(new Font(null, 0, 30));
        this.add((Component)this.clientLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.clientValue = new JLabel("");
        this.clientValue.setFont(new Font(null, 0, 30));
        this.add((Component)this.clientValue, c);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                System.out.println("keypressed " + e.getKeyCode());
            }

            @Override
            public void keyReleased(KeyEvent e) {
                CardReaderInterface.this.handleKey(e.getKeyCode(), e.getKeyChar());
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.requestFocus();
    }

    private void digitPressed(char digit) {
        this.codValue.setText(this.codValue.getText() + digit);
        if (this.codValue.getText().length() == VpConfig.getInstance().codFidelitateLength) {
            this.updateProductText();
        }
    }

    private void handleKey(int keyCode, char keyChar) {
        if (this.waiter == null) {
            this.loginUser();
        }
        switch (keyCode) {
            case 8: {
                String text = this.codValue.getText();
                if (text.length() > 0) {
                    text = text.substring(0, text.length() - 1);
                    this.codValue.setText(text);
                }
                this.updateProductText();
                break;
            }
            default: {
                this.digitPressed(keyChar);
            }
        }
    }

    private void updateProductText() {
        ClientPromotieView cpv = PromotionLogic.getInstance().getClientPromotieForCard(this.codValue.getText());
        if (cpv != null) {
            this.identified = ClientLogic.getInstance().getClientById(cpv.getIdClient());
            this.clientLabel.setText(this.identified.toString());
        } else {
            this.clientLabel.setText("");
        }
    }

    private void loginUser() {
        User u = UsersLogic.getInstance().requestWaiterLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, VpConfig.getInstance().requestPasswordForWaitersSelection);
        if (u != null) {
            this.waiter = u;
        } else {
            DialogUtils.errorDialog(this, "Utilizator sau parola incorecte", LangRoAll.nuPotContinua);
        }
    }

    private void doAdminLogin() {
        GuiUtilsRest.doAdminLogin(RestLogic.getInstance());
    }

    @Override
    public void doStuff() {
    }
}

