/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.orders;

import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.gui.touch.TouchOrderTableModel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.multilang.LangRoAll;

public class KeysTableModel
extends TouchOrderTableModel {
    private boolean isTableVirtuala = false;

    public void setTableVirtuala(boolean tableVirtuala) {
        this.isTableVirtuala = tableVirtuala;
    }

    public KeysTableModel() {
        this._columnNames = new String[]{LangRoAll.produs, LangRoAll.cantitate, LangRoAll.valoare};
        this._columnTypes = new Class[]{String.class, String.class, String.class};
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this._sales == null) {
            return null;
        }
        if (rowIndex > this._sales.size() || rowIndex < 0 || columnIndex < 0 || columnIndex >= this._columnNames.length) {
            return null;
        }
        Sale o = (Sale)this._sales.elementAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                String s = o.getProductName();
                String mp = o.getModPreparare();
                String detalii = "";
                if (Validators.correctString(mp)) {
                    detalii = detalii + mp + ", ";
                }
                if (Validators.correctString(o.getFreeS1())) {
                    detalii = detalii + o.getFreeS1() + ", ";
                }
                if (Validators.correctString(o.getFreeS2())) {
                    detalii = detalii + o.getFreeS2() + ", ";
                }
                if (o.getFreeD1() > 0.0) {
                    detalii = detalii + Utils.getString2Decimals(o.getFreeD1()) + "/" + Utils.getString2Decimals(o.getFreeD2()) + ", ";
                }
                if (detalii.endsWith(", ")) {
                    detalii = detalii.substring(0, detalii.length() - 2);
                }
                s = s + " (" + detalii + ")";
                return s;
            }
            case 1: {
                String cant = o.getQuantityForKeys();
                return cant;
            }
            case 2: {
                return this.isTableVirtuala ? "" : Utils.getString2Decimals(o.getTotal());
            }
        }
        return null;
    }
}

