/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.orders;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.ValoareContClient;
import ro.atreides.clienti.gui.ClientEditDialog;
import ro.atreides.clienti.gui.ClientEditPanelProvider;
import ro.atreides.clienti.gui.ClientSelectDialog;
import ro.atreides.clienti.gui.PersFizicaAddEditPanel;
import ro.atreides.clienti.gui.PersJuridicaAddEditPanel;
import ro.atreides.facturi.gui.AddFacturaDialog;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.nomenclatura.gui.ProductPicturePanel;
import ro.atreides.promo.ClientPromotieView;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.promo.gui.PromotiiDialog;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.restaurant.gui.orders.KeysTableModel;
import ro.atreides.restaurant.gui.orders.KeysTouchTableChooserDialog;
import ro.atreides.restaurant.gui.orders.ProductTreePanel;
import ro.atreides.restaurant.gui.touch2.TipPlataPanelInterface;
import ro.atreides.restaurant.gui.touch2.TipPlataPanelNew;
import ro.atreides.restaurant.logic.AddSaleInterface;
import ro.atreides.restaurant.logic.PaymentLogic;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.logic.VanzariXmlHandler;
import ro.atreides.restaurant.modules.scale.ScaleMessageConsumer;
import ro.atreides.stocks.BonConsumItem;
import ro.atreides.stocks.ConsumTransferInterface;
import ro.atreides.stocks.Lot;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Order;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.TipCont;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.events.EventsLogic;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.JMultilineLabel;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.CardInputDialog;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.dialogs.ItemChooserDialog;
import ro.atreides.utils.gui.keypad.KeypadListener;
import ro.atreides.utils.gui.keypad.VirtualKeypad2;
import ro.atreides.utils.gui.table.ColumnSizeProvider;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.licensing.LicenseManager;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.multilanguage.LanguageLogic;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataChooser;
import ro.atreides.utils.plati.TipPlataProvider;

public class KeysTouchMain
extends ReflectedJPanel
implements CleanupRequired,
ScaleMessageConsumer {
    private static final int TOP_PANEL_FONT_SIZE = 20;
    private static final int TOP_PANEL_MAX_TEXT_SIZE = 350;
    private static final int TABLE_FONT_SIZE = 20;
    private static final int POPUP_FONT_SIZE = 25;
    private static final int PRODUCTS_COMBO_FONT_SIZE = 15;
    private static final int DIVIDED_SIZE = 20;
    private static final double DIVIDER_WEIGHT = 0.4;
    protected static final int PRODUCT_TREE_FONT_SIZE = 15;
    protected static final int SCROLLBAR_SIZE = 20;
    protected static final int KEYPAD_FONT_SIZE = 25;
    private static boolean addWaiterName = true;
    protected static final String KEYSTOUCHSHOWDOT = "keystouchshowdot";
    protected static final String X_COMBO_SEARCH_IN_PRODUCT = "XComboSearchInProduct";
    protected static final String TOUCH_2_TIP_PLATA_FONT_SIZE = "touch2TipPlataFontSize";
    protected static final String KEYS_TIPURI_DE_PLATA = "keysTipuriDePlata";
    protected RestLogic logic;
    protected JLabel codValue;
    protected JLabel total;
    protected JLabel pretValue;
    protected JMultilineLabel promoValue;
    protected JMultilineLabel clientValue;
    private JMultilineLabel denumireValue;
    protected KeysTableModel _orderTableModel = null;
    private JTable _orderTable = null;
    protected User waiter;
    protected Product identified = null;
    private int idLot = -1;
    private Hashtable orders = new Hashtable();
    private Hashtable tables = new Hashtable();
    protected int _currentSlot;
    protected JPanel up;
    public static Vector locations;
    public static Vector sectii;
    private Vector allTables;
    private boolean cumulateSales = false;
    private double pretCurent = -1.0;
    private int idCategorieUndefined = -1;
    protected XComboBox produseCombo;
    private FilterableComboBoxModel produseComboModel;
    protected VirtualKeypad2 kp;
    protected JButton productsAddButton;
    protected JButton productsCancelButton;
    protected JButton codButton;
    protected JButton cantarButton;
    protected JButton comenzi;
    protected boolean readFromCantar = false;
    private ProductPicturePanel ppp;
    private boolean isRetur = false;
    private int idOrder = -1;
    protected TipPlataPanelNew platiPanel;
    public static boolean showGolireButton;
    public static boolean showTransferButton;
    public static boolean showConsumButton;
    public static boolean showRestituireButton;
    public static boolean showInchideButton;

    public KeysTouchMain() {
        this.logic = RestLogic.getInstance();
        addWaiterName = Config.getInstance().getBoolean(KEYSTOUCHSHOWDOT);
        this.init();
        this.display();
        Categorie c = NomeclaturaLogic.getInstance().getCategoryByName("UndefinedC");
        if (c != null) {
            this.idCategorieUndefined = c.getId();
        }
        RestLogic.getInstance().addScaleConsumer(this);
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                GuiUtils.updateJTableColumnSize(KeysTouchMain.this._orderTable, new ColumnSizeProvider(){

                    @Override
                    public int getColumnSize(int column) {
                        switch (column) {
                            case 0: {
                                return 6;
                            }
                            case 1: {
                                return 1;
                            }
                            case 2: {
                                return 1;
                            }
                        }
                        return 1;
                    }
                });
                GuiUtils.updateJTableRowSize(KeysTouchMain.this._orderTable, 20);
            }
        }.start();
    }

    private void init() {
        this.codValue = new JLabel("");
        this.codValue.setFont(new Font(null, 0, 20));
        this.denumireValue = new JMultilineLabel();
        this.denumireValue.setJustified(true);
        this.denumireValue.setMaxWidth(350);
        this.denumireValue.setFont(new Font(null, 0, 20));
        this.pretValue = new JLabel("");
        this.pretValue.setFont(new Font(null, 0, 20));
        this.clientValue = new JMultilineLabel();
        this.clientValue.setFont(new Font(null, 0, 20));
        this.promoValue = new JMultilineLabel();
        this.promoValue.setFont(new Font(null, 0, 20));
        this._orderTableModel = new KeysTableModel();
        this._orderTable = new JTable(this._orderTableModel);
        this._orderTable.setFocusable(false);
        this._orderTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot).isLaPlata()) {
                    return;
                }
                final int selRow = KeysTouchMain.this._orderTable.rowAtPoint(e.getPoint());
                if (selRow != -1) {
                    Font bonItemFont = new Font(null, 1, 25);
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem sterge = new JMenuItem(LangRoAll.sterge);
                    sterge.setFocusable(false);
                    sterge.setFont(bonItemFont);
                    sterge.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            Sale s = KeysTouchMain.this._orderTableModel.getEntryAtRow(selRow);
                            User u = UsersLogic.getInstance().getUserById(KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot).getUser());
                            VpConfig config = VpConfig.getInstance();
                            Table t = KeysTouchMain.this.getTable(KeysTouchMain.this._currentSlot);
                            boolean verificarePreturi = t.isVirtuala();
                            User supervizor = null;
                            if (config.passwordForStergereRetur && !verificarePreturi) {
                                supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                            }
                            if (supervizor != null || !config.passwordForStergereRetur || verificarePreturi) {
                                User autorizator = supervizor != null ? supervizor : u;
                                KeysTouchMain.this.logic.decrementSale(KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot), s, autorizator, "", s.getCantitateMarcata(), t, null, !verificarePreturi);
                                KeysTouchMain.this._orderTableModel.updateTable(KeysTouchMain.this.logic.getSales(s.getIdOrder(), KeysTouchMain.this.cumulateSales, -1, new ScreenSaleInterface()));
                                KeysTouchMain.this.updateTotals();
                                KeysTouchMain.this.updateRestAfterProduct();
                            }
                        }
                    });
                    popup.add(sterge);
                    if (KeysTouchMain.this.showModificaMenuItem()) {
                        JMenuItem modifica = new JMenuItem(LangRoAll.modifica);
                        modifica.setFocusable(false);
                        modifica.setFont(bonItemFont);
                        modifica.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ev) {
                                Sale s = KeysTouchMain.this._orderTableModel.getEntryAtRow(selRow);
                                User u = UsersLogic.getInstance().getUserById(KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot).getUser());
                                VpConfig config = VpConfig.getInstance();
                                User supervizor = null;
                                if (config.passwordForStergereRetur) {
                                    supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                                }
                                if (supervizor != null || !config.passwordForStergereRetur) {
                                    int idProduct = s.getIdProduct();
                                    Product p = NomeclaturaLogic.getInstance().getProductById(idProduct);
                                    if (s.getIdLot() > 0) {
                                        Lot lot = StockLogic.getInstance().getLotByIdCommit(s.getIdLot());
                                        String codLot = lot.getCodbare();
                                        KeysTouchMain.this.codValue.setText(codLot);
                                    } else {
                                        String cod = NomeclaturaLogic.getInstance().getFirstBarcodeByIdProd(idProduct);
                                        KeysTouchMain.this.codValue.setText(cod);
                                    }
                                    KeysTouchMain.this.updateProductTextCommit();
                                    double cant = s.getCantitateMarcata();
                                    KeysTouchMain.this.kp.setNumber(cant);
                                    KeysTouchMain.this.logic.decrementSale(KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot), s, u, "", s.getCantitateMarcata(), KeysTouchMain.this.getTable(KeysTouchMain.this._currentSlot), null);
                                    KeysTouchMain.this._orderTableModel.updateTable(KeysTouchMain.this.logic.getSales(s.getIdOrder(), KeysTouchMain.this.cumulateSales, -1, new ScreenSaleInterface()));
                                    KeysTouchMain.this.updateTotals();
                                }
                            }
                        });
                        popup.add(modifica);
                    }
                    popup.setInvoker(KeysTouchMain.this._orderTable);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        GuiUtils.updateJTableColumnSize(this._orderTable, this._orderTableModel);
    }

    protected boolean showModificaMenuItem() {
        return true;
    }

    protected void refreshSales() {
        this._orderTableModel.updateTable(this.logic.getSales(this.getOrder(this._currentSlot).getId(), this.cumulateSales, -1, new ScreenSaleInterface()));
    }

    protected Order getOrder(int slot) {
        Order o = (Order)this.orders.get(slot);
        return o;
    }

    protected Order getCurrentOrder() {
        return this.getOrder(this._currentSlot);
    }

    private Table getTable(int slot) {
        Table t = (Table)this.tables.get(slot);
        return t;
    }

    protected Table getCurrentTable() {
        return this.getTable(this._currentSlot);
    }

    protected void setPromotionText() {
        Order order = this.getOrder(this._currentSlot);
        if (order != null) {
            Promotion promo = PromotionLogic.getInstance().getPromotionById(order.getIdPromotie());
            if (promo != null) {
                String promoName = promo.getLabel();
                this.promoValue.setText(promoName);
            } else {
                this.promoValue.setText(" ");
            }
        } else {
            this.promoValue.setText(" ");
        }
        if (order != null && order.isProtocol()) {
            this.promoValue.setText(LangRoAll.protocol);
        }
    }

    protected void setClientText() {
        if (this.getOrder(this._currentSlot) != null) {
            Client c = ClientLogic.getInstance().getClientById(this.getOrder(this._currentSlot).getIdClient());
            if (c != null) {
                this.clientValue.setText(c.toString() + " " + ClientLogic.getInstance().getDetaliiConturi(c.getId()));
                System.out.println(">> 1");
            } else {
                this.clientValue.setText(" ");
                System.out.println(">> 2");
            }
        } else {
            this.clientValue.setText(" ");
            System.out.println(">> 3");
        }
        this.showPremiiPosibile();
    }

    @Override
    public void cleanup() {
    }

    private void display() {
        JPanel right = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 1;
        this.up = this.getUpPanel();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        right.add((Component)this.up, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        right.add((Component)this.getRightPanel(), c);
        JPanel treePanel = this.getTreePanel();
        treePanel.setFocusable(false);
        JSplitPane split = new JSplitPane(1, treePanel, right);
        split.setResizeWeight(0.4);
        split.setDividerSize(20);
        split.setOneTouchExpandable(true);
        split.setFocusable(false);
        this.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)split, c);
    }

    protected JPanel getTreePanel() {
        JPanel left = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 1;
        c.gridwidth = 2;
        Font treePanelFont = new Font(null, 0, 15);
        final ProductTreePanel productTree = new ProductTreePanel(sectii, treePanelFont);
        final JScrollPane scroll = new JScrollPane();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 1.0;
        JTree tree = this.buildTree(productTree);
        tree.setFocusable(false);
        scroll.setViewportView(tree);
        scroll.setFocusable(false);
        GuiUtils.setScrollSize(scroll, 20);
        left.add((Component)scroll, c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        this.comenzi = new JButton(Utils.getTranslation(LangRoAll.comenzi, new String[0]));
        this.comenzi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector<Integer> items = new Vector<Integer>();
                items.add(1);
                items.add(2);
                items.add(3);
                items.add(4);
                KeysTouchTableChooserDialog dialog = new KeysTouchTableChooserDialog(4, items, Utils.getTranslation(LangRoAll.comanda));
                int selected = dialog.getSelected();
                KeysTouchMain.this.switchTable(selected - 1);
            }
        });
        this.comenzi.setFocusable(false);
        left.add((Component)this.comenzi, c);
        c.gridwidth = 1;
        ++c.gridy;
        JButton refresh = new JButton(Utils.getTranslation(LangRoAll.refresh, new String[0]));
        refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                scroll.setViewportView(KeysTouchMain.this.buildTree(productTree));
                KeysTouchMain.this.refreshProduseCombo();
            }
        });
        refresh.setFocusable(false);
        left.add((Component)refresh, c);
        ++c.gridx;
        final JButton optiuni = new JButton(LangRoAll.optiuni);
        optiuni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = KeysTouchMain.this.buildOptiuniPopup();
                popup.show(optiuni, 0, 50);
            }
        });
        optiuni.setFocusable(false);
        left.add((Component)optiuni, c);
        return left;
    }

    private void switchReturMode(boolean retur) {
        if (retur) {
            KeysTouchMain panel = this;
            String s = DialogUtils.inputDialog(panel, "", Utils.getTranslation(LangRoAll.introducetiIdOrder, new String[0]));
            if (!Validators.correctInteger(s)) {
                DialogUtils.errorDialog(panel, LangRoAll.valoareIncorecta, LangRoAll.nuPotContinua);
                return;
            }
            int idOrder = Integer.parseInt(s);
            Order o = RestLogic.getInstance().getOrderById(idOrder);
            if (o == null) {
                DialogUtils.errorDialog(panel, Utils.getTranslation(LangRoAll.idOrderNegasitInBaza, new String[0]), LangRoAll.nuPotContinua);
                return;
            }
            this.idOrder = idOrder;
        } else {
            this.idOrder = -1;
        }
        this.isRetur = retur;
    }

    protected JPopupMenu buildOptiuniPopup() {
        JMenuItem item;
        final KeysTouchMain panel = this;
        Font bonItemFont = new Font(null, 1, 25);
        JPopupMenu popup = new JPopupMenu();
        JMenuItem utilizator = new JMenuItem(LangRoAll.utilizator);
        utilizator.setFocusable(false);
        utilizator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeysTouchMain.this.loginUser();
            }
        });
        utilizator.setFont(bonItemFont);
        popup.add(utilizator);
        JMenuItem kbd = new JMenuItem(Utils.getTranslation(LangRoAll.tastatura, new String[0]));
        kbd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String keyboardCommand = VpConfig.getInstance().virtualkeyboardCommand;
                try {
                    Process onlineProcess = Runtime.getRuntime().exec(keyboardCommand);
                }
                catch (IOException e) {
                    Logger.logException(this, (Exception)e);
                }
                KeysTouchMain.this.produseCombo.requestFocus();
            }
        });
        kbd.setFont(bonItemFont);
        popup.add(kbd);
        popup.add(new JSeparator());
        if (this.logic.getCashRegister().numerarInputReady()) {
            JMenuItem item2 = new JMenuItem(LangRoAll.incarcaCasa);
            item2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    String s = DialogUtils.inputDialog(panel, "0", LangRoAll.valoareIncarcaCasa);
                    if (!Validators.correctDouble(s)) {
                        DialogUtils.errorDialog(panel, Utils.getTranslation(LangRoAll.valoareIncorecta), LangRoAll.nuPotContinua);
                        return;
                    }
                    double value = Utils.parseDouble(s);
                    KeysTouchMain.this.logic.introduNumerar(value);
                }
            });
            item2.setFont(bonItemFont);
            popup.add(item2);
        }
        popup.add(new JSeparator());
        JMenuItem forceTotal = new JMenuItem(LangRoAll.totalCasaMarcat);
        popup.add(forceTotal);
        forceTotal.setFont(bonItemFont);
        forceTotal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                KeysTouchMain.this.logic.forceEcrTotal();
            }
        });
        if (VpConfig.getInstance().showKeysReturButton) {
            item = new JMenuItem(LangRoAll.retur);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeysTouchMain.this.switchReturMode(!KeysTouchMain.this.isRetur);
                }
            });
            item.setFont(bonItemFont);
            popup.add(item);
        }
        if (VpConfig.getInstance().showAdminButton) {
            item = new JMenuItem(LangRoAll.administrare);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeysTouchMain.this.doAdminLogin();
                }
            });
            item.setFont(bonItemFont);
            popup.add(item);
        }
        if (VpConfig.getInstance().showSearaButton) {
            item = new JMenuItem(LangRoAll.seara);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean canPrint = false;
                    User supervizor = null;
                    if (VpConfig.getInstance().touch2AllowSearaReportByWaiters) {
                        if (KeysTouchMain.this.waiter != null) {
                            canPrint = true;
                            supervizor = KeysTouchMain.this.waiter;
                        } else {
                            DialogUtils.okFocusEaterDialog(LangRoAll.neautentificat, LangRoAll.nuPotContinua);
                        }
                    } else {
                        supervizor = UsersLogic.getInstance().requestLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        if (supervizor != null) {
                            if (!UsersLogic.getInstance().isUserInGroup(supervizor.getId(), "group_bo_users")) {
                                DialogUtils.okFocusEaterDialog(LangRoAll.nuAvetiDreptTiparireRaport, LangRoAll.nuPotContinua);
                                return;
                            }
                            canPrint = true;
                        } else {
                            DialogUtils.okFocusEaterDialog(LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
                            return;
                        }
                    }
                    if (canPrint) {
                        GuiUtilsRest.searaButtonPressed(panel, KeysTouchMain.this.logic, KeysTouchMain.this.whatToPrint, supervizor);
                        if (VpConfig.getInstance().piratMode) {
                            KeysTouchMain.this.whatToPrint = 2;
                        }
                    }
                }
            });
            item.setFont(bonItemFont);
            popup.add(item);
        }
        if (VpConfig.getInstance().showXButton) {
            item = new JMenuItem("X");
            item.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean canPrint = false;
                    User supervizor = null;
                    if (KeysTouchMain.this.waiter != null) {
                        if (VpConfig.getInstance().touch2AllowXReportByWaiters) {
                            canPrint = true;
                            supervizor = KeysTouchMain.this.waiter;
                        } else {
                            supervizor = UsersLogic.getInstance().requestLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                            if (supervizor != null) {
                                if (!UsersLogic.getInstance().isUserInGroup(supervizor.getId(), "group_bo_users")) {
                                    DialogUtils.okFocusEaterDialog(LangRoAll.nuAvetiDreptTiparireRaport, LangRoAll.nuPotContinua);
                                    return;
                                }
                                canPrint = true;
                            } else {
                                DialogUtils.okFocusEaterDialog(LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
                                return;
                            }
                        }
                    }
                    if (canPrint) {
                        try {
                            int idLocatie = RestLogic.getIdLocatieForXZReports(KeysTouchMain.this.logic.getLocations());
                            KeysTouchMain.this.logic.printX(KeysTouchMain.this.whatToPrint, supervizor, idLocatie);
                            if (VpConfig.getInstance().piratMode) {
                                KeysTouchMain.this.whatToPrint = 2;
                            }
                            ConnectionPool.getInstance().commit();
                        }
                        catch (SQLException e1) {
                            Logger.logException(this, (Exception)e1);
                        }
                        finally {
                            ConnectionPool.getInstance().releaseConnection();
                        }
                    }
                }
            });
            item.setFont(bonItemFont);
            popup.add(item);
        }
        popup.add(new JSeparator());
        if (VpConfig.getInstance().showPromoButton) {
            item = new JMenuItem(LangRoAll.promotie);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (KeysTouchMain.this.waiter == null) {
                        DialogUtils.errorDialog(panel, Utils.getTranslation(LangRoAll.neautentificat), LangRoAll.nuPotContinua);
                        return;
                    }
                    User supervizor = null;
                    boolean passwordForPromo = VpConfig.getInstance().passwordForPromo;
                    if (passwordForPromo) {
                        supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    }
                    if (supervizor != null || !passwordForPromo) {
                        Vector<Promotion> promotii;
                        KeysTouchMain.this.createOrderIfNullCommit(KeysTouchMain.this._currentSlot);
                        if (!KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot).isLaPlata() && (promotii = PromotionLogic.getInstance().getFidelitatePromotions()).size() > 0) {
                            PromotiiDialog dialog = new PromotiiDialog(4, promotii);
                            int idPromotie = dialog.getSelected();
                            KeysTouchMain.this.logic.setPromotionForOrder(KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot), idPromotie);
                            KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot).setIdPromotie(idPromotie);
                            KeysTouchMain.this.setPromotionText();
                        }
                    }
                }
            });
            item.setFont(bonItemFont);
            popup.add(item);
        }
        if (VpConfig.getInstance().showFidelitateButton) {
            item = new JMenuItem(LangRoAll.fidelitate);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (KeysTouchMain.this.waiter == null) {
                        DialogUtils.errorDialog(panel, Utils.getTranslation(LangRoAll.neautentificat), LangRoAll.nuPotContinua);
                        return;
                    }
                    User supervizor = null;
                    if (VpConfig.getInstance().passwordForFidelitate) {
                        supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    }
                    if (supervizor != null || !VpConfig.getInstance().passwordForFidelitate) {
                        CardInputDialog dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().codFidelitateLength);
                        dialog.setVisible(true);
                        ClientPromotieView cpv = PromotionLogic.getInstance().getClientPromotieForCard(dialog.getCodAutentificare());
                        if (cpv != null) {
                            KeysTouchMain.this.createOrderIfNullCommit(KeysTouchMain.this._currentSlot);
                            if (!KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot).isLaPlata()) {
                                KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot).setIdPromotie(cpv.getIdPromotie());
                                KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot).setIdClient(cpv.getIdClient());
                                KeysTouchMain.this.logic.setClientAndPromotionForOrder(KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot), cpv.getIdClient(), cpv.getIdPromotie());
                                KeysTouchMain.this.setPromotionText();
                                KeysTouchMain.this.setClientText();
                            }
                        }
                    }
                }
            });
            item.setFont(bonItemFont);
            popup.add(item);
        }
        if (VpConfig.getInstance().showProtocolButton) {
            JMenuItem protocol = new JMenuItem(LangRoAll.protocol);
            protocol.setFont(bonItemFont);
            popup.add(protocol);
            protocol.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    User supervizor = null;
                    if (VpConfig.getInstance().passwordForProtocol) {
                        supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, true, true);
                    }
                    if (supervizor != null || !VpConfig.getInstance().passwordForProtocol) {
                        Order order = KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot);
                        if (order == null) {
                            order = KeysTouchMain.this.createOrderIfNullCommit(KeysTouchMain.this._currentSlot);
                        }
                        if (order != null && !order.isLaPlata() && !order.isIncasat()) {
                            boolean isProtocol = order.isProtocol();
                            boolean newState = !isProtocol;
                            KeysTouchMain.this.logic.setProtocolForOrder(order, newState);
                            order.setProtocol(newState);
                        }
                        KeysTouchMain.this.setPromotionText();
                    }
                }
            });
        }
        popup.add(new JSeparator());
        if (VpConfig.getInstance().showClientButton) {
            item = new JMenuItem(LangRoAll.client);
            final ClientEditPanelProvider provider = new ClientEditPanelProvider(){

                @Override
                public PersFizicaAddEditPanel getPfPanel() {
                    return new PersFizicaAddEditPanel();
                }

                @Override
                public PersJuridicaAddEditPanel getPjPanel() {
                    return new PersJuridicaAddEditPanel();
                }
            };
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (KeysTouchMain.this.waiter == null) {
                        DialogUtils.errorDialog(panel, Utils.getTranslation(LangRoAll.neautentificat), LangRoAll.nuPotContinua);
                        return;
                    }
                    KeysTouchMain.this.createOrderIfNullCommit(KeysTouchMain.this._currentSlot);
                    ClientSelectDialog dia = new ClientSelectDialog(GuiUtils.currentFrame);
                    int sel = dia.getSelected();
                    Client c = dia.getSelectedClient();
                    if (sel != -1) {
                        if (VpConfig.getInstance().showClientEditDialogAtClientSelection) {
                            ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), c, c instanceof ClientPersJuridica, provider);
                        }
                    } else if (dia.isMustAdd()) {
                        boolean pj = DialogUtils.confirmDialog(panel, Utils.getTranslation(LangRoAll.adaugamPersoanaJuridica, new String[0]), LangRoAll.persFizicaJuridica);
                        ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), null, pj, provider);
                        sel = cDia.getClientId();
                    }
                    if (sel != -1) {
                        KeysTouchMain.this.logic.setClientForOrder(KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot), sel, dia.getSelectedAdresa());
                        KeysTouchMain.this.setClientText();
                    }
                }
            });
            item.setFont(bonItemFont);
            popup.add(item);
        }
        if (this.showFacturaMenuItem()) {
            item = new JMenuItem(LangRoAll.factura);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (KeysTouchMain.this.waiter == null) {
                        DialogUtils.errorDialog(panel, Utils.getTranslation(LangRoAll.neautentificat), LangRoAll.nuPotContinua);
                        return;
                    }
                    if (KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot) != null) {
                        Hashtable<String, Integer> h = new Hashtable<String, Integer>();
                        h.put("id_order_key", KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot).getId());
                        Vector<NoteView> newData = KeysTouchMain.this.logic.getNote(h, true, 1);
                        if (newData.size() > 0) {
                            new AddFacturaDialog(true, panel, newData, KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot).getIdClient(), null);
                        }
                    }
                }
            });
            item.setFont(bonItemFont);
            popup.add(item);
        }
        popup.add(new JSeparator());
        if (VpConfig.getInstance().showPriceButton) {
            item = new JMenuItem(LangRoAll.pret);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (KeysTouchMain.this.identified == null) {
                        DialogUtils.errorDialog(panel, Utils.getTranslation(LangRoAll.alegetiUnProdus, new String[0]), LangRoAll.nuPotContinua);
                        KeysTouchMain.this.pretCurent = -1.0;
                    } else {
                        KeysTouchMain.this.pretCurent = KeysTouchMain.this.logic.getPriceForProductCommit(KeysTouchMain.this.identified.getId());
                        String value = DialogUtils.inputDialog(panel, Utils.getString2Decimals(KeysTouchMain.this.pretCurent), Utils.getTranslation(LangRoAll.pretPentru, KeysTouchMain.this.identified.getName()));
                        if (Validators.correctDouble(value)) {
                            KeysTouchMain.this.pretCurent = Utils.parseDouble(value);
                            KeysTouchMain.this.pretValue.setText(Utils.getString2Decimals(KeysTouchMain.this.pretCurent));
                        } else {
                            DialogUtils.errorDialog(panel, LangRoAll.valoareIncorecta, LangRoAll.nuPotContinua);
                            KeysTouchMain.this.pretCurent = -1.0;
                        }
                    }
                }
            });
            item.setFont(bonItemFont);
            popup.add(item);
        }
        popup.add(new JSeparator());
        if (VpConfig.getInstance().showIncarcaContButtons) {
            Vector<TipCont> conturi = ClientLogic.getInstance().getAllConturi();
            for (int i = 0; i < conturi.size(); ++i) {
                final TipCont o = conturi.elementAt(i);
                JMenuItem item3 = new JMenuItem(Utils.getTranslation(LangRoAll.incarca) + o.getLabel());
                item3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        Order order = KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot);
                        if (order == null) {
                            order = KeysTouchMain.this.createOrderIfNullCommit(KeysTouchMain.this._currentSlot);
                        }
                        if (order == null) {
                            return;
                        }
                        int idClient = order.getIdClient();
                        if (idClient == -1) {
                            DialogUtils.errorDialog(panel, Utils.getTranslation(LangRoAll.alegetiUnClient), LangRoAll.nuPotContinua);
                            return;
                        }
                        User supervizor = null;
                        if (VpConfig.getInstance().passwordForIncarcareCont) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !VpConfig.getInstance().passwordForIncarcareCont) {
                            String valueS = "";
                            if (o.getProdusFictiv() > 0) {
                                double value = KeysTouchMain.this.logic.getPriceForProductCommit(o.getProdusFictiv());
                                valueS = Utils.getString2Decimals(value);
                            }
                            String input = DialogUtils.inputDialog(panel, valueS, Utils.getTranslation(LangRoAll.valoare));
                            try {
                                boolean printBF;
                                if (!Validators.correctDouble(input)) {
                                    return;
                                }
                                double sum = Utils.parseDouble(input);
                                ClientLogic.getInstance().adaugaTranzactieClient(o.getId(), idClient, sum, LangRoAll.alimentareCont);
                                if (o.getProdusFictiv() > 0 && sum > 0.0 && (printBF = DialogUtils.confirmDialog(panel, LangRoAll.tiparimBonFiscal, LangRoAll.confirmare))) {
                                    Vector<TipPlata> tipuriPlata = TipPlataProvider.getInstance().getTipPlata();
                                    TipPlataChooser chooser = new TipPlataChooser(4, tipuriPlata);
                                    TipPlata tp = chooser.getSelected();
                                    RestLogic.getInstance().printBonFiscalAlimentareCont(o.getProdusFictiv(), sum, KeysTouchMain.this.getTable(KeysTouchMain.this._currentSlot), KeysTouchMain.this.waiter.getId(), idClient, tp);
                                }
                                KeysTouchMain.this.setClientText();
                            }
                            catch (NumberFormatException e) {
                                Logger.logException(this, (Exception)e);
                            }
                        }
                    }
                });
                item3.setFont(bonItemFont);
                popup.add(item3);
            }
        }
        popup.add(new JSeparator());
        if (VpConfig.getInstance().keysShowIncarcaVanzariButton) {
            item = new JMenuItem(Utils.getTranslation(LangRoAll.incarcaVanzariDinXml, new String[0]));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (KeysTouchMain.this.waiter == null) {
                        KeysTouchMain.this.loginUser();
                    }
                    if (KeysTouchMain.this.waiter == null) {
                        return;
                    }
                    String absolutePath = FileDialog.getLoadDialogLocation(panel, Utils.getTranslation(LangRoAll.selectatiFisierul, new String[0]), "xml");
                    if (absolutePath != null) {
                        KeysTouchMain.this.createOrderIfNullCommit(KeysTouchMain.this._currentSlot);
                        VanzariXmlHandler handler = new VanzariXmlHandler(panel, new AddSaleInterface(){

                            @Override
                            public void saleAdded(Product p, String quantity, double price) {
                                KeysTouchMain.this.identified = p;
                                double q = Utils.parseDouble(quantity);
                                KeysTouchMain.this.bonComanda(p, q);
                            }
                        });
                        try {
                            Utils.importXml((DefaultHandler)handler, absolutePath);
                        }
                        catch (IOException e) {
                            Logger.logException(this, (Exception)e);
                        }
                        catch (SAXException e) {
                            Logger.logException(this, (Exception)e);
                        }
                        KeysTouchMain.this._orderTableModel.updateTable(KeysTouchMain.this.logic.getSales(KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot).getId(), KeysTouchMain.this.cumulateSales, -1, new ScreenSaleInterface()));
                    }
                }
            });
            item.setFont(bonItemFont);
            popup.add(item);
        }
        popup.add(new JSeparator());
        if (VpConfig.getInstance().bonFiscalPrintCodFiscal) {
            item = new JMenuItem(Utils.getTranslation(LangRoAll.codFiscal, new String[0]));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    Order order = KeysTouchMain.this.getCurrentOrder();
                    if (order != null) {
                        GuiUtilsRest.setCodFiscalToOrder(panel, order);
                    }
                }
            });
            item.setFont(bonItemFont);
            popup.add(item);
        }
        popup.add(new JSeparator());
        item = new JMenuItem(LangRoAll.exit);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                User supervizor = null;
                if (VpConfig.getInstance().touch2PasswordForExit) {
                    supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                }
                if ((supervizor != null || !VpConfig.getInstance().touch2PasswordForExit) && DialogUtils.confirmDialog(panel, LangRoAll.doritiSaInchidetiProgramul, LangRoAll.confirmare)) {
                    Utils.systemExit();
                }
            }
        });
        item.setFont(bonItemFont);
        popup.add(item);
        return popup;
    }

    protected boolean showFacturaMenuItem() {
        return VpConfig.getInstance().showFacturaButton;
    }

    private void showPremiiPosibile() {
        Client c;
        Order order = this.getOrder(this._currentSlot);
        if (order != null && (c = ClientLogic.getInstance().getClientById(this.getOrder(this._currentSlot).getIdClient())) != null) {
            double totalOrder1 = this.logic.getTotal(order);
            Vector premii = this.logic.getPremiiForClient(c.getId(), totalOrder1);
            if (premii.size() > 0) {
                String message = Utils.getStringForJDialogList(LangRoAll.premiiPosibile, "", premii);
                DialogUtils.okDialog(this, message, LangRoAll.premiiPosibile);
            }
        }
    }

    protected JTree buildTree(ProductTreePanel productTree) {
        productTree.refreshProductList(sectii);
        JTree tree = productTree.getProductTree();
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)tree.getCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DefaultMutableTreeNode lastSelectedNode;
                JTree originator = (JTree)e.getComponent();
                int selRow = originator.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = originator.getPathForRow(selRow);
                if (selRow != -1 && (lastSelectedNode = (DefaultMutableTreeNode)selPath.getLastPathComponent()).isLeaf()) {
                    Product p = (Product)lastSelectedNode.getUserObject();
                    String codBare = NomeclaturaLogic.getInstance().getFirstBarcodeByIdProd(p.getId());
                    KeysTouchMain.this.codValue.setText(codBare);
                    KeysTouchMain.this.updateProductTextCommit();
                    KeysTouchMain.this.up.requestFocus();
                }
            }
        });
        return tree;
    }

    protected JPanel getKeypadPanel() {
        JPanel left = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        this.kp = new VirtualKeypad2(25, true, new Insets(1, 1, 1, 1), new Insets(7, 7, 7, 7), 1);
        this.kp.setBorder(new TitledBorder(Utils.getTranslation(LangRoAll.alegereCantitate, new String[0])));
        this.kp.setNumberEditable(true);
        Dimension d = new Dimension(220, 320);
        this.kp.setMinimumSize(d);
        this.kp.setMaximumSize(d);
        this.kp.setPreferredSize(d);
        this.kp.setSize(d);
        left.add((Component)this.kp, c);
        this.kp.addKeypadListener(new KeypadListener(){

            @Override
            public void backspace() {
            }

            @Override
            public void decimalPressed() {
            }

            @Override
            public void enterPressed() {
                KeysTouchMain.this.productsAddButton.doClick();
            }

            @Override
            public void keypadPressed(int digit) {
            }

            @Override
            public void okPressed() {
            }
        });
        c.gridwidth = 1;
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        this.codButton = new JButton(Utils.getTranslation(LangRoAll.cod, new String[0]));
        this.codButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                KeysTouchMain.this.codValue.setText(KeysTouchMain.this.kp.getValueS());
                KeysTouchMain.this.updateProductTextCommit();
                KeysTouchMain.this.up.requestFocus();
                KeysTouchMain.this.kp.reset();
                KeysTouchMain.this.kp.setNumber(1.0);
                KeysTouchMain.this.kp.requestFocus();
            }
        });
        this.codButton.setFocusable(false);
        this.codButton.setMargin(new Insets(1, 1, 1, 1));
        left.add((Component)this.codButton, c);
        ++c.gridx;
        this.cantarButton = new JButton(Utils.getTranslation(LangRoAll.cantar));
        this.cantarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                KeysTouchMain.this.readFromCantar = true;
            }
        });
        this.cantarButton.setFocusable(false);
        this.cantarButton.setMargin(new Insets(1, 1, 1, 1));
        left.add((Component)this.cantarButton, c);
        if (!LicenseManager.getInstance().isFunctionLicensed("cantar")) {
            this.cantarButton.setEnabled(false);
        }
        ++c.gridx;
        this.productsCancelButton = new JButton(LangRoAll.renunta);
        this.productsCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                KeysTouchMain.this.identified = null;
                KeysTouchMain.this.idLot = -1;
                KeysTouchMain.this.codValue.setText(" ");
                KeysTouchMain.this.updateProductTextCommit();
                KeysTouchMain.this.kp.reset();
                KeysTouchMain.this.produseCombo.clearAllText();
                KeysTouchMain.this.produseCombo.setSelectedItem(null);
                KeysTouchMain.this.up.requestFocus();
            }
        });
        this.productsCancelButton.setFocusable(false);
        this.productsCancelButton.setMargin(new Insets(1, 1, 1, 1));
        left.add((Component)this.productsCancelButton, c);
        c.weighty = 0.0;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.insets = new Insets(5, 2, 0, 2);
        c.anchor = 10;
        c.fill = 2;
        this.productsAddButton = new JButton(LangRoAll.adauga);
        this.productsAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (KeysTouchMain.this.waiter == null) {
                    KeysTouchMain.this.loginUser();
                    return;
                }
                double q1 = 1.0;
                String valueS = KeysTouchMain.this.kp.getValueS();
                if (Validators.correctDouble(valueS)) {
                    q1 = Utils.parseDouble(valueS);
                }
                boolean added = false;
                Object obj = KeysTouchMain.this.produseCombo.getSelectedItem();
                if (obj instanceof Product) {
                    Product p = (Product)obj;
                    if (p == null) {
                        KeysTouchMain.this.produseCombo.requestFocus();
                        return;
                    }
                    KeysTouchMain.this.bonComanda(p, q1);
                    added = true;
                    KeysTouchMain.this.kp.reset();
                } else if (KeysTouchMain.this.identified != null) {
                    KeysTouchMain.this.bonComanda(KeysTouchMain.this.identified, q1);
                    added = true;
                    KeysTouchMain.this.kp.reset();
                }
                if (added) {
                    KeysTouchMain.this.produseCombo.clearAllText();
                }
                KeysTouchMain.this.produseCombo.setSelectedItem(null);
                KeysTouchMain.this.up.requestFocus();
            }
        });
        this.productsAddButton.setFocusable(false);
        left.add((Component)this.productsAddButton, c);
        left.setBorder(new EtchedBorder());
        return left;
    }

    protected JPanel getUpPanel() {
        JPanel left = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weighty = 0.0;
        JPanel productSearch = this.getProductSearchPanel();
        left.add((Component)productSearch, c);
        c.gridx += 2;
        c.gridheight = 5;
        JPanel keypad = this.getKeypadPanel();
        left.add((Component)keypad, c);
        c.gridwidth = 1;
        c.gridheight = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.2;
        c.anchor = 17;
        left.add((Component)this.promoValue, c);
        this.promoValue.setBorder(new EtchedBorder());
        ++c.gridx;
        c.anchor = 13;
        left.add((Component)this.clientValue, c);
        this.clientValue.setBorder(new EtchedBorder());
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 17;
        left.add((Component)this.codValue, c);
        this.codValue.setBorder(new EtchedBorder());
        ++c.gridx;
        c.anchor = 13;
        left.add((Component)this.pretValue, c);
        this.pretValue.setBorder(new EtchedBorder());
        c.weighty = 0.8;
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 17;
        left.add((Component)this.getProductNamePicturePanel(), c);
        left.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                KeysTouchMain.this.handleKey(e.getKeyCode(), e.getKeyChar());
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        left.setFocusable(true);
        left.setBorder(new EtchedBorder());
        return left;
    }

    protected JPanel getProductNamePicturePanel() {
        JPanel left = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        left.add((Component)this.denumireValue, c);
        this.denumireValue.setBorder(new EtchedBorder());
        if (VpConfig.getInstance().keysShowProductPicture) {
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.anchor = 10;
            c.fill = 0;
            this.ppp = new ProductPicturePanel(false, VpConfig.getInstance().productPictureDx);
            ++c.gridx;
            left.add((Component)this.ppp, c);
        }
        return left;
    }

    protected JPanel getProductSearchPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 2;
        c.weightx = 1.0;
        boolean xComboSearchInProduct = Config.getInstance().getBoolean(X_COMBO_SEARCH_IN_PRODUCT);
        Vector products = new Vector();
        this.produseComboModel = new FilterableComboBoxModel(products);
        this.produseCombo = new XComboBox(this.produseComboModel, xComboSearchInProduct);
        this.refreshProduseCombo();
        this.produseCombo.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.produseCombo.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                KeysTouchMain.this.produseCombo.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.produseCombo.setFont(new Font(null, 0, 15));
        result.add((Component)this.produseCombo, c);
        result.setBorder(new TitledBorder(Utils.getTranslation(LangRoAll.cautareProdusDupaNume, new String[0])));
        return result;
    }

    protected void refreshProduseCombo() {
        Vector products = NomeclaturaLogic.getInstance().getPowerSearchProducts(-1, false);
        this.produseComboModel.refresh(products);
    }

    private JPanel getRightPanel() {
        JPanel right = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        right.add((Component)new JScrollPane(this._orderTable), c);
        ++c.gridy;
        c.weighty = 0.0;
        right.add((Component)this.buildTotalPanel(), c);
        right.setFocusable(false);
        return right;
    }

    protected boolean isTipPlataAllowed(TipPlata toFilter, String configName) {
        String configs = Config.getInstance().getString(configName);
        if (Validators.correctString(configs)) {
            Vector split = Utils.splitString(configs, ',');
            for (String s : split) {
                if (!s.equalsIgnoreCase(toFilter.getLabel())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected TipPlataPanelInterface buildPlatiInterface() {
        TipPlataPanelInterface panelInterface = new TipPlataPanelInterface(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void editSuma(TipPlata tipPlata2, Component panel) {
                33 platiInterface = this;
                Vector<Plata> existingPlati = platiInterface.getExistingPlati();
                for (Plata plata : existingPlati) {
                    if (Validators.correctString(plata.getEcrMapping()) == Validators.correctString(tipPlata2.getEcrMapping())) continue;
                    DialogUtils.errorDialog(panel, Utils.getTranslation(LangRoAll.tipDePlataIncompatibil, tipPlata2.getLabel(), plata.getTipPlata()), LangRoAll.nuPotContinua);
                    return;
                }
                User supervizor = null;
                if (tipPlata2.isRequestPassword()) {
                    supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                }
                if (!tipPlata2.isRequestPassword() || supervizor != null) {
                    int idTipCont = tipPlata2.getIdTipCont();
                    if (idTipCont != -1) {
                        int idClient = platiInterface.getIdClient(false);
                        if (idClient <= 0) {
                            DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                            return;
                        }
                        Vector<ValoareContClient> contValues = ClientLogic.getInstance().getConturiClient(idClient, idTipCont);
                        if (contValues.size() <= 0) {
                            DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.contInexistentPtClient, LangRoAll.nuPotContinua);
                            return;
                        }
                        double val = contValues.get(0).getValoare();
                        if (val < 0.0 && !VpConfig.getInstance().incarcareContAllowStartOnMinus) {
                            DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.soldPeMinus, LangRoAll.nuPotContinua);
                            return;
                        }
                    }
                    double value = platiInterface.getValueForPlata(tipPlata2);
                    String comment = "";
                    boolean commentSet = false;
                    while (tipPlata2.isRequestComment() && !commentSet && !Utils.isValueZero(value)) {
                        String s;
                        if (VpConfig.getInstance().tipPlataDetaliiKeypad) {
                            s = DialogUtils.virtualKeyboardInputDialog(GuiUtils.currentFrame, LangRoAll.detalii, 3.0, VpConfig.getInstance().touchSelectorFontSize, false);
                            commentSet = true;
                            comment = s;
                            continue;
                        }
                        s = DialogUtils.inputDialog(panel, "", LangRoAll.detalii);
                        if (!Validators.correctString(s)) continue;
                        commentSet = true;
                        comment = s;
                    }
                    platiInterface.addPlataToOrder(tipPlata2, value, comment);
                    platiInterface.afterEditSuma();
                }
            }

            @Override
            public int getMargins() {
                return 1;
            }

            @Override
            public boolean showLabels() {
                return true;
            }

            @Override
            public int getFontSize() {
                return Config.getInstance().getInt(KeysTouchMain.TOUCH_2_TIP_PLATA_FONT_SIZE, 10);
            }

            @Override
            public boolean allowTipPlata(TipPlata tp) {
                return KeysTouchMain.this.isTipPlataAllowed(tp, KeysTouchMain.KEYS_TIPURI_DE_PLATA);
            }

            @Override
            public boolean canEditSuma() {
                return KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot) != null;
            }

            @Override
            public void afterEditSuma() {
                KeysTouchMain.this.kp.reset();
                KeysTouchMain.this.up.requestFocus();
                KeysTouchMain.this.updateTotals();
            }

            @Override
            public int getIdClient(boolean contAsociat) {
                Order o = KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot);
                if (o == null) {
                    return -1;
                }
                return o.getIdClient();
            }

            @Override
            public Vector<Plata> getExistingPlati() {
                Order order = KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot);
                if (order != null) {
                    Vector<Plata> existingPlati = PaymentLogic.getInstance().getPlatiForOrder(order.getId());
                    return existingPlati;
                }
                return new Vector<Plata>();
            }

            @Override
            public double getValueForPlata(TipPlata tipPlata2) {
                double value;
                Order order = KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot);
                if (tipPlata2.getIdPromo() > 0) {
                    KeysTouchMain.this.logic.setClientAndPromotionForOrder(order, order.getIdClient(), tipPlata2.getIdPromo());
                    KeysTouchMain.this.setPromotionText();
                    KeysTouchMain.this.recomputePrices();
                }
                double total = FloatUtils.roundFloat(RestLogic.getInstance().getTotal(order, -1), 2);
                double valoareCuRest = value = FloatUtils.roundFloat(KeysTouchMain.this.logic.getSumaForPlataNoPlataSkip(order, tipPlata2.getId(), KeysTouchMain.this._orderTableModel.getTotal(), 0), 2);
                String valueS = KeysTouchMain.this.kp.getValueS();
                if (Validators.correctDouble(valueS)) {
                    valoareCuRest = KeysTouchMain.this.kp.getValue();
                } else {
                    valueS = DialogUtils.inputDialog(GuiUtils.currentFrame, Utils.getString2Decimals(value), Utils.getTranslation(LangRoAll.introducetiSuma, new String[0]));
                    if (Validators.correctDouble(valueS)) {
                        valoareCuRest = Utils.parseDouble(valueS);
                    }
                }
                double rest = valoareCuRest - value;
                if (rest != -total) {
                    KeysTouchMain.this.platiPanel.setRestText(rest);
                } else {
                    KeysTouchMain.this.platiPanel.setRestText(null);
                }
                if (valoareCuRest > value && !tipPlata2.isDocumentDePlata()) {
                    valoareCuRest = value;
                }
                RestLogic.restOnCurrentOrderForAfisaj = rest;
                return valoareCuRest;
            }

            @Override
            public void addPlataToOrder(TipPlata tipPlata2, double value, String comment) {
                Plata plata = new Plata(tipPlata2.getId(), value, tipPlata2.getEcrMapping(), tipPlata2.getLabel(), comment, 0);
                Order order = KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot);
                KeysTouchMain.this.logic.addPlataToOrder(order, plata);
            }
        };
        return panelInterface;
    }

    private void updateRestAfterProduct() {
        Order order = this.getOrder(this._currentSlot);
        double total = FloatUtils.roundFloat(RestLogic.getInstance().getTotal(order, -1), 2);
        Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(order.getId(), -1);
        double platit = 0.0;
        for (Plata plata : plati) {
            platit += plata.getSuma();
        }
        platit = FloatUtils.roundFloat(platit, 2);
        this.platiPanel.setRestText(platit - total);
    }

    private Vector<TipPlata> getAllowedTipPlata(TipPlataPanelInterface platiInterface) {
        Vector<TipPlata> _vTipPlata = TipPlataProvider.getInstance().getTipPlata();
        Vector<TipPlata> allowedTipPlata = new Vector<TipPlata>();
        for (TipPlata tipPlata2 : _vTipPlata) {
            if (!platiInterface.allowTipPlata(tipPlata2)) continue;
            allowedTipPlata.add(tipPlata2);
        }
        return allowedTipPlata;
    }

    private JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        Font font = new Font(null, 0, VpConfig.getInstance().touch2TotalFontSize);
        JLabel t1 = new JLabel(LangRoAll.total);
        t1.setForeground(Color.RED);
        t1.setFont(font);
        result.add((Component)t1, c);
        ++c.gridx;
        this.total = new JLabel("");
        this.total.setForeground(Color.RED);
        this.total.setFont(font);
        result.add((Component)this.total, c);
        final KeysTouchMain panel = this;
        TipPlataPanelInterface platiInterface = this.buildPlatiInterface();
        Vector<TipPlata> allowed = this.getAllowedTipPlata(platiInterface);
        this.platiPanel = new TipPlataPanelNew(platiInterface, allowed, panel);
        ++c.gridx;
        result.add((Component)this.platiPanel, c);
        c.weightx = 1.0;
        ++c.gridx;
        result.add((Component)new JLabel(""), c);
        if (addWaiterName) {
            c.weightx = 0.0;
            ++c.gridx;
            final JLabel waiterName = new JLabel("   .   ");
            waiterName.setFocusable(true);
            waiterName.setForeground(Color.BLACK);
            waiterName.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    KeysTouchMain.this.notaDePlata(false, false);
                    waiterName.setForeground(Color.RED);
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            waiterName.setForeground(Color.BLACK);
                        }
                    }.start();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
            result.add((Component)waiterName, c);
        }
        c.weightx = 1.0;
        ++c.gridx;
        result.add((Component)new JLabel(""), c);
        c.weightx = 0.0;
        if (showInchideButton) {
            ++c.gridx;
            JButton inchideBon = new JButton(this.getInchideBonName());
            inchideBon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    KeysTouchMain.this.notaDePlata(true, false);
                }
            });
            inchideBon.setFocusable(false);
            result.add((Component)inchideBon, c);
        }
        if (showGolireButton) {
            ++c.gridx;
            JButton golire = new JButton("Golire");
            golire.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Vector sales = KeysTouchMain.this._orderTableModel.getAllSales();
                    Order order = KeysTouchMain.this.getOrder(KeysTouchMain.this._currentSlot);
                    User u = UsersLogic.getInstance().getUserById(order.getUser());
                    VpConfig config = VpConfig.getInstance();
                    Table t = KeysTouchMain.this.getTable(KeysTouchMain.this._currentSlot);
                    boolean verificarePreturi = t.isVirtuala();
                    User supervizor = null;
                    if (config.passwordForStergereRetur && !verificarePreturi) {
                        supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    }
                    if (supervizor != null || !config.passwordForStergereRetur || verificarePreturi) {
                        User autorizator = supervizor != null ? supervizor : u;
                        for (Sale s : sales) {
                            KeysTouchMain.this.logic.decrementSale(order, s, autorizator, "", s.getCantitateMarcata(), t, null, !verificarePreturi);
                        }
                        KeysTouchMain.this._orderTableModel.updateTable(KeysTouchMain.this.logic.getSales(order.getId(), KeysTouchMain.this.cumulateSales, -1, new ScreenSaleInterface()));
                        KeysTouchMain.this.updateTotals();
                        KeysTouchMain.this.updateRestAfterProduct();
                    }
                }
            });
            result.add((Component)golire, c);
        }
        if (showTransferButton) {
            ++c.gridx;
            JButton bonTransfer = new JButton(LangRoAll.transfera);
            bonTransfer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double totalF;
                    Vector sales = KeysTouchMain.this._orderTableModel.getAllSales();
                    if (GuiUtilsRest.bonTransfer(panel, false, 2, sales, totalF = KeysTouchMain.this._orderTableModel.getTotal(), KeysTouchMain.this.waiter)) {
                        DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                    }
                }
            });
            result.add((Component)bonTransfer, c);
        }
        if (showConsumButton) {
            ++c.gridx;
            JButton bonConsum = new JButton("Consum");
            bonConsum.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ItemChooserDialog itemChooserDialog = new ItemChooserDialog(6, StockLogic.getInstance().getMagazii(), false);
                    Magazie destinatie = (Magazie)itemChooserDialog.getSelected();
                    Vector<ConsumTransferInterface> toTransfer = new Vector<ConsumTransferInterface>();
                    Vector sales = KeysTouchMain.this._orderTableModel.getAllSales();
                    for (Sale sale : sales) {
                        BonConsumItem bci = new BonConsumItem();
                        bci.setCantitate(sale.getCantitateMarcata());
                        bci.setDenumire(sale.getProductName());
                        int idProduct = sale.getIdProduct();
                        int idStock = KeysTouchMain.this.logic.getIdStock(idProduct);
                        if (idStock <= 0) continue;
                        bci.setIdStock(idStock);
                        double pretIesire = StockLogic.getInstance().getCatalogPriceForStock(idStock);
                        if (pretIesire < 0.0) {
                            pretIesire = 0.0;
                        }
                        bci.setPpu(pretIesire);
                        bci.setValoare(pretIesire * bci.getCantitate());
                        bci.setPretAcz(0.0);
                        toTransfer.add(bci);
                    }
                    double totalF = KeysTouchMain.this._orderTableModel.getTotal();
                    StockLogic.getInstance().addAndPrintConsum(new Date(), destinatie, toTransfer, totalF, 2);
                    DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                }
            });
            result.add((Component)bonConsum, c);
        }
        if (showRestituireButton) {
            ++c.gridx;
            JButton restituire = new JButton("Restituire");
            restituire.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double totalF;
                    Vector sales = KeysTouchMain.this._orderTableModel.getAllSales();
                    if (GuiUtilsRest.bonTransfer(panel, true, 2, sales, totalF = KeysTouchMain.this._orderTableModel.getTotal(), KeysTouchMain.this.waiter)) {
                        DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                    }
                }
            });
            result.add((Component)restituire, c);
        }
        result.setBorder(new TitledBorder(LangRoAll.total));
        return result;
    }

    protected String getInchideBonName() {
        return Utils.getTranslation(LangRoAll.inchideBon, new String[0]);
    }

    public void focus() {
        this.up.requestFocus();
        this.up.setFocusCycleRoot(true);
    }

    private void digitPressed(char digit) {
        if (digit >= '0' && digit <= '9' || digit >= 'a' && digit <= 'z' || digit >= 'A' && digit <= 'Z') {
            String oldCode = this.codValue.getText();
            if (Validators.correctString(oldCode)) {
                this.codValue.setText(oldCode + digit);
            } else {
                this.codValue.setText("" + digit);
            }
            if (!VpConfig.getInstance().keysWaitForEnter) {
                this.updateProductTextCommit();
            }
        } else {
            System.out.println("Digit ignored : " + digit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProductTextCommit() {
        try {
            this.updateProductTextNoCommit();
            ConnectionPool.getInstance().commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    private void updateProductInfos(Product identified) throws SQLException {
        this.denumireValue.setText(identified.getName());
        double price = this.logic.getPriceForProductNoCommit(identified.getId());
        this.pretValue.setText(Utils.getString2Decimals(price));
        if (this.ppp != null) {
            this.ppp.reload(identified.getId());
        }
    }

    private void updateProductTextNoCommit() throws SQLException {
        String s1 = this.codValue.getText();
        this.idLot = -1;
        if (Utils.isCodLot(s1)) {
            Lot lot = StockLogic.getInstance().getLotByIdCodbareCommit(s1);
            if (lot == null) {
                DialogUtils.errorDialog(this, "Lot negasit", LangRoAll.nuPotContinua);
                return;
            }
            int idStock = lot.getIdStock();
            Product product = StockLogic.getInstance().getProductForStock(idStock);
            if (product == null) {
                DialogUtils.errorDialog(this, "Lotul ales NU reprezinta o marfa", LangRoAll.nuPotContinua);
                return;
            }
            this.identified = product;
            this.idLot = lot.getId();
            this.updateProductInfos(this.identified);
        } else {
            if (Utils.isCodCantar(s1)) {
                double cantitate = Utils.getCantarCantitate(s1);
                this.kp.setNumber(cantitate);
                s1 = Utils.getCantarCodBare(s1);
            }
            this.identified = NomeclaturaLogic.getInstance().getProductByCodBareNoCommit(s1);
            if (this.identified != null) {
                this.updateProductInfos(this.identified);
            } else {
                this.denumireValue.setText(" ");
                this.pretValue.setText(" ");
                if (s1.length() > 0 && VpConfig.getInstance().keysWaitForEnter && VpConfig.getInstance().keysWarningIfProductNotFound) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, Utils.getTranslation(LangRoAll.codBareIncorect, new String[0]), Utils.getTranslation(LangRoAll.codBareIncorect, new String[0]));
                    this.codValue.setText(" ");
                }
            }
            this.pretCurent = -1.0;
            if (this.isRetur) {
                this.denumireValue.setForeground(Color.RED);
            } else {
                this.denumireValue.setForeground(Color.BLACK);
            }
        }
    }

    protected void switchTable(int newSlot) {
        if (this.isRetur) {
            DialogUtils.errorDialog(this, Utils.getTranslation(LangRoAll.nuPutetiSchimbaComandaInReturMode, new String[0]), LangRoAll.nuPotContinua);
            return;
        }
        Table t = (Table)this.tables.get(newSlot);
        if (t != null) {
            Order order = (Order)this.orders.get(newSlot);
            if (order != null) {
                Vector<Sale> sales = this.logic.getSales(order.getId(), this.cumulateSales, -1, new ScreenSaleInterface());
                this._orderTableModel.updateTable(sales);
                RestLogic.getInstance().switchAfisajClientOrderCommit(order.getId());
            } else {
                order = this.logic.getOpenOrderAtTable(t);
                if (order == null) {
                    order = this.createOrderIfNullCommit(newSlot);
                } else {
                    this.setOrderCommit(order, newSlot);
                }
                int newId = -1;
                if (order != null) {
                    Vector<Sale> sales = this.logic.getSales(order.getId(), this.cumulateSales, -1, new ScreenSaleInterface());
                    this._orderTableModel.updateTable(sales);
                    newId = order.getId();
                } else {
                    this._orderTableModel.clear();
                }
                RestLogic.getInstance().switchAfisajClientOrderCommit(newId);
            }
            this._currentSlot = newSlot;
            this.updateTotals();
            this.setPromotionText();
            this.setClientText();
            this.comenzi.setText(Utils.getTranslation(LangRoAll.comanda) + (newSlot + 1));
        }
    }

    protected void handleKey(int keyCode, char keyChar) {
        if (this.waiter == null) {
            this.loginUser();
        }
        if (this.getTable(this._currentSlot) == null) {
            return;
        }
        switch (keyCode) {
            case 112: {
                this.switchTable(0);
                break;
            }
            case 113: {
                this.switchTable(1);
                break;
            }
            case 114: {
                this.switchTable(2);
                break;
            }
            case 115: {
                this.switchTable(3);
                break;
            }
            case 120: {
                if (!VpConfig.getInstance().piratMode) break;
                this.notaDePlata(false, false);
                break;
            }
            case 121: {
                this.notaDePlata(false, true);
                break;
            }
            case 122: {
                this.recomputePrices();
                break;
            }
            case 123: {
                this.notaDePlata(true, false);
                break;
            }
            case 10: {
                if (VpConfig.getInstance().keysWaitForEnter) {
                    this.updateProductTextCommit();
                }
                if (this.identified == null) break;
                if (this.identified.getIdCategorie() == this.idCategorieUndefined) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, Utils.getTranslation(LangRoAll.categorieNedefinita, new String[0]), LangRoAll.nuPotContinua);
                    this.codValue.setText(" ");
                    this.updateProductTextCommit();
                    break;
                }
                double q1 = 1.0;
                String valueS = this.kp.getValueS();
                if (Validators.correctDouble(valueS)) {
                    q1 = Utils.parseDouble(valueS);
                }
                this.bonComanda(this.identified, q1);
                break;
            }
            case 8: {
                String text = this.codValue.getText();
                if (text.length() > 0) {
                    text = text.substring(0, text.length() - 1);
                    this.codValue.setText(text);
                }
                if (VpConfig.getInstance().keysWaitForEnter) break;
                this.updateProductTextCommit();
                break;
            }
            case 106: {
                this.kp.reset();
                this.kp.requestFocus();
                break;
            }
            case 116: {
                TipPlataProvider.getInstance().pushButton(0);
                break;
            }
            case 117: {
                TipPlataProvider.getInstance().pushButton(1);
                break;
            }
            case 118: {
                TipPlataProvider.getInstance().pushButton(2);
                break;
            }
            case 119: {
                TipPlataProvider.getInstance().pushButton(3);
                break;
            }
            default: {
                this.digitPressed(keyChar);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Order createOrderIfNullCommit(int slot) {
        try {
            Order result = this.createOrderIfNullNotCommit(slot);
            ConnectionPool.getInstance().commit();
            Order order = result;
            return order;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Order order = null;
            return order;
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    private Order createOrderIfNullNotCommit(int slot) throws SQLException {
        if (this.getOrder(slot) == null && this.waiter != null) {
            Order order = this.logic.newOrderNoCommit(this.getTable(slot).getId(), this.waiter.getId(), false);
            this.setOrderNoCommit(order, slot);
            return order;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrderCommit(Order o, int slot) {
        try {
            this.setOrderNoCommit(o, slot);
            ConnectionPool.getInstance().commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    private void setOrderNoCommit(Order o, int comandaCurenta) throws SQLException {
        if (o != null) {
            this.orders.put(comandaCurenta, o);
            RestLogic.getInstance().switchAfisajClientOrderNoCommit(o.getId());
        } else {
            this.orders.remove(comandaCurenta);
            RestLogic.getInstance().switchAfisajClientOrderNoCommit(-1);
        }
    }

    private double readNewPrice(int idProduct) throws SQLException {
        String s;
        double catalogPrice = RestLogic.getInstance().getPriceForProductNoCommit(idProduct);
        while (!Validators.correctDouble(s = DialogUtils.inputDialog(this, Utils.getString2Decimals(catalogPrice), Utils.getTranslation(LangRoAll.introducetiPretul, new String[0])))) {
        }
        return Utils.parseDouble(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bonComanda(Product identified, double cantitate) {
        block16: {
            Categorie cat = NomeclaturaLogic.getInstance().getCategoryById(identified.getIdCategorie());
            if (cat != null) {
                if (cantitate != (double)((int)cantitate) && !cat.isPretKg()) {
                    DialogUtils.errorDialog(this, Utils.getTranslation(LangRoAll.produsulNuAcceptaCantitateFractionata, identified.toString()), LangRoAll.nuPotContinua);
                    return;
                }
            } else {
                DialogUtils.errorDialog(this, Utils.getTranslation(LangRoAll.categorieNullPtProdus, identified.toString()), LangRoAll.nuPotContinua);
                return;
            }
            boolean protocol = false;
            if (this.isRetur) {
                Vector<Sale> oldSales = this.logic.getSales(this.idOrder, true, -1, new ScreenSaleInterface(), -1);
                boolean found = false;
                for (Sale sale : oldSales) {
                    if (identified.getId() != sale.getIdProduct()) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    DialogUtils.errorDialog(this, Utils.getTranslation(LangRoAll.produsneGasitInComandaNr, identified + "", this.idOrder + ""), LangRoAll.nuPotContinua);
                    return;
                }
                cantitate = -cantitate;
            }
            try {
                if (EventsLogic.getInstance().isDayOpenNoCommit(1)) {
                    this.createOrderIfNullNotCommit(this._currentSlot);
                    if (this.getOrder(this._currentSlot) == null) {
                        return;
                    }
                    Sectie sectie = NomeclaturaLogic.getInstance().getSectieByIdNoCommit(cat.getSectie());
                    Vector<Sale> toAdd = new Vector<Sale>();
                    long now = System.currentTimeMillis();
                    String modPreparare = null;
                    Sale se = null;
                    se = this.pretCurent != -1.0 ? this.logic.buildSaleNoCommit(identified, 0.0, cantitate, modPreparare, -1, -1, -1, -1, -1, now, this.pretCurent, "", 0) : this.logic.buildSaleNoCommit(identified, 0.0, cantitate, modPreparare, -1, -1, -1, -1, -1, now, 0);
                    se.setFreeD1(-1.0);
                    se.setFreeD2(-1.0);
                    se.setFreeI1(-1);
                    se.setFreeS1("");
                    se.setFreeS2("");
                    se.setIdLot(this.idLot);
                    toAdd.add(se);
                    this.logic.productsSoldNoCommit(toAdd, this.getOrder(this._currentSlot), this.getTable(this._currentSlot), sectie, protocol, null, null, this.getOrder(this._currentSlot).getUser());
                    this.codValue.setText(" ");
                    this.updateProductTextNoCommit();
                    this.pretCurent = -1.0;
                    cantitate = 0.0;
                    Sale s1 = this.logic.reloadSaleNoCommit(se.getFirstIdSale(), se.getIdOrder());
                    s1.setProductName(se.getProductName());
                    s1.setSectieName(se.getSectieName());
                    this._orderTableModel.addSale(s1);
                    this.updateTotals();
                    this.updateRestAfterProduct();
                    ConnectionPool.getInstance().commit();
                    this._orderTable.changeSelection(this._orderTableModel.getRowCount() - 1, 0, false, false);
                    break block16;
                }
                DialogUtils.errorDialog(this, LanguageLogic.utils_events_openDayPlease, LanguageLogic.utils_cannotContinue);
                ConnectionPool.getInstance().rollBack();
                return;
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    ConnectionPool.getInstance().rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e1);
                }
            }
            finally {
                ConnectionPool.getInstance().releaseConnection();
            }
        }
        this.kp.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recomputePrices() {
        if (this.getOrder(this._currentSlot) != null) {
            Vector<Sale> sales = null;
            try {
                this.logic.recomputePricesNoCommit(this.getOrder(this._currentSlot));
                sales = this.logic.getSalesNoCommitNoCategoriesSort(this.getOrder(this._currentSlot).getId(), this.cumulateSales, -1, new ScreenSaleInterface());
                this._orderTableModel.updateTable(sales);
                this.updateTotals();
                ConnectionPool.getInstance().commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    ConnectionPool.getInstance().rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e1);
                }
            }
            finally {
                ConnectionPool.getInstance().releaseConnection();
            }
        }
    }

    private void notaDePlata(boolean f, boolean comanda) {
        double totalF;
        if (!this.checkBeforeIncasat(this)) {
            return;
        }
        Order o = this.getOrder(this._currentSlot);
        if (o == null) {
            return;
        }
        Table t = this.getTable(this._currentSlot);
        if (t.isVirtuala() && !comanda || !t.isVirtuala() && comanda) {
            return;
        }
        if (comanda) {
            this.logic.setTipOrderForIdCommit(o, Order.TIP_ORDER.COMANDA);
        }
        if ((totalF = this._orderTableModel.getTotal()) < 0.0) {
            DialogUtils.errorDialog(this, Utils.getTranslation(LangRoAll.totalComandaGresit, new String[0]), LangRoAll.nuPotContinua);
            return;
        }
        this.logic.laPlataOrder(o, t, null);
        this.printBf(o, f);
        this.logic.closeOrder(o);
        this._orderTableModel.clear();
        this.setOrderCommit(null, this._currentSlot);
        this.platiPanel.cleanPlatiLabel();
        this.updateTotals();
        this.setPromotionText();
        this.setClientText();
        this.productsCancelButton.doClick();
        this.isRetur = false;
        this.idOrder = -1;
    }

    protected void printBf(Order o, boolean f) {
        this.logic.printBonFiscalSeparat(o, f);
    }

    protected boolean checkBeforeIncasat(Component parent) {
        if (RestLogic.getInstance().needPlatiCheckingAtIncasat(this.getCurrentOrder()) && !this.logic.isTotalOrderEqualWithTotalPlati(this.getCurrentOrder())) {
            DialogUtils.errorDialog(parent, LangRoAll.tipurileDePlataNuAcopera, LangRoAll.nuPotContinua);
            return false;
        }
        return true;
    }

    protected void loginUser() {
        User u = UsersLogic.getInstance().requestWaiterLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, VpConfig.getInstance().requestPasswordForWaitersSelection);
        if (u != null) {
            this.waiter = u;
        } else {
            DialogUtils.errorDialog(this, Utils.getTranslation(LangRoAll.utilizatorSauParolaIncorecta), LangRoAll.nuPotContinua);
        }
        Dimension d = this.kp.getSize();
        System.out.println("Dimension: " + d.toString());
    }

    protected void updateTotals() {
        Table t;
        double totalF = this._orderTableModel.getTotal();
        String newTotal = Utils.getString2Decimals(totalF);
        this.total.setText(newTotal);
        if (this.getOrder(this._currentSlot) != null) {
            Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(this.getOrder(this._currentSlot).getId());
            this.platiPanel.updatePlatiLabels(plati, totalF);
        }
        if ((t = this.getTable(this._currentSlot)) != null && t.isVirtuala()) {
            this.total.setText(Utils.getTranslation(LangRoAll.verificarePreturi, new String[0]));
            this.platiPanel.setRestText(null);
        }
    }

    protected void doAdminLogin() {
        GuiUtilsRest.doAdminLogin(RestLogic.getInstance());
    }

    public Vector getUsedTables() {
        Vector<Table> tables = new Vector<Table>();
        Vector usedLocations = this.logic.getLocationsByLocationNames(locations);
        if (usedLocations.size() == 0) {
            usedLocations = this.logic.getLocations();
        }
        for (Location element : usedLocations) {
            Vector<Table> tablesForThisLocation = this.logic.getTablesByLocation(element.getId());
            tables.addAll(tablesForThisLocation);
        }
        return tables;
    }

    @Override
    public void doStuff() {
        this.focus();
        this.allTables = this.getUsedTables();
        if (this.allTables.size() == 0) {
            DialogUtils.errorDialog(this, Utils.getTranslation(LangRoAll.adaugatiOComanda, new String[0]), LangRoAll.nuPotContinua);
        } else {
            for (int slot = 0; slot < this.allTables.size(); ++slot) {
                Table o = (Table)this.allTables.elementAt(slot);
                this.tables.put(slot, o);
            }
            this.switchTable(0);
        }
        this.kp.reset();
        this.codValue.setText(" ");
        this.pretValue.setText(" ");
    }

    @Override
    public void readQuantity(double f) {
        if (this.readFromCantar) {
            Logger.logDebug(this, "Received quantity: " + Utils.getString3Decimals(f));
            this.kp.setNumber(f);
            this.readFromCantar = false;
        }
    }
}

