/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.base.reports.CorrectionsEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Shift;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class CorrectionsPanel
extends AbstractReportPanel {
    public static final String[] columns = new String[]{LangRoAll.operator, LangRoAll.produs, LangRoAll.cantitate, LangRoAll.suma, LangRoAll.stersDe, LangRoAll.data};
    private RestLogic logic;
    private JComboBox waiters;
    private JComboBox admins;
    private JComboBox ture;
    private JLabel totalSuma;
    private ReportInterface pdfReportInterface;
    private ReportInterface asciiReportInterface;
    private Hashtable printCriteria = new Hashtable();

    public CorrectionsPanel() {
        this.logic = RestLogic.getInstance();
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Object waiter = this.waiters.getSelectedItem();
        if (waiter instanceof User) {
            result.put("user_fo", waiter);
            this.printCriteria.put(LangRoAll.utilizator, waiter);
        } else {
            this.printCriteria.put(LangRoAll.utilizator, LangRoAll.toti);
        }
        Object admin = this.admins.getSelectedItem();
        if (admin instanceof User) {
            result.put("user_bo", admin);
            this.printCriteria.put(LangRoAll.supervizor, admin);
        } else {
            this.printCriteria.put(LangRoAll.supervizor, LangRoAll.toti);
        }
        return result;
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, this.asciiReportInterface, this.data);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return this.logic.getCorrections(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    CorrectionsEntry entry = (CorrectionsEntry)o;
                    try {
                        Label label = new Label(0, row, entry.getWaiterName());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, entry.getProdus());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(2, row, entry.getQuantity()));
                        sheet.addCell((WritableCell)new Number(3, row, entry.getSuma()));
                        label = new Label(4, row, entry.getSupervisorName());
                        sheet.addCell((WritableCell)label);
                        label = new Label(5, row, entry.getDate());
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return CorrectionsPanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return LangRoAll.corectii;
    }

    @Override
    public AbstractTM buildTableModel() {
        Class[] types = Utils.getStringClass(columns.length);
        AbstractTM tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                CorrectionsEntry fe = (CorrectionsEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return fe.getWaiterName();
                    }
                    case 1: {
                        return fe.getProdus();
                    }
                    case 2: {
                        return Utils.getString3Decimals(fe.getQuantity());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getSuma());
                    }
                    case 4: {
                        return fe.getSupervisorName();
                    }
                    case 5: {
                        return fe.getDate();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.total), c);
        ++c.gridx;
        this.totalSuma = new JLabel("");
        result.add((Component)this.totalSuma, c);
        if (Config.getInstance().getBoolean("showStergereButtons")) {
            final CorrectionsPanel panel = this;
            ++c.gridx;
            JButton sterge = new JButton(LangRoAll.sterge);
            sterge.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (DialogUtils.confirmDialog(panel, Utils.getTranslation(LangRoAll.stergereCorectii, new String[0]), LangRoAll.atentie)) {
                        CorrectionsPanel.this.logic.deleteAllCorrections();
                        CorrectionsPanel.this.raport();
                    }
                }
            });
            sterge.setMargin(new Insets(1, 1, 1, 1));
            result.add((Component)sterge, c);
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.tura), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.ture = new JComboBox();
        result.add((Component)this.ture, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.operator), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.waiters = new JComboBox();
        result.add((Component)this.waiters, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.administrator), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.admins = new JComboBox();
        result.add((Component)this.admins, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
        this.updateTotals(this.data);
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.waiters, this.logic.getWaiters());
        ComboUtils.replaceItemsForCombo(this.admins, this.logic.getAdmins());
        ComboUtils.replaceItemsForCombo(this.ture, RestLogic.getInstance().getShifts());
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 1;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 3;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 3: {
                        return CorrectionsPanel.this.totalSuma.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return CorrectionsPanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return CorrectionsPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                CorrectionsEntry fe = (CorrectionsEntry)row;
                switch (column) {
                    case 0: {
                        return fe.getWaiterName();
                    }
                    case 1: {
                        return fe.getProdus();
                    }
                    case 2: {
                        return Utils.getString3Decimals(fe.getQuantity());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getSuma());
                    }
                    case 4: {
                        return fe.getSupervisorName();
                    }
                    case 5: {
                        return fe.getDate();
                    }
                }
                return null;
            }
        };
        this.asciiReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.produs + "|" + LangRoAll.cantitate + "|" + LangRoAll.valoare;
                    }
                }
                return null;
            }

            @Override
            public String getTotal(int column) {
                if (column == 0) {
                    String s = LangRoAll.total + ": " + CorrectionsPanel.this.totalSuma.getText();
                    return s;
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return CorrectionsPanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return CorrectionsPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                CorrectionsEntry fe = (CorrectionsEntry)row;
                if (fe == null) {
                    return null;
                }
                if (column == 0) {
                    String s = fe.getWaiterName() + "|" + fe.getSupervisorName() + "|" + fe.getProdus() + "|" + Utils.getString3Decimals(fe.getQuantity()) + "|" + Utils.getString2Decimals(fe.getSuma()) + "|" + fe.getDate();
                    return s;
                }
                return "";
            }
        };
        this.ture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ComboUtils.anythingButAllSelected(CorrectionsPanel.this.ture)) {
                    Shift s = (Shift)CorrectionsPanel.this.ture.getSelectedItem();
                    CorrectionsPanel.this.dateSelector.selectPeriod();
                    CorrectionsPanel.this.dateSelector.setStartDate(s.getStart());
                    CorrectionsPanel.this.dateSelector.setStopDate(s.getStop());
                } else {
                    CorrectionsPanel.this.dateSelector.setStartDate(DateUtils.getStartOfDay(new Date()));
                    CorrectionsPanel.this.dateSelector.setStopDate(DateUtils.getEndOfDay(new Date()));
                    CorrectionsPanel.this.dateSelector.selectDay();
                }
            }
        });
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    public void updateTotals(Vector items) {
        double suma = 0.0;
        for (CorrectionsEntry element : items) {
            suma += element.getSuma();
        }
        this.totalSuma.setText(Utils.getString2Decimals(suma));
    }
}

