/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.util.Vector;
import javax.swing.JPanel;
import ro.atreides.restaurant.base.reports.VanzariNedescataDetaliiEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class DetaliiVanzareNedescarcata
extends AbstractListPanel {
    private int idProduct;
    private int idSectie;

    public DetaliiVanzareNedescarcata(int idProduct, int idSectie) {
        this.idProduct = idProduct;
        this.idSectie = idSectie;
    }

    @Override
    public String[] buildColumns() {
        return new String[]{LangRoAll.nota, LangRoAll.data, "Necesar"};
    }

    @Override
    public Vector buildData() {
        return RestLogic.getInstance().getDetaliiForVanzareNedescarcata(this.idProduct, this.idSectie);
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public JPanel getBottomPanel() {
        return null;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                VanzariNedescataDetaliiEntry e = (VanzariNedescataDetaliiEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return e.getNota();
                    }
                    case 1: {
                        return e.getData();
                    }
                    case 2: {
                        return Utils.getString2Decimals(e.getNecesar());
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public void doStuff() {
        this.display();
    }
}

