/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.gui.DocumenteCellRenderer;
import ro.atreides.restaurant.gui.reports.DetaliiOrder;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.documente.Document;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Legenda;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class DocumenteReportPanel
extends AbstractReportPanel {
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();
    public static final String[] columns = new String[]{Utils.getTranslation(LangRoAll.document, new String[0]), LangRoAll.data};

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Date> result = new Hashtable<String, Date>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        Legenda l = new Legenda(new String[]{Utils.getTranslation(LangRoAll.validat, new String[0]), Utils.getTranslation(LangRoAll.procesat, new String[0]), Utils.getTranslation(LangRoAll.neprocesat, new String[0])}, new Color[]{Color.GREEN, Color.YELLOW, Color.RED});
        return l;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Document sqv = (Document)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return sqv.getDocument();
                    }
                    case 1: {
                        return Formatters.DATE_AND_TIME_FORMAT.format(sqv.getTimeDocument());
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 0;
        c.gridy = 0;
        c.gridx = 0;
        final DocumenteReportPanel panel = this;
        JButton recalculare = new JButton(Utils.getTranslation(LangRoAll.recalculareDeLaUltimaValidare, new String[0]));
        recalculare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DialogUtils.confirmDialog(panel, Utils.getTranslation(LangRoAll.recalculam, new String[0]), LangRoAll.confirmare) && DialogUtils.confirmDialog(panel, Utils.getTranslation(LangRoAll.recalculamW1, new String[0]), LangRoAll.confirmare)) {
                    DialogUtils.okDialog(panel, Utils.getTranslation(LangRoAll.recalculamW2, new String[0]), Utils.getTranslation(LangRoAll.atentie));
                    RestLogic.getInstance().recalculeazaDocumenteNevalidate();
                }
            }
        });
        result.add((Component)recalculare, c);
        ++c.gridx;
        JButton deleteDocumente = new JButton(Utils.getTranslation(LangRoAll.stergemDocumenteleAfisate, new String[0]));
        deleteDocumente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DialogUtils.confirmDialog(panel, Utils.getTranslation(LangRoAll.stergemDocumenteleAfisate, new String[0]), LangRoAll.confirmare) && DialogUtils.confirmDialog(panel, Utils.getTranslation(LangRoAll.recalculamW1, new String[0]), LangRoAll.confirmare)) {
                    Date start = (Date)DocumenteReportPanel.this.printCriteria.get(Constants.START_KEY);
                    Date stop = (Date)DocumenteReportPanel.this.printCriteria.get(Constants.STOP_KEY);
                    Timestamp s1 = new Timestamp(start.getTime());
                    Timestamp s2 = new Timestamp(stop.getTime());
                    RestLogic.getInstance().deleteDocumente(s1, s2);
                }
            }
        });
        result.add((Component)deleteDocumente, c);
        return result;
    }

    @Override
    public String getName() {
        return Utils.getTranslation(LangRoAll.raportDocumente, new String[0]);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return RestLogic.getInstance().getDocumente(criteria, this.whatToPrint);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    Document sqv = (Document)DocumenteReportPanel.this.data.elementAt(row);
                    try {
                        Label label = new Label(0, row, sqv.getDocument());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, Formatters.DATE_AND_TIME_FORMAT.format(sqv.getTimeDocument()));
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return DocumenteReportPanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return DocumenteReportPanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return DocumenteReportPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                Document sqv = (Document)row;
                switch (column) {
                    case 0: {
                        return sqv.getDocument();
                    }
                    case 1: {
                        return Formatters.DATE_AND_TIME_FORMAT.format(sqv.getTimeDocument());
                    }
                }
                return null;
            }
        };
        DocumenteCellRenderer cellRenderer = new DocumenteCellRenderer(this.tm);
        GuiUtils.updateJTableColumns(this.table, cellRenderer);
        final DocumenteReportPanel panel = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final Document doc = (Document)DocumenteReportPanel.this.tm.getData().get(selRow);
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem valideaza = new JMenuItem(Utils.getTranslation(LangRoAll.valideazaPanaLa, new String[0]));
                JMenuItem recalculare = new JMenuItem(Utils.getTranslation(LangRoAll.recalculareDupaData, new String[0]));
                JMenuItem stergeTranzactiiDupaData = new JMenuItem("Sterge toate tranzactiile dupa data");
                JMenuItem detalii = new JMenuItem(LangRoAll.detaliiNota);
                if (doc.getStatus() != 3) {
                    popup.add(valideaza);
                    popup.add(recalculare);
                }
                if (doc.getIdOrder() > 0) {
                    popup.add(detalii);
                }
                popup.add(stergeTranzactiiDupaData);
                popup.setInvoker(DocumenteReportPanel.this.table);
                valideaza.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (DialogUtils.confirmDialog(panel, Utils.getTranslation(LangRoAll.atiEfectuatBackup, new String[0]), LangRoAll.confirmare) && DialogUtils.confirmDialog(panel, Utils.getTranslation(LangRoAll.validareW2, new String[0]), LangRoAll.confirmare)) {
                            RestLogic.getInstance().valideazaPanaLaData(doc.getTimeDocument());
                            popup.setVisible(false);
                            DocumenteReportPanel.this.raport();
                        }
                    }
                });
                recalculare.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RestLogic.getInstance().recalculareDeLaData(doc.getTimeDocument());
                        popup.setVisible(false);
                        DocumenteReportPanel.this.raport();
                    }
                });
                detalii.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        DetaliiOrder d = new DetaliiOrder(doc.getIdOrder());
                        d.doStuff();
                        JDialog dialog = DialogUtils.getJDialog(d, GuiUtils.currentFrame, Utils.getTranslation(LangRoAll.detaliiNota) + doc.getIdOrder(), 1.1);
                        dialog.setVisible(true);
                        popup.setVisible(false);
                        dialog.toFront();
                    }
                });
                stergeTranzactiiDupaData.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StockLogic.getInstance().deleteAllFutureFiseMagazie(doc.getTimeDocument());
                    }
                });
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

